/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.cimom.adapters.provider.jni;

import com.sun.wbem.cimom.adapter.provider.ProviderAdapterIF;
import com.sun.wbem.cimom.adapter.provider.ProviderProtocolAdapterIF;
import com.sun.wbem.cimom.adapters.provider.jni.SolarisNativeAdapter;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMClassException;
import javax.wbem.cim.CIMException;
import javax.wbem.client.CIMOMHandle;
import javax.wbem.client.ProviderCIMOMHandle;

public class JniProviderAdapter
implements ProviderProtocolAdapterIF {
    private static final String DESCRIPTION = "A JNI provider adapter";
    private static final String VENDOR = "Sun Microsystems Inc.";
    private static final int VERSION = 1;
    private boolean valid = false;
    private ProviderCIMOMHandle mCimom;
    private boolean passAllCheck = false;

    public void initialize(ProviderCIMOMHandle providerCIMOMHandle) {
        this.mCimom = providerCIMOMHandle;
        String string = System.getProperty("passAllProviderCheck", "false");
        if (string != null) {
            this.passAllCheck = string.compareToIgnoreCase("true") == 0;
        }
    }

    public void start() {
        this.valid = true;
    }

    public boolean isValid() {
        return this.valid;
    }

    public void stop() {
        this.valid = false;
    }

    public int getVersion() {
        return 1;
    }

    public String getVendor() {
        return VENDOR;
    }

    public String getDescription() {
        return DESCRIPTION;
    }

    public Object loadProvider(String string, String string2, String[] stringArray, CIMClass cIMClass) throws ClassNotFoundException, CIMClassException {
        try {
            SolarisNativeAdapter solarisNativeAdapter = null;
            solarisNativeAdapter = new SolarisNativeAdapter(string2, stringArray, cIMClass.getName());
            solarisNativeAdapter.getProvider().initialize((CIMOMHandle)this.mCimom);
            return solarisNativeAdapter;
        }
        catch (CIMException cIMException) {
            throw new CIMClassException(cIMException.toString(), (Object)cIMException);
        }
    }

    public void unloadProvider(Object object) throws CIMClassException {
    }

    public ProviderAdapterIF getProviderAdapter(Object object) throws CIMClassException {
        if (object instanceof ProviderAdapterIF) {
            return (ProviderAdapterIF)object;
        }
        throw new CIMClassException("CIM_ERR_INVALID_CLASS", (Object)"Unrecognized object!");
    }

    public void terminate() {
    }
}

