/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.apps.cimworkshop;

import com.sun.wbem.apps.cimworkshop.CIMEventsPanel;
import com.sun.wbem.apps.cimworkshop.CIMMethodsPanel;
import com.sun.wbem.apps.cimworkshop.CIMPropertiesPanel;
import com.sun.wbem.apps.common.ActionString;
import com.sun.wbem.apps.common.I18N;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelListener;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMElement;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.client.CIMClient;

public class CIMTableTabbedPane
extends JTabbedPane {
    protected CIMPropertiesPanel propertiesPanel;
    protected CIMMethodsPanel methodsPanel;
    protected CIMEventsPanel eventsPanel;
    protected Vector cimProperties = null;
    protected Vector cimMethods = null;
    protected ActionString asProps = new ActionString("LBL_PROPERTIES");
    protected ActionString asMethods = new ActionString("LBL_METHODS");
    protected ActionString asEvents = new ActionString("LBL_EVENTS");

    public CIMTableTabbedPane() {
        this(false);
    }

    public CIMTableTabbedPane(boolean bl) {
        this.addPropertiesTab(bl);
        this.addMethodsTab(bl);
        this.setSelectedIndex(0);
    }

    public void removePropertiesTab() {
        this.removeTab(this.asProps.getString());
    }

    public void removeMethodsTab() {
        this.removeTab(this.asMethods.getString());
    }

    public void removeEventsTab() {
        this.removeTab(this.asEvents.getString());
    }

    protected void removeTab(String string) {
        int n = this.indexOfTab(string);
        if (n >= 0) {
            this.removeTabAt(n);
        }
    }

    public void addPropertiesTab(boolean bl) {
        if (this.propertiesPanel == null) {
            this.propertiesPanel = new CIMPropertiesPanel(bl);
        }
        this.addTab(this.asProps.getString(), this.propertiesPanel);
    }

    public void addMethodsTab(boolean bl) {
        if (this.methodsPanel == null) {
            this.methodsPanel = new CIMMethodsPanel(bl);
        }
        this.addTab(this.asMethods.getString(), this.methodsPanel);
    }

    public void addEventsTab() {
        if (this.eventsPanel == null) {
            this.eventsPanel = new CIMEventsPanel();
        }
        this.addTab(this.asEvents.getString(), this.eventsPanel);
    }

    protected void addTab(String string, JPanel jPanel) {
        if (this.indexOfTab(string) < 0) {
            this.addTab(string, jPanel);
        }
    }

    public void initializeEvents(CIMObjectPath cIMObjectPath, CIMClient cIMClient) {
        if (this.eventsPanel != null) {
            this.eventsPanel.initializeEvents(cIMObjectPath, cIMClient);
        }
    }

    public void deleteEventSubscriptions() {
        if (this.eventsPanel != null) {
            this.eventsPanel.deleteEventSubscriptions();
        }
    }

    public void populateTables(CIMClient cIMClient, CIMElement cIMElement) {
        this.propertiesPanel.populateTable(cIMClient, cIMElement);
        this.methodsPanel.populateList(cIMClient, cIMElement);
        if (this.eventsPanel != null) {
            this.eventsPanel.setEventsSelection((CIMClass)cIMElement);
        }
    }

    public void addPropertyTableModelListener(TableModelListener tableModelListener) {
        this.propertiesPanel.addTableModelListener(tableModelListener);
    }

    public void addListSelectionListener(ListSelectionListener listSelectionListener) {
        this.propertiesPanel.addListSelectionListener(listSelectionListener);
    }

    public CIMPropertiesPanel getPropertiesTable() {
        return this.propertiesPanel;
    }

    public CIMMethodsPanel getMethodsTable() {
        return this.methodsPanel;
    }

    public CIMEventsPanel getEventPanel() {
        return this.eventsPanel;
    }

    public Vector getProperties() {
        return this.propertiesPanel.getProperties();
    }

    public void setUneditableProperties(Vector vector) {
        this.propertiesPanel.setUneditableRows(vector);
    }

    public boolean isPropertySelected() {
        return this.propertiesPanel != null && !this.propertiesPanel.isSelectionEmpty();
    }

    public boolean isMethodSelected() {
        return this.methodsPanel != null && !this.methodsPanel.isSelectionEmpty();
    }

    public void invokeMethod() {
        if (this.isMethodSelected()) {
            this.methodsPanel.invokeMethod();
        } else {
            JOptionPane.showMessageDialog(this, I18N.loadString("ERR_NO_METHOD_SELECTED"), I18N.loadString("TTL_CIM_ERROR"), 0);
        }
    }

    public void showQualifiers() {
        if (this.getSelectedIndex() == this.indexOfTab(this.asMethods.getString())) {
            this.showMethodQualifiers();
        } else if (this.getSelectedIndex() == this.indexOfTab(this.asProps.getString())) {
            this.showPropertyQualifiers();
        }
    }

    public void showMethodQualifiers() {
        if (this.isMethodSelected()) {
            this.methodsPanel.showQualifiers();
        } else {
            JOptionPane.showMessageDialog(this, I18N.loadString("ERR_NO_METHOD_SELECTED"), I18N.loadString("TTL_CIM_ERROR"), 0);
        }
    }

    public void showPropertyQualifiers() {
        if (this.isPropertySelected()) {
            this.propertiesPanel.showQualifiers();
        } else {
            JOptionPane.showMessageDialog(this, I18N.loadString("ERR_NO_PROPERTY_SELECTED"), I18N.loadString("TTL_CIM_ERROR"), 0);
        }
    }

    public void showPropertyValue() {
        if (this.isPropertySelected()) {
            this.propertiesPanel.showValue();
        } else {
            JOptionPane.showMessageDialog(this, I18N.loadString("ERR_NO_PROPERTY_SELECTED"), I18N.loadString("TTL_CIM_ERROR"), 0);
        }
    }
}

