/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.apps.common;

import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class SizedIntegerDocument
extends PlainDocument {
    JTextField textField;
    long minVal;
    long maxVal;

    public SizedIntegerDocument(JTextField jTextField, int n) {
        this(jTextField, 0, n);
    }

    public SizedIntegerDocument(JTextField jTextField, int n, int n2) {
        this(jTextField, (long)n, (long)n2);
    }

    public SizedIntegerDocument(JTextField jTextField, long l) {
        this(jTextField, 0L, l);
    }

    public SizedIntegerDocument(JTextField jTextField, long l, long l2) {
        this.textField = jTextField;
        this.minVal = l;
        this.maxVal = l2;
    }

    public void setRange(long l, long l2) {
        this.minVal = l;
        this.maxVal = l2;
        if (this.textField.getText().trim().length() == 0) {
            return;
        }
        try {
            long l3 = Long.parseLong(this.textField.getText());
            if (l3 < this.minVal) {
                this.textField.setText(String.valueOf(this.minVal));
            } else if (l3 > this.maxVal) {
                this.textField.setText(String.valueOf(this.maxVal));
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.textField.setText(String.valueOf(this.minVal));
            return;
        }
    }

    public void setMin(long l) {
        this.minVal = l;
    }

    public void setMax(long l) {
        this.maxVal = l;
    }

    public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
        StringBuffer stringBuffer = new StringBuffer(this.textField.getText());
        stringBuffer.insert(n, string);
        if (!stringBuffer.toString().equals("-") || this.minVal >= 0L) {
            try {
                long l = Long.parseLong(stringBuffer.toString());
                if (this.minVal != this.maxVal && (l < this.minVal || l > this.maxVal)) {
                    return;
                }
            }
            catch (NumberFormatException numberFormatException) {
                return;
            }
        }
        super.insertString(n, string, attributeSet);
    }
}

