/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.logsvc;

import com.sun.wbem.solarisprovider.logsvc.Buffer;
import com.sun.wbem.solarisprovider.logsvc.DataRecord;
import com.sun.wbem.solarisprovider.logsvc.Filterable;
import com.sun.wbem.solarisprovider.logsvc.LogRecord;
import java.util.Vector;

public class FilterThread
implements Runnable {
    Buffer shared_buffer;
    Filterable log_filter;
    int numRecords;
    Vector headers;

    public FilterThread(Buffer buffer, Filterable filterable, int n) {
        this.shared_buffer = buffer;
        this.log_filter = filterable;
        this.numRecords = n;
        this.headers = new Vector();
    }

    public void run() {
        while (this.shared_buffer.retSize() < this.numRecords) {
            Vector vector;
            if (!this.shared_buffer.getMessage() && this.shared_buffer.isEmpty() || (vector = this.shared_buffer.getRecs()) == null) break;
            this.headers = this.apply_filter(vector);
            int n = this.headers.size();
            if ((n += this.shared_buffer.retSize()) >= this.numRecords) {
                this.headers.setSize(this.headers.size() - (n - this.numRecords));
                this.shared_buffer.addToVect(this.headers);
                this.shared_buffer.setMessage();
                this.shared_buffer.setDone(false);
                break;
            }
            this.shared_buffer.addToVect(this.headers);
        }
    }

    private Vector apply_filter(Vector vector) {
        int n = 0;
        int n2 = vector.size();
        Vector<LogRecord> vector2 = new Vector<LogRecord>();
        while (n < n2) {
            DataRecord dataRecord = (DataRecord)vector.elementAt(n);
            LogRecord logRecord = (LogRecord)dataRecord.getRecord();
            logRecord.setRecordId(dataRecord.getOffset());
            logRecord.setHashCode(dataRecord.getHash());
            if (this.log_filter.checkConstraints(logRecord)) {
                vector2.addElement(logRecord);
            }
            ++n;
        }
        return vector2;
    }
}

