/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.util;

public final class SimplePool {
    private Object[] pool;
    private int max;
    private int current = -1;
    Object lock;
    public static final int DEFAULT_SIZE = 16;

    public SimplePool() {
        this.max = 16;
        this.pool = new Object[this.max];
        this.lock = new Object();
    }

    public SimplePool(int max) {
        this.max = max;
        this.pool = new Object[max];
        this.lock = new Object();
    }

    public Object get() {
        Object item = null;
        Object object = this.lock;
        synchronized (object) {
            if (this.current >= 0) {
                item = this.pool[this.current];
                --this.current;
            }
        }
        return item;
    }

    public int getMax() {
        return this.max;
    }

    public void put(Object o) {
        Object object = this.lock;
        synchronized (object) {
            if (this.current < this.max - 1) {
                ++this.current;
                this.pool[this.current] = o;
            }
        }
    }

    public void set(Object o) {
        this.put(o);
    }
}

