/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jserv;

import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.java.util.Configurations;
import org.apache.jserv.JServContext;
import org.apache.jserv.JServLogChannels;
import org.apache.jserv.JServSendError;
import org.apache.jserv.JServServletManager;

class JServSTMStore
implements JServLogChannels {
    private JServServletManager servletManager;
    private String servletName;
    private JServContext[] freeContexts = null;
    private int indexFree = -1;
    private JServContext[] allContexts = null;
    private int indexAll = -1;
    private int initialCapacity;
    private int incrementCapacity;
    private int maximumCapacity;

    JServSTMStore(Configurations configurations, JServServletManager jServServletManager, String string, JServSendError jServSendError, JServContext jServContext) throws ServletException {
        int n;
        this.servletManager = jServServletManager;
        this.servletName = string;
        this.initialCapacity = configurations.getInteger("singleThreadModelServlet.initialCapacity", 5);
        this.incrementCapacity = configurations.getInteger("singleThreadModelServlet.incrementCapacity", 5);
        this.maximumCapacity = configurations.getInteger("singleThreadModelServlet.maximumCapacity", 10);
        int n2 = n = this.initialCapacity < this.maximumCapacity ? this.initialCapacity : this.maximumCapacity;
        if (n <= 0) {
            n = 1;
        }
        this.freeContexts = new JServContext[n];
        this.allContexts = new JServContext[n];
        this.freeContexts[++this.indexFree] = jServContext;
        this.allContexts[++this.indexAll] = jServContext;
        --n;
        while (n > 0) {
            this.addContext(jServSendError);
            --n;
        }
    }

    private void addContext(JServSendError jServSendError) throws ServletException {
        JServContext jServContext;
        if (this.indexAll + 1 >= this.allContexts.length) {
            int n;
            int n2 = n = this.indexAll + 1 + this.incrementCapacity < this.maximumCapacity ? this.indexAll + 1 + this.incrementCapacity : this.maximumCapacity;
            if (n <= this.indexAll + 1) {
                return;
            }
            JServContext[] jServContextArray = new JServContext[n];
            System.arraycopy(this.allContexts, 0, jServContextArray, 0, this.allContexts.length);
            this.allContexts = jServContextArray;
            jServContextArray = new JServContext[n];
            System.arraycopy(this.freeContexts, 0, jServContextArray, 0, this.freeContexts.length);
            this.freeContexts = jServContextArray;
        }
        if ((jServContext = this.servletManager.load_init(this.servletName, jServSendError)) != null) {
            this.freeContexts[++this.indexFree] = jServContext;
            this.allContexts[++this.indexAll] = jServContext;
        }
    }

    synchronized JServContext getContext(JServSendError jServSendError) throws ServletException {
        if (this.indexFree < 0) {
            if (this.indexAll + 1 >= this.maximumCapacity) {
                jServSendError.sendError(503, "The servlet named \"" + this.servletName + "\" is a " + "javax.servlet.SingleThreadModel servlet and no " + "instance is available. Try again later.");
                return null;
            }
            int n = this.indexAll + 1 + this.incrementCapacity <= this.maximumCapacity ? this.incrementCapacity : this.maximumCapacity - this.indexAll - 1;
            while (n > 0) {
                this.addContext(jServSendError);
                --n;
            }
            if (this.indexFree < 0) {
                jServSendError.sendError(503, "The servlet named \"" + this.servletName + "\" isn't" + "free right now. Try again later.");
                return null;
            }
        }
        JServContext jServContext = this.freeContexts[this.indexFree--];
        return jServContext;
    }

    synchronized void returnContext(JServContext jServContext) {
        boolean bl = false;
        int n = 0;
        while (n <= this.indexAll && !bl) {
            if (jServContext == this.allContexts[n]) {
                bl = true;
            }
            ++n;
        }
        if (!bl) {
            return;
        }
        bl = true;
        int n2 = 0;
        while (n2 <= this.indexFree && bl) {
            if (jServContext == this.freeContexts[n2]) {
                bl = false;
            }
            ++n2;
        }
        if (!bl) {
            return;
        }
        if (this.indexFree - 1 >= this.freeContexts.length) {
            return;
        }
        this.freeContexts[++this.indexFree] = jServContext;
    }

    int size() {
        return this.indexAll + 1;
    }

    synchronized Servlet[] getServlets() {
        Servlet[] servletArray = this.allContexts == null ? new Servlet[]{} : new Servlet[this.indexAll + 1];
        int n = this.indexAll;
        while (n >= 0) {
            servletArray[n] = this.allContexts[n].servlet;
            --n;
        }
        return servletArray;
    }

    synchronized JServContext[] clear() {
        JServContext[] jServContextArray = new JServContext[this.indexAll + 1];
        System.arraycopy(this.allContexts, 0, jServContextArray, 0, this.indexAll + 1);
        this.freeContexts = null;
        this.allContexts = null;
        this.indexFree = -1;
        this.indexAll = -1;
        return jServContextArray;
    }
}

