/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.compiler.mib2mof;

import com.sun.wbem.compiler.mib2mof.ASTObjectTypeDefinition;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class MibNode {
    private Hashtable children;
    private String symbolName = null;
    private String oid = null;
    private ASTObjectTypeDefinition objectType = null;
    private String nodeId = "";
    private String computedOid = "";
    private String oidName = "";
    private boolean enumerated = false;
    private String enumeratedType = "";
    private String snmpSyntax = "";
    private long length = -1L;
    private Vector externalIndex = new Vector();

    public MibNode(String string) {
        this.nodeId = string;
        this.computedOid = string;
        this.children = new Hashtable();
    }

    public MibNode getId(String string) {
        if (this.children.containsKey(string)) {
            return (MibNode)this.children.get(string);
        }
        MibNode mibNode = new MibNode(string);
        if (this.nodeId.length() != 0) {
            mibNode.setComputedOid(this.computedOid + "." + string);
        }
        this.children.put(string, mibNode);
        return mibNode;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public String getOid() {
        return this.oid;
    }

    public Hashtable getChildren() {
        return this.children;
    }

    public MibNode getChildWithName(String string) {
        if (this.children == null) {
            return null;
        }
        if (this.children.isEmpty()) {
            return null;
        }
        Enumeration enumeration = this.children.elements();
        while (enumeration.hasMoreElements()) {
            MibNode mibNode = (MibNode)enumeration.nextElement();
            String string2 = mibNode.getRealSymbolName();
            if (!string.equals(string2)) continue;
            return mibNode;
        }
        return null;
    }

    public MibNode findNodeWithName(String string) {
        if (this.symbolName != null && string.equals(this.symbolName)) {
            return this;
        }
        if (this.children == null) {
            return null;
        }
        if (this.children.isEmpty()) {
            return null;
        }
        Enumeration enumeration = this.children.elements();
        while (enumeration.hasMoreElements()) {
            MibNode mibNode = (MibNode)enumeration.nextElement();
            MibNode mibNode2 = mibNode.findNodeWithName(string);
            if (mibNode2 == null) continue;
            return mibNode2;
        }
        return null;
    }

    public String getSymbolName() {
        if (this.symbolName == null) {
            return null;
        }
        String string = this.symbolName.trim();
        string = string.replace('-', '_');
        string = string.replace('.', '_');
        string = string.replace(',', '_');
        string = string.replace(',', '_');
        string = string.replace(' ', '_');
        return Character.toUpperCase(string.charAt(0)) + string.substring(1, string.length());
    }

    public String getRealSymbolName() {
        return this.symbolName;
    }

    public String getRealOidName() {
        return this.oidName;
    }

    public boolean isAssociated() {
        return this.symbolName != null;
    }

    public void setComputedOid(String string) {
        this.computedOid = string;
    }

    public String getComputedOid() {
        return this.computedOid;
    }

    public void setOidName(String string) {
        this.oidName = string;
    }

    public String getOidName() {
        return Character.toUpperCase(this.oidName.charAt(0)) + this.oidName.substring(1, this.oidName.length());
    }

    public boolean isEnumeratedType() {
        return this.enumerated;
    }

    public void setEnumerated(boolean bl) {
        this.enumerated = bl;
    }

    public void setEnumeratedType(String string) {
        this.enumeratedType = string;
        this.enumerated = true;
    }

    public String getEnumeratedType() {
        return this.enumeratedType;
    }

    public void setSnmpSyntax(String string) {
        this.snmpSyntax = string;
    }

    public String getSnmpSyntax() {
        return this.snmpSyntax;
    }

    public ASTObjectTypeDefinition getObjectType() {
        return this.objectType;
    }

    public void setAssociation(String string, String string2, ASTObjectTypeDefinition aSTObjectTypeDefinition) {
        this.oid = string;
        this.symbolName = string2;
        this.objectType = aSTObjectTypeDefinition;
    }

    public boolean isGroup() {
        if (this.objectType != null) {
            return false;
        }
        boolean bl = false;
        Enumeration enumeration = this.children.elements();
        while (enumeration.hasMoreElements()) {
            MibNode mibNode = (MibNode)enumeration.nextElement();
            if (mibNode == null || !mibNode.isAssociated()) continue;
            bl = true;
        }
        return bl;
    }

    public boolean oldIsValidGroup() throws IOException {
        if (this.objectType != null) {
            return false;
        }
        boolean bl = false;
        MibNode mibNode = null;
        Enumeration enumeration = this.children.elements();
        while (enumeration.hasMoreElements()) {
            MibNode mibNode2 = (MibNode)enumeration.nextElement();
            if (mibNode2 == null) continue;
            if (mibNode2.isAssociated()) {
                bl = true;
            }
            if (!mibNode2.isGroup()) continue;
            mibNode = mibNode2;
        }
        if (bl && mibNode != null) {
            throw new IOException(mibNode.getComputedOid());
        }
        return bl;
    }

    public boolean isValidGroup() throws IOException {
        if (this.objectType != null) {
            return false;
        }
        boolean bl = false;
        Enumeration enumeration = this.children.elements();
        while (enumeration.hasMoreElements()) {
            MibNode mibNode = (MibNode)enumeration.nextElement();
            if (mibNode == null) continue;
            if (mibNode.isAssociated()) {
                bl = true;
                continue;
            }
            if (!mibNode.isGroup() && !mibNode.hasNestedGroups()) continue;
        }
        return bl;
    }

    public boolean hasNestedGroups() {
        if (this.objectType != null) {
            return false;
        }
        boolean bl = false;
        Enumeration enumeration = this.children.elements();
        while (enumeration.hasMoreElements()) {
            MibNode mibNode = (MibNode)enumeration.nextElement();
            if (mibNode == null) continue;
            if (mibNode.isAssociated() || mibNode.isGroup()) {
                bl = true;
                continue;
            }
            if (!mibNode.hasNestedGroups()) continue;
            bl = true;
        }
        return bl;
    }

    public boolean isSimpleGroup() {
        return this.isGroup() && !this.hasNestedGroups();
    }

    public boolean isComplexGroup() {
        return this.isGroup() && this.hasNestedGroups();
    }

    public boolean isTable() {
        if (this.isGroup()) {
            return false;
        }
        if (this.hasNestedGroups()) {
            return false;
        }
        if (this.children.isEmpty()) {
            return false;
        }
        return this.isAssociated();
    }

    public void dump(String string) {
        System.out.println(this.toString(string));
        Enumeration enumeration = this.children.elements();
        while (enumeration.hasMoreElements()) {
            MibNode mibNode = (MibNode)enumeration.nextElement();
            if (mibNode == null) continue;
            mibNode.dump(string + " ");
        }
    }

    public String toString(String string) {
        return string + this.toString();
    }

    public String toString() {
        if (this.isAssociated()) {
            return "Name= " + this.symbolName + " OID= " + this.oid + " GROUP= " + String.valueOf(this.isGroup());
        }
        return "OID= " + this.computedOid + " Name= " + this.oidName + " GROUP= " + String.valueOf(this.isGroup());
    }

    public void addExternalIndex(MibNode mibNode) {
        if (!this.externalIndex.contains(mibNode)) {
            this.externalIndex.addElement(mibNode);
        }
    }

    public Vector getExternalIndex() {
        return this.externalIndex;
    }

    public void setFixedLength(long l) {
        this.length = l;
    }

    public long getFixedLength() {
        return this.length;
    }
}

