/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opencard.server;

import com.sun.opencard.common.EventDispatcher;
import com.sun.opencard.common.OCFConstants;
import com.sun.opencard.common.OCFDebug;
import com.sun.opencard.server.OCFCardHandle;
import com.sun.opencard.server.OCFClientHandle;
import com.sun.opencard.service.unknowncard.UnknownCardServiceFactory;
import com.sun.opencard.utils.OCFUtils;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import opencard.core.event.CardTerminalEvent;
import opencard.core.service.CardServiceException;
import opencard.core.service.CardServiceFactory;
import opencard.core.service.CardServiceRegistry;
import opencard.core.service.SmartCard;
import opencard.core.terminal.CardID;
import opencard.core.terminal.CardTerminal;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CardTerminalRegistry;
import opencard.core.terminal.Slot;
import opencard.core.util.OpenCardPropertyLoadingException;

public class OCFServer {
    private static long curClientHandle = 1L;
    private static long curCardHandle = 1L;
    private static Hashtable clientHandles = new Hashtable();
    private static EventDispatcher clientCloseEventDispatcher = new EventDispatcher();
    private static Hashtable cardHandles = new Hashtable();
    private static HashMap cardHandlesByReaderName = new HashMap();
    private static String cardTableLock = "cardTableLock";
    private static CardServiceRegistry cardServiceRegistry;
    private static CardTerminalRegistry cardTerminalRegistry;
    private static float OCF_version;
    private static UnknownCardServiceFactory unknownCardServiceFactory;
    private static ATRPropertyChangeListener propertyChangeListener;

    public static void initializeOCF() {
        OCFServer.debug("initializeOCF", "");
        try {
            SmartCard.start();
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        catch (CardServiceException cardServiceException) {
            cardServiceException.printStackTrace();
        }
        catch (OpenCardPropertyLoadingException openCardPropertyLoadingException) {
            openCardPropertyLoadingException.printStackTrace();
        }
        catch (CardTerminalException cardTerminalException) {
            cardTerminalException.printStackTrace();
        }
        cardServiceRegistry = CardServiceRegistry.getRegistry();
        unknownCardServiceFactory = new UnknownCardServiceFactory();
        cardServiceRegistry.addToEnd(unknownCardServiceFactory);
        cardTerminalRegistry = CardTerminalRegistry.getRegistry();
        clientCloseEventDispatcher.activate();
        OCFServer.debug("initializeOCF", "complete");
    }

    public static void shutdownOCF() throws Exception {
        SmartCard.shutdown();
    }

    public static synchronized long createClientHandle(String string, long l, String string2, String string3) {
        OCFClientHandle oCFClientHandle = new OCFClientHandle(string, curClientHandle, l, string2, string3, clientCloseEventDispatcher);
        clientHandles.put(new Long(curClientHandle), oCFClientHandle);
        return curClientHandle++;
    }

    public static synchronized void removeClientHandle(OCFClientHandle oCFClientHandle) throws Exception {
        oCFClientHandle.close();
        clientHandles.remove(new Long(oCFClientHandle.getValue()));
    }

    public static OCFClientHandle getClientHandle(long l) {
        return (OCFClientHandle)clientHandles.get(new Long(l));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OCFCardHandle removeHandle(String string) {
        OCFServer.debug("removeHandle", "checking available handle for " + string);
        String string2 = cardTableLock;
        synchronized (string2) {
            OCFCardHandle oCFCardHandle;
            block4: {
                oCFCardHandle = (OCFCardHandle)cardHandlesByReaderName.remove(string);
                if (oCFCardHandle != null) break block4;
                OCFServer.debug("removeHandle", "Handle not found for " + string);
                OCFCardHandle oCFCardHandle2 = null;
                return oCFCardHandle2;
            }
            OCFServer.debug("removeHandle", oCFCardHandle.toString());
            cardHandles.remove(new Long(oCFCardHandle.getHandle()));
            oCFCardHandle.close();
            OCFCardHandle oCFCardHandle3 = oCFCardHandle;
            return oCFCardHandle3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public static OCFCardHandle getCardHandle(String string, String string2) {
        OCFServer.debug("getCardHandle", "");
        OCFCardHandle oCFCardHandle = null;
        String string3 = cardTableLock;
        synchronized (string3) {
            if (string2 == null) {
                Enumeration enumeration = cardHandles.elements();
                if (!enumeration.hasMoreElements()) {
                    OCFCardHandle oCFCardHandle2 = null;
                    return oCFCardHandle2;
                }
                oCFCardHandle = (OCFCardHandle)enumeration.nextElement();
            } else {
                oCFCardHandle = (OCFCardHandle)cardHandlesByReaderName.get(string2);
                if (oCFCardHandle == null) {
                    OCFCardHandle oCFCardHandle3 = null;
                    return oCFCardHandle3;
                }
            }
        }
        if (string == null || string.equals(oCFCardHandle.getCardName())) {
            OCFServer.debug("getCardHandle", "returning " + oCFCardHandle);
            return oCFCardHandle;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OCFCardHandle createCardHandle(CardTerminalEvent cardTerminalEvent) {
        OCFServer.debug("createCardHandle", "");
        Slot slot = cardTerminalEvent.getSlot();
        CardID cardID = null;
        SmartCard smartCard = null;
        try {
            cardID = slot.getCardID();
            if (cardID == null) {
                OCFServer.debug("createCardHandle", "cardID is null");
                return null;
            }
            smartCard = SmartCard.getSmartCard(cardTerminalEvent);
            if (smartCard == null) {
                OCFServer.debug("createCardHandle", "smartCard is null");
                return null;
            }
        }
        catch (CardTerminalException cardTerminalException) {
            OCFDebug.printStackTrace(cardTerminalException);
            return null;
        }
        CardServiceFactory cardServiceFactory = cardServiceRegistry.find(cardID);
        OCFCardHandle oCFCardHandle = null;
        String string = cardTableLock;
        synchronized (string) {
            oCFCardHandle = new OCFCardHandle(curCardHandle, smartCard, slot, cardID);
            oCFCardHandle.setCardServiceFactory(cardServiceFactory);
            cardHandles.put(new Long(curCardHandle), oCFCardHandle);
            cardHandlesByReaderName.put(oCFCardHandle.getReaderName(), oCFCardHandle);
            ++curCardHandle;
        }
        return oCFCardHandle;
    }

    private static void updateCardHandles(String string) {
        OCFServer.debug("updateCardHandles", cardHandles.size() + " handles");
        CardServiceFactory cardServiceFactory = cardServiceRegistry.getCardServiceFactory(string);
        if (cardServiceFactory == null) {
            OCFServer.debug("updateCardHandles", "CardServiceFactory not found: " + string);
            return;
        }
        Enumeration enumeration = cardHandles.elements();
        while (enumeration.hasMoreElements()) {
            OCFCardHandle oCFCardHandle = (OCFCardHandle)enumeration.nextElement();
            String string2 = oCFCardHandle.getCardName();
            OCFServer.debug("updateCardHandles", "current name = " + string2);
            if (!unknownCardServiceFactory.getName().equals(string2) || !cardServiceFactory.knows(oCFCardHandle.getCardID())) continue;
            oCFCardHandle.setCardServiceFactory(cardServiceFactory);
        }
    }

    public static OCFCardHandle getCardHandle(long l) {
        return (OCFCardHandle)cardHandles.get(new Long(l));
    }

    public static boolean checkVersion(float f) {
        return f <= OCF_version;
    }

    public static boolean noCardsConfig() {
        Enumeration enumeration = cardServiceRegistry.getCardServiceFactories();
        return !enumeration.hasMoreElements();
    }

    public static boolean noReadersConfig() {
        Enumeration enumeration = cardTerminalRegistry.getCardTerminals();
        return !enumeration.hasMoreElements();
    }

    public static boolean isSupportedCard(String string) {
        return cardServiceRegistry.getCardServiceFactory(string) != null;
    }

    public static boolean isSupportedReader(String string) {
        return cardTerminalRegistry.cardTerminalForName(string) != null;
    }

    public static Enumeration listSupportedCards() {
        Vector<String> vector = new Vector<String>();
        Enumeration enumeration = cardServiceRegistry.getCardServiceFactories();
        while (enumeration.hasMoreElements()) {
            CardServiceFactory cardServiceFactory = (CardServiceFactory)enumeration.nextElement();
            vector.add(cardServiceFactory.getName());
        }
        return vector.elements();
    }

    public static List listTerminalNames(OCFClientHandle oCFClientHandle) throws Exception {
        String string;
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = oCFClientHandle.getDisplay();
        String string3 = oCFClientHandle.getFilterKey();
        long l = oCFClientHandle.getUID();
        try {
            string = OCFUtils.getProperty("ocf.client.default.defaultreader", null);
        }
        catch (Exception exception) {
            string = "";
        }
        Enumeration enumeration = cardTerminalRegistry.getCardTerminals();
        while (enumeration.hasMoreElements()) {
            boolean bl;
            int n;
            CardTerminal cardTerminal = (CardTerminal)enumeration.nextElement();
            String string4 = cardTerminal.getFilterKey();
            String string5 = cardTerminal.getName();
            String string6 = string5;
            if (string6.endsWith("|" + string4)) {
                n = string6.lastIndexOf("|");
                string6 = string6.substring(0, n);
            }
            n = string3.equals(":*") ? 1 : 0;
            boolean bl2 = bl = string3.equals(string4) || n != 0 && string2.equals(string4);
            if (bl) {
                if (!OCFServer.isTerminalAccessable(cardTerminal, l)) continue;
                if (string6.equals(string)) {
                    arrayList.add(0, string6);
                    continue;
                }
                arrayList.add(string6);
                continue;
            }
            if (n == 0 || !OCFServer.isTerminalAccessable(cardTerminal, l)) continue;
            if (string6.equals(string)) {
                arrayList.add(0, string5);
                continue;
            }
            arrayList.add(string5);
        }
        return arrayList;
    }

    public static String getTerminalInfo(OCFClientHandle oCFClientHandle, String string, String string2) {
        CardTerminal cardTerminal = cardTerminalRegistry.cardTerminalForName(string);
        if (cardTerminal == null) {
            return null;
        }
        Properties properties = cardTerminal.features();
        String string3 = properties.getProperty(string2);
        return string3;
    }

    private static boolean isTerminalAccessable(CardTerminal cardTerminal, long l) {
        return cardTerminal.isClientAuthorized(l);
    }

    public static boolean isTerminalVisible(OCFClientHandle oCFClientHandle, String string) {
        boolean bl;
        CardTerminal cardTerminal = cardTerminalRegistry.cardTerminalForName(string);
        if (cardTerminal == null) {
            return false;
        }
        String string2 = cardTerminal.getFilterKey();
        String string3 = oCFClientHandle.getFilterKey();
        String string4 = oCFClientHandle.getDisplay();
        boolean bl2 = string3.equals(":*");
        boolean bl3 = bl = string3.equals(string2) || bl2 && string4.equals(string2);
        return (bl2 || bl) && OCFServer.isTerminalAccessable(cardTerminal, oCFClientHandle.getUID());
    }

    public static String getTerminalRawName(OCFClientHandle oCFClientHandle, String string) {
        if (string.equals(OCFConstants.OCF_WaitForCardSpec_AnyReader) || string.equals(OCFConstants.OCF_WaitForCardSpec_DefaultReader)) {
            return string;
        }
        String string2 = oCFClientHandle.getDisplay();
        String string3 = oCFClientHandle.getFilterKey();
        if (!string3.equals(":*")) {
            string2 = string3;
        }
        String string4 = string + "|" + string2;
        String string5 = string;
        CardTerminal cardTerminal = cardTerminalRegistry.cardTerminalForName(string5);
        if (cardTerminal == null) {
            string5 = string4;
            cardTerminal = cardTerminalRegistry.cardTerminalForName(string5);
        }
        if (cardTerminal != null && OCFServer.isTerminalAccessable(cardTerminal, oCFClientHandle.getUID())) {
            return string5;
        }
        return null;
    }

    private static void debug(String string, String string2) {
        try {
            OCFDebug.debugln("OCFServer : <" + string + "> " + string2);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        OCF_version = 1.0f;
        propertyChangeListener = new ATRPropertyChangeListener();
        OCFUtils.addPropertyChangeListener(propertyChangeListener);
    }

    private static class ATRPropertyChangeListener
    implements PropertyChangeListener {
        private ATRPropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = OCFConstants.OCF_SERVER_PROPERTY_PREFIX;
            int n = string.length();
            int n2 = ".ATR".length();
            String string2 = propertyChangeEvent.getPropertyName();
            if (string2.startsWith(string) && string2.endsWith(".ATR")) {
                String string3 = string2.substring(n, string2.length() - n2);
                this.debug("propertyChange", "ATR for " + string3 + " changed");
                OCFServer.updateCardHandles(string3);
            }
        }

        private void debug(String string, String string2) {
            try {
                OCFDebug.debugln("ATRPropertyChangeListener : <" + string + "> " + string2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

