/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opencard.service.common;

import com.sun.opencard.service.common.OCFCardException;
import opencard.core.OpenCardException;

public class IButtonException
extends OpenCardException {
    public int status;

    public IButtonException(int n, String string) {
        super(Integer.toHexString(n) + " " + string);
        this.status = n;
    }

    public static String errorString(int n) {
        return IButtonException.IbuttonErrorString(n);
    }

    public static String errorByte(byte[] byArray) {
        byte by = byArray[0];
        switch (by) {
            case 98: {
                return "Out of Memory Error";
            }
            case 97: {
                return "Stack Overflow Error";
            }
            case 99: {
                return "Unknown Error";
            }
            case 100: {
                return "Internal Error";
            }
            case 101: {
                return "Illegal Access Error";
            }
        }
        return "unknown error";
    }

    public static String IbuttonErrorString(int n) {
        String string = OCFCardException.errorString(n);
        int n2 = n >> 8;
        int n3 = n & 0xFF;
        switch (n2) {
            case 100: {
                switch (n3) {
                    case 0: {
                        return "Insufficient Memory";
                    }
                }
                break;
            }
            case 99: {
                if (n3 != 1) break;
                return "Success Packet";
            }
            case 144: {
                switch (n3) {
                    case 0: {
                        return "Success";
                    }
                }
                break;
            }
            case 105: {
                switch (n3) {
                    case 0: {
                        return "command not allowed";
                    }
                    case 1: {
                        return "Invalid AID Length";
                    }
                    case 2: {
                        return "Invalid API version";
                    }
                    case 3: {
                        return "Invalid Password";
                    }
                    case 4: {
                        return "Invalid Signature length";
                    }
                    case 5: {
                        return "Hash Corruption";
                    }
                    case 6: {
                        return "Hash Failure";
                    }
                    case 130: {
                        return "Invalid Signature";
                    }
                }
                break;
            }
            case 106: {
                switch (n3) {
                    case 130: {
                        return "Unable to select Applet";
                    }
                    case 132: {
                        return "Class Length overrun";
                    }
                    case 134: {
                        return "Invalid Loader command";
                    }
                    case 135: {
                        return "Invalid/Incomplete packet";
                    }
                }
                break;
            }
            case 111: {
                return "Uncaught Exception";
            }
        }
        return string;
    }
}

