/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opencard.service.common;

import com.sun.opencard.common.OCFDebug;
import com.sun.opencard.opt.security.CertificateAlias;
import com.sun.opencard.opt.security.PrivateKeyAlias;
import com.sun.opencard.service.common.OCFCardException;
import com.sun.opencard.service.common.OCFCode;
import com.sun.opencard.service.common.ServiceUtil;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStreamReader;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.util.Arrays;
import java.util.Vector;
import opencard.core.OpenCardException;
import opencard.core.service.CardService;
import opencard.core.service.CardServiceException;
import opencard.core.service.CardServiceScheduler;
import opencard.core.service.SmartCard;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.ResponseAPDU;
import opencard.opt.terminal.ISOCommandAPDU;
import sun.misc.BASE64Decoder;
import sun.security.x509.X509CertImpl;

public abstract class KeyImportCardService
extends CardService {
    private static int PACKET_SIZE = 116;
    protected OCFCode ocf_codes;
    int MODLEN = 0;

    public void importPrivateKey(byte[] byArray, PrivateKeyAlias privateKeyAlias, PrivateKey privateKey) throws CardServiceException, CardTerminalException, InvalidKeyException, OpenCardException, OCFCardException {
        try {
            try {
                byte[] byArray2;
                byArray = ServiceUtil.paddingZero(byArray, this.ocf_codes.USER_PIN_LENGTH_Byte());
                if (!(privateKey instanceof RSAPrivateKey)) {
                    throw new InvalidKeyException();
                }
                BigInteger bigInteger = ((RSAPrivateKey)privateKey).getModulus().abs();
                byte[] byArray3 = bigInteger.toByteArray();
                System.out.println("mod sign: " + bigInteger.signum());
                System.out.println(bigInteger.toString());
                BigInteger bigInteger2 = ((RSAPrivateKey)privateKey).getPrivateExponent().abs();
                byte[] byArray4 = bigInteger2.toByteArray();
                System.out.println("private sign: " + bigInteger2.signum());
                System.out.println("mod length:" + byArray3.length);
                this.MODLEN = byArray3.length;
                System.out.println("privateExponent length:" + byArray4.length);
                System.out.println(bigInteger2.toString());
                byte[] byArray5 = ServiceUtil.shortToByteArray((short)64);
                this.setup();
                byte[] byArray6 = privateKeyAlias.getAlias().getBytes();
                byte[] byArray7 = ServiceUtil.arrayJoin(byArray, byArray6);
                System.out.println("arrayIn: " + new String(byArray7, 0, byArray7.length));
                int n = 0;
                while (n < byArray7.length) {
                    System.out.print(Integer.toHexString(byArray7[n]));
                    ++n;
                }
                ISOCommandAPDU iSOCommandAPDU = new ISOCommandAPDU((int)this.ocf_codes.Select_RSAByte(), (int)this.ocf_codes.SET_ID_Byte(), 0, 0, byArray7);
                ResponseAPDU responseAPDU = this.sendAPDU(iSOCommandAPDU);
                if (byArray3[0] == 0) {
                    byArray2 = new byte[byArray3.length - 1];
                    System.arraycopy(byArray3, 1, byArray2, 0, byArray3.length - 1);
                    byArray7 = ServiceUtil.arrayJoin(byArray, byArray2);
                    this.MODLEN = byArray2.length;
                } else {
                    byArray7 = ServiceUtil.arrayJoin(byArray, byArray3);
                }
                iSOCommandAPDU = new ISOCommandAPDU((int)this.ocf_codes.Select_RSAByte(), (int)this.ocf_codes.SET_MOD_Byte(), 0, 0, byArray7);
                responseAPDU = this.sendAPDU(iSOCommandAPDU);
                if (byArray4[0] == 0) {
                    byArray2 = new byte[byArray4.length - 1];
                    System.arraycopy(byArray4, 1, byArray2, 0, byArray4.length - 1);
                    byArray7 = ServiceUtil.arrayJoin(byArray, byArray2);
                } else {
                    byArray7 = ServiceUtil.arrayJoin(byArray, byArray4);
                }
                iSOCommandAPDU = new ISOCommandAPDU((int)this.ocf_codes.Select_RSAByte(), (int)this.ocf_codes.SET_PRIVEXP_Byte(), 0, 0, byArray7);
                responseAPDU = this.sendAPDU(iSOCommandAPDU);
                byArray7 = ServiceUtil.arrayJoin(byArray, byArray5);
                iSOCommandAPDU = new ISOCommandAPDU((int)this.ocf_codes.Select_RSAByte(), (int)this.ocf_codes.CREATE_PRIVKEY_Byte(), 0, 0, byArray7);
                responseAPDU = this.sendAPDU(iSOCommandAPDU);
                byArray2 = new byte[20];
                SecureRandom secureRandom = null;
                try {
                    secureRandom = SecureRandom.getInstance("SHA1PRNG");
                }
                catch (Exception exception) {
                    throw new CardServiceException(exception.getMessage());
                }
                secureRandom.nextBytes(byArray2);
                int n2 = this.MODLEN;
                byte[] byArray8 = new byte[n2];
                byArray8[0] = 0;
                byArray8[1] = 1;
                int n3 = 2;
                while (n3 < n2 - 1 - byArray2.length) {
                    byArray8[n3] = -1;
                    ++n3;
                }
                byArray8[n3] = 0;
                System.arraycopy(byArray2, 0, byArray8, n3 + 1, byArray2.length);
                BigInteger bigInteger3 = new BigInteger(byArray8);
                BigInteger bigInteger4 = bigInteger3.modPow(bigInteger2, bigInteger);
                byte[] byArray9 = bigInteger4.toByteArray();
                byte[] byArray10 = ServiceUtil.arrayJoin(byArray, byArray8);
                iSOCommandAPDU = new ISOCommandAPDU((int)this.ocf_codes.Select_RSAByte(), 21, 0, 0, byArray10);
                responseAPDU = this.sendAPDU(iSOCommandAPDU);
                byte[] byArray11 = responseAPDU.data();
                int n4 = byArray9[0] == 0 ? 1 : 0;
                int n5 = 0;
                while (n5 < byArray11.length) {
                    if (byArray11[n5] != byArray9[n5 + n4]) {
                        OCFDebug.debugln("bad key");
                        throw new InvalidKeyException();
                    }
                    ++n5;
                }
                OCFDebug.debugln("good key");
            }
            catch (Exception exception) {
                throw new CardServiceException(exception.getMessage());
            }
            Object var27_28 = null;
        }
        catch (Throwable throwable) {
            Object var27_29 = null;
            this.releaseCardChannel();
            throw throwable;
        }
        this.releaseCardChannel();
    }

    public void importCertificate(byte[] byArray, CertificateAlias certificateAlias, byte[] byArray2) throws CardServiceException, CardTerminalException, CertificateException, OpenCardException, OCFCardException {
        int n = 0;
        int n2 = 1;
        try {
            try {
                byte[] byArray3;
                byArray = ServiceUtil.paddingZero(byArray, this.ocf_codes.USER_PIN_LENGTH_Byte());
                this.setup();
                byte[] byArray4 = certificateAlias.getAlias().getBytes();
                byte[] byArray5 = new byte[byArray.length + 1];
                byArray5[0] = (byte)byArray.length;
                System.arraycopy(byArray, 0, byArray5, 1, byArray.length);
                ISOCommandAPDU iSOCommandAPDU = new ISOCommandAPDU((int)this.ocf_codes.Select_RSAByte(), (int)this.ocf_codes.GET_ALIAS_Byte(), 0, 0, byArray5);
                ResponseAPDU responseAPDU = this.sendAPDU(iSOCommandAPDU);
                System.out.println("alias1... ");
                int n3 = 0;
                while (n3 < byArray4.length) {
                    System.out.print(Integer.toHexString(byArray4[n3]));
                    ++n3;
                }
                System.out.println("alias2... ");
                int n4 = 0;
                while (n4 < responseAPDU.data().length) {
                    System.out.print(Integer.toHexString(responseAPDU.data()[n4]));
                    ++n4;
                }
                if (responseAPDU.data().length != 1 || responseAPDU.data()[0] != 120) {
                    if (!Arrays.equals(responseAPDU.data(), byArray4)) {
                        throw new CardServiceException("wrong alias");
                    }
                    System.out.println("valid alias");
                }
                System.out.println("certBytes length: " + byArray2.length);
                byte[] byArray6 = new byte[4];
                ServiceUtil.intToByteArray(byArray6, 0, byArray2.length);
                byte[] byArray7 = ServiceUtil.arrayJoin(byArray, byArray6);
                System.out.println("arrayIn : ");
                int n5 = 0;
                while (n5 < byArray7.length) {
                    System.out.print(Integer.toHexString(byArray7[n5]));
                    ++n5;
                }
                iSOCommandAPDU = new ISOCommandAPDU((int)this.ocf_codes.Select_RSAByte(), 12, n, 0, byArray7);
                responseAPDU = this.sendAPDU(iSOCommandAPDU);
                int n6 = 0;
                short s = 0;
                int n7 = byArray2.length;
                boolean bl = false;
                System.out.println("bytesToSend: " + n7);
                while (n7 > 0) {
                    System.out.println("bytesSent: " + n6);
                    s = n7 <= PACKET_SIZE ? (short)n7 : (short)PACKET_SIZE;
                    System.out.println("dataSize: " + s);
                    byArray3 = new byte[s];
                    System.arraycopy(byArray2, n6, byArray3, 0, s);
                    byArray7 = ServiceUtil.arrayJoin(byArray, byArray3);
                    iSOCommandAPDU = new ISOCommandAPDU((int)this.ocf_codes.Select_RSAByte(), 12, n2, 0, byArray7);
                    responseAPDU = this.sendAPDU(iSOCommandAPDU);
                    System.out.println("bytesToSend: " + (n7 -= s));
                    System.out.println("bytesSent: " + (n6 += s));
                }
                iSOCommandAPDU = new ISOCommandAPDU(this.ocf_codes.Select_RSAByte(), 13, 0, 0);
                responseAPDU = this.sendAPDU(iSOCommandAPDU);
                byArray3 = responseAPDU.data();
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(byArray3)));
                X509CertImpl x509CertImpl = null;
                x509CertImpl = KeyImportCardService.ParseCert(byArray3);
                System.out.println("cert read back: " + x509CertImpl.toString());
            }
            catch (Exception exception) {
                throw new CardServiceException(exception.getMessage());
            }
            Object var23_23 = null;
        }
        catch (Throwable throwable) {
            Object var23_24 = null;
            this.releaseCardChannel();
            throw throwable;
        }
        this.releaseCardChannel();
    }

    public Vector readCertificates() throws CardServiceException {
        throw new CardServiceException("method not supported");
    }

    public X509Certificate readCertificate(String string, String string2, String string3) throws CardServiceException {
        throw new CardServiceException("method not supported");
    }

    protected void initialize(CardServiceScheduler cardServiceScheduler, SmartCard smartCard, boolean bl) throws CardServiceException {
        super.initialize(cardServiceScheduler, smartCard, bl);
    }

    public abstract void setup() throws OpenCardException, OCFCardException;

    public abstract ResponseAPDU sendAPDU(ISOCommandAPDU var1) throws OpenCardException, OCFCardException;

    /*
     * Unable to fully structure code
     */
    public static byte[] LoadSingleCert(BufferedReader var0) throws Exception {
        var1_1 = null;
        var2_2 = new StringBuffer();
        var3_3 = new BASE64Decoder();
        var1_1 = var0.readLine();
        if (var1_1 != null) ** GOTO lbl10
        return null;
lbl-1000:
        // 1 sources

        {
            var2_2.append(var1_1);
            var1_1 = var0.readLine();
lbl10:
            // 2 sources

            ** while (var1_1 != null)
        }
lbl11:
        // 1 sources

        System.out.println("length of cert: " + var2_2.length());
        return var3_3.decodeBuffer(var2_2.toString());
    }

    public static X509CertImpl ParseCert(byte[] byArray) {
        X509CertImpl x509CertImpl = null;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        try {
            x509CertImpl = new X509CertImpl(byteArrayInputStream);
        }
        catch (Exception exception) {
            System.out.println("error parsing: " + exception.getMessage());
        }
        return x509CertImpl;
    }
}

