/*
 * Decompiled with CFR 0.152.
 */
package opencard.core.terminal;

import opencard.core.OpenCardRuntimeException;
import opencard.core.terminal.APDU;

public class ResponseAPDU
extends APDU {
    public ResponseAPDU(byte[] byArray) {
        super(byArray);
        if (byArray.length < 2) {
            throw new OpenCardRuntimeException("invalid response adpu, length must be at least 2 bytes");
        }
        this.apdu_length = byArray.length;
    }

    public ResponseAPDU(int n) {
        super(n);
        if (n < 2) {
            throw new OpenCardRuntimeException("invalid response adpu, length must be at least 2 bytes");
        }
    }

    public byte[] data() {
        if (this.apdu_length > 2) {
            byte[] byArray = new byte[this.apdu_length - 2];
            System.arraycopy(this.apdu_buffer, 0, byArray, 0, this.apdu_length - 2);
            return byArray;
        }
        return null;
    }

    public final int sw() {
        return this.sw1() << 8 & 0xFF00 | this.sw2() & 0xFF;
    }

    public final byte sw1() {
        return this.apdu_buffer[this.apdu_length - 2];
    }

    public final byte sw2() {
        return this.apdu_buffer[this.apdu_length - 1];
    }
}

