/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.patchmgr.client;

import com.sun.admin.cis.common.ActionString;
import com.sun.admin.cis.common.Constraints;
import com.sun.admin.cis.common.ContextHelpListener;
import com.sun.admin.cis.common.GenInfoPanel;
import com.sun.admin.cis.common.ResourceStrings;
import com.sun.admin.cis.common.SelectableLabel;
import com.sun.admin.patchmgr.client.AnalyzeAddPatchWizard;
import com.sun.admin.patchmgr.client.PatchContextHelpListener;
import com.sun.admin.patchmgr.client.VPatchMgr;
import com.sun.admin.patchmgr.common.AssessedPatchData;
import com.sun.management.viper.console.gui.wizard.VWizardCard;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.event.FocusListener;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class AnalyzeReviewCard
extends VWizardCard {
    private VPatchMgr theApp;
    private ResourceBundle bundle;
    private AnalyzeAddPatchWizard wiz;
    private ActionString actionString;
    private GenInfoPanel infoPanel;
    private PatchContextHelpListener overviewHelpListener;
    private PatchContextHelpListener patchHelp;
    private PatchContextHelpListener downHelp;
    private PatchContextHelpListener backHelp;
    private SelectableLabel downdirField;
    private SelectableLabel backdirField;
    private JList reviewList;
    private JLabel patchLbl = new JLabel();
    private JLabel downLbl = new JLabel();
    private JLabel backLbl = new JLabel();
    public static final int HELP_CACHE_SIZE = 4;
    private static final String ANALYZE_WIZ_S5_OVERVIEW = "analyze_wiz_s5_overview";
    private static final String ANALYZE_WIZ_S5_PATCH = "analyze_wiz_s5_patch";
    private static final String ANALYZE_WIZ_S5_DOWNDIR = "analyze_wiz_s5_downdir";
    private static final String ANALYZE_WIZ_S5_BACKDIR = "analyze_wiz_s5_backdir";
    public static final int VISIBLE_ROWS = 8;

    public AnalyzeReviewCard(VPatchMgr vPatchMgr, AnalyzeAddPatchWizard analyzeAddPatchWizard) {
        this.theApp = vPatchMgr;
        this.bundle = vPatchMgr.getResourceBundle();
        this.wiz = analyzeAddPatchWizard;
        super.setTitle(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"analyze_step5_review"));
        this.constructStep();
    }

    private void constructStep() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        this.initLabel(this.patchLbl, "aa_wiz_patch_lbl");
        this.reviewList = new JList();
        this.reviewList.setVisibleRowCount(8);
        String string = "RXXXXXX-XX ";
        this.reviewList.setPrototypeCellValue(string);
        Font font = this.patchLbl.getFont();
        if (font != null) {
            this.reviewList.setFixedCellHeight(font.getSize() + 3);
        } else {
            this.reviewList.setFixedCellHeight(20);
        }
        this.reviewList.setBackground(this.getBackground());
        this.patchLbl.setLabelFor(this.reviewList);
        JScrollPane jScrollPane = new JScrollPane(this.reviewList);
        jScrollPane.getViewport().add(this.reviewList, null, -1);
        double d = 8 * this.reviewList.getFixedCellHeight();
        double d2 = jScrollPane.getPreferredSize().getHeight() - jScrollPane.getViewport().getPreferredSize().getHeight();
        d += d2;
        d2 = jScrollPane.getVerticalScrollBar().getPreferredSize().getWidth();
        double d3 = (double)this.reviewList.getFixedCellWidth() + d2;
        jScrollPane.setPreferredSize(new Dimension((int)d3, (int)d));
        jScrollPane.setMinimumSize(jScrollPane.getPreferredSize());
        this.initLabel(this.downLbl, "aa_wiz_downdir_lbl");
        this.downdirField = new SelectableLabel("", 18);
        this.downLbl.setLabelFor((Component)this.downdirField);
        this.initLabel(this.backLbl, "aa_wiz_backdir_lbl");
        this.backdirField = new SelectableLabel("", 18);
        this.backLbl.setLabelFor((Component)this.backdirField);
        Constraints.constrain((Container)((Object)this), (Component)this.patchLbl, (int)0, (int)0, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0, (int)24, (int)12, (int)0, (int)0);
        Constraints.constrain((Container)((Object)this), (Component)jScrollPane, (int)1, (int)0, (int)1, (int)1, (int)2, (int)17, (double)0.0, (double)0.0, (int)24, (int)12, (int)0, (int)5);
        Constraints.constrain((Container)((Object)this), (Component)this.downLbl, (int)0, (int)1, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (int)5, (int)12, (int)0, (int)0);
        Constraints.constrain((Container)((Object)this), (Component)this.downdirField, (int)1, (int)1, (int)1, (int)1, (int)2, (int)17, (double)0.0, (double)0.0, (int)5, (int)12, (int)0, (int)5);
        Constraints.constrain((Container)((Object)this), (Component)this.backLbl, (int)0, (int)2, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0, (int)5, (int)12, (int)0, (int)0);
        Constraints.constrain((Container)((Object)this), (Component)this.backdirField, (int)1, (int)2, (int)1, (int)1, (int)2, (int)18, (double)0.0, (double)0.0, (int)5, (int)12, (int)0, (int)5);
        Constraints.constrain((Container)((Object)this), (Component)new JPanel(), (int)2, (int)2, (int)1, (int)1, (int)0, (int)17, (double)1.0, (double)1.0, (int)5, (int)12, (int)0, (int)5);
        this.reviewList.addFocusListener((FocusListener)((Object)this.patchHelp));
        this.downdirField.addFocusListener((FocusListener)((Object)this.downHelp));
        this.backdirField.addFocusListener((FocusListener)((Object)this.backHelp));
    }

    public void loadHelp() {
        Vector vector = new Vector(4);
        this.infoPanel = this.wiz.getInfoPanel();
        this.overviewHelpListener = new PatchContextHelpListener(this.theApp, vector, this.infoPanel, ANALYZE_WIZ_S5_OVERVIEW);
        this.patchHelp = new PatchContextHelpListener(this.theApp, vector, this.infoPanel, ANALYZE_WIZ_S5_PATCH);
        this.downHelp = new PatchContextHelpListener(this.theApp, vector, this.infoPanel, ANALYZE_WIZ_S5_DOWNDIR);
        this.backHelp = new PatchContextHelpListener(this.theApp, vector, this.infoPanel, ANALYZE_WIZ_S5_BACKDIR);
        ContextHelpListener.loadHelp(vector);
    }

    private void initLabel(JLabel jLabel, String string) {
        this.actionString = new ActionString(this.bundle, string);
        jLabel.setText(this.actionString.getString());
        jLabel.setDisplayedMnemonic(this.actionString.getMnemonic());
    }

    public void start() {
        super.start();
        Vector vector = this.wiz.getPatchList();
        int n = vector.size();
        Vector<String> vector2 = new Vector<String>(n);
        AssessedPatchData assessedPatchData = null;
        int n2 = 0;
        while (n2 < n) {
            assessedPatchData = (AssessedPatchData)vector.elementAt(n2);
            vector2.addElement(assessedPatchData.getPatchId());
            ++n2;
        }
        this.reviewList.setListData(vector2);
        String string = this.wiz.getDownloadDir();
        this.downdirField.setText(string);
        String string2 = this.wiz.getBackoutDir();
        if (string2.equals("")) {
            this.backdirField.setText(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"cmn_default"));
        } else {
            this.backdirField.setText(string2);
        }
        if (this.wiz.isItOKToInstall) {
            this.setProperty("vwp.canmovebackward", "vwp.true");
            this.setProperty("vwp.canmoveforward", "vwp.true");
            this.setProperty("vwp.finishstate", "vwp.true");
        } else {
            this.setProperty("vwp.canmovebackward", "vwp.true");
            this.setProperty("vwp.canmoveforward", "vwp.false");
            this.setProperty("vwp.finishstate", "vwp.false");
        }
        this.infoPanel.setFocusListener((FocusListener)((Object)this.overviewHelpListener), true);
    }

    public boolean stop(boolean bl) {
        if (!bl) {
            return true;
        }
        this.wiz.doFinish();
        return true;
    }

    public boolean isSubStep() {
        return false;
    }

    public void reset() {
        this.wiz.setPreventCancel(false);
    }
}

