/*
 * Copyright 2002-2003 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

#ifndef _SYS_MULTIDATA_H
#define	_SYS_MULTIDATA_H

#pragma ident	"@(#)multidata.h	1.1	03/01/28 SMI"

#ifdef	__cplusplus
extern "C" {
#endif

/*
 * Multidata interface declarations.
 * These interfaces are still evolving; do not use them in unbundled drivers.
 */

/*
 * Multidata packet attribute information.
 */
typedef struct pattrinfo_s {
	uint_t	type;		/* attribute type value */
	uint_t	len;		/* attribute length */
	void	*buf;		/* pointer to user data area */
} pattrinfo_t;

/*
 * Multidata buffer information.
 */
typedef struct mbufinfo_s {
	uchar_t	*hbuf_rptr;	/* start address of header buffer */
	uchar_t	*hbuf_wptr;	/* end address of header buffer */
	uchar_t	*pbuf_rptr;	/* start address of payload buffer */
	uchar_t	*pbuf_wptr;	/* end address of payload buffer */
} mbufinfo_t;

/*
 * Multidata packet descriptor information.
 */
typedef struct pdescinfo_s {
	uint_t	flags;		/* misc. flags */
	uchar_t	*hdr_base;	/* start address of header area */
	uchar_t *hdr_rptr;	/* start address of header data */
	uchar_t *hdr_wptr;	/* end address of header data */
	uchar_t	*hdr_lim;	/* end address of header area */
	uchar_t *pld_rptr;	/* start address of payload data */
	uchar_t *pld_wptr;	/* pointer to end of payload data */
} pdescinfo_t;

/*
 * Possible values for flags
 */
#define	PDESC_HBUF_REF	0x1	/* descriptor uses header buffer */
#define	PDESC_PBUF_REF	0x2	/* descriptor uses payload buffer */

#define	PDESC_HDRSIZE(p) ((p)->hdr_lim - (p)->hdr_base)
#define	PDESC_HDRL(p)    ((p)->hdr_wptr - (p)->hdr_rptr)
#define	PDESC_HDRHEAD(p) ((p)->hdr_rptr - (p)->hdr_base)
#define	PDESC_HDRTAIL(p) ((p)->hdr_lim - (p)->hdr_wptr)
#define	PDESC_PLDSIZE(p) ((p)->pld_wptr - (p)->pld_rptr)
#define	PDESC_PLDL(p)    PDESC_PLDSIZE(p)

/*
 * These structures are opaque to multidata clients.
 */
struct pdesc_s;
typedef struct pdesc_s pdesc_t;

struct pattr_s;
typedef struct pattr_s pattr_t;

struct multidata_s;
typedef struct multidata_s multidata_t;

#ifdef _KERNEL

extern int mmd_alloc(mblk_t *, mblk_t *, mblk_t **, multidata_t **, int);
extern multidata_t *mmd_getmultidata(mblk_t *);
extern int mmd_getregions(multidata_t *, mbufinfo_t *);
extern int mmd_getcnt(multidata_t *, uint_t *, uint_t *);
extern int mmd_addpdesc(multidata_t *, pdescinfo_t *, pdesc_t **, int);
extern void mmd_rempdesc(pdesc_t *);
extern pdesc_t *mmd_getfirstpdesc(multidata_t *, pdescinfo_t *);
extern pdesc_t *mmd_getlastpdesc(multidata_t *, pdescinfo_t *);
extern pdesc_t *mmd_getnextpdesc(pdesc_t *, pdescinfo_t *);
extern pdesc_t *mmd_getprevpdesc(pdesc_t *, pdescinfo_t *);
extern int mmd_adjpdesc(pdesc_t *, pdescinfo_t *);
extern int mmd_transform(pdesc_t *, mblk_t **);
extern int mmd_dupbufs(multidata_t *, mblk_t **, mblk_t **);
extern int mmd_getpdescinfo(pdesc_t *, pdescinfo_t *);
extern int mmd_addpattr(multidata_t *, pdesc_t *, pattrinfo_t *,
    pattr_t **, int);
extern void mmd_rempattr(pattr_t *);
extern pattr_t *mmd_getpattr(multidata_t *, pdesc_t *, pattrinfo_t *);

#endif /* _KERNEL */

#ifdef	__cplusplus
}
#endif

#endif	/* _SYS_MULTIDATA_H */
