/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.admserv;

import com.netscape.management.admserv.AdminServer;
import com.netscape.management.admserv.config.BaseConfigPanel;
import com.netscape.management.admserv.panel.AdminConfigPanel;
import com.netscape.management.admserv.panel.DialogFrame;
import com.netscape.management.admserv.panel.IRestartControl;
import com.netscape.management.admserv.panel.RestartOperation;
import com.netscape.management.admserv.panel.StopOperation;
import com.netscape.management.client.IMenuInfo;
import com.netscape.management.client.IMenuItem;
import com.netscape.management.client.IPage;
import com.netscape.management.client.IResourceObject;
import com.netscape.management.client.MenuItemSeparator;
import com.netscape.management.client.MenuItemText;
import com.netscape.management.client.ResourceObject;
import com.netscape.management.client.ResourcePage;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.ModalDialogUtil;
import com.netscape.management.client.util.RemoteImage;
import com.netscape.management.client.util.ResourceSet;
import com.netscape.management.nmclf.SuiOptionPane;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.tree.DefaultMutableTreeNode;

public class AdminServerNode
extends ResourceObject
implements IMenuInfo {
    public static ResourceSet _resource = new ResourceSet("com.netscape.management.admserv.admserv");
    public static Icon _icon = new RemoteImage(_resource.getString("admin", "smallIcon"));
    public static String _i18nMenuConfig = _resource.getString("menu", "Config");
    public static String _i18nMenuRestart = _resource.getString("menu", "Restart");
    public static String _i18nMenuStop = _resource.getString("menu", "Stop");
    public static String _i18nDescrMenuConfig = _resource.getString("menuDescription", "ConfigAdmin");
    public static String _i18nDescrMenuRestart = _resource.getString("menuDescription", "RestartAdmin");
    public static String _i18nDescrMenuStop = _resource.getString("menuDescription", "StopAdmin");
    public static String _i18nStopTask;
    public static String _i18nAckStop;
    public static String MENU_CONFIG;
    public static String MENU_RESTART;
    public static String MENU_STOP;
    private BaseConfigPanel _configPanel;
    private boolean _menuConfigEnabled;
    private boolean _menuRestartEnabled;
    private boolean _menuStopEnabled;
    private ConsoleInfo _consoleInfo;

    public AdminServerNode(ConsoleInfo ci, String[] taskList) {
        super(AdminServer._resource.getString("admin", "title"));
        this._consoleInfo = ci;
        this._menuConfigEnabled = this.findTask("task.ServerSetup", taskList);
        this._menuRestartEnabled = this.findTask("task.Restart", taskList);
        this._menuStopEnabled = this.findTask("task.Stop", taskList);
        ((DefaultMutableTreeNode)((Object)this)).setAllowsChildren(true);
    }

    private boolean findTask(String task, String[] list) {
        int i = 0;
        while (i < list.length) {
            if (list[i].endsWith(task)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public Icon getIcon() {
        return _icon;
    }

    public String[] getMenuCategoryIDs() {
        return new String[]{"OBJECT", "CONTEXT"};
    }

    public IMenuItem[] getMenuItems(String categoryID) {
        if (categoryID.equals("OBJECT") || categoryID.equals("CONTEXT")) {
            return new IMenuItem[]{new MenuItemSeparator(), new MenuItemText(MENU_CONFIG, _i18nMenuConfig, _i18nDescrMenuConfig, this._menuConfigEnabled), new MenuItemText(MENU_RESTART, _i18nMenuRestart, _i18nDescrMenuRestart, this._menuRestartEnabled), new MenuItemText(MENU_STOP, _i18nMenuStop, _i18nDescrMenuStop, this._menuStopEnabled)};
        }
        return null;
    }

    public void actionMenuSelected(IPage viewInstance, IMenuItem item) {
        if (viewInstance instanceof ResourcePage) {
            if (item.getID().equals(MENU_CONFIG)) {
                ResourcePage page = (ResourcePage)viewInstance;
                this._configPanel = null;
                page.setCustomPanel(this.getCustomPanel());
            } else if (item.getID().equals(MENU_STOP)) {
                ResourcePage page = (ResourcePage)viewInstance;
                int userSelection = SuiOptionPane.showConfirmDialog((Component)page, (Object)_i18nAckStop, (String)_i18nStopTask, (int)0);
                if (userSelection != 0) {
                    return;
                }
                StopOperation operation = new StopOperation(this._consoleInfo);
                operation.monitorOperation("");
                String title = AdminServer._resource.getString("taskName", "stop");
                DialogFrame dialog = new DialogFrame((Component)page, title, operation.getPanel());
                ((Component)((Object)dialog)).setVisible(true);
                dialog.dispose();
                ModalDialogUtil.sleep();
            } else if (item.getID().equals(MENU_RESTART)) {
                ResourcePage page = (ResourcePage)viewInstance;
                if (!this.canRestartFromConsole((JPanel)page)) {
                    return;
                }
                RestartOperation operation = new RestartOperation(this._consoleInfo);
                operation.monitorOperation("");
                String title = AdminServer._resource.getString("taskName", "restart");
                DialogFrame dialog = new DialogFrame((Component)page, title, operation.getPanel());
                ((Component)((Object)dialog)).setVisible(true);
                dialog.dispose();
                ModalDialogUtil.sleep();
            } else {
                Debug.println((String)("Not Yet Implemented: " + item));
            }
        }
    }

    private boolean canRestartFromConsole(JPanel parent) {
        IRestartControl restartControl = (IRestartControl)this._consoleInfo.get("RESTART_CONTROL");
        if (restartControl != null) {
            if (!restartControl.canRestartFromConsole()) {
                String msg = AdminServer._resource.getString("restart", "canNotRestart");
                SuiOptionPane.showMessageDialog((Component)parent, (Object)msg, (String)this.getName(), (int)0);
                return false;
            }
        } else {
            Debug.println((String)"RestartOperation: restart activator not in ConsoleInfo");
        }
        return true;
    }

    public Component getCustomPanel() {
        if (!this._menuConfigEnabled) {
            return null;
        }
        if (this._configPanel == null || !this._configPanel.isInitialized()) {
            this._configPanel = new BaseConfigPanel(new AdminConfigPanel(this._consoleInfo));
        }
        return this._configPanel;
    }

    public boolean run(IPage viewInstance, IResourceObject[] selection) {
        return false;
    }

    static {
        _i18nAckStop = _resource.getString("stop", "ack");
        _i18nStopTask = _resource.getString("taskName", "stop");
        MENU_CONFIG = "CONFIG";
        MENU_RESTART = "RESTART";
        MENU_STOP = "STOP";
    }
}

