/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.admserv.panel;

import com.netscape.management.admserv.config.IConfigDataModel;
import com.netscape.management.admserv.config.RemoteRequestException;
import com.netscape.management.admserv.config.ValidationException;
import com.netscape.management.admserv.panel.CGIAggregateEnumerator;
import com.netscape.management.admserv.panel.CGIDataModel;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.util.Debug;
import java.awt.Component;
import java.util.Enumeration;
import java.util.Hashtable;

public class CGIAggregateDataModel
implements IConfigDataModel {
    private static String _clazz = "CGIAggregateDataModel";
    protected Hashtable _CGIs = new Hashtable();
    protected String _modelName;
    protected ConsoleInfo _consoleInfo;

    public CGIAggregateDataModel(ConsoleInfo consoleInfo) {
        this._consoleInfo = consoleInfo;
    }

    public void add(String prefix, CGIDataModel cgi) {
        this._CGIs.put(prefix, cgi);
    }

    public void remove(String prefix) {
        this._CGIs.remove(prefix);
    }

    public void setDialogParent(Component comp) {
        Enumeration e = this._CGIs.elements();
        while (e.hasMoreElements()) {
            CGIDataModel cgi = (CGIDataModel)e.nextElement();
            cgi.setDialogParent(comp);
        }
    }

    public IConfigDataModel getCGI(String prefix) {
        return (IConfigDataModel)this._CGIs.get(prefix);
    }

    protected String getAttrPrefix(String attrName) {
        int dot = attrName.indexOf(46);
        if (dot > 0) {
            return attrName.substring(0, dot);
        }
        Debug.println((String)("dot not found in " + attrName));
        return null;
    }

    public String getAttribute(String attr) {
        IConfigDataModel cgi = (IConfigDataModel)this._CGIs.get(this.getAttrPrefix(attr));
        if (cgi != null) {
            return cgi.getAttribute(attr);
        }
        Debug.println((String)(_clazz + ".getAttribute() CGI for the attr " + attr + " not in data model"));
        return "";
    }

    public void setAttribute(String attr, String val) throws ValidationException {
        IConfigDataModel cgi = (IConfigDataModel)this._CGIs.get(this.getAttrPrefix(attr));
        if (cgi != null) {
            cgi.setAttribute(attr, val);
        } else {
            Debug.println((String)(_clazz + ".setAttribute() CGI for the attr " + attr + " not in data model"));
        }
    }

    public Enumeration getAttributes() {
        return new CGIAggregateEnumerator(this._CGIs);
    }

    public boolean isLoaded() {
        Enumeration e = this._CGIs.elements();
        while (e.hasMoreElements()) {
            IConfigDataModel cgi = (IConfigDataModel)e.nextElement();
            if (cgi.isLoaded()) continue;
            return false;
        }
        return true;
    }

    public boolean isModified() {
        Enumeration e = this._CGIs.elements();
        while (e.hasMoreElements()) {
            IConfigDataModel cgi = (IConfigDataModel)e.nextElement();
            if (!cgi.isModified()) continue;
            return true;
        }
        return false;
    }

    public void load() throws RemoteRequestException {
        Enumeration e = this._CGIs.elements();
        while (e.hasMoreElements()) {
            IConfigDataModel cgi = (IConfigDataModel)e.nextElement();
            if (cgi.isLoaded()) continue;
            cgi.load();
        }
    }

    public void save() throws RemoteRequestException {
        Enumeration e = this._CGIs.elements();
        while (e.hasMoreElements()) {
            IConfigDataModel cgi = (IConfigDataModel)e.nextElement();
            if (!cgi.isModified()) continue;
            cgi.save();
        }
    }

    public String getModelName() {
        return CGIDataModel.getServerName(this._consoleInfo);
    }

    public ConsoleInfo getConsoleInfo() {
        return this._consoleInfo;
    }
}

