/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.admserv.panel;

import com.netscape.management.admserv.config.ActionMonitorPanel;
import com.netscape.management.admserv.config.IConfigDataModel;
import com.netscape.management.admserv.config.RemoteRequestException;
import com.netscape.management.admserv.config.ValidationException;
import com.netscape.management.admserv.panel.AdminOperation;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.util.AdmTask;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.ResourceSet;
import com.netscape.management.client.util.URLByteEncoder;
import java.awt.Component;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public abstract class CGIDataModel
implements IConfigDataModel {
    static ResourceSet _resource = new ResourceSet("com.netscape.management.admserv.panel.panel");
    static String _i18nProgressLoading = _resource.getString("adminop", "ProgressLoading");
    static String _i18nProgressSaving = _resource.getString("adminop", "ProgressSaving");
    static String _i18nLoadFailed = _resource.getString("adminop", "LoadFailed");
    static String _i18nSaveFailed = _resource.getString("adminop", "SaveFailed");
    protected Hashtable _data;
    protected Hashtable _origData;
    protected ConsoleInfo _consoleInfo;
    protected boolean _loaded;
    protected boolean _saved;
    protected boolean _modified;
    protected String _taskURL;
    protected String _adminURL;
    protected Component _dialogParent;

    public CGIDataModel(ConsoleInfo consoleInfo, String taskURL) {
        this._consoleInfo = consoleInfo;
        this._taskURL = taskURL;
        this._adminURL = this._consoleInfo.getAdminURL() + this._taskURL;
    }

    public static String getServerName(ConsoleInfo ci) {
        String server = (String)ci.get("SERVER_NAME");
        if (server == null) {
            Debug.println((String)"CGIDataModel.getServerName: SERVER_NAME not found in console info");
            return "unknown";
        }
        return server;
    }

    public String getModelName() {
        return CGIDataModel.getServerName(this._consoleInfo);
    }

    public ConsoleInfo getConsoleInfo() {
        return this._consoleInfo;
    }

    public Enumeration getAttributes() {
        return this._data.keys();
    }

    public boolean isLoaded() {
        return this._loaded;
    }

    public void load() throws RemoteRequestException {
        if (ActionMonitorPanel.getActiveInstance() != null) {
            MessageFormat msg = new MessageFormat(_i18nProgressLoading);
            Object[] msgArgs = new Object[]{""};
            ActionMonitorPanel.getActiveInstance().setStatusText(msg.format(msgArgs));
        }
        this._data = this.getConfiguration(this._adminURL, this.getCGIParamsForGetOp());
        boolean bl = this._loaded = !this._data.isEmpty();
        if (!this._loaded) {
            throw new RemoteRequestException(this._adminURL, _i18nLoadFailed);
        }
        this._origData = CGIDataModel.cloneStringHashtable(this._data, null);
    }

    public boolean isModified() {
        return this._modified;
    }

    public void save() throws RemoteRequestException {
        if (ActionMonitorPanel.getActiveInstance() != null) {
            MessageFormat msg = new MessageFormat(_i18nProgressSaving);
            Object[] msgArgs = new Object[]{this.getModelName()};
            ActionMonitorPanel.getActiveInstance().setStatusText(msg.format(msgArgs));
        }
        try {
            this.setConfiguration(this._adminURL, this.getCGIParamsForSetOp());
            if (!this._saved) {
                throw new RemoteRequestException(this._adminURL, _i18nSaveFailed);
            }
        }
        catch (RemoteRequestException e) {
            this._data.clear();
            this._data = CGIDataModel.cloneStringHashtable(this._origData, null);
            throw e;
        }
        this._origData.clear();
        this._origData = CGIDataModel.cloneStringHashtable(this._data, null);
        this._modified = false;
    }

    public String getAttribute(String attr) {
        return (String)this._data.get(attr);
    }

    public void setAttribute(String attr, String val) throws ValidationException {
        String curVal = this.getAttribute(attr);
        if (!this._modified) {
            this._modified = val == null ? curVal != null : !val.equals(curVal);
        }
        this._data.put(attr, val);
    }

    public String toURLformat(Hashtable args) {
        String p = "";
        Enumeration e = args.keys();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            String value = (String)args.get(name);
            p = p + name + "=" + URLByteEncoder.encodeUTF8((String)value) + (e.hasMoreElements() ? "&" : "");
        }
        return p;
    }

    public static Hashtable cloneStringHashtable(Hashtable tbl, String renamePrefix) {
        Hashtable<String, String> out = new Hashtable<String, String>();
        Enumeration e = tbl.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String val = (String)tbl.get(key);
            if (renamePrefix == null) {
                out.put(new String(key), new String(val));
                continue;
            }
            out.put(renamePrefix + key, new String(val));
        }
        return out;
    }

    public static Vector commaStringToVector(String s) {
        Vector<String> v = new Vector<String>();
        if (s != null) {
            StringTokenizer st = new StringTokenizer(s, ",");
            while (st.hasMoreTokens()) {
                v.addElement(st.nextToken());
            }
        }
        return v;
    }

    public static String vectorToCommaString(Vector v) {
        String s = "";
        Enumeration e = v.elements();
        while (e.hasMoreElements()) {
            s = s + e.nextElement();
            if (!e.hasMoreElements()) continue;
            s = s + ",";
        }
        return s;
    }

    public Component getDialogParent() {
        return this._dialogParent;
    }

    public void setDialogParent(Component comp) {
        this._dialogParent = comp;
    }

    public abstract String getCGIParamsForGetOp();

    public abstract String getCGIParamsForSetOp();

    protected Hashtable getConfiguration(String adminURL, String args) throws RemoteRequestException {
        AdmTask task = null;
        try {
            task = new AdmTask(new URL(adminURL), this._consoleInfo.getAuthenticationDN(), this._consoleInfo.getAuthenticationPassword());
        }
        catch (MalformedURLException e) {
            Debug.println((String)("CGIDataModel.getConfiguration " + e));
            throw new RemoteRequestException(e);
        }
        if (args != null) {
            task.setArguments(args);
        }
        task.exec();
        int status = task.getStatus();
        this._loaded = status == 0;
        Debug.println((String)(adminURL + " " + status));
        AdminOperation.processAdmTaskStatus(adminURL, task, this._consoleInfo);
        if (task != null) {
            return task.getResult();
        }
        return new Hashtable();
    }

    protected void setConfiguration(String adminURL, String args) throws RemoteRequestException {
        AdmTask task = null;
        try {
            task = new AdmTask(new URL(adminURL), this._consoleInfo.getAuthenticationDN(), this._consoleInfo.getAuthenticationPassword());
        }
        catch (MalformedURLException e) {
            Debug.println((String)("CGIDataModel.setConfiguration " + e));
            throw new RemoteRequestException(e);
        }
        if (args != null) {
            task.setArguments(args);
        }
        task.exec();
        int status = task.getStatus();
        Debug.println((String)(adminURL + " " + status));
        this._saved = status == 0;
        AdminOperation.processAdmTaskStatus(adminURL, task, this._consoleInfo);
    }
}

