/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.admserv.panel;

import com.netscape.management.admserv.config.GBC;
import com.netscape.management.admserv.config.ValidationException;
import com.netscape.management.admserv.panel.CGISNMPSetup;
import com.netscape.management.admserv.panel.CommunityEditPanel;
import com.netscape.management.admserv.panel.EditableList;
import com.netscape.management.admserv.panel.SNMPCommunityPanel;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.ResourceSet;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

class CommunityList
extends EditableList {
    CommunityEditPanel _editPanel;
    JPanel _detailsPanel;
    JLabel _lblDetailsName;
    JLabel _lblDetailsOperation;
    Vector _communities;
    String _cmdSet = "SET";
    String _cmdGet = "GET";
    String _cmdAll = "ALL";
    static String _i18nEditCommunity = EditableList._resource.getString("snmpcom", "EditCommunityToolTip");
    static String _i18nAddCommunity = EditableList._resource.getString("snmpcom", "AddCommunityToolTip");
    static String _i18nRemoveCommunity = EditableList._resource.getString("snmpcom", "RemoveCommunityToolTip");

    public CommunityList(Vector communities) {
        this.setCommunities(communities);
    }

    public void setCommunities(Vector communities) {
        this._communities = communities;
        this.setList(this.getCommunityNames(this._communities));
    }

    Vector getCommunityNames(Vector entryList) {
        Vector v = new Vector(entryList.size());
        int i = 0;
        while (i < entryList.size()) {
            Hashtable entry = (Hashtable)entryList.elementAt(i);
            v.addElement(entry.get("community"));
            ++i;
        }
        return v;
    }

    public JPanel getEditPanel() {
        this._editPanel = new CommunityEditPanel();
        JTextField[] txtComponents = this._editPanel.getTextComponents();
        this.setEditPanelInitalFocusComponent(txtComponents[0]);
        this.setEditPanelCommitOnEnterComponents(txtComponents);
        return this._editPanel;
    }

    public String getEditTitle() {
        return SNMPCommunityPanel._i18nEditDialogTitle;
    }

    public String getAddTitle() {
        return SNMPCommunityPanel._i18nAddDialogTitle;
    }

    public String getEditToolTip() {
        return _i18nEditCommunity;
    }

    public String getAddToolTip() {
        return _i18nAddCommunity;
    }

    public String getRemoveToolTip() {
        return _i18nRemoveCommunity;
    }

    public ResourceSet getHelpResourceSet() {
        return SNMPCommunityPanel._resource;
    }

    public String getHelpToken() {
        return "editSNMPCommunityHelp";
    }

    public JPanel getDetailsPanel() {
        this._detailsPanel = this.createDetailsPanel();
        return this._detailsPanel;
    }

    public String getDetailsTitle() {
        return SNMPCommunityPanel._i18nDetailsGroupbox;
    }

    private JPanel createDetailsPanel() {
        JPanel p = new JPanel(new GridBagLayout());
        GBC gbc = new GBC();
        JLabel lbl = new JLabel(SNMPCommunityPanel._i18nDetailName, 2);
        gbc.setInsets(0, 0, 0, 0);
        gbc.setGrid(0, 0, 1, 1);
        gbc.setSpace(0.0, 0.0, 18, 1);
        p.add((Component)lbl, gbc);
        this._lblDetailsName = new JLabel(" ", 2);
        gbc.setInsets(0, 10, 0, 0);
        gbc.setGrid(1, 0, 1, 1);
        gbc.setSpace(1.0, 0.0, 18, 2);
        p.add((Component)this._lblDetailsName, gbc);
        lbl = new JLabel(SNMPCommunityPanel._i18nDetailOperations, 2);
        gbc.setInsets(10, 0, 0, 0);
        gbc.setGrid(0, 1, 1, 1);
        gbc.setSpace(0.0, 0.0, 18, 2);
        p.add((Component)lbl, gbc);
        this._lblDetailsOperation = new JLabel(" ", 2);
        gbc.setInsets(10, 10, 0, 0);
        gbc.setGrid(1, 1, 1, 1);
        gbc.setSpace(1.0, 0.0, 18, 2);
        p.add((Component)this._lblDetailsOperation, gbc);
        return p;
    }

    public void validateEdit() throws ValidationException {
        String community = this._editPanel.getCommunity();
        if (community.length() == 0) {
            throw new ValidationException(SNMPCommunityPanel._i18nEditDialogCommunity, SNMPCommunityPanel._i18nMsgEnterCommunity);
        }
    }

    public void setEditPanelParameters(String item) {
        if (item == null) {
            this._editPanel.setCommunity("");
            this._editPanel.setOperation(this._cmdAll);
        } else {
            int idx = this.findCommunity(item);
            if (idx >= 0) {
                Hashtable entry = (Hashtable)this._communities.elementAt(idx);
                this._editPanel.setCommunity(item);
                this._editPanel.setOperation((String)entry.get("operation"));
            } else {
                Debug.println((String)("ERROR: Community not found: " + item));
            }
        }
    }

    public String getEditPanelItem() {
        return this._editPanel.getCommunity();
    }

    private int findCommunity(String name) {
        return CGISNMPSetup.findEntry(this._communities, "community", name);
    }

    public void createItem(String item) {
        this._communities.addElement(CGISNMPSetup.createCommunityEntry(new String(item), new String(this._editPanel.getOperation())));
    }

    public void removeItem(String item) {
        int idx = this.findCommunity(item);
        if (idx >= 0) {
            this._communities.removeElementAt(idx);
        } else {
            Debug.println((String)("ERROR: Community not found: " + item));
        }
    }

    public void updateItem(String item, boolean isRenamed) {
        int idx = this.findCommunity(item);
        if (idx >= 0) {
            Hashtable entry = CGISNMPSetup.createCommunityEntry(new String(this._editPanel.getCommunity()), new String(this._editPanel.getOperation()));
            this._communities.setElementAt(entry, idx);
        } else {
            Debug.println((String)("ERROR: Community not found: " + item));
        }
    }

    private void dumpData() {
        if (this._communities.size() == 0) {
            Debug.println((String)"No entries");
            return;
        }
        int i = 0;
        while (i < this._communities.size()) {
            Hashtable entry = (Hashtable)this._communities.elementAt(i);
            String community = (String)entry.get("community");
            String operation = (String)entry.get("operation");
            Debug.print((String)(i + "=[" + community + " " + operation + "] "));
            ++i;
        }
        Debug.println((String)"");
    }

    public void selectItem(String item) {
        if (item == null) {
            this._lblDetailsName.setText("");
            this._lblDetailsOperation.setText("");
            return;
        }
        int idx = this.findCommunity(item);
        if (idx >= 0) {
            Hashtable entry = (Hashtable)this._communities.elementAt(idx);
            String community = (String)entry.get("community");
            String operation = (String)entry.get("operation");
            this._lblDetailsName.setText(community);
            if (operation.equals(this._cmdAll)) {
                operation = SNMPCommunityPanel._i18nOperationsAll;
            } else if (operation.equals(this._cmdGet)) {
                operation = SNMPCommunityPanel._i18nOperationsGET;
            } else if (operation.equals(this._cmdSet)) {
                operation = SNMPCommunityPanel._i18nOperationsSET;
            } else {
                Debug.println((String)("ERROR: Bad perrmissions: " + item));
            }
            this._lblDetailsOperation.setText(operation);
        } else {
            Thread.currentThread();
            Thread.dumpStack();
            Debug.println((String)("ERROR: Community not found: " + item));
        }
    }
}

