/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.admserv.panel;

import com.netscape.management.admserv.config.RemoteRequestException;
import com.netscape.management.admserv.panel.AdminOperation;
import com.netscape.management.admserv.panel.IRestartControl;
import com.netscape.management.admserv.panel.TimeoutAdmTask;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.util.Debug;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.URL;

public class RestartOperation
extends AdminOperation {
    protected static int STATE_REQ_RESTART = 0;
    protected static int STATE_GET_NEWPID = 1;
    protected int _oldPID = -1;
    protected int _newPID = -1;
    protected int _state;
    protected String _taskArguments = "op=restart";
    protected IRestartControl _restartControl;
    String _i18nSendRequest = AdminOperation._resource.getString("restart", "SendRequest");
    String _i18nAccepted = AdminOperation._resource.getString("restart", "Accepted");
    String _i18nWait = AdminOperation._resource.getString("restart", "Wait");
    String _i18nDone = AdminOperation._resource.getString("restart", "Done");
    String _i18nStopped = AdminOperation._resource.getString("restart", "Stopped");

    public RestartOperation(ConsoleInfo consoleInfo) {
        super(consoleInfo, "admin-serv/tasks/Operation/Restart");
        this._restartControl = (IRestartControl)this._consoleInfo.get("RESTART_CONTROL");
        this.createActionPanel(true);
    }

    protected void createTask(ConsoleInfo ci, String adminURL) throws RemoteRequestException {
        try {
            this._task = new TimeoutAdmTask(new URL(adminURL), ci.getAuthenticationDN(), ci.getAuthenticationPassword());
        }
        catch (MalformedURLException e) {
            Debug.println((String)("" + e));
            throw new RemoteRequestException(e);
        }
        this._task.setArguments(this._taskArguments);
    }

    public void performOperationalTask(ConsoleInfo ci, String taskURL) throws RemoteRequestException {
        this._state = STATE_REQ_RESTART;
        this._newPID = -1;
        this._oldPID = -1;
        this._taskArguments = "op=restart";
        this._actionPanel.setStatusText(this._i18nSendRequest);
        super.performOperationalTask(ci, taskURL);
        this._actionPanel.setStatusText(this._i18nAccepted);
        if (this._task != null && this._task.getResult() != null) {
            String pid = (String)this._task.getResult().get("pid");
            try {
                this._oldPID = Integer.parseInt(pid);
            }
            catch (Exception e) {
                // empty catch block
            }
            Debug.println((String)("restart pid =" + pid));
        }
        if (this._oldPID == -1) {
            throw new RemoteRequestException(taskURL, "No server PID in CGI response,\nRestart CGI needs to be upgraded to the latest version");
        }
        if (this._restartControl != null) {
            this._restartControl.setNeedsAutoRestart(false);
        }
        long t0 = System.currentTimeMillis();
        boolean stopDetected = false;
        this._state = STATE_GET_NEWPID;
        this._taskArguments = "op=getpid";
        this.createTask(ci, ci.getAdminURL() + this._taskURL);
        ((TimeoutAdmTask)this._task).setMaxWaitInterval(5000L);
        this._actionPanel.setStatusText(this._i18nWait);
        this._actionPanel.setStatusTextSameLIne("\n");
        while (this._newPID == -1 || this._newPID == this._oldPID) {
            try {
                Thread.currentThread();
                Thread.sleep(3000L);
            }
            catch (Exception e) {
                // empty catch block
            }
            Debug.println((String)("Exec " + ((TimeoutAdmTask)this._task).getURL()));
            this._task.exec();
            this.processAdmTaskStatus(taskURL);
            if (!stopDetected && this._task != null && this._task.getStatus() == -1 && this._task.getException() != null && this._task.getException() instanceof ConnectException) {
                String postRestartURL;
                stopDetected = true;
                this._actionPanel.setStatusTextSameLIne("\n" + this._i18nStopped + "\n");
                String string = postRestartURL = this._restartControl == null ? null : this._restartControl.getPostRestartURL();
                if (postRestartURL != null) {
                    Debug.println((String)("post restart URL = " + postRestartURL));
                    this._consoleInfo.setAdminURL(postRestartURL);
                    this.createTask(ci, postRestartURL + this._taskURL);
                    ((TimeoutAdmTask)this._task).setMaxWaitInterval(5000L);
                }
            }
            if (this._task != null && this._task.getStatus() == 0 && this._task.getResult() != null) {
                String pid = (String)this._task.getResult().get("pid");
                try {
                    this._newPID = Integer.parseInt(pid);
                }
                catch (Exception e) {
                    // empty catch block
                }
                Debug.println((String)("getpid pid =" + pid + " old pid = " + this._oldPID));
            }
            this._actionPanel.setStatusTextSameLIne("*");
            if (System.currentTimeMillis() - t0 <= 90000L) continue;
            t0 = System.currentTimeMillis();
            this._actionPanel.setStatusTextSameLIne("\n");
        }
        this._actionPanel.setStatusText(this._i18nDone + "\n");
        Debug.println((String)("Operation time = " + (double)(System.currentTimeMillis() - t0) / 1000.0));
    }

    public void processAdmTaskStatus(String url) throws RemoteRequestException {
        Debug.println((String)("status=" + this._task.getStatus() + " ex=" + this._task.getException() + " result=" + this._task.getResult()));
        int status = this._task.getStatus();
        if (this._state == STATE_GET_NEWPID) {
            if (status == -1) {
                Debug.println((String)("getpid request error " + this._task.getException()));
                return;
            }
            if (status == -2) {
                Debug.println((String)"getpid request timedout");
                return;
            }
        }
        super.processAdmTaskStatus(url);
    }
}

