/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.server.http.servlet;

import com.iplanet.server.http.servlet.NSServletOutputStreamWriter;
import com.iplanet.server.http.servlet.NSServletSession;
import com.iplanet.server.http.util.ResUtil;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import javax.servlet.ServletOutputStream;

class NSServletOutputStream
extends ServletOutputStream {
    public static final int DEFAULT_BUFFER_SIZE = 8192;
    public static final int DEFAULT_FLUSH_TIMEOUT = 0;
    private byte[] _buffer;
    private int _bufferSize;
    private int _nBytes = 0;
    private boolean _inWriterMethod = false;
    private boolean _flushNativeStream = true;
    private boolean _ignoreWrite = false;
    private long _flushTimeout;
    private long _lastFlushTime = 0L;
    private boolean _flushTimeoutExpired = false;
    private NSServletSession _session;
    private NSServletOutputStreamWriter _streamWriter = null;
    private boolean _isStreamActive = false;
    private boolean _isWriterActive = false;
    private boolean _isOpen;
    private static ResUtil _res = ResUtil.getDefaultResUtil();

    public NSServletOutputStream(NSServletSession nSServletSession, int n, int n2) {
        if (n > 0) {
            this._buffer = new byte[n];
            this._bufferSize = n;
            this._flushTimeout = n2 * 1000;
        } else {
            this._buffer = null;
            this._bufferSize = 0;
            this._flushTimeout = 0L;
        }
        if (this._flushTimeout > 0L) {
            this._lastFlushTime = System.currentTimeMillis();
        }
        this._session = nSServletSession;
        this._session.ostream_setSize(this._bufferSize);
        this._isOpen = true;
    }

    private void checkOpen() throws IOException {
        if (!this._isOpen) {
            throw new IOException(_res.getProp("servlet.NSServletOutputStream.msg_streamAlreadyClosed"));
        }
    }

    protected void clear() {
        try {
            this.checkOpen();
            if (this._isWriterActive) {
                this._streamWriter.clear();
            }
        }
        catch (IOException iOException) {}
        this._nBytes = 0;
        this._session.ostream_reset();
    }

    public void close() throws IOException {
        if (this._isOpen) {
            this.setNativeStreamFlushMode(false);
            this.flush();
            this._isOpen = false;
            if (this._isWriterActive && !this._inWriterMethod) {
                this._streamWriter.close();
            }
            this._buffer = null;
            this._bufferSize = 0;
        }
    }

    protected void enableStream() {
        this._isStreamActive = true;
    }

    protected void enableWriter() {
        this._isWriterActive = true;
    }

    public void flush() throws IOException {
        this.checkOpen();
        if (this._ignoreWrite) {
            return;
        }
        if (this._isWriterActive && !this._inWriterMethod) {
            this._streamWriter.flush();
        }
        this.writeBuffer();
        if (this._flushNativeStream) {
            this._session.flush();
            if (this._flushTimeout > 0L) {
                this._lastFlushTime = System.currentTimeMillis();
                this._flushTimeoutExpired = false;
            }
        }
    }

    protected int getBufferSize() {
        return this._bufferSize;
    }

    public Writer getWriter(String string) throws IOException, UnsupportedEncodingException {
        this.checkOpen();
        if (this._streamWriter == null) {
            this._streamWriter = new NSServletOutputStreamWriter(this, string);
        }
        return this._streamWriter;
    }

    protected boolean hasFlushTimeoutExpired() {
        if (this._flushTimeout > 0L && !this._flushTimeoutExpired) {
            long l = System.currentTimeMillis();
            this._flushTimeoutExpired = l > this._lastFlushTime + this._flushTimeout;
        }
        return this._flushTimeoutExpired;
    }

    protected void resize(int n) throws IOException {
        this.checkOpen();
        if (n == this._bufferSize) {
            return;
        }
        if (this._isWriterActive) {
            this._streamWriter.resize(n);
        }
        this.writeBuffer();
        this._buffer = null;
        this._bufferSize = 0;
        if (n > 0) {
            this._buffer = new byte[n];
            this._bufferSize = n;
        }
        this._session.ostream_setSize(n);
    }

    void setInWriterMethod(boolean bl) {
        this._inWriterMethod = bl;
    }

    void setNativeStreamFlushMode(boolean bl) {
        this._flushNativeStream = bl;
    }

    void setWriteIgnore(boolean bl) {
        this._ignoreWrite = bl;
    }

    public void write(int n) throws IOException {
        this.checkOpen();
        if (this._ignoreWrite) {
            return;
        }
        if (this._isWriterActive && !this._inWriterMethod) {
            this._streamWriter.flush();
        }
        if (this._bufferSize > 0 && this._isStreamActive) {
            this._buffer[this._nBytes++] = (byte)n;
            if (this._nBytes == this._bufferSize) {
                this.writeBuffer();
            }
        } else {
            this._session.write((byte)n);
        }
        if (!this._inWriterMethod && this.hasFlushTimeoutExpired()) {
            this.flush();
        }
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.checkOpen();
        if (this._ignoreWrite) {
            return;
        }
        if (n < 0 || n >= byArray.length || n2 < 0 || n + n2 > byArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return;
        }
        if (this._isWriterActive && !this._inWriterMethod) {
            this._streamWriter.flush();
        }
        if (this._bufferSize > 0 && this._isStreamActive) {
            if (n2 >= this._bufferSize) {
                this.writeBuffer();
                this._session.write(byArray, n, n2);
            } else {
                int n3 = n;
                int n4 = n + n2;
                while (n3 < n4) {
                    int n5 = this._bufferSize - this._nBytes;
                    int n6 = n4 - n3;
                    int n7 = Math.min(n5, n6);
                    System.arraycopy(byArray, n3, this._buffer, this._nBytes, n7);
                    n3 += n7;
                    this._nBytes += n7;
                    if (this._nBytes != this._bufferSize) continue;
                    this.writeBuffer();
                }
                if (this._nBytes == this._bufferSize) {
                    this.writeBuffer();
                }
            }
        } else {
            this._session.write(byArray, n, n2);
        }
        if (!this._inWriterMethod && this.hasFlushTimeoutExpired()) {
            this.flush();
        }
    }

    void writeBuffer() throws IOException {
        this.checkOpen();
        if (this._nBytes > 0) {
            this._session.write(this._buffer, 0, this._nBytes);
            this._nBytes = 0;
        }
    }
}

