/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.repository;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeMap;

class PersistentStore {
    private FileInputStream in;
    private FileOutputStream out;
    private String fileName;
    private long fileLength;
    private Object[] maps = new Object[4];
    private TreeMap deletedObjectsBySize = new TreeMap();
    private HashMap deletedObjectsByOffset = new HashMap();
    private HashMap deletedObjectsByEnd = new HashMap();
    private HashMap objectIdMap = new HashMap();

    public PersistentStore(String string) throws IOException {
        this.fileName = string;
        this.fileLength = 0L;
        this.maps[0] = this.deletedObjectsBySize;
        this.maps[1] = this.deletedObjectsByOffset;
        this.maps[2] = this.deletedObjectsByEnd;
        this.maps[3] = this.objectIdMap;
        RandomAccessFile randomAccessFile = new RandomAccessFile(string, "rw");
        this.fileLength = randomAccessFile.length();
        randomAccessFile.close();
    }

    public byte[] readObjectBytes(long l) throws IOException {
        PersistObject persistObject = this.getObjectFromId(l);
        byte[] byArray = new byte[persistObject.length];
        this.read(byArray, persistObject.offset);
        return byArray;
    }

    public long writeObjectBytes(byte[] byArray) throws IOException {
        int n = byArray.length;
        PersistObject persistObject = this.createPersistObject(n);
        this.write(persistObject.offset, byArray);
        this.putObjectToIdMap(persistObject);
        return persistObject.id;
    }

    public void deleteObject(long l) {
        PersistObject persistObject = this.getObjectFromId(l);
        if (persistObject == null) {
            System.out.println("invaid object id: " + l);
            return;
        }
        this.removeObjectFromIdMap(l);
        this.addDeletedObject(persistObject, false);
    }

    private void joinDeleteObject() {
        HashMap hashMap = new HashMap();
        HashMap hashMap2 = (HashMap)this.deletedObjectsByOffset.clone();
        Iterator iterator = hashMap2.values().iterator();
        while (iterator.hasNext()) {
            PersistObject persistObject = (PersistObject)iterator.next();
            if (this.deletedObjectsByOffset.get(new Long(persistObject.offset)) == null) continue;
            this.removeDeleteObject(persistObject);
            PersistObject persistObject2 = (PersistObject)this.deletedObjectsByOffset.get(new Long(persistObject.offset + (long)persistObject.length));
            if (persistObject2 != null) {
                this.removeDeleteObject(persistObject2);
                persistObject.length += persistObject2.length;
            }
            this.addDeletedObject(persistObject, false);
            persistObject2 = (PersistObject)this.deletedObjectsByEnd.get(new Long(persistObject.offset));
            if (persistObject2 == null) continue;
            this.removeDeleteObject(persistObject);
            this.removeDeleteObject(persistObject2);
            persistObject2.length += persistObject.length;
            this.addDeletedObject(persistObject2, false);
        }
    }

    public void addToSnapshot(ObjectOutputStream objectOutputStream) throws IOException {
        PersistObject persistObject;
        this.joinDeleteObject();
        Iterator iterator = this.deletedObjectsByOffset.values().iterator();
        while (iterator.hasNext()) {
            persistObject = (PersistObject)iterator.next();
            this.deletedObjectsBySize.remove(persistObject);
            persistObject.bReadyToUse = true;
            this.deletedObjectsBySize.put(persistObject, persistObject);
        }
        persistObject = (PersistObject)this.deletedObjectsByEnd.get(new Long(this.fileLength));
        if (persistObject != null && persistObject.bReadyToUse) {
            RandomAccessFile randomAccessFile = new RandomAccessFile(this.fileName, "rw");
            randomAccessFile.setLength(persistObject.offset);
            this.fileLength = persistObject.offset;
            randomAccessFile.close();
            this.removeDeleteObject(persistObject);
        }
        objectOutputStream.writeLong(PersistObject.currentID);
        objectOutputStream.writeObject(this.maps);
    }

    public void recoverFromSnapshot(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        PersistObject.currentID = objectInputStream.readLong();
        this.maps = (Object[])objectInputStream.readObject();
        this.deletedObjectsBySize = (TreeMap)this.maps[0];
        this.deletedObjectsByOffset = (HashMap)this.maps[1];
        this.deletedObjectsByEnd = (HashMap)this.maps[2];
        this.objectIdMap = (HashMap)this.maps[3];
    }

    public PersistObject getPersistObject(long l) {
        return this.getObjectFromId(l);
    }

    public void addPersistObject(PersistObject persistObject) {
        this.putObjectToIdMap(persistObject);
        this.createPersistObject(persistObject.length);
    }

    private PersistObject createPersistObject(int n) {
        PersistObject persistObject = new PersistObject(this.fileLength, n);
        if (this.deletedObjectsBySize.isEmpty()) {
            return persistObject;
        }
        PersistObject persistObject2 = (PersistObject)this.deletedObjectsBySize.lastKey();
        if (!persistObject2.bReadyToUse || persistObject2.length < persistObject.length) {
            return persistObject;
        }
        this.removeDeleteObject(persistObject2);
        persistObject.offset = persistObject2.offset;
        persistObject2.offset = persistObject.offset + (long)n;
        persistObject2.length -= persistObject.length;
        this.addDeletedObject(persistObject2, true);
        return persistObject;
    }

    private void addDeletedObject(PersistObject persistObject, boolean bl) {
        if (persistObject.length == 0) {
            return;
        }
        persistObject.bReadyToUse = bl;
        Long l = new Long(persistObject.offset + (long)persistObject.length);
        this.deletedObjectsBySize.put(persistObject, persistObject);
        this.deletedObjectsByOffset.put(new Long(persistObject.offset), persistObject);
        this.deletedObjectsByEnd.put(l, persistObject);
    }

    private void removeDeleteObject(PersistObject persistObject) {
        this.deletedObjectsBySize.remove(persistObject);
        this.deletedObjectsByOffset.remove(new Long(persistObject.offset));
        this.deletedObjectsByEnd.remove(new Long(persistObject.offset + (long)persistObject.length));
    }

    private PersistObject getObjectFromId(long l) {
        return (PersistObject)this.objectIdMap.get(new Long(l));
    }

    private void putObjectToIdMap(PersistObject persistObject) {
        this.objectIdMap.put(new Long(persistObject.id), persistObject);
    }

    private void removeObjectFromIdMap(long l) {
        this.objectIdMap.remove(new Long(l));
    }

    private void write(long l, byte[] byArray) throws IOException {
        RandomAccessFile randomAccessFile = new RandomAccessFile(this.fileName, "rw");
        randomAccessFile.seek(l);
        randomAccessFile.write(byArray);
        this.fileLength = randomAccessFile.length();
        randomAccessFile.close();
    }

    private void read(byte[] byArray, long l) throws IOException {
        RandomAccessFile randomAccessFile = new RandomAccessFile(this.fileName, "r");
        randomAccessFile.seek(l);
        randomAccessFile.read(byArray);
        randomAccessFile.close();
    }

    static class PersistObject
    implements Comparable,
    Serializable {
        private static final long serialVersionUID = -8265199713085209820L;
        static long currentID = 0L;
        private long id = currentID++;
        private long offset;
        private int length;
        private boolean bReadyToUse = true;

        public PersistObject(long l, int n) {
            this.offset = l;
            this.length = n;
        }

        public int compareTo(Object object) {
            PersistObject persistObject = (PersistObject)object;
            if (this == persistObject) {
                return 0;
            }
            if (this.bReadyToUse && !persistObject.bReadyToUse) {
                return 1;
            }
            if (!this.bReadyToUse && persistObject.bReadyToUse) {
                return -1;
            }
            if (this.length == persistObject.length) {
                return this.id > persistObject.id ? 1 : -1;
            }
            return this.length > persistObject.length ? 1 : -1;
        }

        public long getID() {
            return this.id;
        }
    }
}

