/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.patch;

import com.sun.patchpro.model.PatchProListener;
import com.sun.patchpro.model.PatchProProperties;
import com.sun.patchpro.patch.PatchAccumulator;
import com.sun.patchpro.patch.PatchID;
import com.sun.patchpro.patch.PatchList;
import com.sun.wbem.solarisprovider.common.ProviderUtility;
import com.sun.wbem.solarisprovider.patch.PPro;
import com.sun.wbem.solarisprovider.patch.PProUtil;
import com.sun.wbem.solarisprovider.patch.PatchException;
import java.io.File;
import java.util.Vector;
import javax.wbem.client.Debug;

public class DownloadPatches
extends PPro {
    private File downloadDir;
    private PatchList assessedPatchList = null;
    private PatchList accumPatchList = null;
    private PatchList patchesNotDownloaded = null;
    private static final String DWNL_AUTH_STR = "patchpro.patch.download.authenticate";

    public DownloadPatches(ProviderUtility providerUtility) {
        provUtil = providerUtility;
    }

    protected void initialize(Vector vector, String string) throws PatchException {
        this.patchListVec = vector;
        this.targetDir = string;
        if (this.targetDir != null && this.targetDir.length() > 0) {
            PProUtil.dirAvailable(this.targetDir);
        }
        this.init();
        if (this.model == null) {
            throw new PatchException("EXM_DL_UNEXP_ERR");
        }
        boolean bl = PProUtil.isHostSerialized();
        if (bl) {
            this.host = PProUtil.getSerializedHost();
            if (this.host == null || this.patchListVec == null || this.patchListVec.size() == 0) {
                this.analyzeHost();
                PProUtil.setSerializedHost(this.host);
            } else {
                this.setHost();
                this.initializeDB();
            }
        } else {
            this.analyzeHost();
            PProUtil.setSerializedHost(this.host);
        }
    }

    protected void patchDownloader(boolean bl) throws PatchException {
        int n = 0;
        if (this.targetDir == null || this.targetDir.length() == 0) {
            this.targetDir = "/var/sadm/spool";
        }
        Debug.trace3((String)("targetDir: " + this.targetDir));
        Debug.trace3((String)"Before downloadPatches(): ");
        DownloadPatches.makeDirectory("/var/tmp/ppro-patches");
        this.downloadDir = new File("/var/tmp/ppro-patches");
        if (this.patchListVec != null) {
            n = this.patchListVec.size();
        }
        if (n > 0) {
            this.downloadPatchList(bl);
        } else if (n == 0) {
            this.downloadRecommended(bl);
        } else {
            throw new PatchException("EXM_DL_UNEXP_ERR");
        }
    }

    protected Vector getAssessedOrAccumPatchList() throws PatchException {
        if (this.accumPatchList != null) {
            return PProUtil.patchListToVector(this.accumPatchList);
        }
        if (this.assessedPatchList != null) {
            return PProUtil.patchListToVector(this.assessedPatchList);
        }
        return null;
    }

    protected Vector getPatchesNotDownloaded() throws PatchException {
        if (this.patchesNotDownloaded != null) {
            return PProUtil.patchListToVector(this.patchesNotDownloaded);
        }
        return null;
    }

    private void downloadRecommended(boolean bl) throws PatchException {
        this.assessedPatchList = this.getNeededPatches();
        Debug.trace3((String)"In downloadRecommended: ");
        PProUtil.printPatchList(this.assessedPatchList);
        try {
            this.download(this.assessedPatchList, bl);
        }
        catch (Exception exception) {
            this.cleanup();
            if (PPro.provUtil != null) {
                PPro.provUtil.writeLog(2, exception);
            }
            throw new PatchException(exception.getLocalizedMessage());
        }
    }

    private void downloadPatchList(boolean bl) throws PatchException {
        try {
            try {
                Debug.trace3((String)"Started getPatchAccumulator().");
                PatchAccumulator patchAccumulator = null;
                if (this.model != null) {
                    this.done = false;
                    this.model.assessNeededPatches();
                    int n = 0;
                    while (!this.done) {
                        try {
                            Debug.trace3((String)(n++ + "-"));
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                } else {
                    throw new PatchException("EXM_DL_UNEXP_ERR");
                }
                patchAccumulator = this.model.getPatchAccumulator();
                int n = this.patchListVec.size();
                String string = "";
                int n2 = 0;
                while (n2 < n) {
                    string = (String)this.patchListVec.elementAt(n2);
                    Debug.trace3((String)("pidStr: " + string));
                    PatchID patchID = new PatchID((String)this.patchListVec.elementAt(n2));
                    this.accumPatchList = patchAccumulator.getPatchClosure(patchID);
                    ++n2;
                }
                PProUtil.printPatchList(this.accumPatchList);
                int n3 = 0;
                while (n3 < this.accumPatchList.size()) {
                    Debug.trace3((String)("select status is: " + this.accumPatchList.getSelectionStatus(n3)));
                    this.accumPatchList.setSelectionStatus(n3, true);
                    Debug.trace3((String)("select status is: " + this.accumPatchList.getSelectionStatus(n3)));
                    ++n3;
                }
                this.download(this.accumPatchList, bl);
            }
            catch (Exception exception) {
                if (PPro.provUtil != null) {
                    PPro.provUtil.writeLog(2, exception);
                }
                throw new PatchException(exception.getLocalizedMessage());
            }
            Object var9_11 = null;
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            this.cleanup();
            throw throwable;
        }
        this.cleanup();
    }

    private void download(PatchList patchList, boolean bl) throws Exception {
        Debug.trace3((String)"Started download(PatchList).");
        this.model.downloadPatches(patchList, this.downloadDir);
        int n = 0;
        this.done = false;
        while (!this.done) {
            try {
                Debug.trace3((String)(n++ + "-"));
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.setupDownload(patchList, this.targetDir, bl);
        this.patchesNotDownloaded = this.model.getUnavailablePatches();
        PProUtil.printPatchList(this.patchesNotDownloaded);
        this.logIt(patchList, this.patchesNotDownloaded);
    }

    private void logIt(PatchList patchList, PatchList patchList2) throws Exception {
        int n;
        int n2 = patchList2 != null ? patchList2.size() : 0;
        int n3 = n = patchList != null ? patchList.size() : 0;
        if (n2 == 0 && n > 0) {
            StringBuffer stringBuffer = new StringBuffer();
            int n4 = 0;
            while (n4 < n) {
                String string = patchList.getPatchAt(n4).getPatchID().getPatchID();
                stringBuffer.append(string);
                stringBuffer.append(" ");
                ++n4;
            }
            PPro.provUtil.writeLog(0, "LM_8900", "LM_8901", stringBuffer.toString(), this.targetDir, null, null, null);
        }
    }

    private void setupDownload(PatchList patchList, String string, boolean bl) throws PatchException {
        PatchProProperties patchProProperties = PatchProProperties.getInstance();
        String string2 = patchProProperties.getProperty(DWNL_AUTH_STR);
        Debug.trace3((String)("authStr: " + string2));
        if (string2.equals("true")) {
            Debug.trace3((String)"extracting signed patches");
            if (bl) {
                PProUtil.extractSignedPatches(patchList, string);
            } else {
                PProUtil.copySignedPatches(patchList, string);
            }
        } else {
            this.cleanup();
            throw new PatchException("EXM_PP_DOWNLOAD_AUTH");
        }
    }

    private static void makeDirectory(String string) throws PatchException {
        try {
            File file = new File(string);
            File file2 = new File("/var/tmp");
            if (!file2.exists()) {
                throw new PatchException("EXM_DL_UNEXP_ERR");
            }
            if (file.exists()) {
                File[] fileArray = file.listFiles();
                int n = 0;
                while (n < fileArray.length) {
                    fileArray[n].delete();
                    ++n;
                }
            } else if (!file.mkdir()) {
                throw new PatchException("EXM_DL_UNEXP_ERR");
            }
        }
        catch (Exception exception) {
            if (PPro.provUtil != null) {
                PPro.provUtil.writeLog(2, exception);
            }
            throw new PatchException(exception.getLocalizedMessage());
        }
    }

    private void testDownloadRecommended() throws PatchException {
        System.out.println("------ Download Recommended Patches -------\n");
        this.patchDownloader(true);
        System.out.println("\n------  Download Recommended Patches ------\n");
    }

    private void testDownloadPatchList() throws PatchException {
        System.out.println("------ Download Recommended Patches -------\n");
        Vector<String> vector = new Vector<String>();
        String string = "";
        int n = 0;
        while (true) {
            if ((string = PProUtil.getKeyBoard(++n + ") " + "Patch IDs list(type 'b' to break): ")).length() == 0) {
                --n;
                continue;
            }
            if (string.equals("b")) break;
            vector.addElement(string);
        }
        this.patchListVec = vector;
        System.out.println("size: " + this.patchListVec.size());
        this.patchDownloader(true);
        System.out.println("\n------  Download Recommended Patches ------\n");
    }

    protected void test() {
        this.done = false;
        while (!this.done) {
            System.out.println("1 - Download Recomended Patches: ");
            System.out.println("2 - Enter known patches to download: ");
            System.out.println("q - To quit");
            System.out.println("");
            System.out.print("Enter option: ");
            try {
                byte[] byArray = new byte[100];
                char c = (char)System.in.read(byArray);
                System.out.println("");
                if (c != '\u0002') continue;
                char c2 = (char)byArray[0];
                switch (c2) {
                    case '1': {
                        this.testDownloadRecommended();
                        break;
                    }
                    case '2': {
                        this.testDownloadPatchList();
                        break;
                    }
                    case 'q': {
                        if (this.model != null) {
                            this.model.removeListener((PatchProListener)this);
                        }
                        this.done = true;
                    }
                }
            }
            catch (Exception exception) {
                this.cleanup();
                System.out.println("Exception: " + exception);
                exception.printStackTrace();
            }
            System.out.println("");
        }
    }

    public static void main(String[] stringArray) {
        DownloadPatches downloadPatches = new DownloadPatches(null);
        try {
            downloadPatches.initialize(null, null);
        }
        catch (PatchException patchException) {
            System.out.println((Object)patchException);
        }
        downloadPatches.test();
    }
}

