/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.patch;

import com.sun.wbem.solarisprovider.common.ProviderUtility;
import com.sun.wbem.solarisprovider.patch.PatchException;
import com.sun.wbem.solarisprovider.patch.PatchPkgInfo;
import com.sun.wbem.solarisprovider.patch.SolarisPatchObj;
import com.sun.wbem.solarisprovider.patch.SolarisPatchUtil;
import java.util.Calendar;
import java.util.Date;
import java.util.Vector;
import javax.wbem.cim.CIMDateTime;

public class SolarisPatchInfo {
    private static final String patchaddCmd = new String("/usr/sbin/patchadd");
    private static final String patchrmCmd = new String("/usr/sbin/patchrm");
    private static final String displayOpt = new String("-p");
    public static final String SYNOPSIS = "Synopsis";
    public static final String RELEASE_DATE = "Date";
    public static final String ARCH = "Relevant Architectures";
    public static final String SOLARIS_RELEASE = "Solaris Release";
    public static final String SUNOS_RELEASE = "SunOS Release";
    public static final String SUNOS_RELEASE_2 = "SunOS release";
    public static final String REQUIRED_PATCHES = "Patches required with this patch";
    public static final String CONFLICTING_PATCHES = "Patches which conflict with this patch";
    public static final String OBSOLETED_PATCHES = "Patches accumulated and obsoleted by this patch";
    private static final String NOT_AVAILABLE = "Not Available";
    private ProviderUtility provUtil;

    public SolarisPatchInfo(ProviderUtility providerUtility) {
        this.provUtil = providerUtility;
    }

    public Vector getPatchListData() throws PatchException {
        try {
            Vector<SolarisPatchObj> vector = new Vector<SolarisPatchObj>();
            String[] stringArray = new String[]{patchaddCmd, displayOpt};
            SolarisPatchUtil solarisPatchUtil = new SolarisPatchUtil(this.provUtil);
            Vector vector2 = solarisPatchUtil.execScript(stringArray);
            String[] stringArray2 = (String[])vector2.elementAt(0);
            int n = 0;
            while (n < stringArray2.length) {
                if (stringArray2[n].startsWith("Patch:")) {
                    vector.addElement(this.formPatchObj(stringArray2[n]));
                }
                ++n;
            }
            return vector;
        }
        catch (PatchException patchException) {
            throw patchException;
        }
        catch (Exception exception) {
            this.provUtil.writeLog(2, "LM_8850", "LM_8851", null, null, null, null, null);
            throw new PatchException("EXM_PATCHLIST_ERR");
        }
    }

    public SolarisPatchObj getPatchData(String string) throws PatchException {
        try {
            Vector vector = new Vector();
            String[] stringArray = new String[]{patchaddCmd, displayOpt};
            SolarisPatchUtil solarisPatchUtil = new SolarisPatchUtil(this.provUtil);
            Vector vector2 = solarisPatchUtil.execScript(stringArray);
            String[] stringArray2 = (String[])vector2.elementAt(0);
            int n = 0;
            while (n < stringArray2.length) {
                SolarisPatchObj solarisPatchObj;
                if (stringArray2[n].startsWith("Patch:") && (solarisPatchObj = solarisPatchUtil.parseLine(stringArray2[n])).getPatchName().equals(string)) {
                    return this.formPatchObj(stringArray2[n]);
                }
                ++n;
            }
            return null;
        }
        catch (PatchException patchException) {
            throw patchException;
        }
        catch (Exception exception) {
            this.provUtil.writeLog(2, "LM_8850", "LM_8851", null, null, null, null, null);
            throw new PatchException("EXM_PATCHLIST_ERR");
        }
    }

    private SolarisPatchObj formPatchObj(String string) throws PatchException {
        Object object;
        String string2;
        SolarisPatchUtil solarisPatchUtil = new SolarisPatchUtil(this.provUtil);
        SolarisPatchObj solarisPatchObj = solarisPatchUtil.parseLine(string);
        String string3 = solarisPatchObj.getPatchName();
        String string4 = solarisPatchUtil.getPatchBackoutDir(string3, string2 = (String)solarisPatchObj.getPackages().elementAt(0));
        if (string4 != null) {
            solarisPatchObj.setBackoutDir(string4);
        } else {
            solarisPatchObj.setBackUpFiles(false);
        }
        Date date = solarisPatchUtil.getPatchInstallDate(string3);
        if (date != null) {
            object = new CIMDateTime(date);
            solarisPatchObj.setInstallDate((CIMDateTime)object);
        }
        object = new StringBuffer(50);
        ((StringBuffer)object).append("/var/sadm/patch");
        ((StringBuffer)object).append("/");
        ((StringBuffer)object).append(string3);
        ((StringBuffer)object).append("/");
        ((StringBuffer)object).append("README");
        ((StringBuffer)object).append(".");
        ((StringBuffer)object).append(string3);
        Vector vector = solarisPatchUtil.contentsOfReadmeFile(((StringBuffer)object).toString());
        if (vector != null) {
            String string5;
            String string6 = PatchPkgInfo.getInfoValue(vector, SYNOPSIS);
            solarisPatchObj.setDescription(string6);
            String string7 = PatchPkgInfo.getInfoValue(vector, RELEASE_DATE);
            Calendar calendar = solarisPatchUtil.convertDate(string7);
            if (calendar != null) {
                string5 = new CIMDateTime(calendar);
                solarisPatchObj.setReleaseDate((CIMDateTime)string5);
            }
            string5 = PatchPkgInfo.getInfoValue(vector, ARCH);
            solarisPatchObj.setArchitecture(string5);
            String string8 = PatchPkgInfo.getInfoValue(vector, SOLARIS_RELEASE);
            solarisPatchObj.setSolRelease(string8);
            String string9 = PatchPkgInfo.getInfoValue(vector, SUNOS_RELEASE);
            if (string9.equals("")) {
                string9 = PatchPkgInfo.getInfoValue(vector, SUNOS_RELEASE_2);
                solarisPatchObj.setSunOSRelease(string9);
            } else {
                solarisPatchObj.setSunOSRelease(string9);
            }
        } else {
            solarisPatchObj.setDescription(NOT_AVAILABLE);
        }
        return solarisPatchObj;
    }

    public int addPatch(SolarisPatchObj solarisPatchObj) throws PatchException {
        try {
            Object object;
            SolarisPatchUtil solarisPatchUtil = new SolarisPatchUtil(this.provUtil);
            String[] stringArray = solarisPatchObj.patchAddCmd();
            Vector vector = solarisPatchUtil.execScript(stringArray);
            int n = 1;
            String[] stringArray2 = null;
            if (vector != null && vector.size() > 0) {
                stringArray2 = (String[])vector.elementAt(0);
                object = (Integer)vector.elementAt(2);
                n = (Integer)object;
            }
            object = "";
            int n2 = 0;
            while (n2 < stringArray2.length) {
                object = (String)object + stringArray2[n2];
                ++n2;
            }
            if (n > 0) {
                this.provUtil.writeLog(2, "LM_8810", "LM_8811", solarisPatchObj.getPatchName(), (String)object, null, null, null);
                throw new PatchException("EXM_PATCH_ADD_ERR", solarisPatchObj.getPatchName(), (String)object);
            }
            if (n == 0) {
                this.provUtil.writeLog(0, "LM_8812", "LM_8813", solarisPatchObj.getPatchName(), (String)object, null, null, null);
            }
            return n;
        }
        catch (PatchException patchException) {
            throw patchException;
        }
        catch (Exception exception) {
            this.provUtil.writeLog(2, "LM_8810", "LM_8814", null, null, null, null, null);
            throw new PatchException("EXM_PATCH_DIE");
        }
    }

    public int removePatch(String string) throws PatchException {
        try {
            Object object;
            SolarisPatchUtil solarisPatchUtil = new SolarisPatchUtil(this.provUtil);
            String[] stringArray = new String[]{patchrmCmd, string};
            Vector vector = solarisPatchUtil.execScript(stringArray);
            int n = 1;
            String[] stringArray2 = null;
            if (vector != null && vector.size() > 0) {
                stringArray2 = (String[])vector.elementAt(0);
                object = (Integer)vector.elementAt(2);
                n = (Integer)object;
            }
            object = "";
            int n2 = 0;
            while (n2 < stringArray2.length) {
                object = (String)object + stringArray2[n2];
                ++n2;
            }
            if (n > 0) {
                this.provUtil.writeLog(2, "LM_8815", "LM_8816", string, (String)object, null, null, null);
                throw new PatchException("EXM_PATCH_REMOVE_ERR", string, (String)object);
            }
            if (n == 0) {
                this.provUtil.writeLog(0, "LM_8817", "LM_8818", string, (String)object, null, null, null);
            }
            return n;
        }
        catch (PatchException patchException) {
            throw patchException;
        }
        catch (Exception exception) {
            this.provUtil.writeLog(2, "LM_8815", "LM_8819", null, null, null, null, null);
            throw new PatchException("EXM_PATCH_DIE");
        }
    }
}

