/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.usermgr.groups;

import com.sun.wbem.solarisprovider.common.ProviderDirectoryFilter;
import com.sun.wbem.solarisprovider.usermgr.common.SolServerException;
import com.sun.wbem.solarisprovider.usermgr.groups.GroupObj;
import com.sun.wbem.solarisprovider.usermgr.users.FlatUserObj;
import com.sun.wbem.utility.directorytable.DirectoryFilter;
import com.sun.wbem.utility.directorytable.DirectoryMask;
import com.sun.wbem.utility.directorytable.DirectoryRow;
import com.sun.wbem.utility.directorytable.DirectoryTable;
import com.sun.wbem.utility.directorytable.DirectoryTableAccessException;
import com.sun.wbem.utility.directorytable.DirectoryTableConnectionException;
import com.sun.wbem.utility.directorytable.DirectoryTableDoesNotExistException;
import com.sun.wbem.utility.directorytable.DirectoryTableException;
import com.sun.wbem.utility.directorytable.DirectoryTableFactory;
import com.sun.wbem.utility.directorytable.DirectoryTableInvalidParameterException;
import com.sun.wbem.utility.directorytable.SearchTemplate;
import com.sun.wbem.utility.directorytable.TableDefinitions;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.Vector;

public class SolarisGroupTable {
    private String table = new String("group");
    private String emptyString = new String("");
    private String fileType = new String("File");
    private String nameCol = "name";
    private String passwdCol = "passwd";
    private String gidCol = "gid";
    private String memberCol = "members";
    private int nameColNum = 0;
    private int passwdColNum = 0;
    private int gidColNum = 0;
    private int memberColNum = 0;
    private String scope;

    public SolarisGroupTable(String string) {
        this.scope = string;
    }

    public static String[] parseMembersIntoArray(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n++] = stringTokenizer.nextToken();
        }
        return stringArray;
    }

    public static String formatMembersIntoString(String[] stringArray) {
        if (stringArray.length == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(stringArray[0]);
        int n = 1;
        while (n < stringArray.length) {
            stringBuffer.append(",");
            stringBuffer.append(stringArray[n]);
            ++n;
        }
        return stringBuffer.toString();
    }

    private boolean isGroupMember(String string, String string2) {
        if (string2 == null) {
            return false;
        }
        if (string2 == "") {
            return false;
        }
        String[] stringArray = SolarisGroupTable.parseMembersIntoArray(string2);
        int n = 0;
        while (n < stringArray.length) {
            if (string.compareTo(stringArray[n]) == 0) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private DirectoryTable openGroupTable() throws DirectoryTableException {
        try {
            DirectoryTable directoryTable = DirectoryTableFactory.getDirectoryTableInstance((String)this.scope);
            directoryTable.open(this.table);
            TableDefinitions tableDefinitions = directoryTable.getCurrentTableDefinitions();
            this.nameColNum = tableDefinitions.getColumnNumber(this.nameCol);
            this.passwdColNum = tableDefinitions.getColumnNumber(this.passwdCol);
            this.gidColNum = tableDefinitions.getColumnNumber(this.gidCol);
            this.memberColNum = tableDefinitions.getColumnNumber(this.memberCol);
            return directoryTable;
        }
        catch (DirectoryTableInvalidParameterException directoryTableInvalidParameterException) {
            throw directoryTableInvalidParameterException;
        }
        catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
            throw directoryTableDoesNotExistException;
        }
        catch (DirectoryTableConnectionException directoryTableConnectionException) {
            throw directoryTableConnectionException;
        }
        catch (DirectoryTableException directoryTableException) {
            throw directoryTableException;
        }
    }

    private void closeGroupTable(DirectoryTable directoryTable) {
        directoryTable.close();
        this.nameColNum = 0;
        this.passwdColNum = 0;
        this.gidColNum = 0;
        this.memberColNum = 0;
    }

    public String translateNametoGID(String string) {
        try {
            DirectoryTable directoryTable = this.openGroupTable();
            DirectoryRow directoryRow = directoryTable.getRowInstance();
            directoryRow.putColumn(this.nameColNum, string);
            DirectoryRow directoryRow2 = directoryTable.getFirstRow((SearchTemplate)directoryRow);
            if (directoryRow2 == null) {
                return string;
            }
            String string2 = directoryRow2.getColumn(this.gidColNum);
            this.closeGroupTable(directoryTable);
            return string2;
        }
        catch (Exception exception) {
            return string;
        }
    }

    public String translateGIDtoName(String string) {
        try {
            DirectoryTable directoryTable = this.openGroupTable();
            DirectoryRow directoryRow = directoryTable.getRowInstance();
            directoryRow.putColumn(this.gidColNum, string);
            DirectoryRow directoryRow2 = directoryTable.getFirstRow((SearchTemplate)directoryRow);
            if (directoryRow2 == null) {
                return string;
            }
            String string2 = directoryRow2.getColumn(this.nameColNum);
            this.closeGroupTable(directoryTable);
            return string2;
        }
        catch (Exception exception) {
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GroupObj getGroupRow(GroupObj groupObj) throws DirectoryTableException, SolServerException {
        block17: {
            DirectoryTable directoryTable = null;
            directoryTable = this.openGroupTable();
            try {
                try {
                    DirectoryRow directoryRow = directoryTable.getRowInstance();
                    directoryRow.putColumn(this.nameColNum, groupObj.getGroupName());
                    directoryRow = directoryTable.getFirstRow((SearchTemplate)directoryRow);
                    if (directoryRow == null) {
                        throw new SolServerException("EXM_SUS22", groupObj.getGroupName());
                    }
                    groupObj.setGroupUsers(SolarisGroupTable.parseMembersIntoArray(directoryRow.getColumn(this.memberColNum)));
                    groupObj.setGroupID(directoryRow.getColumn(this.gidColNum));
                    groupObj.setGroupPassword(directoryRow.getColumn(this.passwdColNum));
                }
                catch (DirectoryTableInvalidParameterException directoryTableInvalidParameterException) {
                    Object var10_7 = null;
                    if (directoryTable != null) {
                        this.closeGroupTable(directoryTable);
                    }
                    break block17;
                }
                catch (DirectoryTableAccessException directoryTableAccessException) {
                    throw directoryTableAccessException;
                }
                catch (DirectoryTableConnectionException directoryTableConnectionException) {
                    Object var10_8 = null;
                    if (directoryTable != null) {
                        this.closeGroupTable(directoryTable);
                    }
                    break block17;
                }
                catch (DirectoryTableException directoryTableException) {
                    throw directoryTableException;
                }
                catch (SolServerException solServerException) {
                    throw solServerException;
                }
                catch (Exception exception) {
                    Object var10_9 = null;
                    if (directoryTable != null) {
                        this.closeGroupTable(directoryTable);
                    }
                }
                Object var10_6 = null;
                if (directoryTable != null) {
                    this.closeGroupTable(directoryTable);
                }
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                if (directoryTable != null) {
                    this.closeGroupTable(directoryTable);
                }
                throw throwable;
            }
        }
        return groupObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addGroupRow(GroupObj groupObj) throws DirectoryTableException, SolServerException {
        DirectoryTable directoryTable = null;
        directoryTable = this.openGroupTable();
        try {
            try {
                DirectoryRow directoryRow = directoryTable.getRowInstance();
                if (groupObj.getGroupID() != null) {
                    directoryRow.putColumn(this.gidColNum, groupObj.getGroupID());
                    directoryRow = directoryTable.getFirstRow((SearchTemplate)directoryRow);
                }
                if (directoryRow != null) {
                    throw new SolServerException("EXM_SUS16", groupObj.getGroupID());
                }
                directoryRow = directoryTable.getRowInstance();
                if (groupObj.getGroupName() != null) {
                    directoryRow.putColumn(this.nameColNum, groupObj.getGroupName());
                    directoryRow = directoryTable.getFirstRow((SearchTemplate)directoryRow);
                }
                if (directoryRow != null) {
                    throw new SolServerException("EXM_SUS18", groupObj.getGroupName());
                }
                directoryRow = directoryTable.getRowInstance();
                if (groupObj.getGroupName() != null) {
                    directoryRow.putColumn(this.nameColNum, groupObj.getGroupName());
                }
                if (groupObj.getGroupID() != null) {
                    directoryRow.putColumn(this.gidColNum, groupObj.getGroupID());
                }
                if (groupObj.getGroupPassword() != null) {
                    directoryRow.putColumn(this.passwdColNum, groupObj.getGroupPassword());
                }
                if (groupObj.getGroupUsers() != null) {
                    directoryRow.putColumn(this.memberColNum, SolarisGroupTable.formatMembersIntoString(groupObj.getGroupUsers()));
                }
                directoryTable.addRow(directoryRow);
            }
            catch (SolServerException solServerException) {
                throw solServerException;
            }
            catch (DirectoryTableInvalidParameterException directoryTableInvalidParameterException) {
                throw directoryTableInvalidParameterException;
            }
            catch (DirectoryTableAccessException directoryTableAccessException) {
                throw directoryTableAccessException;
            }
            catch (DirectoryTableConnectionException directoryTableConnectionException) {
                throw directoryTableConnectionException;
            }
            catch (DirectoryTableException directoryTableException) {
                throw directoryTableException;
            }
            catch (Exception exception) {
                Object var10_7 = null;
                if (directoryTable != null) {
                    this.closeGroupTable(directoryTable);
                }
            }
            Object var10_6 = null;
            if (directoryTable != null) {
                this.closeGroupTable(directoryTable);
            }
        }
        catch (Throwable throwable) {
            Object var10_8 = null;
            if (directoryTable != null) {
                this.closeGroupTable(directoryTable);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void modifyGroupRow(GroupObj groupObj) throws DirectoryTableException, SolServerException {
        DirectoryTable directoryTable = null;
        directoryTable = this.openGroupTable();
        try {
            try {
                DirectoryRow directoryRow = directoryTable.getRowInstance();
                if (groupObj.getGroupID() != null) {
                    directoryRow.putColumn(this.gidColNum, groupObj.getGroupID());
                    directoryRow = directoryTable.getFirstRow((SearchTemplate)directoryRow);
                    if (directoryRow == null) {
                        this.addGroupRow(groupObj);
                        Object var10_6 = null;
                        if (directoryTable == null) return;
                        this.closeGroupTable(directoryTable);
                        return;
                    }
                }
                DirectoryRow directoryRow2 = directoryTable.getRowInstance();
                String string = directoryRow.getColumn(this.nameColNum);
                if (!string.equals(groupObj.getGroupName()) && groupObj.getGroupName() != null) {
                    directoryRow2.putColumn(this.nameColNum, groupObj.getGroupName());
                    directoryRow2 = directoryTable.getFirstRow((SearchTemplate)directoryRow2);
                    if (directoryRow2 != null) {
                        throw new SolServerException("EXM_SUS18", groupObj.getGroupName());
                    }
                    directoryRow2 = directoryTable.getRowInstance();
                }
                if (groupObj.getGroupUsers() != null) {
                    directoryRow2.putColumn(this.memberColNum, SolarisGroupTable.formatMembersIntoString(groupObj.getGroupUsers()));
                }
                if (groupObj.getGroupName() != null) {
                    directoryRow2.putColumn(this.nameColNum, groupObj.getGroupName());
                }
                if (groupObj.getGroupPassword() != null) {
                    directoryRow2.putColumn(this.passwdColNum, groupObj.getGroupPassword());
                }
                if (groupObj.getGroupID() != null) {
                    directoryRow2.putColumn(this.gidColNum, groupObj.getGroupID());
                }
                directoryTable.modifyRow(directoryRow, directoryRow2);
            }
            catch (SolServerException solServerException) {
                throw solServerException;
            }
            catch (DirectoryTableInvalidParameterException directoryTableInvalidParameterException) {
                throw directoryTableInvalidParameterException;
            }
            catch (DirectoryTableAccessException directoryTableAccessException) {
                throw directoryTableAccessException;
            }
            catch (DirectoryTableConnectionException directoryTableConnectionException) {
                throw directoryTableConnectionException;
            }
            catch (DirectoryTableException directoryTableException) {
                throw directoryTableException;
            }
            catch (Exception exception) {
                Object var10_8 = null;
                if (directoryTable == null) return;
                this.closeGroupTable(directoryTable);
                return;
            }
        }
        catch (Throwable throwable) {
            Object var10_9 = null;
            if (directoryTable == null) throw throwable;
            this.closeGroupTable(directoryTable);
            throw throwable;
        }
        Object var10_7 = null;
        if (directoryTable == null) return;
        this.closeGroupTable(directoryTable);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void deleteGroupRow(GroupObj groupObj) throws DirectoryTableException, Exception {
        DirectoryTable directoryTable = null;
        directoryTable = this.openGroupTable();
        try {
            try {
                DirectoryRow directoryRow = directoryTable.getRowInstance();
                directoryRow.putColumn(this.nameColNum, groupObj.getGroupName());
                directoryRow = directoryTable.getFirstRow((SearchTemplate)directoryRow);
                if (directoryRow == null) {
                    Object var9_6 = null;
                    if (directoryTable == null) return;
                    this.closeGroupTable(directoryTable);
                    return;
                }
                directoryTable.deleteRow(directoryRow);
            }
            catch (DirectoryTableInvalidParameterException directoryTableInvalidParameterException) {
                throw directoryTableInvalidParameterException;
            }
            catch (DirectoryTableAccessException directoryTableAccessException) {
                throw directoryTableAccessException;
            }
            catch (DirectoryTableConnectionException directoryTableConnectionException) {
                throw directoryTableConnectionException;
            }
            catch (DirectoryTableException directoryTableException) {
                throw directoryTableException;
            }
            catch (Exception exception) {
                throw exception;
            }
        }
        catch (Throwable throwable) {
            Object var9_8 = null;
            if (directoryTable == null) throw throwable;
            this.closeGroupTable(directoryTable);
            throw throwable;
        }
        Object var9_7 = null;
        if (directoryTable == null) return;
        this.closeGroupTable(directoryTable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ArrayList getAllGroupRows(ProviderDirectoryFilter providerDirectoryFilter) throws DirectoryTableException {
        ArrayList<GroupObj> arrayList = new ArrayList<GroupObj>();
        DirectoryTable directoryTable = null;
        DirectoryFilter directoryFilter = null;
        directoryTable = this.openGroupTable();
        if (providerDirectoryFilter != null) {
            try {
                directoryFilter = providerDirectoryFilter.getDirectoryFilter(directoryTable);
            }
            catch (Exception exception) {
                throw new DirectoryTableInvalidParameterException("EXM_INVALID");
            }
        }
        try {
            try {
                DirectoryRow directoryRow = null;
                DirectoryMask directoryMask = directoryTable.getDirectoryMaskInstance();
                directoryMask.setColumn(this.nameColNum);
                directoryMask.setColumn(this.gidColNum);
                directoryRow = directoryFilter != null ? directoryTable.getAll((SearchTemplate)directoryFilter, directoryMask) : directoryTable.getAll(directoryMask);
                if (directoryRow == null) {
                    ArrayList<GroupObj> arrayList2 = arrayList;
                    Object var12_14 = null;
                    if (directoryTable == null) return arrayList2;
                    this.closeGroupTable(directoryTable);
                    return arrayList2;
                }
                int n = 1;
                while (n <= directoryRow.getNumberOfRows()) {
                    GroupObj groupObj = new GroupObj(directoryRow.getColumn(this.nameColNum, n));
                    groupObj.setGroupType("Solaris");
                    groupObj.setGroupID(directoryRow.getColumn(this.gidColNum, n));
                    arrayList.add(groupObj);
                    ++n;
                }
            }
            catch (DirectoryTableInvalidParameterException directoryTableInvalidParameterException) {
                throw directoryTableInvalidParameterException;
            }
            catch (DirectoryTableAccessException directoryTableAccessException) {
                throw directoryTableAccessException;
            }
            catch (DirectoryTableConnectionException directoryTableConnectionException) {
                throw directoryTableConnectionException;
            }
            catch (DirectoryTableException directoryTableException) {
                throw directoryTableException;
            }
            catch (Exception exception) {
                Object var12_16 = null;
                if (directoryTable == null) return arrayList;
                this.closeGroupTable(directoryTable);
                return arrayList;
            }
        }
        catch (Throwable throwable) {
            Object var12_17 = null;
            if (directoryTable == null) throw throwable;
            this.closeGroupTable(directoryTable);
            throw throwable;
        }
        Object var12_15 = null;
        if (directoryTable == null) return arrayList;
        this.closeGroupTable(directoryTable);
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Vector getAllGroupRows() throws DirectoryTableException {
        Vector<GroupObj> vector = null;
        int n = 0;
        DirectoryTable directoryTable = null;
        directoryTable = this.openGroupTable();
        try {
            try {
                DirectoryMask directoryMask = directoryTable.getDirectoryMaskInstance();
                directoryMask.setColumn(this.nameColNum);
                directoryMask.setColumn(this.gidColNum);
                DirectoryRow directoryRow = directoryTable.getAll(directoryMask);
                if (directoryRow == null) {
                    Vector<GroupObj> vector2 = vector = new Vector<GroupObj>();
                    Object var10_12 = null;
                    if (directoryTable == null) return vector2;
                    this.closeGroupTable(directoryTable);
                    return vector2;
                }
                n = directoryRow.getNumberOfRows();
                vector = new Vector(n);
                vector.setSize(n);
                int n2 = 1;
                while (n2 <= n) {
                    GroupObj groupObj = new GroupObj(directoryRow.getColumn(this.nameColNum, n2));
                    groupObj.setGroupType("Solaris");
                    groupObj.setGroupID(directoryRow.getColumn(this.gidColNum, n2));
                    vector.setElementAt(groupObj, n2 - 1);
                    ++n2;
                }
            }
            catch (DirectoryTableInvalidParameterException directoryTableInvalidParameterException) {
                throw directoryTableInvalidParameterException;
            }
            catch (DirectoryTableAccessException directoryTableAccessException) {
                throw directoryTableAccessException;
            }
            catch (DirectoryTableConnectionException directoryTableConnectionException) {
                throw directoryTableConnectionException;
            }
            catch (DirectoryTableException directoryTableException) {
                throw directoryTableException;
            }
        }
        catch (Throwable throwable) {
            Object var10_14 = null;
            if (directoryTable == null) throw throwable;
            this.closeGroupTable(directoryTable);
            throw throwable;
        }
        Object var10_13 = null;
        if (directoryTable == null) return vector;
        this.closeGroupTable(directoryTable);
        return vector;
    }

    public Vector getAllSecondaryGroups(FlatUserObj flatUserObj) throws DirectoryTableException {
        Vector<String> vector = null;
        int n = 0;
        DirectoryTable directoryTable = null;
        directoryTable = this.openGroupTable();
        try {
            try {
                DirectoryMask directoryMask = directoryTable.getDirectoryMaskInstance();
                directoryMask.setColumn(this.nameColNum);
                directoryMask.setColumn(this.memberColNum);
                DirectoryRow directoryRow = directoryTable.getAll(directoryMask);
                boolean bl = false;
                String string = "";
                if (flatUserObj.getPrimaryGroup() != null) {
                    string = flatUserObj.getPrimaryGroup();
                }
                String string2 = "";
                if (directoryRow == null) {
                    vector = new Vector<String>();
                } else {
                    n = directoryRow.getNumberOfRows();
                    vector = new Vector(n);
                    vector.setSize(n);
                }
                int n2 = 0;
                int n3 = 1;
                while (n3 <= n) {
                    String string3 = directoryRow.getColumn(this.memberColNum, n3);
                    if (this.isGroupMember(flatUserObj.getUserName(), string3) && (string2 = directoryRow.getColumn(this.nameColNum, n3)) != null && !string2.equals(string)) {
                        vector.setElementAt(string2, n2);
                        ++n2;
                    }
                    ++n3;
                }
                vector.setSize(n2);
            }
            catch (DirectoryTableInvalidParameterException directoryTableInvalidParameterException) {
                throw directoryTableInvalidParameterException;
            }
            catch (DirectoryTableAccessException directoryTableAccessException) {
                throw directoryTableAccessException;
            }
            catch (DirectoryTableConnectionException directoryTableConnectionException) {
                throw directoryTableConnectionException;
            }
            catch (DirectoryTableException directoryTableException) {
                throw directoryTableException;
            }
            Object var14_18 = null;
            if (directoryTable != null) {
                this.closeGroupTable(directoryTable);
            }
        }
        catch (Throwable throwable) {
            Object var14_19 = null;
            if (directoryTable != null) {
                this.closeGroupTable(directoryTable);
            }
            throw throwable;
        }
        return vector;
    }

    public String getNextAvailableGID() throws DirectoryTableException {
        int n = 100;
        DirectoryTable directoryTable = null;
        directoryTable = this.openGroupTable();
        int n2 = 0;
        boolean bl = false;
        try {
            try {
                TableDefinitions tableDefinitions = directoryTable.getCurrentTableDefinitions();
                DirectoryMask directoryMask = directoryTable.getDirectoryMaskInstance();
                directoryMask.setColumn(this.gidColNum);
                DirectoryRow directoryRow = directoryTable.getAll(directoryMask);
                directoryRow.sortByColumn(this.gidColNum, tableDefinitions);
                int n3 = 1;
                while (n3 <= directoryRow.getNumberOfRows()) {
                    String string = directoryRow.getColumn(this.gidColNum, n3);
                    if (string != null && string.trim().length() > 0 && (n2 = Integer.parseInt(string)) != 60001 && n2 != 60002 && n2 != 65534) {
                        if (n == n2) {
                            ++n;
                        } else if (n < n2) {
                            bl = true;
                        }
                    }
                    ++n3;
                }
            }
            catch (DirectoryTableInvalidParameterException directoryTableInvalidParameterException) {
                throw directoryTableInvalidParameterException;
            }
            catch (DirectoryTableAccessException directoryTableAccessException) {
                throw directoryTableAccessException;
            }
            catch (DirectoryTableConnectionException directoryTableConnectionException) {
                throw directoryTableConnectionException;
            }
            catch (DirectoryTableException directoryTableException) {
                throw directoryTableException;
            }
            Object var11_15 = null;
            if (directoryTable != null) {
                this.closeGroupTable(directoryTable);
            }
        }
        catch (Throwable throwable) {
            Object var11_16 = null;
            if (directoryTable != null) {
                this.closeGroupTable(directoryTable);
            }
            throw throwable;
        }
        return String.valueOf(n);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean doesGroupExist(GroupObj groupObj) throws Exception {
        DirectoryTable directoryTable = null;
        directoryTable = this.openGroupTable();
        try {
            try {
                DirectoryRow directoryRow = directoryTable.getRowInstance();
                directoryRow.putColumn(this.nameColNum, groupObj.getGroupName());
                directoryRow = directoryTable.getFirstRow((SearchTemplate)directoryRow);
                if (directoryRow == null) {
                    boolean bl = false;
                    Object var9_8 = null;
                    if (directoryTable == null) return bl;
                    this.closeGroupTable(directoryTable);
                    return bl;
                }
                Object var9_9 = null;
                if (directoryTable == null) return true;
                this.closeGroupTable(directoryTable);
                return true;
            }
            catch (DirectoryTableInvalidParameterException directoryTableInvalidParameterException) {
                throw directoryTableInvalidParameterException;
            }
            catch (DirectoryTableAccessException directoryTableAccessException) {
                throw directoryTableAccessException;
            }
            catch (DirectoryTableConnectionException directoryTableConnectionException) {
                throw directoryTableConnectionException;
            }
            catch (DirectoryTableException directoryTableException) {
                throw directoryTableException;
            }
            catch (Exception exception) {
                throw exception;
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            if (directoryTable == null) throw throwable;
            this.closeGroupTable(directoryTable);
            throw throwable;
        }
    }
}

