/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.apps.cimworkshop;

import com.sun.wbem.apps.common.ActionString;
import com.sun.wbem.apps.common.ButtonPanel;
import com.sun.wbem.apps.common.CIMClientObject;
import com.sun.wbem.apps.common.CIMErrorDialog;
import com.sun.wbem.apps.common.ColumnLayout;
import com.sun.wbem.apps.common.FlowArea;
import com.sun.wbem.apps.common.I18N;
import com.sun.wbem.apps.common.LAYOUT_ALIGNMENT;
import com.sun.wbem.apps.common.Util;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMNameSpace;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMQualifier;
import javax.wbem.cim.CIMValue;
import javax.wbem.client.CIMClient;

public class CIMEventsPanel
extends JScrollPane
implements ActionListener {
    protected Hashtable eventSelectionTable = new Hashtable();
    protected Hashtable filterInstanceTable = new Hashtable();
    protected Hashtable filterDeliveryInstanceTable = new Hashtable();
    protected int eventMask = 0;
    protected CIMClass cimClass = null;
    protected CIMClient cimClient = null;
    protected CIMObjectPath indicationHandler = null;
    protected JPanel mainPanel;
    protected CardLayout card;
    JButton btnSet;
    JCheckBox btnInstCreate;
    JCheckBox btnInstDelete;
    JCheckBox btnInstModify;
    JRadioButton btnEnable;
    JRadioButton btnDisable;
    private final String CREATE = "CIM_InstCreation";
    private final String DELETE = "CIM_InstDeletion";
    private final String MODIFY = "CIM_InstModification";
    private final int NONE = 0;
    private final int LIFE_CYCLE = 1;
    private final int PROCESS_INDICATION = 2;
    protected int eventType = 0;
    protected boolean eventsSupported = true;

    public CIMEventsPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.mainPanel = new JPanel();
        this.card = new CardLayout();
        this.mainPanel.setLayout(this.card);
        ActionString actionString = new ActionString("LBL_SET");
        this.btnSet = new JButton(actionString.getString());
        this.btnSet.setMnemonic(actionString.getMnemonic());
        this.btnSet.setActionCommand("SET");
        this.btnSet.addActionListener(this);
        ButtonPanel buttonPanel = new ButtonPanel();
        buttonPanel.add(this.btnSet);
        this.mainPanel.add("LIFE_CYCLE", this.createLifeCyclePanel());
        this.mainPanel.add("PROCESS_INDICATION", this.createProcessIndicationPanel());
        this.mainPanel.add("NONE", this.createMsgPanel("MSG_EVENT_CLASS"));
        this.mainPanel.add("NO_EVENTS", this.createMsgPanel("MSG_NO_EVENTS"));
        this.card.show(this.mainPanel, "NO_NONE");
        jPanel.add((Component)this.mainPanel, "North");
        jPanel.add((Component)buttonPanel, "South");
        this.setViewportView(jPanel);
    }

    private JPanel createMsgPanel(String string) {
        JPanel jPanel = new JPanel();
        FlowArea flowArea = new FlowArea(I18N.loadString(string), 35);
        flowArea.setBorder(BorderFactory.createEmptyBorder(15, 5, 15, 5));
        jPanel.add(flowArea);
        return jPanel;
    }

    private JPanel createLifeCyclePanel() {
        JPanel jPanel = new JPanel(new ColumnLayout(LAYOUT_ALIGNMENT.CENTER));
        ActionString actionString = new ActionString("LBL_INSTANCE_CREATE");
        ActionString actionString2 = new ActionString("LBL_INSTANCE_DELETE");
        ActionString actionString3 = new ActionString("LBL_INSTANCE_MODIFY");
        this.btnInstCreate = new JCheckBox(actionString.getString());
        this.btnInstCreate.setMnemonic(actionString.getMnemonic());
        this.btnInstCreate.addActionListener(this);
        this.btnInstDelete = new JCheckBox(actionString2.getString());
        this.btnInstDelete.setMnemonic(actionString2.getMnemonic());
        this.btnInstDelete.addActionListener(this);
        this.btnInstModify = new JCheckBox(actionString3.getString());
        this.btnInstModify.setMnemonic(actionString3.getMnemonic());
        this.btnInstModify.addActionListener(this);
        FlowArea flowArea = new FlowArea(I18N.loadString("MSG_SELECT_EVENTS"), 35);
        flowArea.setBorder(BorderFactory.createEmptyBorder(15, 5, 15, 5));
        JPanel jPanel2 = new JPanel(new ColumnLayout(LAYOUT_ALIGNMENT.LEFT));
        jPanel2.add(this.btnInstCreate);
        jPanel2.add(this.btnInstDelete);
        jPanel2.add(this.btnInstModify);
        jPanel.add(flowArea);
        jPanel.add(jPanel2);
        return jPanel;
    }

    private JPanel createProcessIndicationPanel() {
        JPanel jPanel = new JPanel(new ColumnLayout(LAYOUT_ALIGNMENT.CENTER));
        ActionString actionString = new ActionString("LBL_ENABLED");
        ActionString actionString2 = new ActionString("LBL_DISABLED");
        this.btnEnable = new JRadioButton(actionString.getString());
        this.btnEnable.setMnemonic(actionString.getMnemonic());
        this.btnEnable.addActionListener(this);
        this.btnDisable = new JRadioButton(actionString2.getString());
        this.btnDisable.setMnemonic(actionString2.getMnemonic());
        this.btnDisable.addActionListener(this);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.btnEnable);
        buttonGroup.add(this.btnDisable);
        FlowArea flowArea = new FlowArea(I18N.loadString("MSG_PI_EVENTS"), 35);
        flowArea.setBorder(BorderFactory.createEmptyBorder(15, 5, 15, 5));
        JPanel jPanel2 = new JPanel(new ColumnLayout(LAYOUT_ALIGNMENT.LEFT));
        jPanel2.add(this.btnEnable);
        jPanel2.add(this.btnDisable);
        jPanel.add(flowArea);
        jPanel.add(jPanel2);
        return jPanel;
    }

    public void deleteEventSubscriptions() {
        if (this.cimClient != null) {
            CIMObjectPath cIMObjectPath;
            String string;
            Enumeration enumeration = this.filterDeliveryInstanceTable.keys();
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                cIMObjectPath = (CIMObjectPath)this.filterDeliveryInstanceTable.get(string);
                try {
                    this.cimClient.deleteInstance(cIMObjectPath);
                }
                catch (CIMException cIMException) {
                    CIMErrorDialog.display(this, cIMException);
                }
            }
            enumeration = this.filterInstanceTable.keys();
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                cIMObjectPath = (CIMObjectPath)this.filterInstanceTable.get(string);
                try {
                    this.cimClient.deleteInstance(cIMObjectPath);
                }
                catch (CIMException cIMException) {
                    CIMErrorDialog.display(this, cIMException);
                }
            }
            if (this.indicationHandler != null) {
                try {
                    this.cimClient.deleteInstance(Util.getRelativeObjectPath(this.indicationHandler));
                    this.indicationHandler = null;
                }
                catch (CIMException cIMException) {
                    CIMErrorDialog.display(this, cIMException);
                }
            }
        }
        this.filterInstanceTable.clear();
        this.filterDeliveryInstanceTable.clear();
        this.eventSelectionTable.clear();
    }

    public void initializeEvents(CIMObjectPath cIMObjectPath, CIMClient cIMClient) {
        this.indicationHandler = cIMObjectPath;
        boolean bl = this.eventsSupported = this.indicationHandler != null;
        if (!this.eventsSupported) {
            this.card.show(this.mainPanel, "NO_EVENTS");
        } else {
            this.card.show(this.mainPanel, "NONE");
        }
        this.cimClient = cIMClient;
    }

    public void setEventsSelection(CIMClass cIMClass) {
        if (this.cimClient == null || !this.eventsSupported) {
            return;
        }
        this.cimClass = cIMClass;
        if (this.cimClass == null) {
            this.eventType = 0;
        } else {
            String string = this.cimClass.getName();
            CIMQualifier cIMQualifier = cIMClass.getQualifier("Indication");
            Boolean bl = new Boolean("true");
            this.eventType = cIMQualifier != null && cIMQualifier.hasValue() && bl.equals(cIMQualifier.getValue().getValue()) ? 2 : 1;
            Integer n = new Integer(0);
            if (this.eventSelectionTable.containsKey(string)) {
                n = (Integer)this.eventSelectionTable.get(string);
            }
            this.eventMask = n;
            this.initializeControls();
        }
        switch (this.eventType) {
            case 0: {
                this.card.show(this.mainPanel, "NONE");
                break;
            }
            case 1: {
                this.card.show(this.mainPanel, "LIFE_CYCLE");
                break;
            }
            case 2: {
                this.card.show(this.mainPanel, "PROCESS_INDICATION");
            }
        }
        this.btnSet.setEnabled(false);
    }

    private void initializeControls() {
        if (this.eventType == 1) {
            this.btnInstCreate.setSelected((this.eventMask & 1) > 0);
            this.btnInstDelete.setSelected((this.eventMask & 2) > 0);
            this.btnInstModify.setSelected((this.eventMask & 4) > 0);
        } else if (this.eventType == 2) {
            this.btnDisable.setSelected(this.eventMask == 0);
        }
    }

    private int getSelectedMask() {
        int n = 0;
        if (this.eventType == 1) {
            if (this.btnInstCreate.isSelected()) {
                ++n;
            }
            if (this.btnInstDelete.isSelected()) {
                n += 2;
            }
            if (this.btnInstModify.isSelected()) {
                n += 4;
            }
        } else if (this.eventType == 2 && this.btnEnable.isSelected()) {
            n = 1;
        }
        return n;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("SET")) {
            int n = this.getSelectedMask();
            this.setEvents(n);
            if (n == 0) {
                this.eventSelectionTable.remove(this.cimClass.getName());
            } else {
                this.eventSelectionTable.put(this.cimClass.getName(), new Integer(n));
            }
            this.eventMask = n;
            this.btnSet.setEnabled(false);
        } else {
            this.enableSetButton();
        }
    }

    private void enableSetButton() {
        this.btnSet.setEnabled(this.eventMask != this.getSelectedMask());
    }

    private void setEvents(int n) {
        if (!this.createIndicationHandler()) {
            return;
        }
        if (this.eventType == 1) {
            if ((~(this.eventMask & 1) & (n & 1)) > 0) {
                this.setLifeCycleInstance("CIM_InstCreation");
            }
            if ((~(this.eventMask & 2) & (n & 2)) > 0) {
                this.setLifeCycleInstance("CIM_InstDeletion");
            }
            if ((~(this.eventMask & 4) & (n & 4)) > 0) {
                this.setLifeCycleInstance("CIM_InstModification");
            }
            if ((this.eventMask & 1 & ~(n & 1)) > 0) {
                this.removeLifeCycleInstance("CIM_InstCreation");
            }
            if ((this.eventMask & 2 & ~(n & 2)) > 0) {
                this.removeLifeCycleInstance("CIM_InstDeletion");
            }
            if ((this.eventMask & 4 & ~(n & 4)) > 0) {
                this.removeLifeCycleInstance("CIM_InstModification");
            }
        } else if (this.eventType == 2) {
            if (this.eventMask == 0 && n == 1) {
                this.setIndicationInstance();
            } else if (this.eventMask == 1 && n == 0) {
                this.removeIndicationInstance();
            }
        }
    }

    public void addFilter(String string, String string2, String string3) {
        this.addFilter("", "", "", string, "", string2, string3);
    }

    public void addFilter(String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        CIMObjectPath cIMObjectPath = null;
        try {
            CIMClass cIMClass = this.cimClient.getClass(new CIMObjectPath("CIM_IndicationFilter"), true, true, true, null);
            CIMInstance cIMInstance = cIMClass.newInstance();
            if (string != null && string.trim().length() > 0) {
                cIMInstance.setProperty("SystemCreationClassName", new CIMValue((Object)string));
            }
            if (string2 != null && string2.trim().length() > 0) {
                cIMInstance.setProperty("SystemName", new CIMValue((Object)string2));
            }
            if (string3 != null && string3.trim().length() > 0) {
                cIMInstance.setProperty("CreationClassName", new CIMValue((Object)string3));
            }
            if (string5 != null && string5.trim().length() > 0) {
                cIMInstance.setProperty("SourceNamespace", new CIMValue((Object)string5));
            }
            if (string6 != null) {
                cIMInstance.setProperty("Query", new CIMValue((Object)string6));
            }
            if (string7 != null) {
                cIMInstance.setProperty("QueryLanguage", new CIMValue((Object)string7));
            } else {
                cIMInstance.setProperty("QueryLanguage", new CIMValue((Object)"WQL"));
            }
            cIMObjectPath = this.cimClient.createInstance(new CIMObjectPath(), cIMInstance);
            CIMClass cIMClass2 = this.cimClient.getClass(new CIMObjectPath("CIM_IndicationSubscription"), true, true, true, null);
            cIMInstance = cIMClass2.newInstance();
            cIMInstance.setProperty("filter", new CIMValue((Object)cIMObjectPath));
            cIMInstance.setProperty("handler", new CIMValue((Object)this.indicationHandler));
            CIMObjectPath cIMObjectPath2 = this.cimClient.createInstance(new CIMObjectPath(), cIMInstance);
            if (cIMObjectPath2 == null) {
                cIMObjectPath2 = new CIMObjectPath();
                cIMObjectPath2.setNameSpace("");
                cIMObjectPath2.setObjectName(cIMInstance.getClassName());
                cIMObjectPath2.setKeys(cIMInstance.getKeyValuePairs());
            }
            this.filterInstanceTable.put(string4, Util.getRelativeObjectPath(cIMObjectPath));
            this.filterDeliveryInstanceTable.put(string4, Util.getRelativeObjectPath(cIMObjectPath2));
        }
        catch (CIMException cIMException) {
            CIMErrorDialog.display(this, cIMException);
            try {
                if (cIMObjectPath != null) {
                    this.cimClient.deleteInstance(Util.getRelativeObjectPath(cIMObjectPath));
                }
            }
            catch (CIMException cIMException2) {
                // empty catch block
            }
            return;
        }
    }

    private void removeLifeCycleInstance(String string) {
        if (this.cimClass == null) {
            return;
        }
        String string2 = this.cimClass.getName();
        String string3 = string + "." + string2;
        CIMObjectPath cIMObjectPath = null;
        CIMObjectPath cIMObjectPath2 = null;
        cIMObjectPath = (CIMObjectPath)this.filterInstanceTable.get(string3);
        cIMObjectPath2 = (CIMObjectPath)this.filterDeliveryInstanceTable.get(string3);
        try {
            if (cIMObjectPath2 != null) {
                this.cimClient.deleteInstance(cIMObjectPath2);
                this.filterDeliveryInstanceTable.remove(string3);
            }
        }
        catch (CIMException cIMException) {
            CIMErrorDialog.display(this, cIMException);
        }
        try {
            if (cIMObjectPath != null) {
                this.cimClient.deleteInstance(cIMObjectPath);
                this.filterInstanceTable.remove(string3);
            }
        }
        catch (CIMException cIMException) {
            CIMErrorDialog.display(this, cIMException);
        }
    }

    private void removeIndicationInstance() {
        if (this.cimClass == null) {
            return;
        }
        String string = this.cimClass.getName();
        CIMObjectPath cIMObjectPath = null;
        CIMObjectPath cIMObjectPath2 = null;
        cIMObjectPath = (CIMObjectPath)this.filterInstanceTable.get(string);
        cIMObjectPath2 = (CIMObjectPath)this.filterDeliveryInstanceTable.get(string);
        try {
            if (cIMObjectPath2 != null) {
                this.cimClient.deleteInstance(cIMObjectPath2);
                this.filterDeliveryInstanceTable.remove(string);
            }
        }
        catch (CIMException cIMException) {
            CIMErrorDialog.display(this, cIMException);
        }
        try {
            if (cIMObjectPath != null) {
                this.cimClient.deleteInstance(cIMObjectPath);
                this.filterInstanceTable.remove(string);
            }
        }
        catch (CIMException cIMException) {
            CIMErrorDialog.display(this, cIMException);
        }
    }

    private void setIndicationInstance() {
        if (this.cimClass == null) {
            return;
        }
        String string = this.cimClass.getName();
        String string2 = "SELECT * FROM " + string;
        this.addFilter(string, string2, "WQL");
    }

    private void setLifeCycleInstance(String string) {
        if (this.cimClass == null) {
            return;
        }
        String string2 = this.cimClass.getName();
        String string3 = string + "." + string2;
        String string4 = "SELECT * FROM " + string + " WHERE sourceInstance ISA " + string2;
        CIMNameSpace cIMNameSpace = new CIMNameSpace();
        if (cIMNameSpace.getNameSpace().equals(CIMClientObject.getNameSpace())) {
            this.addFilter(string3, string4, "WQL");
        } else {
            this.addFilter("", "", "", string3, CIMClientObject.getNameSpace(), string4, "WQL");
        }
    }

    private boolean createIndicationHandler() {
        if (this.indicationHandler == null) {
            try {
                CIMInstance cIMInstance = this.cimClient.getIndicationHandler(null);
                this.indicationHandler = this.cimClient.createInstance(new CIMObjectPath(), cIMInstance);
            }
            catch (CIMException cIMException) {
                return false;
            }
        }
        return true;
    }
}

