/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client;

import com.netscape.management.client.IMenuInfo;
import com.netscape.management.client.IMenuItem;
import com.netscape.management.client.IPage;
import com.netscape.management.client.ITaskModel;
import com.netscape.management.client.ITaskObject;
import com.netscape.management.client.MenuItemSeparator;
import com.netscape.management.client.MenuItemText;
import com.netscape.management.client.TaskModel;
import com.netscape.management.client.TaskObject;
import com.netscape.management.client.acleditor.ACLEditor;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.keycert.CRLManagementDialog;
import com.netscape.management.client.keycert.CertManagementDialog;
import com.netscape.management.client.keycert.ChangeKeyPasswordDialog;
import com.netscape.management.client.keycert.KeyCertWizard;
import com.netscape.management.client.keycert.PKCS11ManagementDialog;
import com.netscape.management.client.util.ClassLoaderUtil;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.LDAPUtil;
import com.netscape.management.client.util.ResourceSet;
import com.sun.java.swing.tree.DefaultMutableTreeNode;
import com.sun.java.swing.tree.MutableTreeNode;
import java.util.Enumeration;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPSearchConstraints;
import netscape.ldap.LDAPSearchResults;

public class LDAPTaskModel
extends TaskModel
implements IMenuInfo {
    public static String MENU_OPEN = "OPEN";
    public static String MENU_ACL = "ACL";
    public static String MENU_KEYCERT = "CERTIFICATE SETUP WIZARD";
    public static String MENU_KEYCERT_MANAGEMENT = "CERTIFICATE MANAGEMENT";
    public static String MENU_PKCS11 = "PKCS #11 MANAGEMENT";
    public static String MENU_CHANGEPW = "CHANGE TRUST DB PASSWORD";
    public static String MENU_CRL_MANAGEMENT = "CRL MANAGEMENT";
    static ResourceSet _resource = new ResourceSet("com.netscape.management.client.default");
    protected ITaskObject _selection;

    public LDAPTaskModel(ConsoleInfo ci) {
        super(ci);
        this.setRoot((ITaskObject)LDAPTaskModel.getTasksFromLDAP(ci));
    }

    public String[] getMenuCategoryIDs() {
        return new String[]{"FILE", "EDIT", "CONTEXT"};
    }

    public IMenuItem[] getMenuItems(String categoryID) {
        if (categoryID.equals("FILE")) {
            if (this._consoleInfo.get("CLUSTER") != null) {
                return new IMenuItem[]{new MenuItemSeparator(), new MenuItemText(MENU_OPEN, _resource.getString("menu", "FileOpen"), "TODO:description")};
            }
            return new IMenuItem[]{new MenuItemText(MENU_KEYCERT, _resource.getString("menu", "FileKCWizard"), "TODO:description"), new MenuItemText(MENU_KEYCERT_MANAGEMENT, _resource.getString("menu", "FileCertManagement"), "TODO:description"), new MenuItemText(MENU_CRL_MANAGEMENT, _resource.getString("menu", "FileCRLManagement"), "TODO:description"), new MenuItemText(MENU_PKCS11, _resource.getString("menu", "FilePKCS11Management"), "TODO:description"), new MenuItemText(MENU_CHANGEPW, _resource.getString("menu", "FileChangePw"), "TODO:description"), new MenuItemSeparator(), new MenuItemText(MENU_OPEN, _resource.getString("menu", "FileOpen"), "TODO:description")};
        }
        if (categoryID.equals("EDIT")) {
            return new IMenuItem[]{new MenuItemText(MENU_ACL, _resource.getString("menu", "EditSetACL"), "TODO:description", false)};
        }
        if (categoryID.equals("CONTEXT")) {
            return new IMenuItem[]{new MenuItemText(MENU_OPEN, _resource.getString("menu", "FileOpen"), "TODO:description"), new MenuItemText(MENU_ACL, _resource.getString("menu", "EditSetACL"), "TODO:description")};
        }
        return null;
    }

    public void actionObjectSelected(IPage viewInstance, ITaskObject selection, ITaskObject previousSelection) {
        super.actionObjectSelected(viewInstance, selection, previousSelection);
        this._selection = selection;
        if (selection == null) {
            this.fireDisableMenuItem(viewInstance, MENU_ACL);
        } else {
            this.fireEnableMenuItem(viewInstance, MENU_ACL);
        }
    }

    public void actionMenuSelected(IPage viewInstance, IMenuItem item) {
        if (item.getID().equals(MENU_OPEN)) {
            this.actionObjectRun(viewInstance, this._selection);
        } else if (item.getID().equals(MENU_ACL)) {
            this._consoleInfo.setAclDN(this._selection.getConsoleInfo().getCurrentDN());
            this._consoleInfo.setUserGroupDN("");
            ACLEditor ed = new ACLEditor(this._consoleInfo);
            ed.show();
        } else if (item.getID().equals(MENU_KEYCERT)) {
            KeyCertWizard wizard = new KeyCertWizard(this._consoleInfo);
        } else if (item.getID().equals(MENU_KEYCERT_MANAGEMENT)) {
            CertManagementDialog certmgt = new CertManagementDialog(this._consoleInfo);
        } else if (item.getID().equals(MENU_CRL_MANAGEMENT)) {
            CRLManagementDialog crlManagement = new CRLManagementDialog(this._consoleInfo);
        } else if (item.getID().equals(MENU_PKCS11)) {
            PKCS11ManagementDialog pkcs11 = new PKCS11ManagementDialog(this._consoleInfo);
        } else if (item.getID().equals(MENU_CHANGEPW)) {
            ChangeKeyPasswordDialog changeKeyPasswordDialog = new ChangeKeyPasswordDialog(this._consoleInfo);
        }
    }

    public static TaskObject getTasksFromLDAP(ConsoleInfo ci) {
        ResourceSet _resource = new ResourceSet("com.netscape.management.client.default");
        TaskObject root = new TaskObject("root", ci);
        root.setAllowsChildren(true);
        LDAPTaskModel.getTasksFromLDAP(ci, (DefaultMutableTreeNode)root);
        return root;
    }

    public static void getTasksFromLDAP(ConsoleInfo ci, DefaultMutableTreeNode root) {
        block12: {
            LDAPSearchResults result = null;
            try {
                LDAPConnection ldc = ci.getLDAPConnection();
                if (ldc == null) break block12;
                LDAPSearchConstraints cons = ldc.getSearchConstraints();
                cons.setBatchSize(1);
                result = ldc.search(ci.getCurrentDN(), 2, "(ObjectClass=nstask)", null, false, cons);
                while (result.hasMoreElements()) {
                    LDAPEntry findEntry;
                    try {
                        findEntry = result.next();
                    }
                    catch (Exception exception) {
                        continue;
                    }
                    LDAPAttributeSet findAttrs = findEntry.getAttributeSet();
                    Enumeration enumAttrs = findAttrs.getAttributes();
                    String sLabel = "";
                    String sJavaClassName = "";
                    String sDescription = "";
                    while (enumAttrs.hasMoreElements()) {
                        LDAPAttribute anAttr = (LDAPAttribute)enumAttrs.nextElement();
                        String attrName = anAttr.getName();
                        if (attrName.equalsIgnoreCase("nsTaskLabel")) {
                            sLabel = LDAPUtil.flatting((Enumeration)anAttr.getStringValues());
                            continue;
                        }
                        if (attrName.equalsIgnoreCase("cn")) continue;
                        if (attrName.equalsIgnoreCase("nsclassname")) {
                            sJavaClassName = LDAPUtil.flatting((Enumeration)anAttr.getStringValues());
                            continue;
                        }
                        if (!attrName.equalsIgnoreCase("Description")) continue;
                        sDescription = LDAPUtil.flatting((Enumeration)anAttr.getStringValues());
                    }
                    if (sJavaClassName.equals("")) {
                        Debug.println((String)("LDAPTaskModel:getTasksFromLDAP:no nsClassName for " + findEntry.getDN()));
                        continue;
                    }
                    try {
                        Class c = ClassLoaderUtil.getClass((ConsoleInfo)ci, (String)sJavaClassName);
                        if (c != null) {
                            TaskObject task = (TaskObject)c.newInstance();
                            ConsoleInfo taskConsoleInfo = (ConsoleInfo)ci.clone();
                            taskConsoleInfo.put("SIE", LDAPTaskModel.getSIE(ci));
                            taskConsoleInfo.setCurrentDN(findEntry.getDN());
                            task.setConsoleInfo(taskConsoleInfo);
                            root.add((MutableTreeNode)task);
                            continue;
                        }
                        System.err.println("LdapTaskUtil:getTasksFromLDAP:could not load class for task entry:" + findEntry.toString());
                    }
                    catch (Exception exception) {
                        Debug.println((String)("LDAPTaskModel.getTasksFromLdap: Could not load class: " + sJavaClassName));
                    }
                }
            }
            catch (Exception exception) {}
        }
    }

    static String getSIE(ConsoleInfo consoleInfo) {
        String currentDN = consoleInfo.getCurrentDN();
        return currentDN.substring(currentDN.indexOf("cn=") + 3, currentDN.indexOf(","));
    }

    public static ITaskModel createTaskModel(ConsoleInfo ci) {
        return new LDAPTaskModel(ci);
    }
}

