/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client;

import com.netscape.management.client.CloseVetoException;
import com.netscape.management.client.FeedbackIndicator;
import com.netscape.management.client.IMenuInfo;
import com.netscape.management.client.IPage;
import com.netscape.management.client.IStatusItem;
import com.netscape.management.client.ITaskModel;
import com.netscape.management.client.ITaskModelListener;
import com.netscape.management.client.ITaskObject;
import com.netscape.management.client.TaskModelEvent;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.util.Debug;
import com.sun.java.swing.event.TreeModelListener;
import com.sun.java.swing.tree.TreeNode;
import com.sun.java.swing.tree.TreePath;
import java.awt.Cursor;
import java.util.Enumeration;
import java.util.Vector;

public class TaskModel
implements ITaskModel {
    ConsoleInfo _consoleInfo;
    ITaskObject _root;
    Vector _listeners = new Vector();

    public TaskModel() {
    }

    public TaskModel(ConsoleInfo info) {
        this._consoleInfo = info;
    }

    public TaskModel(ITaskObject root) {
        this.setRoot(root);
    }

    public void setRoot(ITaskObject root) {
        this._root = root;
    }

    public Object getRoot() {
        return this._root;
    }

    public Object getChild(Object node, int index) {
        return ((ITaskObject)node).getChildAt(index);
    }

    public int getIndexOfChild(Object parent, Object child) {
        return ((ITaskObject)parent).getIndex((TreeNode)((ITaskObject)child));
    }

    public int getChildCount(Object node) {
        return ((ITaskObject)node).getChildCount();
    }

    public boolean isLeaf(Object node) {
        return ((ITaskObject)node).getChildCount() == 0;
    }

    public void addTreeModelListener(TreeModelListener l) {
    }

    public void removeTreeModelListener(TreeModelListener l) {
    }

    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    public Enumeration getModelListeners() {
        return this._listeners.elements();
    }

    public void addITaskModelListener(ITaskModelListener l) {
        this._listeners.addElement(l);
    }

    public void removeITaskModelListener(ITaskModelListener l) {
        this._listeners.removeElement(l);
    }

    public int getViewCount() {
        return 0;
    }

    public String getViewName(int viewIndex) {
        return null;
    }

    public int getViewType(int viewIndex) {
        return 0;
    }

    public Object getViewRoot(int viewIndex) {
        return this.getRoot();
    }

    public void fireAddStatusItem(IPage viewInstance, IStatusItem item) {
        Enumeration e = this.getModelListeners();
        while (e.hasMoreElements()) {
            ITaskModelListener l = (ITaskModelListener)e.nextElement();
            l.addStatusItem(new TaskModelEvent((Object)this, viewInstance, item));
        }
    }

    public void fireRemoveStatusItem(IPage viewInstance, IStatusItem item) {
        Enumeration e = this.getModelListeners();
        while (e.hasMoreElements()) {
            ITaskModelListener l = (ITaskModelListener)e.nextElement();
            l.removeStatusItem(new TaskModelEvent((Object)this, viewInstance, item));
        }
    }

    public void fireChangeStatusItemState(IPage viewInstance, String itemID, Object state) {
        Enumeration e = this.getModelListeners();
        while (e.hasMoreElements()) {
            ITaskModelListener l = (ITaskModelListener)e.nextElement();
            l.changeStatusItemState(new TaskModelEvent((Object)this, viewInstance, itemID, state));
        }
    }

    public void fireChangeFeedbackCursor(IPage viewInstance, int feedbackIndicatorType) {
        Enumeration e = this.getModelListeners();
        while (e.hasMoreElements()) {
            ITaskModelListener l = (ITaskModelListener)e.nextElement();
            l.changeFeedbackCursor(new TaskModelEvent((Object)this, viewInstance, (Cursor)new FeedbackIndicator(feedbackIndicatorType)));
        }
    }

    public void fireRemoveMenuItems(IPage viewInstance, IMenuInfo menuInfo) {
        Enumeration e = this.getModelListeners();
        while (e.hasMoreElements()) {
            ITaskModelListener l = (ITaskModelListener)e.nextElement();
            l.removeMenuItems(new TaskModelEvent((Object)this, viewInstance, menuInfo));
        }
    }

    public void fireAddMenuItems(IPage viewInstance, IMenuInfo menuInfo) {
        Enumeration e = this.getModelListeners();
        while (e.hasMoreElements()) {
            ITaskModelListener l = (ITaskModelListener)e.nextElement();
            l.addMenuItems(new TaskModelEvent((Object)this, viewInstance, menuInfo));
        }
    }

    public void fireDisableMenuItem(IPage viewInstance, String menuItemID) {
        Enumeration e = this.getModelListeners();
        while (e.hasMoreElements()) {
            ITaskModelListener l = (ITaskModelListener)e.nextElement();
            l.disableMenuItem(new TaskModelEvent((Object)this, viewInstance, menuItemID));
        }
    }

    public void fireEnableMenuItem(IPage viewInstance, String menuItemID) {
        Enumeration e = this.getModelListeners();
        while (e.hasMoreElements()) {
            ITaskModelListener l = (ITaskModelListener)e.nextElement();
            l.enableMenuItem(new TaskModelEvent((Object)this, viewInstance, menuItemID));
        }
    }

    public void actionObjectSelected(IPage viewInstance, ITaskObject selection, ITaskObject previousSelection) {
        if (previousSelection != null && selection != previousSelection) {
            previousSelection.unselect(viewInstance);
        }
        if (selection != null) {
            selection.select(viewInstance);
        }
    }

    public void actionObjectRun(IPage viewInstance, ITaskObject selection) {
        if (selection != null) {
            Debug.println((String)"rsptime", (String)("Run Task " + selection.getName() + " ..."));
            selection.run(viewInstance);
        }
    }

    public void actionViewClosing(IPage viewInstance) throws CloseVetoException {
    }

    static String getSIE(ConsoleInfo consoleInfo) {
        String currentDN = consoleInfo.getCurrentDN();
        return currentDN.substring(currentDN.indexOf("cn=") + 3, currentDN.indexOf(","));
    }
}

