/*
 * Decompiled with CFR 0.152.
 */
package crysec;

import crysec.Certificate;
import crysec.Streamable;
import crysec.Utils;
import crysec.X500Name;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.Date;

public class X509
extends Certificate
implements Streamable,
Serializable {
    protected byte[] contents;
    protected byte[] fingerprint;
    protected X500Name issuer;
    protected X509 issuerCertificate;
    protected Date notBeforeDate;
    protected Date notAfterDate;

    public X509(InputStream is) throws Exception {
        super(is);
    }

    public X509(File file) throws Exception {
        super(file);
    }

    public X509(URL url) throws Exception {
        super(url);
    }

    public void initialize(InputStream is) throws Exception {
        try {
            this.input(is);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new Exception(e.toString());
        }
    }

    public void save(OutputStream os) {
        try {
            this.output(os);
        }
        catch (IOException iOException) {}
    }

    public void input(InputStream IS) throws IOException {
    }

    public void output(OutputStream os) throws IOException {
        os.write(this.contents);
    }

    public int length() {
        return this.contents.length;
    }

    public boolean verify() throws Exception {
        return true;
    }

    public boolean verifyCertDate() {
        Date now = new Date();
        return !now.before(this.notBeforeDate) && !now.after(this.notAfterDate);
    }

    public X500Name getIssuer() {
        return this.issuer;
    }

    public void setIssuerCertificate(X509 ic) {
        this.issuerCertificate = ic;
    }

    public X509 getIssuerCertificate() {
        return this.issuerCertificate;
    }

    public byte[] getFingerprint() {
        return this.fingerprint;
    }

    public Date getNotBeforeDate() {
        return this.notBeforeDate;
    }

    public Date getNotAfterDate() {
        return this.notAfterDate;
    }

    public String toString() {
        return "fingerprint = " + Utils.toHexString(this.fingerprint) + ", not before = " + this.notBeforeDate + ", not after = " + this.notAfterDate + ", holder = " + this.holder + ", issuer = " + this.issuer + ", key = " + this.key;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        System.out.println("write x509 object");
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        this.save(bs);
        out.writeObject(bs.toByteArray());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        System.out.println("read x509 object");
        try {
            this.initialize(new ByteArrayInputStream((byte[])in.readObject()));
        }
        catch (Exception exception) {}
    }
}

