/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.certsrv.ug;

import com.netscape.admin.certsrv.CMSAdminUtil;
import com.netscape.admin.certsrv.EAdminException;
import com.netscape.admin.certsrv.connection.AdminConnection;
import com.netscape.certsrv.common.NameValuePairs;
import com.netscape.management.client.util.JButtonFactory;
import com.sun.java.swing.BorderFactory;
import com.sun.java.swing.DefaultListModel;
import com.sun.java.swing.Icon;
import com.sun.java.swing.JButton;
import com.sun.java.swing.JDialog;
import com.sun.java.swing.JFrame;
import com.sun.java.swing.JLabel;
import com.sun.java.swing.JList;
import com.sun.java.swing.JPanel;
import com.sun.java.swing.JScrollPane;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.Vector;

public class UserListDialog
extends JDialog
implements ActionListener,
MouseListener {
    private String PREFIX = "USERLISTDIALOG";
    private JFrame mParentFrame;
    private AdminConnection mConnection;
    private ResourceBundle mResource;
    protected DefaultListModel mDataModel;
    protected Vector mCurrentUsers;
    protected Vector mSelectedUser;
    private JScrollPane mScrollPane;
    private JList mList;
    private JButton mOK;
    private JButton mCancel;
    private boolean mIsOk = false;
    static /* synthetic */ Class class$com$netscape$admin$certsrv$CMSAdminResources;

    public UserListDialog(JFrame parent, AdminConnection conn) {
        super((Frame)parent, true);
        this.mParentFrame = parent;
        this.mConnection = conn;
        this.mSelectedUser = new Vector();
        this.mResource = ResourceBundle.getBundle((class$com$netscape$admin$certsrv$CMSAdminResources != null ? class$com$netscape$admin$certsrv$CMSAdminResources : (class$com$netscape$admin$certsrv$CMSAdminResources = UserListDialog.class$("com.netscape.admin.certsrv.CMSAdminResources"))).getName());
        this.mDataModel = new DefaultListModel();
        ((Component)((Object)this)).setSize(360, 216);
        ((Dialog)((Object)this)).setTitle(this.mResource.getString(String.valueOf(this.PREFIX) + "_TITLE"));
        this.setLocationRelativeTo((Component)parent);
        this.getRootPane().setDoubleBuffered(true);
        this.setDisplay();
    }

    public void showDialog(Vector users) {
        this.mCurrentUsers = users;
        this.mSelectedUser.removeAllElements();
        try {
            this.refresh();
        }
        catch (EAdminException eAdminException) {
            CMSAdminUtil.showMessageDialog((JFrame)this.mParentFrame, (ResourceBundle)this.mResource, (String)this.PREFIX, (String)"SERVERERROR", (int)0);
            return;
        }
        this.setButtons();
        this.mIsOk = false;
        ((Dialog)((Object)this)).show();
    }

    public Vector getSelectedUser() {
        return this.mSelectedUser;
    }

    public boolean isOK() {
        return this.mIsOk;
    }

    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource().equals(this.mOK)) {
            int[] rowIndex = this.mList.getSelectedIndices();
            int j = 0;
            while (j < rowIndex.length) {
                this.mSelectedUser.addElement(((JLabel)this.mDataModel.elementAt(rowIndex[j])).getText());
                ++j;
            }
            this.mIsOk = true;
            ((Component)((Object)this)).hide();
        }
        if (evt.getSource().equals(this.mCancel)) {
            ((Component)((Object)this)).hide();
        }
    }

    public void mouseClicked(MouseEvent e) {
        this.setButtons();
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
        this.setButtons();
    }

    public void mouseExited(MouseEvent e) {
        this.setButtons();
    }

    private void setButtons() {
        if (this.mList.getSelectedIndex() < 0) {
            this.mOK.setEnabled(false);
            return;
        }
        this.mOK.setEnabled(true);
    }

    private void setDisplay() {
        this.getContentPane().setLayout(new BorderLayout());
        JPanel center = new JPanel();
        GridBagLayout gb = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        center.setLayout(gb);
        JPanel content = this.makeContentPane();
        CMSAdminUtil.resetGBC((GridBagConstraints)gbc);
        gbc.anchor = 11;
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gb.setConstraints((Component)content, gbc);
        center.add((Component)content);
        JPanel action = this.makeActionPane();
        CMSAdminUtil.resetGBC((GridBagConstraints)gbc);
        gbc.anchor = 11;
        gbc.gridwidth = 0;
        gbc.gridheight = 0;
        gbc.weightx = 1.0;
        gb.setConstraints((Component)action, gbc);
        center.add((Component)action);
        this.getContentPane().add("Center", (Component)center);
    }

    private JPanel makeActionPane() {
        this.mOK = CMSAdminUtil.makeJButton((ResourceBundle)this.mResource, (String)this.PREFIX, (String)"OK", null, (ActionListener)this);
        this.mCancel = CMSAdminUtil.makeJButton((ResourceBundle)this.mResource, (String)this.PREFIX, (String)"CANCEL", null, (ActionListener)this);
        JButton[] buttons = new JButton[]{this.mOK, this.mCancel};
        JButtonFactory.resize((JButton[])buttons);
        return CMSAdminUtil.makeJButtonPanel((JButton[])buttons);
    }

    private JPanel makeContentPane() {
        JPanel mListPanel = new JPanel();
        GridBagLayout gb = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        mListPanel.setLayout(gb);
        this.mList = CMSAdminUtil.makeJList((DefaultListModel)this.mDataModel, (int)9);
        this.mScrollPane = new JScrollPane((Component)this.mList, 22, 31);
        this.mList.setSelectionMode(2);
        this.mList.addMouseListener(this);
        this.mScrollPane.setBackground(Color.white);
        this.mScrollPane.setBorder(BorderFactory.createLoweredBevelBorder());
        CMSAdminUtil.resetGBC((GridBagConstraints)gbc);
        gbc.anchor = 11;
        gbc.gridwidth = 0;
        gbc.gridheight = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gb.setConstraints((Component)this.mScrollPane, gbc);
        mListPanel.add((Component)this.mScrollPane);
        return mListPanel;
    }

    private void refresh() throws EAdminException {
        NameValuePairs response;
        this.mDataModel.removeAllElements();
        try {
            response = this.mConnection.search("ug", "users", new NameValuePairs());
        }
        catch (EAdminException e) {
            CMSAdminUtil.showErrorDialog((JFrame)this.mParentFrame, (ResourceBundle)this.mResource, (String)e.getMessage(), (int)0);
            return;
        }
        Vector<String> store = new Vector<String>();
        Enumeration e = response.getNames();
        while (e.hasMoreElements()) {
            String entry = ((String)e.nextElement()).trim();
            if (this.mCurrentUsers.indexOf(entry) != -1) continue;
            store.addElement(entry);
        }
        Object[] vals = new String[store.size()];
        store.copyInto(vals);
        CMSAdminUtil.bubbleSort((String[])vals);
        int y = 0;
        while (y < vals.length) {
            this.mDataModel.addElement((Object)new JLabel((String)vals[y], (Icon)CMSAdminUtil.getImage((String)"alluser16n.gif"), 2));
            ++y;
        }
        this.refreshTable();
    }

    private void refreshTable() {
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }
}

