/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv;

import com.netscape.admin.dirserv.AttributeTableModel;
import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.Helper;
import com.netscape.admin.dirserv.browser.IBrowserNodeInfo;
import com.netscape.admin.dirserv.browser.LDAPConnectionPool;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPMessage;
import netscape.ldap.LDAPSearchConstraints;
import netscape.ldap.LDAPSearchListener;
import netscape.ldap.LDAPSearchResult;

class AttributeController
implements Runnable {
    LDAPConnectionPool _connectionPool;
    JPanel _panel;
    AttributeTableModel _attributeTableData;
    JTable _attributeTable;
    IBrowserNodeInfo _waitingNode;
    boolean _shutDown = false;
    boolean _isWorking = false;
    boolean _isAbandoned = true;
    boolean _isCancelled = false;
    Hashtable _entryCache = new Hashtable();
    LDAPConnection _ldc;
    LDAPSearchListener _listener;
    int DEFAULT_ATTRIBUTE_SIZE = 100;
    int DEFAULT_VALUE_SIZE = 150;
    static final String ALL_ENTRY_FILTER = "|(objectclass=*)(objectclass=ldapsubentry)";
    static final String[] ALL_ATTRS = new String[]{"*", "nsrole", "nsroledn"};

    public AttributeController(LDAPConnectionPool lDAPConnectionPool, JPanel jPanel) {
        this._panel = jPanel;
        this._connectionPool = lDAPConnectionPool;
        this._attributeTableData = new AttributeTableModel();
        this._attributeTable = new JTable(this._attributeTableData);
        this._attributeTable.setAutoResizeMode(0);
        this._attributeTable.setRowSelectionAllowed(false);
        JScrollPane jScrollPane = new JScrollPane(this._attributeTable);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        this._panel.add((Component)jScrollPane, gridBagConstraints);
        this.wakeUp();
    }

    public void updateAttributePanel(IBrowserNodeInfo iBrowserNodeInfo) {
        this.stopUpdate();
        this._waitingNode = iBrowserNodeInfo;
        if (!this._isWorking) {
            AttributeController attributeController = this;
            synchronized (attributeController) {
                this.notify();
            }
        }
    }

    public void clearAttributePanel() {
        this.stopUpdate();
        this._attributeTableData.cleanData();
        this._attributeTableData.fireTableDataChanged();
        this._attributeTable.getTableHeader().resizeAndRepaint();
        this._panel.validate();
        this._panel.repaint();
    }

    public void reset() {
        this._entryCache.clear();
    }

    public void shutDown() {
        this._shutDown = true;
        this.stopUpdate();
    }

    public void wakeUp() {
        this._shutDown = false;
        Thread thread = new Thread(this);
        thread.start();
    }

    public void run() {
        while (!this._shutDown) {
            this._isWorking = true;
            if (this._waitingNode != null) {
                this.readAndUpdate();
            }
            try {
                AttributeController attributeController = this;
                synchronized (attributeController) {
                    this._isWorking = false;
                    this.wait();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void stopUpdate() {
        if (this._isWorking && !this._isCancelled) {
            this._isCancelled = true;
            Thread thread = new Thread(new Runnable(){

                public void run() {
                    AttributeController.this.abandon();
                }
            });
            thread.start();
        }
    }

    private void abandon() {
        if (!this._isAbandoned && this._listener != null && this._ldc != null && this._listener != null) {
            this._isAbandoned = true;
            try {
                this._ldc.abandon(this._listener);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void readAndUpdate() {
        IBrowserNodeInfo iBrowserNodeInfo = this._waitingNode;
        this._waitingNode = null;
        LDAPEntry lDAPEntry = (LDAPEntry)this._entryCache.get(iBrowserNodeInfo.getURL());
        if (lDAPEntry == null) {
            boolean bl = false;
            try {
                this._ldc = this._connectionPool.getConnection(iBrowserNodeInfo.getURL());
                String string = Helper.getNodeInfoDN(iBrowserNodeInfo);
                LDAPSearchConstraints lDAPSearchConstraints = (LDAPSearchConstraints)this._ldc.getSearchConstraints().clone();
                this._listener = this._ldc.search(string, 0, ALL_ENTRY_FILTER, ALL_ATTRS, false, this._listener, lDAPSearchConstraints);
                while (!bl && !this._isCancelled) {
                    LDAPMessage lDAPMessage = this._listener.getResponse();
                    if (lDAPMessage != null) {
                        if (!(lDAPMessage instanceof LDAPSearchResult)) continue;
                        lDAPEntry = ((LDAPSearchResult)lDAPMessage).getEntry();
                        bl = true;
                        continue;
                    }
                    this._isCancelled = true;
                }
                if (this._isCancelled) {
                    lDAPEntry = null;
                    if (this._isCancelled && !this._isAbandoned) {
                        this._isAbandoned = true;
                        this._ldc.abandon(this._listener);
                    }
                }
            }
            catch (LDAPException lDAPException) {
                // empty catch block
            }
            if (lDAPEntry != null) {
                this._entryCache.put(iBrowserNodeInfo.getURL(), lDAPEntry);
            }
        }
        if (lDAPEntry != null) {
            this.updateTableFromEntry(lDAPEntry);
        }
        this._isCancelled = false;
    }

    private void updateTableFromEntry(LDAPEntry lDAPEntry) {
        String string;
        int n = 0;
        int n2 = 0;
        this._attributeTableData.cleanData();
        LDAPAttributeSet lDAPAttributeSet = lDAPEntry.getAttributeSet();
        int n3 = lDAPAttributeSet.size();
        int n4 = 0;
        String string2 = null;
        int n5 = 0;
        String string3 = null;
        int n6 = 0;
        String[] stringArray = new String[n3];
        int n7 = 0;
        while (n7 < n3) {
            LDAPAttribute lDAPAttribute = lDAPAttributeSet.elementAt(n7);
            stringArray[n7] = string = lDAPAttribute.getName();
            ++n7;
        }
        DSUtil.bubbleSort(stringArray, true);
        int n8 = 0;
        while (n8 < n3) {
            string = lDAPAttributeSet.getAttribute(stringArray[n8]);
            String string4 = stringArray[n8];
            int n9 = string4.length();
            if (n9 > n) {
                n = n9;
                n5 = n4;
                string2 = string4;
            }
            Enumeration enumeration = string.getStringValues();
            while (enumeration.hasMoreElements()) {
                String string5 = (String)enumeration.nextElement();
                int n10 = string5.length();
                if (n10 > n2) {
                    n2 = n10;
                    n6 = n4;
                    string3 = string5;
                }
                this._attributeTableData.addRow(string4, string5);
                ++n4;
            }
            ++n8;
        }
        final int n11 = this.getComponentWidth(string2, n5, 0) + 10;
        final int n12 = this.getComponentWidth(string3, n6, 1) + 10;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                TableColumn tableColumn = AttributeController.this._attributeTable.getColumn(AttributeController.this._attributeTableData.COLUMN_NAMES[0]);
                if (n11 > AttributeController.this.DEFAULT_ATTRIBUTE_SIZE) {
                    tableColumn.setPreferredWidth(n11);
                } else {
                    tableColumn.setPreferredWidth(AttributeController.this.DEFAULT_ATTRIBUTE_SIZE);
                }
                tableColumn = AttributeController.this._attributeTable.getColumn(AttributeController.this._attributeTableData.COLUMN_NAMES[1]);
                if (n12 > AttributeController.this.DEFAULT_VALUE_SIZE) {
                    tableColumn.setPreferredWidth(n12);
                } else {
                    tableColumn.setPreferredWidth(AttributeController.this.DEFAULT_VALUE_SIZE);
                }
                AttributeController.this._attributeTableData.fireTableDataChanged();
                AttributeController.this._attributeTable.getTableHeader().resizeAndRepaint();
            }
        });
    }

    private int getComponentWidth(String string, int n, int n2) {
        TableCellRenderer tableCellRenderer = this._attributeTable.getCellRenderer(n, n2);
        Component component = tableCellRenderer.getTableCellRendererComponent(this._attributeTable, string, false, false, n, n2);
        return (int)component.getPreferredSize().getWidth();
    }
}

