/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv;

import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.DatabaseConfig;
import com.netscape.admin.dirserv.IContentPageInfo;
import com.netscape.admin.dirserv.MenuItemRadioButton;
import com.netscape.admin.dirserv.task.CreateVLVIndex;
import com.netscape.management.client.Framework;
import com.netscape.management.client.IFramework;
import com.netscape.management.client.IMenuItem;
import com.netscape.management.client.IMenuItemCategory;
import com.netscape.management.client.MenuItemCategory;
import com.netscape.management.client.MenuItemCheckBox;
import com.netscape.management.client.MenuItemSeparator;
import com.netscape.management.client.MenuItemText;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.ResourceSet;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;

public class ContentMenuController {
    JPopupMenu _contextMenu;
    IContentPageInfo _contentPage;
    DatabaseConfig _databaseConfig;
    ActionListener _listener;
    IFramework _framework;
    Vector _shortcutRegisterers;
    Hashtable _shortCutTable;
    private String[] _categoryID = null;
    IMenuItem[] _viewMenuItems;
    IMenuItem[] _displayMenuItems;
    IMenuItem[] _partitionViewMenuItems;
    IMenuItem[] _objectNewRootEntryMenuItems;
    IMenuItem[] _contextNewRootEntryMenuItems;
    IMenuItem[] _objectTopMenuItems = new IMenuItem[]{new MenuItemCategory("OBJECT", Framework.i18n((String)"menu", (String)"Object"))};
    IMenuItem[] _fileMenuItems;
    IMenuItem[] _contextMenuItems;
    IMenuItem[] _contextNewMenuItems;
    IMenuItem[] _objectNewMenuItems;
    IMenuItem[] _editMenuItems;
    IMenuItem[] _objectMenuItems;
    IMenuItem[] _layoutMenuItems;
    static ResourceSet _resource = DSUtil._resource;
    static final String MENU_CONTEXT = "CONTEXT";
    static final String MENU_OBJECT = "OBJECT";
    static final String OPEN = "open";
    static final String ADVANCED_OPEN = "advanced open";
    static final String ACL = "acl";
    static final String ROLES = "roles";
    static final String SET_REFERRALS = "referral";
    static final String AUTHENTICATE = "authenticate";
    static final String CUT = "cut";
    static final String COPY = "copy";
    static final String PASTE = "paste";
    static final String UNDO = "undo";
    static final String DELETE = "delete";
    static final String NEW_USER = "newuser";
    static final String NEW_GROUP = "newgroup";
    static final String NEW_ORGANIZATIONALUNIT = "newou";
    static final String NEW_ROLE = "newrole";
    static final String NEW_COS = "newcos";
    static final String NEW_OBJECT = "newobject";
    static final String SEARCH_UG = "search";
    static final String CREATE_VLV_INDEX = "createVLVIndex";
    static final String DELETE_VLV_INDEX = "deleteVLVIndex";
    static final String CONTEXTNEW = "CONTEXTNEW";
    static final String CONTEXTNEWROOTENTRY = "CONTEXTNEWROOTENTRY";
    static final String OBJECTNEW = "OBJECTNEW";
    static final String OBJECTNEWROOTENTRY = "OBJECTNEWROOTENTRY";
    static final String REFRESHTREE = "REFRESHTREE";
    static final String FOLLOW_REFERRALS = "FOLLOW_REFERRALS";
    static final String COPYDN = "copydn";
    static final String COPYLDAPURL = "copyldapurl";
    static final String PARTITIONVIEW = "PARTITIONVIEW";
    static final String SORT = "SORT";
    static final String DISPLAY = "DISPLAY";
    static final String DISPLAY_ACI_COUNT = "DISPLAY_ACI_COUNT";
    static final String DISPLAY_ROLE_COUNT = "DISPLAY_ROLE_COUNT";
    static final String DISPLAY_ACCOUNT_INACTIVATION = "DISPLAY_ACCOUNT_INACTIVATION";
    static final String LAYOUT = "LAYOUT";
    static final String ACTIVATE = "activate";
    static final String INACTIVATE = "inactivate";
    static final String VIEW_ALL_PARTITIONS = "ALL_PARTITIONS";
    static final String ONLY_TREE_LAYOUT = "ONLY_TREE_LAYOUT";
    static final String NODE_LEAF_LAYOUT = "NODE_LEAF_LAYOUT";
    static final String ATTRIBUTE_LAYOUT = "ATTRIBUTE_LAYOUT";

    public ContentMenuController(IContentPageInfo iContentPageInfo, JPopupMenu jPopupMenu, IFramework iFramework, DatabaseConfig databaseConfig, ActionListener actionListener) {
        this._contentPage = iContentPageInfo;
        this._contextMenu = jPopupMenu;
        this._framework = iFramework;
        this._shortcutRegisterers = new Vector(2);
        this._databaseConfig = databaseConfig;
        this._listener = actionListener;
        this.createShortCutKeys();
    }

    public void addShortCutRegisterer(JComponent jComponent) {
        this._shortcutRegisterers.addElement(jComponent);
    }

    public void recreateNewRootEntryMenus() {
        this.unpopulateMenuCategory(CONTEXTNEWROOTENTRY);
        this.unpopulateMenuCategory(OBJECTNEWROOTENTRY);
        this._objectNewRootEntryMenuItems = null;
        this._contextNewRootEntryMenuItems = null;
        this.populateMenuCategory(CONTEXTNEWROOTENTRY);
        this.populateMenuCategory(OBJECTNEWROOTENTRY);
        this.updateMenuState();
    }

    public void recreateDynamicMenus() {
        this.unpopulateMenuCategory(CONTEXTNEWROOTENTRY);
        this.unpopulateMenuCategory(OBJECTNEWROOTENTRY);
        this.unpopulateMenuCategory(PARTITIONVIEW);
        this._objectNewRootEntryMenuItems = null;
        this._contextNewRootEntryMenuItems = null;
        this._partitionViewMenuItems = null;
        this.populateMenuCategory(CONTEXTNEWROOTENTRY);
        this.populateMenuCategory(OBJECTNEWROOTENTRY);
        this.populateMenuCategory(PARTITIONVIEW);
        this.updateMenuState();
    }

    public void updateMenuState() {
        boolean bl = this._contentPage.isRootSelected();
        boolean bl2 = this._contentPage.isSelectedNodeRemote();
        boolean bl3 = this._contentPage.isClipboardEmpty();
        Integer n = new Integer(10);
        Integer n2 = new Integer(CreateVLVIndex.CAN_NOT_HAVE_INDEX);
        if (!bl2) {
            n = this._contentPage.getSelectionActivationState();
            n2 = this._contentPage.getSelectionVlvState();
        }
        this.updateNewMenuItems(bl);
        this.updateAciMenuItems(bl);
        this.updateRoleMenuItems(bl);
        this.updateReferralMenuItems(bl);
        this.updateCutCopyPasteMenuItems(bl, bl3);
        this.updateSearchMenuItems(bl);
        this.updateActivateInactivateMenuItems(n, bl2);
        this.updateVLVMenuItems(n2, bl2);
        this.setEnabledMenuItem(this._contextMenuItems, OPEN, true);
        this.setEnabledMenuItem(this._objectMenuItems, OPEN, true);
        this.setEnabledMenuItem(this._contextMenuItems, ADVANCED_OPEN, true);
        this.setEnabledMenuItem(this._objectMenuItems, ADVANCED_OPEN, true);
        this.updateFollowReferralsMenuItem();
    }

    public void populateMenuItems() {
        String[] stringArray = this.getMenuCategoryIDs();
        int n = 0;
        while (n < stringArray.length) {
            this.populateMenuCategory(stringArray[n]);
            ++n;
        }
    }

    public void unpopulateMenuItems() {
        String[] stringArray = this.getMenuCategoryIDs();
        int n = stringArray.length - 1;
        while (n >= 0) {
            this.unpopulateMenuCategory(stringArray[n]);
            --n;
        }
    }

    public void disableMenus() {
        this.setEnabledMenuItem(this._contextMenuItems, false);
        this.setEnabledMenuItem(this._objectMenuItems, false);
        this.setEnabledMenuItem(this._editMenuItems, false);
        this.setEnabledMenuItem(this._contextMenuItems, REFRESHTREE, true);
    }

    private void createFileMenuItems() {
        this._fileMenuItems = new IMenuItem[]{new MenuItemText(AUTHENTICATE, _resource.getString("menu", AUTHENTICATE), _resource.getString("menu", "authenticate-description"), this._listener), new MenuItemSeparator()};
        this.addShortCuts(this._fileMenuItems);
        this.setActionCommand(this._fileMenuItems);
    }

    private void createContextMenuItems() {
        this._contextMenuItems = new IMenuItem[]{new MenuItemText(OPEN, _resource.getString("menu", "properties"), _resource.getString("menu", "properties-description"), this._listener), new MenuItemText(ADVANCED_OPEN, _resource.getString("menu", "advanced-properties"), _resource.getString("menu", "advanced-properties-description"), this._listener), new MenuItemText(SEARCH_UG, _resource.getString("menu", "EditFindUG"), _resource.getString("menu", "EditFindUG-description"), this._listener), new MenuItemSeparator(), new MenuItemCategory(CONTEXTNEW, _resource.getString("menu", "EditNew")), new MenuItemCategory(CONTEXTNEWROOTENTRY, _resource.getString("menu", "EditNewRootEntry")), new MenuItemSeparator(), new MenuItemText(ACL, _resource.getString("menu", "editacls"), _resource.getString("menu", "editacls-description"), this._listener), new MenuItemText(ROLES, _resource.getString("menu", "editroles"), _resource.getString("menu", "editroles-description"), this._listener), new MenuItemText(SET_REFERRALS, _resource.getString("menu", "editreferrals"), _resource.getString("menu", "editreferrals-description"), this._listener), new MenuItemSeparator(), new MenuItemText(CREATE_VLV_INDEX, _resource.getString("menu", "createIndex"), _resource.getString("menu", "createIndex-description"), this._listener), new MenuItemText(DELETE_VLV_INDEX, _resource.getString("menu", "deleteIndex"), _resource.getString("menu", "deleteIndex-description"), this._listener), new MenuItemSeparator(), new MenuItemText(ACTIVATE, _resource.getString("menu", ACTIVATE), _resource.getString("menu", "activate-description"), this._listener), new MenuItemText(INACTIVATE, _resource.getString("menu", INACTIVATE), _resource.getString("menu", "inactivate-description"), this._listener), new MenuItemSeparator(), new MenuItemText(CUT, _resource.getString("menu", "EditCut"), _resource.getString("menu", "EditCut-description"), this._listener), new MenuItemText(COPY, _resource.getString("menu", "EditCopy"), _resource.getString("menu", "EditCopy-description"), this._listener), new MenuItemText(PASTE, _resource.getString("menu", "EditPaste"), _resource.getString("menu", "EditPaste-description"), this._listener), new MenuItemText(DELETE, _resource.getString("menu", "EditDelete"), _resource.getString("menu", "EditDelete-description"), this._listener), new MenuItemSeparator(), new MenuItemText(REFRESHTREE, _resource.getString("menu", "refresh"), _resource.getString("menu", "refresh-description"), this._listener)};
        this.addShortCuts(this._contextMenuItems);
        this.setActionCommand(this._contextMenuItems);
    }

    private void createContextNewMenuItems() {
        this._contextNewMenuItems = new IMenuItem[]{new MenuItemText(NEW_USER, _resource.getString("menu", "EditNewUser"), _resource.getString("menu", "EditNewUser-description"), this._listener), new MenuItemText(NEW_GROUP, _resource.getString("menu", "EditNewGroup"), _resource.getString("menu", "EditNewGroup-description"), this._listener), new MenuItemText(NEW_ORGANIZATIONALUNIT, _resource.getString("menu", "EditNewOu"), _resource.getString("menu", "EditNewOu-description"), this._listener), new MenuItemSeparator(), new MenuItemText(NEW_ROLE, _resource.getString("menu", "EditNewRole"), _resource.getString("menu", "EditNewRole-description"), this._listener), new MenuItemText(NEW_COS, _resource.getString("menu", "EditNewCos"), _resource.getString("menu", "EditNewCos-description"), this._listener), new MenuItemSeparator(), new MenuItemText(NEW_OBJECT, _resource.getString("menu", "EditNewObject"), _resource.getString("menu", "EditNewObject-description"), this._listener)};
        this.addShortCuts(this._contextNewMenuItems);
        this.setActionCommand(this._contextNewMenuItems);
    }

    private void createObjectNewMenuItems() {
        this._objectNewMenuItems = new IMenuItem[]{new MenuItemText(NEW_USER, _resource.getString("menu", "EditNewUser"), _resource.getString("menu", "EditNewUser-description"), this._listener), new MenuItemText(NEW_GROUP, _resource.getString("menu", "EditNewGroup"), _resource.getString("menu", "EditNewGroup-description"), this._listener), new MenuItemText(NEW_ORGANIZATIONALUNIT, _resource.getString("menu", "EditNewOu"), _resource.getString("menu", "EditNewOu-description"), this._listener), new MenuItemSeparator(), new MenuItemText(NEW_ROLE, _resource.getString("menu", "EditNewRole"), _resource.getString("menu", "EditNewRole-description"), this._listener), new MenuItemText(NEW_COS, _resource.getString("menu", "EditNewCos"), _resource.getString("menu", "EditNewCos-description"), this._listener), new MenuItemSeparator(), new MenuItemText(NEW_OBJECT, _resource.getString("menu", "EditNewObject"), _resource.getString("menu", "EditNewObject-description"), this._listener)};
        this.addShortCuts(this._objectNewMenuItems);
        this.setActionCommand(this._objectNewMenuItems);
    }

    private void createObjectMenuItems() {
        this._objectMenuItems = new IMenuItem[]{new MenuItemText(OPEN, _resource.getString("menu", "properties"), _resource.getString("menu", "properties-description"), this._listener), new MenuItemText(ADVANCED_OPEN, _resource.getString("menu", "advanced-properties"), _resource.getString("menu", "advanced-properties-description"), this._listener), new MenuItemText(SEARCH_UG, _resource.getString("menu", "EditFindUG"), _resource.getString("menu", "EditFindUG-description"), this._listener), new MenuItemSeparator(), new MenuItemCategory(OBJECTNEW, _resource.getString("menu", "EditNew")), new MenuItemCategory(OBJECTNEWROOTENTRY, _resource.getString("menu", "EditNewRootEntry")), new MenuItemSeparator(), new MenuItemText(ACL, _resource.getString("menu", "editacls"), _resource.getString("menu", "editacls-description"), this._listener), new MenuItemText(ROLES, _resource.getString("menu", "editroles"), _resource.getString("menu", "editroles-description"), this._listener), new MenuItemText(SET_REFERRALS, _resource.getString("menu", "editreferrals"), _resource.getString("menu", "editreferrals-description"), this._listener), new MenuItemSeparator(), new MenuItemText(CREATE_VLV_INDEX, _resource.getString("menu", "createIndex"), _resource.getString("menu", "createIndex-description"), this._listener), new MenuItemText(DELETE_VLV_INDEX, _resource.getString("menu", "deleteIndex"), _resource.getString("menu", "deleteIndex-description"), this._listener), new MenuItemSeparator(), new MenuItemText(ACTIVATE, _resource.getString("menu", ACTIVATE), _resource.getString("menu", "activate-description"), this._listener), new MenuItemText(INACTIVATE, _resource.getString("menu", INACTIVATE), _resource.getString("menu", "inactivate-description"), this._listener)};
        this.addShortCuts(this._objectMenuItems);
        this.setActionCommand(this._objectMenuItems);
    }

    private void createEditMenuItems() {
        this._editMenuItems = new IMenuItem[]{new MenuItemSeparator(), new MenuItemText(CUT, _resource.getString("menu", "EditCut"), _resource.getString("menu", "EditCut-description"), this._listener), new MenuItemText(COPY, _resource.getString("menu", "EditCopy"), _resource.getString("menu", "EditCopy-description"), this._listener), new MenuItemText(PASTE, _resource.getString("menu", "EditPaste"), _resource.getString("menu", "EditPaste-description"), this._listener), new MenuItemText(DELETE, _resource.getString("menu", "EditDelete"), _resource.getString("menu", "EditDelete-description"), this._listener), new MenuItemSeparator(), new MenuItemText(COPYDN, _resource.getString("menu", "EditCopyDN"), _resource.getString("menu", "EditCopyDN-description"), this._listener), new MenuItemText(COPYLDAPURL, _resource.getString("menu", "EditCopyLDAPURL"), _resource.getString("menu", "EditCopyLDAPURL-description"), this._listener)};
        this.addShortCuts(this._editMenuItems);
        this.setActionCommand(this._editMenuItems);
    }

    private void createNewRootEntryMenuItems() {
        Debug.println((String)"ContentMenuController.createNewRootEntryMenuItems()");
        Vector vector = this._databaseConfig.getRootSuffixesWithoutEntry();
        Debug.println((String)("ContentMenuController.createNewRootEntryMenuItems() the list is " + vector));
        if (vector != null) {
            int n = vector.size();
            this._objectNewRootEntryMenuItems = new IMenuItem[n];
            this._contextNewRootEntryMenuItems = new IMenuItem[n];
            int n2 = 0;
            while (n2 < this._objectNewRootEntryMenuItems.length) {
                String string = (String)vector.elementAt(n2);
                this._objectNewRootEntryMenuItems[n2] = new MenuItemText(string, string, _resource.getString("menu", "EditNewRoot-description", string), this._listener);
                this._contextNewRootEntryMenuItems[n2] = new MenuItemText(string, string, _resource.getString("menu", "EditNewRoot-description", string), this._listener);
                ++n2;
            }
            this.addShortCuts(this._contextNewRootEntryMenuItems);
            this.setActionCommand(this._contextNewRootEntryMenuItems);
            this.addShortCuts(this._objectNewRootEntryMenuItems);
            this.setActionCommand(this._objectNewRootEntryMenuItems);
        }
    }

    private void createLayoutMenuItems() {
        this._layoutMenuItems = new IMenuItem[]{new MenuItemRadioButton(NODE_LEAF_LAYOUT, _resource.getString("menu", "nodeleaflayout"), _resource.getString("menu", "nodeleafview-description"), this._contentPage.getPanelLayout().equals(NODE_LEAF_LAYOUT), this._listener), new MenuItemRadioButton(ONLY_TREE_LAYOUT, _resource.getString("menu", "onlytreelayout"), _resource.getString("menu", "onlytreeview-description"), this._contentPage.getPanelLayout().equals(ONLY_TREE_LAYOUT), this._listener), new MenuItemRadioButton(ATTRIBUTE_LAYOUT, _resource.getString("menu", "attributelayout"), _resource.getString("menu", "attributeview-description"), this._contentPage.getPanelLayout().equals(ATTRIBUTE_LAYOUT), this._listener)};
        this.addShortCuts(this._layoutMenuItems);
        this.setActionCommand(this._layoutMenuItems);
        ButtonGroup buttonGroup = new ButtonGroup();
        int n = 0;
        while (n < this._layoutMenuItems.length) {
            if (this._layoutMenuItems[n] instanceof MenuItemRadioButton) {
                buttonGroup.add((MenuItemRadioButton)this._layoutMenuItems[n]);
            }
            ++n;
        }
    }

    private void createDisplayMenuItems() {
        this._displayMenuItems = new IMenuItem[]{new MenuItemCheckBox(DISPLAY_ACI_COUNT, _resource.getString("menu", "acicount"), _resource.getString("menu", "acicount-description"), this._listener, (this._contentPage.getDisplay() & 1) != 0), new MenuItemCheckBox(DISPLAY_ROLE_COUNT, _resource.getString("menu", "rolecount"), _resource.getString("menu", "rolecount-description"), this._listener, (this._contentPage.getDisplay() & 2) != 0), new MenuItemCheckBox(DISPLAY_ACCOUNT_INACTIVATION, _resource.getString("menu", "viewaccountinactivation"), _resource.getString("menu", "viewaccountinactivation-description"), this._listener, (this._contentPage.getDisplay() & 4) != 0)};
        this.addShortCuts(this._displayMenuItems);
        this.setActionCommand(this._displayMenuItems);
    }

    private void createPartitionViewMenuItems() {
        Debug.println((String)"ContentMenuController.createPartitionViewMenuItems()");
        Vector vector = this._databaseConfig.getDatabaseList(0);
        IMenuItem[] iMenuItemArray = null;
        iMenuItemArray = vector != null && vector.size() > 0 ? new IMenuItem[vector.size() + 2] : new IMenuItem[1];
        boolean bl = true;
        ButtonGroup buttonGroup = new ButtonGroup();
        String string = _resource.getString("menu", "PartitionView-all");
        bl = this._contentPage.getSelectedPartitionView().equals(VIEW_ALL_PARTITIONS);
        iMenuItemArray[0] = new MenuItemRadioButton(VIEW_ALL_PARTITIONS, string, _resource.getString("menu", "PartitionView-all-description", string), bl, this._listener);
        buttonGroup.add((MenuItemRadioButton)iMenuItemArray[0]);
        if (iMenuItemArray.length > 1) {
            iMenuItemArray[1] = new MenuItemSeparator();
        }
        int n = 2;
        while (n < iMenuItemArray.length) {
            string = (String)vector.elementAt(n - 2);
            bl = this._contentPage.getSelectedPartitionView().equals(string);
            iMenuItemArray[n] = new MenuItemRadioButton(string, string, _resource.getString("menu", "PartitionView-description", string), bl, this._listener);
            buttonGroup.add((MenuItemRadioButton)iMenuItemArray[n]);
            ++n;
        }
        this._partitionViewMenuItems = iMenuItemArray;
        this.addShortCuts(this._partitionViewMenuItems);
        this.setActionCommand(this._partitionViewMenuItems);
    }

    private void createViewMenuItems() {
        IMenuItem[] iMenuItemArray = new IMenuItem[]{new MenuItemSeparator(), new MenuItemCheckBox(FOLLOW_REFERRALS, _resource.getString("menu", "referrals"), _resource.getString("menu", "referrals-description"), this._listener, this._contentPage.getFollowReferrals()), new MenuItemCheckBox(SORT, _resource.getString("menu", "sort"), _resource.getString("menu", "sort-description"), this._listener, this._contentPage.isSorted()), new MenuItemSeparator(), new MenuItemCategory(DISPLAY, _resource.getString("menu", "display")), new MenuItemCategory(LAYOUT, _resource.getString("menu", "layout")), new MenuItemCategory(PARTITIONVIEW, _resource.getString("menu", "PartitionView")), new MenuItemSeparator(), new MenuItemText(REFRESHTREE, _resource.getString("menu", "refresh"), _resource.getString("menu", "refresh-description"), this._listener)};
        this._viewMenuItems = iMenuItemArray;
        this.addShortCuts(this._viewMenuItems);
        this.setActionCommand(this._viewMenuItems);
    }

    protected void addShortCuts(IMenuItem[] iMenuItemArray) {
        int n = 0;
        while (n < iMenuItemArray.length) {
            KeyStroke keyStroke;
            MenuItemText menuItemText;
            String string;
            if (iMenuItemArray[n] instanceof MenuItemText && (string = (menuItemText = (MenuItemText)iMenuItemArray[n]).getID()) != null && (keyStroke = (KeyStroke)this._shortCutTable.get(string)) != null) {
                menuItemText.setAccelerator(keyStroke);
                Enumeration enumeration = this._shortcutRegisterers.elements();
                while (enumeration.hasMoreElements()) {
                    JComponent jComponent = (JComponent)enumeration.nextElement();
                    jComponent.registerKeyboardAction(this._listener, menuItemText.getID(), menuItemText.getAccelerator(), 1);
                }
            }
            ++n;
        }
    }

    protected void setActionCommand(IMenuItem[] iMenuItemArray) {
        int n = 0;
        while (n < iMenuItemArray.length) {
            if (iMenuItemArray[n] instanceof MenuItemText) {
                ((MenuItemText)iMenuItemArray[n]).setActionCommand(iMenuItemArray[n].getID());
            } else if (iMenuItemArray[n] instanceof MenuItemCheckBox) {
                ((MenuItemCheckBox)iMenuItemArray[n]).setActionCommand(iMenuItemArray[n].getID());
            }
            ++n;
        }
    }

    private void populateMenuCategory(String string) {
        IMenuItem[] iMenuItemArray = this.getMenuItems(string);
        if (iMenuItemArray != null) {
            if (string.equals(MENU_CONTEXT)) {
                Debug.println((String)("ContentMenuController.populateMenuCategory() adding " + string + " to context menu"));
                int n = 0;
                while (n < iMenuItemArray.length) {
                    this._contextMenu.add(iMenuItemArray[n].getComponent());
                    ++n;
                }
            } else {
                JMenu jMenu = this.getMenu(this._contextMenu, string);
                if (jMenu != null) {
                    Debug.println((String)("ContentMenuController.populateMenuCategory() adding " + string + " to some menu"));
                    int n = 0;
                    while (n < iMenuItemArray.length) {
                        jMenu.add(iMenuItemArray[n].getComponent());
                        ++n;
                    }
                } else if (this._framework != null) {
                    Debug.println((String)("ContentMenuController.populateMenuCategory() adding " + string + " to Framework"));
                    int n = 0;
                    while (n < iMenuItemArray.length) {
                        this._framework.addMenuItem(string, iMenuItemArray[n]);
                        ++n;
                    }
                }
            }
        } else {
            Debug.println((String)("ContentMenuController.populateMenuCategory() " + string + " has no menu items"));
        }
    }

    private void unpopulateMenuCategory(String string) {
        IMenuItem[] iMenuItemArray = this.getMenuItems(string);
        if (iMenuItemArray != null) {
            if (string.equals(MENU_CONTEXT)) {
                Debug.println((String)("ContentMenuController.unpopulateMenuCategory() removing " + string + " from context"));
                int n = 0;
                while (n < iMenuItemArray.length) {
                    this._contextMenu.remove(iMenuItemArray[n].getComponent());
                    ++n;
                }
            } else {
                JMenu jMenu = this.getMenu(this._contextMenu, string);
                if (jMenu != null) {
                    Debug.println((String)("ContentMenuController.unpopulateMenuCategory() removing " + string + " from menu"));
                    int n = 0;
                    while (n < iMenuItemArray.length) {
                        this.removeMenuItem(jMenu, iMenuItemArray[n]);
                        ++n;
                    }
                } else if (this._framework != null) {
                    Debug.println((String)("ContentMenuController.unpopulateMenuCategory() removing " + string + " from framework"));
                    int n = 0;
                    while (n < iMenuItemArray.length) {
                        this._framework.removeMenuItem(iMenuItemArray[n]);
                        ++n;
                    }
                }
            }
        } else {
            Debug.println((String)("ContentMenuController.unpopulateMenuCategory() " + string + " has no menu items"));
        }
    }

    private JMenu getMenu(JPopupMenu jPopupMenu, String string) {
        JMenu jMenu = null;
        int n = 0;
        while (n < jPopupMenu.getComponentCount()) {
            JMenu jMenu2;
            Component component = jPopupMenu.getComponentAtIndex(n);
            if (component instanceof IMenuItemCategory && string.equals(((IMenuItemCategory)component).getID())) {
                jMenu = (JMenu)((IMenuItemCategory)component).getComponent();
                break;
            }
            if (component instanceof JMenu && (jMenu2 = this.getMenu((JMenu)component, string)) != null) {
                jMenu = jMenu2;
                break;
            }
            ++n;
        }
        return jMenu;
    }

    private JMenu getMenu(JMenu jMenu, String string) {
        JMenu jMenu2 = null;
        int n = 0;
        while (n < jMenu.getMenuComponentCount()) {
            JMenu jMenu3;
            Component component = jMenu.getMenuComponent(n);
            if (component instanceof IMenuItemCategory && string.equals(((IMenuItemCategory)component).getID())) {
                jMenu2 = (JMenu)((IMenuItemCategory)component).getComponent();
                break;
            }
            if (component instanceof JMenu && (jMenu3 = this.getMenu((JMenu)component, string)) != null) {
                jMenu2 = jMenu3;
                break;
            }
            ++n;
        }
        return jMenu2;
    }

    private JMenu getMenu(JMenuBar jMenuBar, String string) {
        JMenu jMenu = null;
        int n = 0;
        while (n < jMenuBar.getMenuCount()) {
            JMenu jMenu2;
            JMenu jMenu3 = jMenuBar.getMenu(n);
            if (jMenu3 instanceof IMenuItemCategory && string.equals(((IMenuItemCategory)jMenu3).getID())) {
                jMenu = (JMenu)((IMenuItemCategory)jMenu3).getComponent();
                break;
            }
            if (jMenu3 instanceof JMenu && (jMenu2 = this.getMenu(jMenu3, string)) != null) {
                jMenu = jMenu2;
                break;
            }
            ++n;
        }
        return jMenu;
    }

    private boolean removeMenuItem(JMenu jMenu, IMenuItem iMenuItem) {
        boolean bl = false;
        int n = 0;
        while (n < jMenu.getMenuComponentCount()) {
            Component component = jMenu.getMenuComponent(n);
            if (component instanceof IMenuItem && component == iMenuItem) {
                jMenu.remove(n);
                bl = true;
                break;
            }
            if (component instanceof JMenu && this.removeMenuItem((JMenu)component, iMenuItem)) {
                bl = true;
                break;
            }
            ++n;
        }
        return bl;
    }

    private String[] getMenuCategoryIDs() {
        if (this._categoryID == null) {
            this._categoryID = new String[]{"<top>", "FILE", "EDIT", "VIEW", MENU_CONTEXT, MENU_OBJECT, CONTEXTNEW, CONTEXTNEWROOTENTRY, OBJECTNEW, OBJECTNEWROOTENTRY, DISPLAY, LAYOUT, PARTITIONVIEW};
        }
        return this._categoryID;
    }

    private IMenuItem[] getMenuItems(String string) {
        if (string.equals("<top>")) {
            return this._objectTopMenuItems;
        }
        if (string.equals("FILE")) {
            if (this._fileMenuItems == null) {
                this.createFileMenuItems();
            }
            return this._fileMenuItems;
        }
        if (string.equals(MENU_CONTEXT)) {
            if (this._contextMenuItems == null) {
                this.createContextMenuItems();
            }
            return this._contextMenuItems;
        }
        if (string.equals(CONTEXTNEW)) {
            if (this._contextNewMenuItems == null) {
                this.createContextNewMenuItems();
            }
            return this._contextNewMenuItems;
        }
        if (string.equals(OBJECTNEW)) {
            if (this._objectNewMenuItems == null) {
                this.createObjectNewMenuItems();
            }
            return this._objectNewMenuItems;
        }
        if (string.equals(CONTEXTNEWROOTENTRY)) {
            if (this._contextNewRootEntryMenuItems == null) {
                this.createNewRootEntryMenuItems();
            }
            return this._contextNewRootEntryMenuItems;
        }
        if (string.equals(OBJECTNEWROOTENTRY)) {
            if (this._objectNewRootEntryMenuItems == null) {
                this.createNewRootEntryMenuItems();
            }
            return this._objectNewRootEntryMenuItems;
        }
        if (string.equals("EDIT")) {
            if (this._editMenuItems == null) {
                this.createEditMenuItems();
            }
            return this._editMenuItems;
        }
        if (string.equals("VIEW")) {
            if (this._viewMenuItems == null) {
                this.createViewMenuItems();
            }
            return this._viewMenuItems;
        }
        if (string.equals(MENU_OBJECT)) {
            if (this._objectMenuItems == null) {
                this.createObjectMenuItems();
            }
            return this._objectMenuItems;
        }
        if (string.equals(LAYOUT)) {
            if (this._layoutMenuItems == null) {
                this.createLayoutMenuItems();
            }
            return this._layoutMenuItems;
        }
        if (string.equals(DISPLAY)) {
            if (this._displayMenuItems == null) {
                this.createDisplayMenuItems();
            }
            return this._displayMenuItems;
        }
        if (string.equals(PARTITIONVIEW)) {
            if (this._partitionViewMenuItems == null) {
                this.createPartitionViewMenuItems();
            }
            return this._partitionViewMenuItems;
        }
        return null;
    }

    private void setEnabledMenuItem(IMenuItem[] iMenuItemArray, String string, boolean bl) {
        boolean bl2 = false;
        int n = 0;
        while (n < iMenuItemArray.length && !bl2) {
            if (iMenuItemArray[n].getID().equals(string)) {
                bl2 = true;
                if (iMenuItemArray[n] instanceof JMenuItem) {
                    ((JMenuItem)iMenuItemArray[n]).setEnabled(bl);
                }
            }
            ++n;
        }
    }

    private void setEnabledMenuItem(IMenuItem[] iMenuItemArray, boolean bl) {
        int n = 0;
        while (n < iMenuItemArray.length) {
            if (iMenuItemArray[n] instanceof JMenuItem) {
                ((JMenuItem)iMenuItemArray[n]).setEnabled(bl);
            }
            ++n;
        }
    }

    private void setCheckedMenuItem(IMenuItem[] iMenuItemArray, String string, boolean bl) {
        boolean bl2 = false;
        int n = 0;
        while (n < iMenuItemArray.length && !bl2) {
            Debug.println((String)("ContentMenuController.setCheckedMenuItem() ID " + iMenuItemArray[n].getID()));
            if (iMenuItemArray[n].getID().equals(string)) {
                bl2 = true;
                if (iMenuItemArray[n] instanceof MenuItemCheckBox) {
                    ((MenuItemCheckBox)iMenuItemArray[n]).setChecked(bl);
                }
            }
            ++n;
        }
    }

    private void updateSearchMenuItems(boolean bl) {
        this.setEnabledMenuItem(this._objectMenuItems, SEARCH_UG, !bl);
        this.setEnabledMenuItem(this._contextMenuItems, SEARCH_UG, !bl);
    }

    private void updateAciMenuItems(boolean bl) {
        this.setEnabledMenuItem(this._objectMenuItems, ACL, !bl);
        this.setEnabledMenuItem(this._contextMenuItems, ACL, !bl);
    }

    private void updateRoleMenuItems(boolean bl) {
        this.setEnabledMenuItem(this._objectMenuItems, ROLES, !bl);
        this.setEnabledMenuItem(this._contextMenuItems, ROLES, !bl);
    }

    private void updateReferralMenuItems(boolean bl) {
        this.setEnabledMenuItem(this._objectMenuItems, SET_REFERRALS, !bl);
        this.setEnabledMenuItem(this._contextMenuItems, SET_REFERRALS, !bl);
    }

    private void updateCutCopyPasteMenuItems(boolean bl, boolean bl2) {
        this.setEnabledMenuItem(this._editMenuItems, COPY, !bl);
        this.setEnabledMenuItem(this._contextMenuItems, COPY, !bl);
        this.setEnabledMenuItem(this._editMenuItems, CUT, !bl);
        this.setEnabledMenuItem(this._contextMenuItems, CUT, !bl);
        this.setEnabledMenuItem(this._editMenuItems, DELETE, !bl);
        this.setEnabledMenuItem(this._contextMenuItems, DELETE, !bl);
        this.setEnabledMenuItem(this._editMenuItems, COPYDN, !bl);
        this.setEnabledMenuItem(this._editMenuItems, COPYLDAPURL, !bl);
        this.setEnabledMenuItem(this._editMenuItems, PASTE, !bl && !bl2);
        this.setEnabledMenuItem(this._contextMenuItems, PASTE, !bl && !bl2);
    }

    private void updateNewMenuItems(boolean bl) {
        boolean bl2 = false;
        if (this._contextNewRootEntryMenuItems != null) {
            bl2 = this._contextNewRootEntryMenuItems.length > 0;
        }
        this.setEnabledMenuItem(this._objectMenuItems, OBJECTNEWROOTENTRY, bl && bl2);
        this.setEnabledMenuItem(this._contextMenuItems, CONTEXTNEWROOTENTRY, bl && bl2);
        this.setEnabledMenuItem(this._objectMenuItems, OBJECTNEW, !bl);
        this.setEnabledMenuItem(this._contextMenuItems, CONTEXTNEW, !bl);
    }

    private void updateVLVMenuItems(Integer n, boolean bl) {
        if (bl) {
            this.setEnabledMenuItem(this._objectMenuItems, CREATE_VLV_INDEX, true);
            this.setEnabledMenuItem(this._contextMenuItems, CREATE_VLV_INDEX, true);
            this.setEnabledMenuItem(this._objectMenuItems, DELETE_VLV_INDEX, false);
            this.setEnabledMenuItem(this._contextMenuItems, DELETE_VLV_INDEX, false);
        } else if (n == CreateVLVIndex.NO_INDEX) {
            this.setEnabledMenuItem(this._objectMenuItems, CREATE_VLV_INDEX, true);
            this.setEnabledMenuItem(this._contextMenuItems, CREATE_VLV_INDEX, true);
            this.setEnabledMenuItem(this._objectMenuItems, DELETE_VLV_INDEX, false);
            this.setEnabledMenuItem(this._contextMenuItems, DELETE_VLV_INDEX, false);
        } else if (n == CreateVLVIndex.HAS_INDEX) {
            this.setEnabledMenuItem(this._objectMenuItems, CREATE_VLV_INDEX, false);
            this.setEnabledMenuItem(this._contextMenuItems, CREATE_VLV_INDEX, false);
            this.setEnabledMenuItem(this._objectMenuItems, DELETE_VLV_INDEX, true);
            this.setEnabledMenuItem(this._contextMenuItems, DELETE_VLV_INDEX, true);
        } else {
            this.setEnabledMenuItem(this._objectMenuItems, CREATE_VLV_INDEX, false);
            this.setEnabledMenuItem(this._contextMenuItems, CREATE_VLV_INDEX, false);
            this.setEnabledMenuItem(this._objectMenuItems, DELETE_VLV_INDEX, false);
            this.setEnabledMenuItem(this._contextMenuItems, DELETE_VLV_INDEX, false);
        }
    }

    private void updateActivateInactivateMenuItems(Integer n, boolean bl) {
        if (bl) {
            this.setEnabledMenuItem(this._objectMenuItems, ACTIVATE, false);
            this.setEnabledMenuItem(this._contextMenuItems, ACTIVATE, false);
            this.setEnabledMenuItem(this._objectMenuItems, INACTIVATE, true);
            this.setEnabledMenuItem(this._contextMenuItems, INACTIVATE, true);
        } else if (n == 10) {
            this.setEnabledMenuItem(this._objectMenuItems, ACTIVATE, false);
            this.setEnabledMenuItem(this._contextMenuItems, ACTIVATE, false);
            this.setEnabledMenuItem(this._objectMenuItems, INACTIVATE, false);
            this.setEnabledMenuItem(this._contextMenuItems, INACTIVATE, false);
        } else if (n == 9) {
            this.setEnabledMenuItem(this._objectMenuItems, ACTIVATE, false);
            this.setEnabledMenuItem(this._contextMenuItems, ACTIVATE, false);
            this.setEnabledMenuItem(this._objectMenuItems, INACTIVATE, true);
            this.setEnabledMenuItem(this._contextMenuItems, INACTIVATE, true);
        } else {
            this.setEnabledMenuItem(this._objectMenuItems, ACTIVATE, true);
            this.setEnabledMenuItem(this._contextMenuItems, ACTIVATE, true);
            this.setEnabledMenuItem(this._objectMenuItems, INACTIVATE, false);
            this.setEnabledMenuItem(this._contextMenuItems, INACTIVATE, false);
        }
    }

    private void createShortCutKeys() {
        this._shortCutTable = new Hashtable();
        this._shortCutTable.put(OPEN, KeyStroke.getKeyStroke(80, 2));
        this._shortCutTable.put(ACL, KeyStroke.getKeyStroke(76, 2));
        this._shortCutTable.put(REFRESHTREE, KeyStroke.getKeyStroke(82, 2));
        this._shortCutTable.put(COPY, KeyStroke.getKeyStroke(67, 2));
        this._shortCutTable.put(CUT, KeyStroke.getKeyStroke(88, 2));
        this._shortCutTable.put(PASTE, KeyStroke.getKeyStroke(86, 2));
        this._shortCutTable.put(DELETE, KeyStroke.getKeyStroke(68, 2));
    }

    public void updateFollowReferralsMenuItem() {
        if (this._contentPage.getSelectedPartitionView().equals(VIEW_ALL_PARTITIONS)) {
            this.setEnabledMenuItem(this._viewMenuItems, FOLLOW_REFERRALS, true);
        } else {
            this.setEnabledMenuItem(this._viewMenuItems, FOLLOW_REFERRALS, false);
            if (this._contentPage.getFollowReferrals()) {
                this.setCheckedMenuItem(this._viewMenuItems, FOLLOW_REFERRALS, false);
            }
        }
    }
}

