/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.attredit;

import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.attredit.BinaryAttributeEditor;
import com.netscape.admin.dirserv.attredit.RequestFileDialog;
import com.netscape.management.client.util.Debug;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;

public class ImageAttributeEditor
extends BinaryAttributeEditor {
    private static final int labelHeight = 23;

    public ImageAttributeEditor() {
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                int n = ImageAttributeEditor.this.getValueCount();
                int n2 = 0;
                while (n2 < n) {
                    ImageAttributeEditor.this.update(n2);
                    ++n2;
                }
            }
        });
    }

    protected RequestFileDialog makeRequestFileDialog(JFrame jFrame) {
        String string = DSUtil._resource.getString("attrEdit", "image-request-label");
        return new RequestFileDialog(null, string);
    }

    protected void update(int n) {
        try {
            JButton jButton = (JButton)this._fields.elementAt(n);
            byte[] byArray = null;
            byArray = (byte[])this.getValue(n);
            if (byArray == null || byArray.length == 0) {
                super.update(n);
                return;
            }
            jButton.setText(null);
            Image image = null;
            try {
                image = Toolkit.getDefaultToolkit().createImage(byArray);
            }
            catch (Exception exception) {
                Debug.println((String)exception.toString());
            }
            if (image == null) {
                Debug.println((String)"ImageAttributeEditor.update: failed to load image");
                jButton.setText("failed");
            } else {
                Image image2;
                int n2;
                Dimension dimension = jButton.getSize();
                dimension.height = Math.max(23, dimension.height);
                Dimension dimension2 = this.getSize();
                int n3 = dimension.width;
                int n4 = n2 = dimension.height;
                ImageIcon imageIcon = new ImageIcon(image);
                int n5 = imageIcon.getIconHeight();
                int n6 = imageIcon.getIconWidth();
                Debug.println((String)("ImageAttributeEditor.update: loaded image " + n6 + "x" + n5 + " pixels"));
                dimension.width = Math.min(dimension.width, n6);
                n2 = dimension.height = dimension.width * n5 / n6;
                if (n6 <= dimension.width) {
                    image2 = image;
                } else {
                    image2 = this.createImage(dimension.width, dimension.height);
                    Graphics graphics = image2.getGraphics();
                    graphics.drawImage(image, 0, 0, dimension.width, dimension.height, 0, 0, n6, n5, null);
                }
                jButton.setIcon(new ImageIcon(image2));
                dimension.width += 6;
                dimension.height += 6;
                jButton.setMinimumSize(dimension);
                jButton.setPreferredSize(dimension);
                Debug.println((String)("ImageAttributeEditor.update: setting minimum field size = " + dimension));
                if (n2 > n4) {
                    dimension2.height += n2 + 6 - n4;
                    Debug.println((String)("ImageAttributeEditor.update: setting minimum size = " + dimension2));
                    this.setMinimumSize(dimension2);
                    this.setPreferredSize(dimension2);
                    this.forceLayout();
                } else {
                    this.invalidate();
                    this.validate();
                }
            }
            jButton.repaint();
        }
        catch (Exception exception) {
            Debug.println((String)("ImageAttributeEditor.update: " + exception));
        }
    }

    private void forceLayout() {
        ImageAttributeEditor imageAttributeEditor = this;
        Container container = imageAttributeEditor.getParent();
        while (container != null) {
            if (container instanceof Frame || container instanceof Dialog) {
                container.invalidate();
                container.validate();
                break;
            }
            container = container.getParent();
        }
    }
}

