/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.cosedit;

import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.cosedit.CosAttributeRec;
import com.netscape.admin.dirserv.panel.UIFactory;
import com.netscape.admin.dirserv.propedit.NewAttributeDialog;
import com.netscape.management.client.components.Table;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.ug.DefaultResEditorPage;
import com.netscape.management.client.ug.ResourceEditor;
import com.netscape.management.client.ug.ResourcePageObservable;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.JButtonFactory;
import com.netscape.management.client.util.ResourceSet;
import com.netscape.management.nmclf.SuiConstants;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;

public class ResEditorCosAttributes
extends DefaultResEditorPage
implements ListSelectionListener,
ActionListener,
SuiConstants,
Observer {
    ResourceEditor _resourceEditor;
    ResourcePageObservable _observable;
    ConsoleInfo _info;
    String _id;
    Vector _attributeVector = new Vector();
    NewAttributeDialog _attributeDialog;
    CosAttributesTableModel _tableModel;
    JTable _table;
    JButton _addButton;
    JButton _removeButton;
    static Vector _qualifierLabels;
    static ResourceSet _resource;
    private static final String _section = "cosAttributesPage";

    public ResEditorCosAttributes() {
        _qualifierLabels = new Vector(3);
        _qualifierLabels.addElement(_resource.getString(_section, "qualifier-default"));
        _qualifierLabels.addElement(_resource.getString(_section, "qualifier-override"));
        _qualifierLabels.addElement(_resource.getString(_section, "qualifier-operational"));
    }

    public void initialize(ResourcePageObservable resourcePageObservable, ResourceEditor resourceEditor) {
        this._id = _resource.getString(_section, "id");
        this._resourceEditor = resourceEditor;
        this._observable = resourcePageObservable;
        this._info = resourcePageObservable.getConsoleInfo();
        if (this._table == null) {
            this._table = new Table();
            this._table.setPreferredScrollableViewportSize(new Dimension(10, 10));
            this._table.getSelectionModel().addListSelectionListener(this);
            this._tableModel = new CosAttributesTableModel();
            this._table.setModel(this._tableModel);
            JComboBox jComboBox = new JComboBox(_qualifierLabels);
            DefaultCellEditor defaultCellEditor = new DefaultCellEditor(jComboBox);
            this._table.getColumnModel().getColumn(1).setCellEditor(defaultCellEditor);
            this._addButton = UIFactory.makeJButton(this, _section, "addButton", _resource);
            this._removeButton = UIFactory.makeJButton(this, _section, "removeButton", _resource);
            JButtonFactory.resizeGroup((JButton)this._addButton, (JButton)this._removeButton);
            Box box = new Box(0);
            box.add(Box.createHorizontalGlue());
            box.add(this._addButton);
            box.add(Box.createHorizontalStrut(12));
            box.add(this._removeButton);
            this.layoutComponents();
        }
        this.loadFromObservable();
        this.valueChanged(null);
    }

    void layoutComponents() {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(9, 9, 0, 9);
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        JLabel jLabel = new JLabel(_resource.getString(_section, "label"));
        jPanel.add(jLabel);
        jLabel.setLabelFor(this._table);
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        JScrollPane jScrollPane = new JScrollPane(this._table);
        jScrollPane.setBorder(UIManager.getBorder("Table.scrollPaneBorder"));
        jPanel.add(jScrollPane);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 9, 0, 9);
        gridBagLayout.setConstraints(jScrollPane, gridBagConstraints);
        Box box = new Box(0);
        box.add(Box.createHorizontalGlue());
        box.add(this._addButton);
        box.add(Box.createHorizontalStrut(12));
        box.add(this._removeButton);
        jPanel.add(box);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(9, 9, 9, 9);
        gridBagLayout.setConstraints(box, gridBagConstraints);
        JScrollPane jScrollPane2 = new JScrollPane(jPanel);
        jScrollPane2.setBorder(null);
        ((Container)((Object)this)).setLayout(new BorderLayout());
        ((Container)((Object)this)).add("Center", jScrollPane2);
    }

    public String getID() {
        return this._id;
    }

    public boolean save(ResourcePageObservable resourcePageObservable) throws Exception {
        Vector<String> vector = new Vector<String>();
        Enumeration enumeration = this._attributeVector.elements();
        while (enumeration.hasMoreElements()) {
            CosAttributeRec cosAttributeRec = (CosAttributeRec)enumeration.nextElement();
            vector.add(cosAttributeRec.toString());
        }
        this._observable.replace("cosAttribute", vector);
        return true;
    }

    public boolean isComplete() {
        return this._attributeVector.size() >= 1;
    }

    public String getDisplayName() {
        return this._id;
    }

    public void help() {
        DSUtil.help("configuration-cos-attributes-help");
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this._addButton) {
            this.actionAdd();
        } else if (actionEvent.getSource() == this._removeButton) {
            this.actionRemove();
        }
    }

    void actionAdd() {
        String[] stringArray;
        this._resourceEditor.setBusyCursor(true);
        if (this._attributeDialog == null) {
            this._attributeDialog = new NewAttributeDialog(this._resourceEditor.getFrame(), this._resourceEditor.getConsoleInfo());
            ((Dialog)((Object)this._attributeDialog)).setTitle(_resource.getString(_section, "add-attribute-title"));
            ((JDialog)((Object)this._attributeDialog)).getAccessibleContext().setAccessibleDescription(_resource.getString(_section, "add-attribute-description"));
        }
        Hashtable<String, String> hashtable = new Hashtable<String, String>(this._attributeVector.size() + 1);
        Enumeration enumeration = this._attributeVector.elements();
        while (enumeration.hasMoreElements()) {
            stringArray = (String[])enumeration.nextElement();
            hashtable.put(stringArray.name, stringArray.name);
        }
        this._attributeDialog.setUsed(hashtable);
        this._attributeDialog.show();
        this._attributeDialog.dispose();
        if (!this._attributeDialog.isCancel() && (stringArray = this._attributeDialog.getSelectedAttributes()) != null) {
            int n = 0;
            while (n < stringArray.length) {
                CosAttributeRec cosAttributeRec = new CosAttributeRec(stringArray[n]);
                this._attributeVector.addElement(cosAttributeRec);
                this._tableModel.fireTableRowInserted();
                ++n;
            }
        }
        this._resourceEditor.setBusyCursor(false);
    }

    void actionRemove() {
        int[] nArray = this._table.getSelectedRows();
        int n = nArray.length - 1;
        while (n >= 0) {
            this._attributeVector.removeElementAt(nArray[n]);
            this._tableModel.fireTableRowDeleted(nArray[n]);
            --n;
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this._removeButton.setEnabled(this._table.getSelectedRowCount() > 0 && this._table.getRowCount() > 0);
    }

    public void update(Observable observable, Object object) {
    }

    void loadFromObservable() {
        this._attributeVector.removeAllElements();
        Vector vector = this._observable.get("cosAttribute");
        if (vector != null) {
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                this._attributeVector.addElement(new CosAttributeRec(string));
            }
        }
    }

    static {
        _resource = DSUtil._resource;
    }

    class CosAttributesTableModel
    extends AbstractTableModel {
        static /* synthetic */ Class class$java$lang$String;

        CosAttributesTableModel() {
        }

        public String getColumnName(int n) {
            if (n == 0) {
                return _resource.getString(ResEditorCosAttributes._section, "header-name");
            }
            return _resource.getString(ResEditorCosAttributes._section, "header-qualifier");
        }

        public int getColumnCount() {
            return 2;
        }

        public int getRowCount() {
            return ResEditorCosAttributes.this._attributeVector.size();
        }

        public Object getValueAt(int n, int n2) {
            String string = null;
            if (n < ResEditorCosAttributes.this._attributeVector.size()) {
                CosAttributeRec cosAttributeRec = (CosAttributeRec)ResEditorCosAttributes.this._attributeVector.elementAt(n);
                switch (n2) {
                    case 0: {
                        string = cosAttributeRec.name;
                        break;
                    }
                    case 1: {
                        string = (String)_qualifierLabels.elementAt(cosAttributeRec.qualifier);
                    }
                }
            } else {
                Debug.println((int)0, (String)("ResEditorCosAttributes.CosAttributesTableModel.getValueAt: ignored row = " + n));
            }
            return string;
        }

        public Class getColumnClass(int n) {
            return class$java$lang$String == null ? (class$java$lang$String = CosAttributesTableModel.class$("java.lang.String")) : class$java$lang$String;
        }

        public boolean isCellEditable(int n, int n2) {
            return n2 == 1;
        }

        public void setValueAt(Object object, int n, int n2) {
            CosAttributeRec cosAttributeRec = (CosAttributeRec)ResEditorCosAttributes.this._attributeVector.elementAt(n);
            if (n2 == 1 && object instanceof String) {
                int n3 = _qualifierLabels.indexOf(object);
                if (n3 != -1) {
                    cosAttributeRec.qualifier = n3;
                } else {
                    cosAttributeRec.qualifier = 0;
                    Debug.println((int)0, (String)("CosAttributesTableModel.setValueAt: ignored value " + object));
                }
            } else {
                Debug.println((int)0, (String)("CosAttributesTableModel.setValueAt: ignored change in col" + n2));
            }
        }

        public void fireTableRowInserted() {
            int n = ResEditorCosAttributes.this._attributeVector.size() - 1;
            this.fireTableRowsInserted(n, n);
        }

        public void fireTableRowDeleted(int n) {
            this.fireTableRowsDeleted(n, n);
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }
}

