/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.panel;

import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.IDSModel;
import com.netscape.admin.dirserv.panel.BlankPanel;
import com.netscape.admin.dirserv.panel.GroupPanel;
import com.netscape.management.client.util.AbstractDialog;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.ResourceSet;
import com.netscape.management.nmclf.SuiConstants;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import netscape.ldap.LDAPUrl;

public class LDAPUrlPanel
extends BlankPanel
implements SuiConstants {
    private IDSModel _model = null;
    private JLabel _refNewHostLabel;
    private JTextField _refNewHostText;
    private JLabel _refNewPortLabel;
    private JTextField _refNewPortText;
    private JLabel _refTargetDNLabel;
    private JTextField _refTargetDNText;
    private JLabel _refResult;
    private Object _item = null;
    private static final String _section = "construct-ldap-url";
    private static ResourceSet resource = DSUtil._resource;

    public LDAPUrlPanel(IDSModel iDSModel) {
        super(iDSModel, _section);
        this._helpToken = "configuration-construct-new-url-dbox-help";
        this._model = iDSModel;
        this.setTitle(DSUtil._resource.getString(_section, "title"));
    }

    public void init() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        this._myPanel.setLayout(gridBagLayout);
        this._refNewHostLabel = this.makeJLabel(_section, "new-host");
        this._refNewHostLabel.resetKeyboardActions();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        ++gridBagConstraints.gridy;
        this._myPanel.add((Component)this._refNewHostLabel, gridBagConstraints);
        this._refNewHostText = this.makeJTextField(_section, "new-host");
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 10.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this._refNewHostText.setColumns(16);
        this._myPanel.add((Component)this._refNewHostText, gridBagConstraints);
        this._refNewPortLabel = this.makeJLabel(_section, "new-port");
        this._refNewPortLabel.resetKeyboardActions();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 9, 6, 0);
        this._myPanel.add((Component)this._refNewPortLabel, gridBagConstraints);
        this._refNewPortText = this.makeJTextField(_section, "new-port");
        gridBagConstraints.gridx = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        this._refNewPortText.setColumns(5);
        this._myPanel.add((Component)this._refNewPortText, gridBagConstraints);
        this._refTargetDNLabel = this.makeJLabel(_section, "new-targetDN");
        this._refTargetDNLabel.resetKeyboardActions();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this._myPanel.add((Component)this._refTargetDNLabel, gridBagConstraints);
        this._refTargetDNText = this.makeJTextField(_section, "new-targetDN");
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        gridBagConstraints.gridwidth = 0;
        this._myPanel.add((Component)this._refTargetDNText, gridBagConstraints);
        GroupPanel groupPanel = new GroupPanel(DSUtil._resource.getString(_section, "result-title"));
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.gridwidth = 0;
        this._myPanel.add((Component)groupPanel, gridBagConstraints);
        this._refResult = new JLabel(" ");
        this._refResult.setToolTipText(DSUtil._resource.getString(_section, "ttip"));
        groupPanel.add(this._refResult);
        this.addBottomGlue();
    }

    private void setOkay(boolean bl) {
        AbstractDialog abstractDialog = this.getAbstractDialog();
        if (abstractDialog != null) {
            abstractDialog.setOKButtonEnabled(bl);
        }
    }

    private void checkOkay() {
        String string = this._refTargetDNText.getText();
        boolean bl = false;
        if (!DSUtil.isValidDN(string)) {
            this.setChangeState(this._refTargetDNLabel, 3);
        } else {
            this.setChangeState(this._refTargetDNLabel, 1);
            bl = true;
        }
        String string2 = this._refNewHostText.getText();
        boolean bl2 = string2 != null && string2.trim().length() > 0 && bl;
        this.setOkay(bl2);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        this.checkOkay();
    }

    public void resetCallback() {
        this.clearDirtyFlag();
        this.hideDialog();
    }

    public void okCallback() {
        this.clearDirtyFlag();
        this._item = this.getVal();
        Debug.println((String)("LDAPUrlPanel.okCallback: " + this._item));
        this.hideDialog();
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.updRes();
        super.changedUpdate(documentEvent);
        this.checkOkay();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.updRes();
        super.removeUpdate(documentEvent);
        this.checkOkay();
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.updRes();
        super.insertUpdate(documentEvent);
        this.checkOkay();
    }

    private void updRes() {
        LDAPUrl lDAPUrl = this.getVal();
        if (lDAPUrl != null) {
            this._refResult.setText(lDAPUrl.toString());
        } else {
            this._refResult.setText(DSUtil._resource.getString(_section, "invalid-url-label"));
        }
    }

    public Object getLDAPUrl() {
        return this._item;
    }

    protected LDAPUrl getVal() {
        String string = this._refNewHostText.getText();
        String string2 = this._refNewPortText.getText();
        String string3 = this._refTargetDNText.getText();
        StringBuffer stringBuffer = new StringBuffer("ldap://");
        if (string != null && string2.trim().length() > 0) {
            stringBuffer.append(string);
        }
        if (string2 != null && string2.trim().length() > 0) {
            stringBuffer.append(":");
            stringBuffer.append(string2);
        }
        if (string3 != null && string3.trim().length() > 0) {
            if (!DSUtil.isValidDN(string3)) {
                return null;
            }
            stringBuffer.append("/");
            stringBuffer.append(string3);
        }
        try {
            LDAPUrl lDAPUrl = new LDAPUrl(stringBuffer.toString());
            return lDAPUrl;
        }
        catch (Exception exception) {
            return null;
        }
    }
}

