/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.panel;

import com.netscape.admin.dirserv.IDSModel;
import com.netscape.admin.dirserv.logging.DSLogViewerModel;
import com.netscape.admin.dirserv.panel.ContainerPanel;
import com.netscape.admin.dirserv.panel.DSLogViewer;
import com.netscape.admin.dirserv.panel.RefreshablePanel;
import com.netscape.admin.dirserv.panel.UIFactory;
import com.netscape.management.client.IPage;
import com.netscape.management.client.IResourceObject;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Enumeration;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableColumn;

public abstract class LogContentPanel
extends RefreshablePanel {
    private int _rows = 15;
    private DSLogViewer _viewer;
    protected static final String cgiName = "Tasks/Operation/ViewLog";

    public LogContentPanel(IDSModel iDSModel, String string) {
        super(iDSModel, string, false);
    }

    public void select(IResourceObject iResourceObject, IPage iPage) {
        super.select(iResourceObject, iPage);
        ContainerPanel containerPanel = this.getParentPanel();
        if (containerPanel != null) {
            containerPanel.getOKButton().setVisible(false);
            containerPanel.getCancelButton().setVisible(false);
            containerPanel.updateButtons();
        }
    }

    public void init() {
        this._myPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = this.getGBC();
        JPanel jPanel = this.createRefreshArea();
        gridBagConstraints.gridx = 0;
        int n = UIFactory.getDifferentSpace();
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        this._myPanel.add((Component)jPanel, gridBagConstraints);
        this._viewer = this.getViewer();
        JTable jTable = this._viewer.getTable();
        jTable.setAutoResizeMode(1);
        jTable.setRequestFocusEnabled(false);
        int[] nArray = this.getWidths();
        Enumeration<TableColumn> enumeration = jTable.getColumnModel().getColumns();
        int n2 = 0;
        int n3 = 0;
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = enumeration.nextElement();
            tableColumn.setPreferredWidth(nArray[n2]);
            tableColumn.setResizable(true);
            n3 += nArray[n2];
            ++n2;
        }
        this.adjustTableSize(n3);
        gridBagConstraints = this.getGBC();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this._myPanel.add((Component)this._viewer, gridBagConstraints);
    }

    protected abstract DSLogViewer getViewer();

    abstract int[] getWidths();

    private void adjustTableSize(int n) {
        JTable jTable = this._viewer.getTable();
        DSLogViewerModel dSLogViewerModel = (DSLogViewerModel)jTable.getModel();
        int n2 = dSLogViewerModel.getRowCount();
        n2 = Math.max(n2, this._rows);
        int n3 = jTable.getRowHeight() * n2 + 6;
        Dimension dimension = new Dimension(n, n3);
        Insets insets = this._viewer.getInsets();
        n = this._viewer.getWidth() - insets.left - insets.right;
        n3 = this._viewer.getHeight() - insets.top - insets.bottom;
        dimension.width = Math.max(dimension.width, n);
        dimension.height = Math.max(dimension.height, n3);
        jTable.setMinimumSize(dimension);
        dimension.width = n;
        jTable.setPreferredScrollableViewportSize(dimension);
    }

    private void adjustTableSize() {
        JTable jTable = this._viewer.getTable();
        Enumeration<TableColumn> enumeration = jTable.getColumnModel().getColumns();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = enumeration.nextElement();
            n += tableColumn.getWidth();
        }
        this.adjustTableSize(n);
    }

    public boolean refresh() {
        this.getModel().setWaitCursor(true);
        boolean bl = this._viewer.updateContents();
        this.adjustTableSize();
        this._viewer.scrollToEnd();
        this.getModel().setWaitCursor(false);
        return bl;
    }

    public void okCallback() {
        this.clearDirtyFlag();
        this.hideDialog();
    }

    public void resetCallback() {
        this.clearDirtyFlag();
        this.hideDialog();
    }
}

