/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.panel;

import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.IDSModel;
import com.netscape.admin.dirserv.panel.GroupPanel;
import com.netscape.admin.dirserv.panel.RefreshablePanel;
import com.netscape.management.client.IPage;
import com.netscape.management.client.IResourceObject;
import com.netscape.management.client.util.ResourceSet;
import com.netscape.management.nmclf.SuiTableHeaderRenderer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;

public class MonitorBasePanel
extends RefreshablePanel {
    protected LDAPEntry _entry;
    protected LDAPConnection _ldc;
    protected String _entryName = "cn=monitor";
    protected Vector _tables = new Vector();
    private boolean _isSelected = false;
    protected static final int PREFERRED_WIDTH = 500;
    static final ResourceSet _resource = DSUtil._resource;

    public MonitorBasePanel(IDSModel iDSModel, String string) {
        super(iDSModel, string, true);
    }

    public void select(IResourceObject iResourceObject, IPage iPage) {
        if (!this._isInitialized) {
            this.init();
            this._isInitialized = true;
        }
        this._isSelected = true;
        if (this._refreshCheckbox != null && this._refreshCheckbox.isSelected()) {
            this.startUpdater();
        }
    }

    public void unselect(IResourceObject iResourceObject, IPage iPage) {
        this._isSelected = false;
        this.stopUpdater();
    }

    public boolean refresh() {
        Enumeration enumeration = this._tables.elements();
        while (enumeration.hasMoreElements()) {
            JTable jTable = (JTable)enumeration.nextElement();
            jTable.repaint();
        }
        return true;
    }

    protected String getAttrValue(String string) {
        return DSUtil.getAttrValue(this._entry, string);
    }

    protected void setColumnWidths(JTable jTable, int[] nArray) {
        Enumeration<TableColumn> enumeration = jTable.getColumnModel().getColumns();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = enumeration.nextElement();
            tableColumn.setPreferredWidth(nArray[n]);
            tableColumn.setResizable(true);
            ++n;
        }
    }

    protected void setColumnHeaders(JTable jTable, String[] stringArray) {
        Enumeration<TableColumn> enumeration = jTable.getColumnModel().getColumns();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = enumeration.nextElement();
            tableColumn.setHeaderValue(stringArray[n]);
            ++n;
        }
    }

    protected int getTotalColumnWidth(JTable jTable) {
        Enumeration<TableColumn> enumeration = jTable.getColumnModel().getColumns();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = enumeration.nextElement();
            n += tableColumn.getWidth();
        }
        return n;
    }

    private Dimension getOptimalDimension(JTable jTable, JComponent jComponent) {
        int n = this.getTotalColumnWidth(jTable);
        Dimension dimension = new Dimension(n, (jTable.getRowMargin() + jTable.getRowHeight()) * jTable.getRowCount());
        Insets insets = jComponent.getInsets();
        n = jComponent.getWidth() - insets.left - insets.right;
        dimension.width = Math.max(dimension.width, n);
        return dimension;
    }

    private void setupTable(JTable jTable, JComponent jComponent) {
        Dimension dimension = this.getOptimalDimension(jTable, jComponent);
        jTable.setMinimumSize(dimension);
        jTable.setSize(dimension);
        jTable.getTableHeader().setReorderingAllowed(false);
        jTable.setRowSelectionAllowed(false);
        jTable.setColumnSelectionAllowed(false);
        jTable.setAutoResizeMode(1);
        jTable.setRequestFocusEnabled(false);
        jTable.sizeColumnsToFit(true);
    }

    protected void addTable(JTable jTable, JComponent jComponent, String string) {
        this.addTableInScrollPane(jTable, jComponent, string);
    }

    protected void addTableInScrollPane(JTable jTable, JComponent jComponent, String string) {
        JScrollPane jScrollPane = new JScrollPane(jTable);
        GroupPanel groupPanel = new GroupPanel(string);
        jScrollPane.setHorizontalScrollBarPolicy(31);
        jScrollPane.setVerticalScrollBarPolicy(21);
        this._gbc.gridwidth = 0;
        this._gbc.fill = 1;
        groupPanel.add((Component)jScrollPane, this._gbc);
        this._gbc.fill = 2;
        jComponent.add((Component)groupPanel, this._gbc);
        this.setupTable(jTable, jComponent);
        Dimension dimension = this.getOptimalDimension(jTable, jComponent);
        jTable.setPreferredScrollableViewportSize(new Dimension(10, dimension.height));
    }

    protected void addTableInGroupPane(JTable jTable, JComponent jComponent, String string) {
        GroupPanel groupPanel = new GroupPanel(string);
        groupPanel.add((Component)jTable, this._gbc);
        this.setupTable(jTable, jComponent);
        this._gbc.insets = new Insets(10, 0, 2, 2);
        this._gbc.gridwidth = 0;
        this._gbc.fill = 2;
        jComponent.add((Component)groupPanel, this._gbc);
    }

    protected void rightAlignColumns(JTable jTable, int n, int n2) {
        int n3 = n;
        while (n3 <= n2) {
            jTable.getColumnModel().getColumn(n3).setCellRenderer(new RightAlignedCellRenderer());
            SuiTableHeaderRenderer suiTableHeaderRenderer = (SuiTableHeaderRenderer)jTable.getColumnModel().getColumn(n3).getHeaderRenderer();
            suiTableHeaderRenderer.setHorizontalAlignment(4);
            suiTableHeaderRenderer.setHorizontalTextPosition(4);
            ++n3;
        }
    }

    class PerfTableModel
    extends AbstractTableModel {
        protected String[] _labels;
        protected String[] _headers;
        protected String[] _dataNames;
        protected LDAPEntry _monitorEntry = null;

        PerfTableModel(String[] stringArray, String[] stringArray2, String[] stringArray3) {
            this._labels = stringArray;
            this._headers = stringArray2;
            this._dataNames = stringArray3;
            this._monitorEntry = MonitorBasePanel.this._entry;
        }

        PerfTableModel(String[] stringArray, String[] stringArray2, String[] stringArray3, LDAPEntry lDAPEntry) {
            this._labels = stringArray;
            this._headers = stringArray2;
            this._dataNames = stringArray3;
            this._monitorEntry = lDAPEntry;
        }

        public void updEntry(LDAPEntry lDAPEntry) {
            this.updEntry(lDAPEntry, true);
        }

        public void updEntry(LDAPEntry lDAPEntry, boolean bl) {
            this._monitorEntry = lDAPEntry;
            if (bl) {
                this.fireTableDataChanged();
            }
        }

        public void updDataNames(String[] stringArray, boolean bl) {
            this._dataNames = stringArray;
            if (bl) {
                this.fireTableDataChanged();
            }
        }

        public void notifyChanges() {
            this.fireTableDataChanged();
        }

        public int getColumnCount() {
            return this._headers.length;
        }

        public int getRowCount() {
            return this._labels.length;
        }

        public Object getValueAt(int n, int n2) {
            String string;
            if (n2 == 0) {
                string = this._labels[n];
            } else {
                string = DSUtil.getAttrValue(this._monitorEntry, this._dataNames[n]);
                if (string == null || string.length() < 1) {
                    return "";
                }
            }
            return string;
        }

        public String getColumnName(int n) {
            return this._headers[n];
        }
    }

    class RightAlignedCellRenderer
    extends DefaultTableCellRenderer {
        RightAlignedCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setHorizontalAlignment(4);
            return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        }
    }
}

