/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.panel;

import com.netscape.admin.dirserv.DSSchemaHelper;
import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.DefaultResourceModel;
import com.netscape.admin.dirserv.GlobalConstants;
import com.netscape.admin.dirserv.IDSModel;
import com.netscape.admin.dirserv.panel.AttrTableModel;
import com.netscape.admin.dirserv.panel.AttributeDialog;
import com.netscape.admin.dirserv.panel.BlankPanel;
import com.netscape.admin.dirserv.panel.CenterAlignedHeaderRenderer;
import com.netscape.admin.dirserv.panel.CheckBoxTableCellRenderer;
import com.netscape.admin.dirserv.panel.ContainerPanel;
import com.netscape.admin.dirserv.panel.SimpleDialog;
import com.netscape.admin.dirserv.panel.UIFactory;
import com.netscape.management.client.IPage;
import com.netscape.management.client.IResourceObject;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.UITools;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import netscape.ldap.LDAPAttributeSchema;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPSchema;
import netscape.ldap.LDAPSchemaElement;
import netscape.ldap.LDAPSyntaxSchema;

public class SchemaAttributesPanel
extends BlankPanel
implements ListSelectionListener {
    private JButton _createButton = null;
    private JButton _deleteButton = null;
    private JButton _editButton = null;
    private JButton _helpButton = null;
    private AttrTable _userDefTable = null;
    private AttrTable _stdTable = null;
    private AttrTableModel _userDefTableModel = null;
    private AttrTableModel _stdTableModel = null;
    private static int[] _widths = new int[]{130, 160, 115, 40};
    private static final int MULTI_INDEX = 3;
    private static Hashtable _htSyntaxStrings = null;
    private static final String _section = "schemaattributes";

    public SchemaAttributesPanel(IDSModel iDSModel, String string, boolean bl) {
        super(iDSModel, string, bl);
        this._helpToken = "configuration-schema-attr-help";
        _htSyntaxStrings = SchemaAttributesPanel.getSyntaxStrings(this.getModel().getSchema());
        this._refreshWhenSelect = false;
    }

    public SchemaAttributesPanel(IDSModel iDSModel) {
        this(iDSModel, _section, false);
    }

    static Hashtable getSyntaxStrings(LDAPSchema lDAPSchema) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Enumeration enumeration = lDAPSchema.getSyntaxes();
        while (enumeration.hasMoreElements()) {
            LDAPSyntaxSchema lDAPSyntaxSchema = (LDAPSyntaxSchema)enumeration.nextElement();
            if (lDAPSyntaxSchema == null) continue;
            hashtable.put(lDAPSyntaxSchema.getID(), lDAPSyntaxSchema.getDescription());
        }
        return hashtable;
    }

    static String getSyntaxString(String string) {
        String string2;
        String string3;
        if (_htSyntaxStrings != null && (string3 = (String)_htSyntaxStrings.get(string2 = SchemaAttributesPanel.getNormalizedID(string))) != null) {
            return string3;
        }
        return "";
    }

    private static String getNormalizedID(String string) {
        int n = string.indexOf(123);
        String string2 = n < 0 ? new String(string) : string.substring(0, n);
        return string2;
    }

    public void init() {
        this.getModel().setWaitCursor(true);
        int n = UIFactory.getDifferentSpace();
        EmptyBorder emptyBorder = new EmptyBorder(this.getBorderInsets());
        this._myPanel.setBorder(emptyBorder);
        this._myPanel.setLayout(new GridBagLayout());
        JLabel jLabel = this.makeJLabel(_section, "intro");
        jLabel.setLabelFor(this);
        this.resetGBC();
        this._gbc.gridwidth = 0;
        this._gbc.insets = new Insets(0, 0, n, 0);
        this._myPanel.add((Component)jLabel, this._gbc);
        JComponent jComponent = this.createAttributeListArea(this._myPanel);
        this._gbc.weightx = 1.0;
        this._gbc.weighty = 1.0;
        this._gbc.fill = 1;
        this._myPanel.add((Component)jComponent, this._gbc);
        JComponent jComponent2 = this.createButtonsPanel();
        this._gbc.weightx = 1.0;
        this._gbc.weighty = 0.0;
        this._gbc.fill = 2;
        this._gbc.insets.top = n;
        this._myPanel.add((Component)jComponent2, this._gbc);
        this.getModel().setWaitCursor(false);
    }

    protected void setColumnWidths(JTable jTable, int[] nArray) {
        if (jTable == null) {
            return;
        }
        Enumeration<TableColumn> enumeration = jTable.getColumnModel().getColumns();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            TableModel tableModel;
            TableColumn tableColumn = enumeration.nextElement();
            tableColumn.setWidth(nArray[n]);
            tableColumn.setResizable(true);
            if (n == 3 && (tableModel = jTable.getModel()).getColumnClass(n) == Boolean.TYPE) {
                tableColumn.setMinWidth(nArray[n]);
                tableColumn.setHeaderRenderer((TableCellRenderer)((Object)new CenterAlignedHeaderRenderer()));
                tableColumn.setCellRenderer(new CheckBoxTableCellRenderer());
            }
            ++n;
        }
    }

    protected int getTotalColumnWidth(JTable jTable) {
        if (jTable == null) {
            return 0;
        }
        Enumeration<TableColumn> enumeration = jTable.getColumnModel().getColumns();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = enumeration.nextElement();
            n += tableColumn.getWidth();
        }
        return n;
    }

    private Dimension getOptimalDimension(JTable jTable, Container container) {
        if (jTable == null) {
            return new Dimension();
        }
        int n = this.getTotalColumnWidth(jTable);
        Dimension dimension = new Dimension(n, jTable.getRowHeight() * jTable.getRowCount() + 8);
        Insets insets = container.getInsets();
        n = ((JComponent)container).getWidth() - insets.left - insets.right;
        dimension.width = Math.max(dimension.width, n);
        return dimension;
    }

    private void setupTable(JTable jTable, Container container, Dimension dimension) {
        jTable.setBackground(Color.white);
        jTable.setRowHeight(16);
        Dimension dimension2 = dimension;
        if (dimension2 == null) {
            dimension2 = this.getOptimalDimension(jTable, container);
        }
        jTable.setMinimumSize(dimension2);
        jTable.setSize(dimension2);
        jTable.setPreferredScrollableViewportSize(dimension2);
        jTable.getTableHeader().setReorderingAllowed(false);
        jTable.setRowSelectionAllowed(false);
        jTable.setColumnSelectionAllowed(false);
        jTable.setAutoResizeMode(1);
        jTable.setRequestFocusEnabled(false);
    }

    private void setupTable(JTable jTable, Container container) {
        this.setupTable(jTable, container, null);
    }

    protected JScrollPane addTableInScrollPane(JTable jTable, Container container, Dimension dimension) {
        JScrollPane jScrollPane = new JScrollPane(jTable);
        jScrollPane.setBackground(Color.white);
        jScrollPane.setBorder(UITools.createLoweredBorder());
        this.resetGBC();
        this._gbc.anchor = 17;
        this._gbc.gridwidth = 0;
        this._gbc.weighty = 1.0;
        this._gbc.fill = 1;
        this._gbc.insets = new Insets(0, 0, 0, 0);
        container.add((Component)jScrollPane, this._gbc);
        this.setupTable(jTable, container, dimension);
        return jScrollPane;
    }

    protected JScrollPane addTableInScrollPane(JTable jTable, Container container) {
        return this.addTableInScrollPane(jTable, container, null);
    }

    protected JComponent createAttributeListArea(Container container) {
        String string = new String();
        Object[][] objectArray = new Object[][]{{DSUtil._resource.getString(_section, "namecolumn-label"), string.getClass()}, {DSUtil._resource.getString(_section, "oidcolumn-label"), string.getClass()}, {DSUtil._resource.getString(_section, "syntaxcolumn-label"), string.getClass()}, {DSUtil._resource.getString(_section, "multicolumn-label"), Boolean.TYPE}};
        JLabel jLabel = this.makeJLabel(_section, "standard");
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.resetGBC();
        this._gbc.gridwidth = 0;
        this._gbc.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)jLabel, this._gbc);
        this._stdTableModel = new AttrTableModel(objectArray);
        this._userDefTableModel = new AttrTableModel(objectArray);
        this.populateTables();
        this._stdTable = new AttrTable(this._stdTableModel);
        jLabel.setLabelFor(this._stdTable);
        JScrollPane jScrollPane = this.addTableInScrollPane(this._stdTable, jPanel);
        jLabel = this.makeJLabel(_section, "userdefined");
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.resetGBC();
        this._gbc.gridwidth = 0;
        this._gbc.insets = new Insets(0, 0, 0, 0);
        jPanel2.add((Component)jLabel, this._gbc);
        this._userDefTable = new AttrTable(this._userDefTableModel);
        jLabel.setLabelFor(this._userDefTable);
        JScrollPane jScrollPane2 = this.addTableInScrollPane(this._userDefTable, jPanel2);
        this._userDefTable.setRowSelectionAllowed(true);
        this._userDefTable.getSelectionModel().addListSelectionListener(this);
        final JSplitPane jSplitPane = new JSplitPane(0, jPanel, jPanel2);
        jSplitPane.setBorder(new EmptyBorder(0, 0, 0, 0));
        jSplitPane.setDividerLocation(0.5);
        jSplitPane.setDividerSize(10);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                jSplitPane.setDividerLocation(0.5);
            }
        });
        return jSplitPane;
    }

    public void select(IResourceObject iResourceObject, IPage iPage) {
        Debug.println((String)"SchemaAttributesPanel.select");
        if (!this._isInitialized) {
            this.init();
            this._isInitialized = true;
            this.clearDirtyFlag();
        }
    }

    public boolean refresh() {
        Debug.println((String)"SchemaAttributesPanel.refresh");
        this.getModel().setWaitCursor(true);
        try {
            LDAPSchema lDAPSchema = new LDAPSchema();
            LDAPConnection lDAPConnection = this.getModel().getServerInfo().getLDAPConnection();
            if (lDAPConnection != null) {
                lDAPSchema.fetchSchema(lDAPConnection);
                this.getModel().setSchema(lDAPSchema);
            }
        }
        catch (LDAPException lDAPException) {
            Debug.println((String)("SchemaAttributesPanel.refresh: " + (Object)((Object)lDAPException)));
            return false;
        }
        this.populateTables();
        this.getModel().setWaitCursor(false);
        return true;
    }

    protected void populateTables() {
        this._userDefTableModel.removeAllRows();
        this._stdTableModel.removeAllRows();
        LDAPSchema lDAPSchema = this.getModel().getSchema();
        if (lDAPSchema == null) {
            return;
        }
        LDAPSchema lDAPSchema2 = lDAPSchema;
        synchronized (lDAPSchema2) {
            Enumeration enumeration = lDAPSchema.getAttributes();
            while (enumeration.hasMoreElements()) {
                LDAPAttributeSchema lDAPAttributeSchema = (LDAPAttributeSchema)enumeration.nextElement();
                this.addAttributeRow(lDAPAttributeSchema);
            }
        }
        this.setColumnWidths(this._stdTable, _widths);
        this.setColumnWidths(this._userDefTable, _widths);
        if (this._stdTable != null) {
            this._stdTable.repaint();
        }
        if (this._userDefTable != null) {
            this._userDefTable.repaint();
        }
    }

    private void addAttributeRow(LDAPAttributeSchema lDAPAttributeSchema) {
        if (!DSUtil.isStandardSchema((LDAPSchemaElement)lDAPAttributeSchema)) {
            this._userDefTableModel.addRow(lDAPAttributeSchema);
        } else {
            this._stdTableModel.addRow(lDAPAttributeSchema);
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.updateButtons();
    }

    private void updateButtons() {
        if (this._editButton == null) {
            return;
        }
        boolean bl = this._userDefTable.getSelectedRowCount() > 0;
        this._editButton.setEnabled(this._userDefTable.getSelectedRowCount() == 1);
        this._deleteButton.setEnabled(bl);
    }

    protected JComponent createButtonsPanel() {
        this._createButton = this.makeJButton(_section, "create");
        this._editButton = this.makeJButton(_section, "edit");
        this._deleteButton = this.makeJButton(_section, "delete");
        this._helpButton = this.makeJButton("general", "Help");
        JButton[] jButtonArray = new JButton[]{this._createButton, this._editButton, this._deleteButton, this._helpButton};
        JPanel jPanel = UIFactory.makeJButtonPanel(jButtonArray, true);
        this._editButton.setEnabled(false);
        this._deleteButton.setEnabled(false);
        return jPanel;
    }

    private boolean removeRowByName(String string) {
        return this._userDefTable.removeRowByName(string);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        AttributeDialog attributeDialog = null;
        String string = "";
        LDAPSchema lDAPSchema = this.getModel().getSchema();
        LDAPAttributeSchema lDAPAttributeSchema = null;
        if (object.equals(this._createButton)) {
            attributeDialog = new AttributeDialog(this.getModel());
            ((Dialog)((Object)attributeDialog)).setTitle(DSUtil._resource.getString(_section, "new-title"));
        } else if (object.equals(this._editButton)) {
            int n = this._userDefTable.getSelectedRow();
            if (n < 0) {
                return;
            }
            string = (String)this._userDefTable.getValueAt(n, 0);
            lDAPAttributeSchema = lDAPSchema.getAttribute(string);
            if (lDAPAttributeSchema == null) {
                Debug.println((String)("SchemaAttributePanel.actionPerformed: No schema def for " + string));
                return;
            }
            attributeDialog = new AttributeDialog(this.getModel(), lDAPAttributeSchema);
            ((Dialog)((Object)attributeDialog)).setTitle(DSUtil._resource.getString(_section, "edit-title"));
        } else if (object.equals(this._helpButton)) {
            this.helpCallback();
        } else if (object.equals(this._deleteButton)) {
            int n;
            int n2;
            String string2;
            int n3 = this._userDefTable.getSelectedRow();
            if (n3 < 0) {
                return;
            }
            int[] nArray = this._userDefTable.getSelectedRows();
            String[] stringArray = new String[nArray.length];
            LDAPAttributeSchema[] lDAPAttributeSchemaArray = new LDAPAttributeSchema[nArray.length];
            int n4 = 0;
            while (n4 < nArray.length) {
                stringArray[n4] = (String)this._userDefTable.getValueAt(nArray[n4], 0);
                lDAPAttributeSchemaArray[n4] = lDAPSchema.getAttribute(stringArray[n4]);
                if (lDAPAttributeSchemaArray[n4] == null) {
                    Debug.println((String)("SchemaAttributePanel.actionPerformed: No schema def for " + stringArray[n4]));
                    return;
                }
                ++n4;
            }
            boolean bl = BlankPanel.requiresConfirmation(GlobalConstants.PREFERENCES_CONFIRM_DELETE_ATTRIBUTE);
            if (bl) {
                string2 = stringArray[0];
                n2 = 1;
                while (n2 < stringArray.length) {
                    string2 = string2 + " " + stringArray[n2];
                    ++n2;
                }
                string2 = "'" + DSUtil.abreviateString(string2, 20) + "'";
                n = DSUtil.showConfirmationDialog((Component)this.getModel().getFrame(), "confirm-delete", string2, _section);
                if (n != 0) {
                    this.updateButtons();
                    return;
                }
            }
            if ((string2 = this.getModel().getServerInfo().getLDAPConnection()) == null) {
                Debug.println((String)"SchemaAttributePanel.actionPerformed: No LDAPConnection");
                return;
            }
            n2 = 0;
            n = 0;
            while (n2 == 0) {
                try {
                    int n5 = 0;
                    while (n5 < stringArray.length) {
                        lDAPAttributeSchema = lDAPAttributeSchemaArray[n5];
                        if (lDAPAttributeSchema != null) {
                            Debug.println((String)("SchemaAttributesPanel.actionPerformed: delete " + lDAPAttributeSchema.getValue()));
                            lDAPAttributeSchema.remove((LDAPConnection)string2);
                            lDAPAttributeSchemaArray[n5] = null;
                        }
                        ++n5;
                    }
                    n2 = 1;
                    n = 1;
                }
                catch (LDAPException lDAPException) {
                    Debug.println((String)("SchemaAttributesPanel.actionPerformed: " + (Object)((Object)lDAPException) + " attr = " + lDAPAttributeSchema.getValue()));
                    if (lDAPException.getLDAPResultCode() == 50) {
                        DSUtil.showPermissionDialog((Component)this.getModel().getFrame(), (LDAPConnection)string2);
                        if (this.getModel().getNewAuthentication(false)) continue;
                        n2 = 1;
                        continue;
                    }
                    n2 = 1;
                    DSUtil.showErrorDialog((Component)this.getModel().getFrame(), "failed-delete", lDAPException.toString(), _section);
                }
            }
            this.getModel().notifyAuthChangeListeners();
            if (n != 0) {
                String string3 = stringArray[0];
                this.removeRowByName(stringArray[0]);
                int n6 = 1;
                while (n6 < nArray.length) {
                    string3 = string3 + "," + stringArray[n6];
                    this.removeRowByName(stringArray[n6]);
                    ++n6;
                }
                string3 = "'" + DSUtil.abreviateString(string3, 20) + "'";
                DSUtil.showInformationDialog((Component)this.getModel().getFrame(), "successful-delete", string3, _section);
                this.getModel().setSchema(null);
            }
        }
        if (attributeDialog != null) {
            try {
                attributeDialog.packAndShow();
                lDAPAttributeSchema = attributeDialog.getAttribute();
                if (lDAPAttributeSchema != null) {
                    if (object.equals(this._editButton)) {
                        this.removeRowByName(string);
                    }
                    this.addAttributeRow(lDAPAttributeSchema);
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        this.updateButtons();
    }

    public static void main(String[] stringArray) {
        Object object;
        Object object2;
        Debug.setTrace((boolean)true);
        try {
            UIManager.setLookAndFeel("com.netscape.management.nmclf.SuiLookAndFeel");
        }
        catch (Exception exception) {
            System.err.println("Cannot load nmc look and feel.");
        }
        DefaultResourceModel defaultResourceModel = new DefaultResourceModel();
        try {
            int n = Integer.parseInt(stringArray[1]);
            object2 = new LDAPConnection();
            object2.connect(3, stringArray[0], n, stringArray[2], stringArray[3]);
            object = new LDAPSchema();
            object.fetchSchema(object2);
            defaultResourceModel.setSchema((LDAPSchema)object);
        }
        catch (Exception exception) {
            System.err.println(exception);
            System.err.println("Usage: SchemaAttributesPanel HOST PORT AUTHDN AUTHPASSWORD");
            System.exit(1);
        }
        SchemaAttributesPanel schemaAttributesPanel = new SchemaAttributesPanel(defaultResourceModel){

            public void okCallback() {
                this.hideDialog();
                System.exit(0);
            }
        };
        ((BlankPanel)schemaAttributesPanel).init();
        object2 = new ContainerPanel(defaultResourceModel, schemaAttributesPanel, false);
        object = BlankPanel.createDialog((JComponent)object2, schemaAttributesPanel);
        ((SimpleDialog)((Object)object)).show();
    }

    class AttrTable
    extends JTable
    implements MouseListener {
        AttrTable(TableModel tableModel) {
            super(tableModel);
            this.addMouseListener(this);
            this.createDefaultColumnsFromModel();
            tableModel.addTableModelListener(this);
        }

        public void add(LDAPAttributeSchema lDAPAttributeSchema) {
            AttrTableModel attrTableModel = (AttrTableModel)this.getModel();
            attrTableModel.addRow(lDAPAttributeSchema);
        }

        boolean removeRowByName(String string) {
            AttrTableModel attrTableModel = (AttrTableModel)this.getModel();
            int n = 0;
            while (n < attrTableModel.getRowCount()) {
                String string2 = (String)this.getValueAt(n, 0);
                if (string.equalsIgnoreCase(string2)) {
                    attrTableModel.removeRow(n);
                    return true;
                }
                ++n;
            }
            return false;
        }

        void singleClicked(MouseEvent mouseEvent) {
        }

        void doubleClicked(MouseEvent mouseEvent) {
            int n = this.rowAtPoint(mouseEvent.getPoint());
            Debug.println((String)("AttrTable.doubleClicked on row " + n));
            if (n >= 0) {
                String string = (String)this.getValueAt(n, 0);
                IDSModel iDSModel = SchemaAttributesPanel.this.getModel();
                LDAPSchema lDAPSchema = iDSModel.getSchema();
                LDAPAttributeSchema lDAPAttributeSchema = lDAPSchema.getAttribute(string);
                if (DSUtil.isStandardSchema((LDAPSchemaElement)lDAPAttributeSchema)) {
                    return;
                }
                AttributeDialog attributeDialog = new AttributeDialog(iDSModel, lDAPAttributeSchema);
                ((Dialog)((Object)attributeDialog)).setTitle(DSUtil._resource.getString(SchemaAttributesPanel._section, "edit-title"));
                attributeDialog.show();
                AttrTable attrTable = this;
                synchronized (attrTable) {
                    LDAPAttributeSchema lDAPAttributeSchema2 = attributeDialog.getAttribute();
                    if (lDAPAttributeSchema2 != null) {
                        AttrTableModel attrTableModel = (AttrTableModel)this.getModel();
                        this.removeRowByName(lDAPAttributeSchema.getName());
                        this.add(lDAPAttributeSchema2);
                    }
                }
            }
        }

        public void tableChanged(TableModelEvent tableModelEvent) {
            Debug.println((int)8, (String)("AttrTable.tableChanged " + tableModelEvent));
            this.repaint();
            super.tableChanged(tableModelEvent);
        }

        private void popup(MouseEvent mouseEvent) {
            Debug.println((String)("AttrTable.popup " + mouseEvent));
        }

        public void processMouseEvent(MouseEvent mouseEvent) {
            super.processMouseEvent(mouseEvent);
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            int n = mouseEvent.getModifiers();
            if (mouseEvent.getClickCount() == 2 && (n & 4) == 0) {
                this.doubleClicked(mouseEvent);
            } else {
                this.singleClicked(mouseEvent);
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public synchronized String getToolTipText(MouseEvent mouseEvent) {
            String string = "";
            if (mouseEvent == null) {
                return string;
            }
            Point point = mouseEvent.getPoint();
            if (point == null) {
                return string;
            }
            int n = this.rowAtPoint(point);
            if (n >= 0 && n < this.getRowCount()) {
                String string2 = (String)this.getValueAt(n, 0);
                Debug.println((int)8, (String)("AttrTable.getToolTipText: row = " + n + " attrName = " + string2));
                IDSModel iDSModel = SchemaAttributesPanel.this.getModel();
                Debug.println((int)8, (String)("AttrTable.getToolTipText: model = " + iDSModel));
                LDAPSchema lDAPSchema = iDSModel.getSchema();
                Debug.println((int)8, (String)("AttrTable.getToolTipText: schema = " + (lDAPSchema == null)));
                LDAPAttributeSchema lDAPAttributeSchema = lDAPSchema.getAttribute(string2);
                Debug.println((int)8, (String)("AttrTable.getToolTipText: las = " + lDAPAttributeSchema));
                if (lDAPAttributeSchema != null) {
                    string = string2;
                    String string3 = DSSchemaHelper.arrayToString(lDAPAttributeSchema.getAliases());
                    if (string3 != null && string3.length() > 0) {
                        string = string + ", " + string3;
                    }
                    string = string + ": " + lDAPAttributeSchema.getDescription();
                }
            }
            return string;
        }
    }
}

