/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.panel.replication;

import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.panel.BackendPanel;
import com.netscape.admin.dirserv.panel.UIFactory;
import com.netscape.management.client.util.Debug;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.util.DN;

public class ReplicaPanel
extends BackendPanel {
    private static String ENTRY_KEYWORD = "entry";

    public ReplicaPanel(LDAPConnection lDAPConnection, LDAPEntry lDAPEntry) {
        super(lDAPConnection);
        this.setSelectedReplica(lDAPEntry);
    }

    public LDAPEntry getReplicaEntry() {
        String string = String.valueOf(this._theChoice.getSelectedIndex());
        Hashtable hashtable = (Hashtable)this._htSuffixAndBackends.get(string);
        return (LDAPEntry)hashtable.get(ENTRY_KEYWORD);
    }

    public boolean setSelectedReplica(LDAPEntry lDAPEntry) {
        if (lDAPEntry == null) {
            return false;
        }
        int n = 0;
        while (n < this._htSuffixAndBackends.size()) {
            DN dN;
            String string = String.valueOf(n);
            LDAPEntry lDAPEntry2 = (LDAPEntry)((Hashtable)this._htSuffixAndBackends.get(string)).get(ENTRY_KEYWORD);
            DN dN2 = new DN(lDAPEntry.getDN());
            if (dN2.equals(dN = new DN(lDAPEntry2.getDN()))) {
                this._theChoice.setSelectedIndex(n);
                return true;
            }
            ++n;
        }
        return false;
    }

    protected void init() {
        block9: {
            this.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = this.getGBC();
            gridBagConstraints.anchor = 13;
            gridBagConstraints.gridwidth = -1;
            this.add((Component)this._label, gridBagConstraints);
            gridBagConstraints.weightx = 1.0;
            this._theChoice = UIFactory.makeJComboBox(null, null);
            this._theChoice.setEditable(false);
            this.add((Component)this._theChoice, gridBagConstraints);
            try {
                boolean bl = true;
                String string = null;
                Vector vector = DSUtil.getLDBMInstanceList(this._ldc, bl, string);
                Debug.println((int)8, (String)("ReplicaPanel.init: ldbm instance list size = " + (vector == null ? 0 : vector.size())));
                if (vector == null || vector.size() <= 0) break block9;
                Enumeration enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    Vector vector2;
                    Object e = enumeration.nextElement();
                    LDAPEntry lDAPEntry = null;
                    String string2 = null;
                    if (e instanceof Vector) {
                        vector2 = (Vector)e;
                        lDAPEntry = (LDAPEntry)vector2.elementAt(0);
                        string2 = "cn=replica," + ((LDAPEntry)vector2.elementAt(1)).getDN();
                    } else {
                        lDAPEntry = (LDAPEntry)e;
                        string2 = "cn=replica," + lDAPEntry.getDN();
                    }
                    vector2 = null;
                    try {
                        vector2 = this._ldc.read(string2);
                    }
                    catch (LDAPException lDAPException) {
                        Debug.println((int)6, (String)("ReplicaPanel.init: could not read dn = " + string2 + ": " + (Object)((Object)lDAPException)));
                        vector2 = null;
                    }
                    if (vector2 != null) {
                        String string3 = DSUtil.getAttrValue(lDAPEntry, "nsslapd-suffix");
                        String string4 = DSUtil.getAttrValue(lDAPEntry, "cn");
                        this._theChoice.addItem(string3);
                        if (this._htSuffixAndBackends == null) {
                            this._htSuffixAndBackends = new Hashtable();
                        }
                        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
                        hashtable.put("nsslapd-suffix", string3);
                        hashtable.put("cn", string4);
                        hashtable.put(ENTRY_KEYWORD, vector2);
                        String string5 = "" + (this._theChoice.getItemCount() - 1);
                        this._htSuffixAndBackends.put(string5, hashtable);
                        continue;
                    }
                    Debug.println((int)8, (String)("ReplicaPanel.init: there is no replica entry for " + string2));
                }
            }
            catch (LDAPException lDAPException) {
                Debug.println((String)("ReplicaPanel.init: could not load backend instances from server " + DSUtil.format(this._ldc) + " exception: " + (Object)((Object)lDAPException)));
                lDAPException.printStackTrace();
            }
        }
    }
}

