/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.panel.replication;

import com.netscape.admin.dirserv.DSResourceModel;
import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.IDSContentListener;
import com.netscape.admin.dirserv.IDSModel;
import com.netscape.admin.dirserv.node.DSResourceObject;
import com.netscape.admin.dirserv.panel.replication.AgreementReader;
import com.netscape.admin.dirserv.panel.replication.AgreementResourceObject;
import com.netscape.admin.dirserv.panel.replication.AgreementTable;
import com.netscape.admin.dirserv.panel.replication.AgreementWizard;
import com.netscape.admin.dirserv.panel.replication.AgreementWizardInfo;
import com.netscape.admin.dirserv.panel.replication.IReplicationResourceObject;
import com.netscape.admin.dirserv.panel.replication.MMRAgreement;
import com.netscape.admin.dirserv.panel.replication.ReplicaConfigTabPanel;
import com.netscape.admin.dirserv.panel.replication.ReplicationAgreement;
import com.netscape.admin.dirserv.panel.replication.ReplicationTool;
import com.netscape.admin.dirserv.panel.replication.SIRAgreement;
import com.netscape.management.client.IMenuInfo;
import com.netscape.management.client.IMenuItem;
import com.netscape.management.client.IPage;
import com.netscape.management.client.IResourceObject;
import com.netscape.management.client.MenuItemSeparator;
import com.netscape.management.client.MenuItemText;
import com.netscape.management.client.ResourceObject;
import com.netscape.management.client.ResourcePage;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.RemoteImage;
import com.netscape.management.client.util.ResourceSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import javax.swing.Icon;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPDN;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;

public class ReplicaResourceObject
extends DSResourceObject
implements IMenuInfo,
ActionListener,
TreeExpansionListener,
IDSContentListener,
IReplicationResourceObject {
    protected String[] _categoryID;
    protected IMenuItem[] _contextMenuItems;
    protected IMenuItem[] _objectMenuItems;
    private ResourceObject _parent = null;
    private Component _panel = null;
    private boolean _isLoaded = false;
    private LDAPEntry _instEntry = null;
    private LDAPEntry _mapTreeEntry = null;
    private LDAPEntry _replicaEntry = null;
    private boolean _isLeaf = false;
    private boolean _isInitiallyExpanded = false;
    private boolean _isTreeCollapsed = true;
    private static final String _replicaImageName = "dbobj.gif";
    private static RemoteImage _replicaIcon = DSUtil.getPackageImage("dbobj.gif");
    protected static ResourceSet _resource = new ResourceSet("com.netscape.admin.dirserv.panel.replication.replication");
    static final String NEW = "new";

    public ReplicaResourceObject(IDSModel iDSModel, ResourceObject resourceObject, LDAPEntry lDAPEntry, LDAPEntry lDAPEntry2) {
        super(LDAPDN.explodeDN((String)lDAPEntry.getDN(), (boolean)true)[0], _replicaIcon, _replicaIcon, iDSModel);
        this._parent = resourceObject;
        this._instEntry = lDAPEntry;
        this._mapTreeEntry = lDAPEntry2;
        this._isLeaf = this.checkIfLeaf();
    }

    private boolean checkIfLeaf() {
        AgreementTable agreementTable = new AgreementTable();
        LDAPEntry lDAPEntry = this.getReplicaEntry();
        if (lDAPEntry != null) {
            Enumeration enumeration;
            AgreementReader agreementReader = new AgreementReader(this._model, agreementTable, lDAPEntry.getDN());
            agreementReader.readAgreements();
            if (agreementReader.isSuccess() && (enumeration = (agreementTable = agreementReader.getAgreements()).elements()).hasMoreElements()) {
                return false;
            }
        }
        return true;
    }

    public IDSModel getModel() {
        return this._model;
    }

    public Component getCustomPanel() {
        Debug.println((int)8, (String)("ReplicaResourceObject.getCustomPanel: panel = " + this._panel + " replica entry = " + this._replicaEntry));
        if (this._panel == null) {
            this._panel = new ReplicaConfigTabPanel(this._model, this, this._instEntry, this._mapTreeEntry, this.getReplicaEntry());
        }
        return this._panel;
    }

    public String[] getMenuCategoryIDs() {
        if (this._categoryID == null) {
            this._categoryID = this._model.isModuleDisabled("replication") ? new String[0] : new String[]{"OBJECT", "CONTEXT"};
        }
        return this._categoryID;
    }

    public IMenuItem[] getMenuItems(String string) {
        if (string.equals("CONTEXT")) {
            if (this._contextMenuItems == null) {
                this._contextMenuItems = this.createMenuItems();
            }
            return this._contextMenuItems;
        }
        if (string.equals("OBJECT")) {
            if (this._objectMenuItems == null) {
                this._objectMenuItems = this.createMenuItems();
            }
            return this._objectMenuItems;
        }
        return null;
    }

    private IMenuItem[] createMenuItems() {
        String string = "replication-node-agreementPopupMenu";
        return new IMenuItem[]{new MenuItemText(NEW, _resource.getString(string, "New"), _resource.getString(string, "New-description")), new MenuItemSeparator(), new MenuItemText("refresh", DSUtil._resource.getString("menu", "refresh"), DSUtil._resource.getString("menu", "refresh-description"))};
    }

    public void actionMenuSelected(IPage iPage, IMenuItem iMenuItem) {
        if (iMenuItem.getID().equals("refresh")) {
            ((DSResourceModel)this._model).actionMenuSelected(iPage, iMenuItem);
        } else if (iMenuItem.getID().equals(NEW)) {
            Object object;
            Object object2;
            int n = ((DefaultMutableTreeNode)((Object)this)).getChildCount();
            boolean bl = this._isTreeCollapsed;
            if (!ReplicationTool.authenticate(this._model)) {
                return;
            }
            if (this.getReplicaEntry() == null) {
                ReplicationTool.displayError(this._model.getFrame(), "replication-err-noReplicaOrChangelog", "title", "msg", null);
                return;
            }
            boolean bl2 = false;
            try {
                object2 = this._model.getServerInfo().getLDAPConnection();
                object = object2.read("cn=changelog5,cn=config");
                if (object != null) {
                    bl2 = true;
                }
            }
            catch (LDAPException lDAPException) {
                // empty catch block
            }
            if (!bl2) {
                ReplicationTool.displayError(this._model.getFrame(), "replication-err-noReplicaOrChangelog", "title", "msg", null);
                return;
            }
            object2 = new AgreementWizardInfo();
            ((AgreementWizardInfo)object2).setServerInfo(this._model.getServerInfo());
            ((AgreementWizardInfo)object2).setConsoleInfo(this._model.getConsoleInfo());
            ((AgreementWizardInfo)object2).setParentNode(this);
            ((AgreementWizardInfo)object2).setWizardType("NEW");
            ((AgreementWizardInfo)object2).setLDAPSchema(this._model.getSchema());
            if (this._instEntry != null) {
                object = DSUtil.getAttrValue(this._instEntry, "nsslapd-suffix");
                ((AgreementWizardInfo)object2).setSubtree((String)object);
            }
            ((AgreementWizardInfo)object2).setReplicaEntry(this.getReplicaEntry());
            object = new AgreementWizard(this._model.getFrame(), (AgreementWizardInfo)object2);
            int n2 = ((DefaultMutableTreeNode)((Object)this)).getChildCount();
            if (n2 > n || !bl) {
                this.expandPath((ResourcePage)iPage);
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("refresh")) {
            Debug.println((String)"ReplicaResourceObject.actionPerformed(): Refresh Selected");
            this.reload();
            this.refreshTree();
        }
    }

    public LDAPEntry getReplicaEntry() {
        if (this._mapTreeEntry != null && this._replicaEntry == null) {
            try {
                String string = "cn=replica," + this._mapTreeEntry.getDN();
                LDAPConnection lDAPConnection = this._model.getServerInfo().getLDAPConnection();
                this._replicaEntry = lDAPConnection.read(string);
            }
            catch (LDAPException lDAPException) {
                // empty catch block
            }
        }
        return this._replicaEntry;
    }

    public boolean run(IPage iPage) {
        Debug.println((String)"ReplicaResourceObject: run()");
        this.reload();
        if (super.getChildCount() != 0) {
            this.expandPath((ResourcePage)iPage);
        }
        this.refreshTree();
        return true;
    }

    public boolean run(IPage iPage, IResourceObject[] iResourceObjectArray) {
        return this.run(iPage);
    }

    public void reload() {
        this._replicaEntry = null;
        Debug.println((int)8, (String)"ReplicaResourceObject.reload: BEGIN");
        this.cleanTree();
        if (!ReplicationTool.authenticate(this._model)) {
            return;
        }
        Debug.println((int)8, (String)"ReplicaResourceObject.reload: adding agreement nodes");
        this.addAgreementNodes();
        Debug.println((int)8, (String)"ReplicaResourceObject.reload: END");
    }

    private void addAgreementNodes() {
        this._isLeaf = true;
        if (this.getReplicaEntry() == null) {
            return;
        }
        this._model.fireChangeFeedbackCursor(null, 3);
        AgreementTable agreementTable = new AgreementTable();
        AgreementReader agreementReader = new AgreementReader(this._model, agreementTable, this.getReplicaEntry().getDN());
        agreementReader.readAgreements();
        if (agreementReader.isSuccess()) {
            agreementTable = agreementReader.getAgreements();
            Enumeration enumeration = agreementTable.elements();
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                AgreementResourceObject agreementResourceObject = null;
                if (e instanceof MMRAgreement) {
                    Debug.println((String)"Add MMR Node");
                    agreementResourceObject = new AgreementResourceObject(((ReplicationAgreement)e).getNickname(), (Icon)ReplicationTool.getImage("ds-rep-get-16.gif"), (Icon)ReplicationTool.getImage("ds-rep-get-32.gif"), this, this._parent);
                    agreementResourceObject.setAgreement((ReplicationAgreement)e);
                }
                if (e instanceof SIRAgreement) {
                    Debug.println((String)"Add Legacyr Node");
                    agreementResourceObject = new AgreementResourceObject(((ReplicationAgreement)e).getNickname(), (Icon)ReplicationTool.getImage("ds-rep-push-16.gif"), (Icon)ReplicationTool.getImage("ds-rep-push-32.gif"), this);
                    agreementResourceObject.setAgreement((ReplicationAgreement)e);
                } else {
                    Debug.println((String)("Class is " + e.getClass().getName()));
                }
                if (agreementResourceObject == null) continue;
                this._isLeaf = false;
                ((DefaultMutableTreeNode)((Object)this)).add((MutableTreeNode)((Object)agreementResourceObject));
            }
            this.refreshTree();
            this._isLoaded = true;
        }
        this._model.fireChangeFeedbackCursor(null, 0);
    }

    public boolean isLoaded() {
        return this._isLoaded;
    }

    public boolean isLeaf() {
        return this._isLeaf;
    }

    public void select(IPage iPage) {
        if (!this.isLoaded()) {
            this.reload();
        }
        super.select(iPage);
    }

    void refreshTree() {
        this._model.fireTreeStructureChanged(this);
    }

    public void contentChanged() {
        this.reload();
        this.refreshTree();
    }

    public void expandPath(ResourcePage resourcePage) {
        TreePath treePath = new TreePath(((DefaultMutableTreeNode)((Object)this)).getPath());
        resourcePage.expandTreePath(treePath);
    }

    private void cleanTree() {
        ((DefaultMutableTreeNode)((Object)this)).removeAllChildren();
    }

    public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
        IResourceObject iResourceObject = (IResourceObject)treeExpansionEvent.getPath().getLastPathComponent();
        if (this.equals(iResourceObject) && !this._isInitiallyExpanded) {
            this._isInitiallyExpanded = true;
            Debug.println((String)"ReplicaResourceObject.treeExpanded: this");
            if (!this.isLoaded()) {
                this.reload();
            }
        }
        this._isTreeCollapsed = false;
    }

    public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
        this._isTreeCollapsed = true;
    }
}

