/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.patchmgr.client;

import com.sun.admin.cis.common.AdminException;
import com.sun.admin.cis.common.Constraints;
import com.sun.admin.cis.common.ErrorDialog;
import com.sun.admin.cis.common.FlowArea;
import com.sun.admin.cis.common.ListFetchAdapter;
import com.sun.admin.cis.common.ListFetchEvent;
import com.sun.admin.cis.common.ListFetchListener;
import com.sun.admin.cis.common.ProgressPanel;
import com.sun.admin.cis.common.ResourceStrings;
import com.sun.admin.cis.common.WarningDialog;
import com.sun.admin.patchmgr.client.AnalyzeAddPatchWizard;
import com.sun.admin.patchmgr.client.AppContent;
import com.sun.admin.patchmgr.client.Content;
import com.sun.admin.patchmgr.client.DownloadPatchWizard;
import com.sun.admin.patchmgr.client.MultiSysPatchAddWiz;
import com.sun.admin.patchmgr.client.PatchAddWizard;
import com.sun.admin.patchmgr.client.PatchDetails;
import com.sun.admin.patchmgr.client.VPatchMgr;
import com.sun.admin.patchmgr.common.PatchMgrObj;
import com.sun.admin.patchmgr.common.PatchRemoveOrder;
import com.sun.admin.patchmgr.common.VerifyPatch;
import com.sun.management.viper.console.VConsoleEvent;
import com.sun.management.viper.console.VConsoleProperties;
import com.sun.management.viper.console.VScopeNode;
import com.sun.management.viper.console.gui.VBusyPanel;
import com.sun.management.viper.console.gui.VDialog;
import com.sun.management.viper.console.gui.VFrame;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.tree.MutableTreeNode;

public class AppContent
extends Content {
    public static final String ID_COLUMN = "PatchIDColHeader";
    public static final String DESCR_COLUMN = "SynopsisColHeader";
    private final Object[][] columnHeaderConfig = new Object[][]{{"SynopsisColHeader", new Integer(48)}};
    private ResourceBundle bundle;
    private VScopeNode rootNode = new VScopeNode();
    private static String[][] columnHeaders = null;
    private ImageIcon smallPatchIcon;
    private ImageIcon largePatchIcon;
    private String sortPreferencesKey;
    private VDialog dlg = null;
    private VDialog mdlg = null;
    private VDialog ddlg = null;
    private VDialog udlg = null;
    private PatchAddWizard addPatchW = null;
    private MultiSysPatchAddWiz multiSysPatchW = null;
    private DownloadPatchWizard downloadWiz = null;
    private AnalyzeAddPatchWizard analyzeWiz = null;
    private boolean bRefreshInProgress = false;
    boolean firstTime = true;
    boolean firstTimemulti = true;
    boolean firstUpgrade = true;
    boolean firstDownload = true;
    private static final String CONFIRM_REMOVE_PATCH_TITLE = "ConfirmRemovePatchTitle";
    private static final String DELETE_BUTTON_LABEL = "Delete";
    private static final String GENERIC_INFO_TITLE = "generic_info_title";

    public AppContent(VPatchMgr vPatchMgr) {
        super(vPatchMgr);
        this.rootNode.setColumnHeaders(this.getColumnHeaders());
        this.rootNode.setMenuBar((JMenuBar)vPatchMgr.getMenuBar());
        this.rootNode.setToolBar((JToolBar)vPatchMgr.getToolBar());
        this.bundle = vPatchMgr.getResourceBundle();
        this.sortPreferencesKey = this.getClass().getName() + ".sortPreferences";
        this.smallPatchIcon = vPatchMgr.loadImageIcon("patch_mgr_16.gif");
        this.largePatchIcon = vPatchMgr.loadImageIcon("patch_mgr_32.gif");
    }

    public void viewDetails() {
        Vector vector = this.getSelected();
        if (vector.isEmpty()) {
            return;
        }
        this.theApp.waitOn();
        VScopeNode vScopeNode = (VScopeNode)vector.elementAt(0);
        PatchMgrObj patchMgrObj = (PatchMgrObj)vScopeNode.getPayload();
        VFrame vFrame = new VFrame();
        PatchDetails patchDetails = new PatchDetails(this.theApp, this.theApp.getFrame(), patchMgrObj);
        this.theApp.waitOff();
        patchDetails.show();
    }

    public void installPatch() {
        if (this.firstTime) {
            this.dlg = new VDialog((Frame)this.theApp.getFrame(), false);
        }
        if (!this.dlg.isVisible()) {
            if (this.addPatchW != null) {
                this.dlg.remove((Component)((Object)this.addPatchW));
            }
            this.addPatchW = new PatchAddWizard(this.theApp, ResourceStrings.getString((ResourceBundle)this.bundle, (String)"patch_add_wiz_title"));
            this.addPatchW.setContainer((Component)this.dlg);
            this.addPatchW.init();
            this.addPatchW.start();
            this.dlg.pack();
            this.dlg.showCenter((Component)this.theApp.getProperties().getPropertyObject("vconsole.frame"));
            this.firstTime = false;
        } else {
            this.dlg.setVisible(true);
            this.dlg.requestFocusInWindow();
        }
    }

    public void installMMPatch() {
        if (this.firstTimemulti) {
            this.mdlg = new VDialog((Frame)this.theApp.getFrame(), false);
        }
        if (!this.mdlg.isVisible()) {
            if (this.multiSysPatchW != null) {
                this.mdlg.remove((Component)((Object)this.multiSysPatchW));
            }
            this.multiSysPatchW = new MultiSysPatchAddWiz(this.theApp, ResourceStrings.getString((ResourceBundle)this.bundle, (String)"mm_wiz_title"));
            this.multiSysPatchW.setContainer((Component)this.mdlg);
            this.multiSysPatchW.init();
            this.multiSysPatchW.start();
            this.mdlg.pack();
            this.mdlg.showCenter((Component)this.theApp.getProperties().getPropertyObject("vconsole.frame"));
            this.firstTimemulti = false;
        } else {
            this.mdlg.setVisible(true);
            this.mdlg.requestFocusInWindow();
        }
    }

    public void downloadPatch() {
        if (this.firstDownload) {
            this.ddlg = new VDialog((Frame)this.theApp.getFrame(), false);
        }
        if (!this.ddlg.isVisible()) {
            if (this.downloadWiz != null) {
                this.ddlg.remove((Component)((Object)this.downloadWiz));
            }
            this.downloadWiz = new DownloadPatchWizard(this.theApp, ResourceStrings.getString((ResourceBundle)this.bundle, (String)"patch_download_wiz_title"));
            this.downloadWiz.setContainer((Component)this.ddlg);
            this.downloadWiz.init();
            this.downloadWiz.start();
            this.ddlg.pack();
            this.ddlg.showCenter((Component)this.theApp.getProperties().getPropertyObject("vconsole.frame"));
            this.firstDownload = false;
        } else {
            this.ddlg.setVisible(true);
            this.ddlg.requestFocusInWindow();
        }
    }

    public void analyzePatch() {
        if (this.firstUpgrade) {
            this.udlg = new VDialog((Frame)this.theApp.getFrame(), false);
        }
        if (!this.udlg.isVisible()) {
            if (this.analyzeWiz != null) {
                this.udlg.remove((Component)((Object)this.analyzeWiz));
            }
            this.analyzeWiz = new AnalyzeAddPatchWizard(this.theApp, ResourceStrings.getString((ResourceBundle)this.bundle, (String)"patch_analyze_wiz_title"));
            this.analyzeWiz.setContainer((Component)this.udlg);
            this.analyzeWiz.init();
            this.analyzeWiz.start();
            this.udlg.pack();
            this.udlg.showCenter((Component)this.theApp.getProperties().getPropertyObject("vconsole.frame"));
            this.firstUpgrade = false;
        } else {
            this.udlg.setVisible(true);
            this.udlg.requestFocusInWindow();
        }
    }

    public void deleteSelected() {
        Thread thread = new Thread(){

            public void run() {
                Object object;
                Object object2;
                Object object3;
                if (!AppContent.this.theApp.getpatchM().hasPatchWriteAuthorization()) {
                    return;
                }
                Vector vector = AppContent.this.getSelected();
                if (vector.isEmpty()) {
                    return;
                }
                ResourceBundle resourceBundle = AppContent.this.theApp.getResourceBundle();
                JPanel jPanel = new JPanel();
                jPanel.setLayout(new GridBagLayout());
                int n = 0;
                try {
                    n = Integer.parseInt(ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"ConfirmDeleteNumColumns"));
                }
                catch (NumberFormatException numberFormatException) {
                    n = 30;
                }
                FlowArea flowArea = new FlowArea(ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"ConfirmRemovePatch"), n);
                flowArea.setSize(flowArea.getPreferredSize());
                Constraints.constrain((Container)jPanel, (Component)flowArea, (int)0, (int)0, (int)2, (int)1, (int)20, (int)5, (int)0, (int)5);
                flowArea = new FlowArea(ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"ConfirmRemovePatchWill"), n);
                flowArea.setSize(flowArea.getPreferredSize());
                Constraints.constrain((Container)jPanel, (Component)flowArea, (int)0, (int)1, (int)2, (int)1, (int)20, (int)5, (int)10, (int)5);
                ImageIcon imageIcon = AppContent.this.theApp.loadImageIcon("warning_bullet_icon.gif");
                JButton jButton = new JButton(imageIcon);
                jButton.setMargin(new Insets(0, 0, 0, 0));
                jButton.setBorderPainted(false);
                Constraints.constrain((Container)jPanel, (Component)jButton, (int)0, (int)2, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0, (int)0, (int)10, (int)10, (int)5);
                flowArea = new FlowArea(ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"ConfirmRemovePatchBullet1"), n - 5);
                flowArea.setSize(flowArea.getPreferredSize());
                String string = ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"RemovePatchTitle");
                int n2 = Math.max(string.length(), 10);
                ProgressPanel progressPanel = new ProgressPanel(AppContent.this.theApp.getFrame(), 1, n2, true);
                progressPanel.setTitle(string);
                ActionListener actionListener = new ActionListener(this, vector, progressPanel, resourceBundle){
                    private final /* synthetic */ Vector val$vSelected;
                    private final /* synthetic */ ProgressPanel val$progressPanel;
                    private final /* synthetic */ ResourceBundle val$bundle;
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = var1_1;
                        this.val$vSelected = vector;
                        this.val$progressPanel = progressPanel;
                        this.val$bundle = resourceBundle;
                    }

                    public void actionPerformed(ActionEvent actionEvent) {
                        1.access$000(this.this$1).theApp.getMenuBar().disableAdd();
                        1.access$000(this.this$1).theApp.getMenuBar().disableMultiSysAdd();
                        1.access$000(this.this$1).theApp.getMenuBar().disableAnalyzeAdd();
                        1.access$000(this.this$1).theApp.getMenuBar().disableDownload();
                        Thread thread = new Thread(this){
                            private final /* synthetic */ 2 this$2;
                            {
                                this.this$2 = var1_1;
                            }

                            public void run() {
                                Object object;
                                Object object2;
                                if (2.access$100(this.this$2).size() == 1) {
                                    2.access$200(this.this$2).setIndeterminate(true);
                                } else {
                                    2.access$200(this.this$2).setRange(0, 2.access$100(this.this$2).size() + 1);
                                    2.access$200(this.this$2).setValue(0);
                                }
                                2.access$200(this.this$2).setVisible(true);
                                2.access$200(this.this$2).toFront();
                                Vector<String> vector = new Vector<String>();
                                Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
                                int n = 0;
                                while (n < 2.access$100(this.this$2).size()) {
                                    object2 = (VScopeNode)2.access$100(this.this$2).elementAt(n);
                                    object = (PatchMgrObj)object2.getPayload();
                                    vector.add(((PatchMgrObj)object).getPatchName());
                                    hashtable.put(((PatchMgrObj)object).getPatchName(), object);
                                    ++n;
                                }
                                object2 = (Vector)1.access$000(2.access$300(this.this$2)).theApp.getInstalledPatches().clone();
                                object = new PatchRemoveOrder(vector, (Vector)object2);
                                Vector vector2 = new Vector();
                                try {
                                    vector2 = ((PatchRemoveOrder)object).getRemoveOrder();
                                }
                                catch (AdminException adminException) {
                                    1.access$000(2.access$300(this.this$2)).theApp.reportErrorException((Exception)((Object)adminException));
                                }
                                Object[] objectArray = new Object[4];
                                if (vector2 != null) {
                                    int n2 = 0;
                                    while (n2 < vector2.size()) {
                                        Object object3;
                                        String string;
                                        Object object4;
                                        try {
                                            object4 = (PatchMgrObj)hashtable.get(vector2.elementAt(n2));
                                            string = ResourceStrings.getString((ResourceBundle)2.access$400(this.this$2), (String)"RemovingPatches");
                                            object3 = new Object[]{((PatchMgrObj)object4).getPatchName()};
                                            objectArray[0] = object3[0];
                                            2.access$200(this.this$2).setText(MessageFormat.format(string, object3));
                                            1.access$000(2.access$300(this.this$2)).theApp.getpatchM().deletePatchData((PatchMgrObj)object4);
                                            1.access$000(2.access$300(this.this$2)).removeFromResultsPane((PatchMgrObj)object4);
                                        }
                                        catch (Exception exception) {
                                            1.access$000(2.access$300(this.this$2)).theApp.reportErrorException(exception);
                                        }
                                        2.access$200(this.this$2).setValue(n2 + 1);
                                        2.access$200(this.this$2).toFront();
                                        object4 = 1.access$000(2.access$300(this.this$2)).theApp.getServerName();
                                        string = "/usr/sadm/bin/smpatch remove";
                                        object3 = " -H " + (String)object4;
                                        objectArray[1] = object4;
                                        objectArray[2] = string + (String)object3 + " --" + " \\";
                                        objectArray[3] = " -i " + objectArray[0];
                                        VConsoleEvent vConsoleEvent = new VConsoleEvent((Object)1.access$000(2.access$300(this.this$2)).theApp, "vconsole.appendcommandlog", (Object)MessageFormat.format(ResourceStrings.getString((ResourceBundle)2.access$400(this.this$2), (String)"CLIDeletePatch"), objectArray));
                                        1.access$000(2.access$300(this.this$2)).theApp.fireConsoleAction(vConsoleEvent);
                                        ++n2;
                                    }
                                }
                                1.access$000(2.access$300(this.this$2)).clearSelection();
                                2.access$200(this.this$2).setValue(2.access$200(this.this$2).getValue() + 1);
                                try {
                                    Thread.sleep(500L);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                2.access$200(this.this$2).setVisible(false);
                                2.access$200(this.this$2).dispose();
                                1.access$000(2.access$300(this.this$2)).theApp.getMenuBar().enableAdd();
                                1.access$000(2.access$300(this.this$2)).theApp.getMenuBar().enableMultiSysAdd();
                                1.access$000(2.access$300(this.this$2)).theApp.getMenuBar().enableAnalyzeAdd();
                                1.access$000(2.access$300(this.this$2)).theApp.getMenuBar().enableDownload();
                            }
                        };
                        thread.start();
                    }

                    static /* synthetic */ Vector access$100(2 var0) {
                        return var0.val$vSelected;
                    }

                    static /* synthetic */ ProgressPanel access$200(2 var0) {
                        return var0.val$progressPanel;
                    }

                    static /* synthetic */ 1 access$300(2 var0) {
                        return var0.this$1;
                    }

                    static /* synthetic */ ResourceBundle access$400(2 var0) {
                        return var0.val$bundle;
                    }
                };
                AppContent.this.theApp.waitOn();
                ProgressPanel progressPanel2 = new ProgressPanel(AppContent.this.theApp.getFrame(), 2, 30, false);
                progressPanel2.setTitle(ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"VerifyTitle"));
                progressPanel2.setText(ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"VerifyingPatches"));
                progressPanel2.setVisible(true);
                Vector<Object> vector2 = new Vector<Object>();
                int n3 = 0;
                while (n3 < vector.size()) {
                    try {
                        object3 = (VScopeNode)vector.elementAt(n3);
                        object2 = (PatchMgrObj)object3.getPayload();
                        object = ((PatchMgrObj)object2).getPatchName();
                        vector2.add(object);
                    }
                    catch (Exception exception) {
                        AppContent.this.theApp.reportErrorException(exception);
                        progressPanel2.setVisible(false);
                        progressPanel2.dispose();
                    }
                    ++n3;
                }
                object3 = (Vector)AppContent.this.theApp.getInstalledPatches().clone();
                object2 = null;
                object = new Vector();
                object2 = VerifyPatch.verifyPatchesToRemove(vector2, (Vector)object3, (Vector)object, resourceBundle);
                AppContent.this.theApp.waitOff();
                progressPanel2.setVisible(false);
                progressPanel2.dispose();
                if (object2 != null) {
                    ErrorDialog errorDialog = new ErrorDialog(AppContent.this.theApp.getFrame(), (String)object2);
                } else {
                    String string2 = VerifyPatch.coaleseMessages((Vector)object);
                    if (string2 != null) {
                        AppContent.this.displayInfoDialog(AppContent.GENERIC_INFO_TITLE, string2);
                    }
                    AppContent.this.displayWarnDialog(AppContent.CONFIRM_REMOVE_PATCH_TITLE, AppContent.DELETE_BUTTON_LABEL, actionListener, jPanel);
                }
            }

            static /* synthetic */ AppContent access$000(1 var0) {
                return var0.AppContent.this;
            }
        };
        thread.start();
    }

    public void displayInfoDialog(String string, String string2) {
        String string3 = ResourceStrings.getString((ResourceBundle)this.bundle, (String)GENERIC_INFO_TITLE);
        ErrorDialog errorDialog = new ErrorDialog(this.theApp.getFrame(), string3, string2, true);
    }

    public void displayWarnDialog(String string, String string2, ActionListener actionListener, JPanel jPanel) {
        String string3 = ResourceStrings.getString((ResourceBundle)this.bundle, (String)string);
        String string4 = ResourceStrings.getString((ResourceBundle)this.bundle, (String)string2);
        WarningDialog warningDialog = new WarningDialog(this.theApp.getFrame(), string3, jPanel, actionListener, string4);
    }

    public void find(Object object) {
    }

    public String whatAmI() {
        return "Patch Manager root node";
    }

    public String getSortAttribute() {
        return ID_COLUMN;
    }

    public String[][] getColumnHeaders() {
        if (columnHeaders == null) {
            columnHeaders = this.constructColumnHeaders(this.columnHeaderConfig);
        }
        return columnHeaders;
    }

    public void setDefaultColumnHeader() {
        ResourceBundle resourceBundle = this.theApp.getResourceBundle();
        VConsoleProperties vConsoleProperties = this.theApp.getProperties();
        vConsoleProperties.setPropertyObject("vconsole.defaultcolumnheader", (Object)ResourceStrings.getString((ResourceBundle)resourceBundle, (String)ID_COLUMN));
    }

    public Hashtable getColumnValues(ResourceBundle resourceBundle, PatchMgrObj patchMgrObj) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        String string = ResourceStrings.getString((ResourceBundle)resourceBundle, (String)ID_COLUMN);
        hashtable.put(string, patchMgrObj.getPatchName());
        string = ResourceStrings.getString((ResourceBundle)resourceBundle, (String)DESCR_COLUMN);
        hashtable.put(string, patchMgrObj.getDescription());
        return hashtable;
    }

    private void appendToResultsPane(Vector vector) {
        PatchMgrObj patchMgrObj;
        String string = this.treeNode.getHTMLText();
        int n = 0;
        while (n < vector.size()) {
            patchMgrObj = (PatchMgrObj)vector.elementAt(n);
            VScopeNode vScopeNode = new VScopeNode(null, null, null, null, null, this.theApp.getMenuBar().getPopupMenu(), this.smallPatchIcon, this.largePatchIcon, patchMgrObj.getPatchName(), null, null, -1, (Object)patchMgrObj);
            vScopeNode.setHTMLText(string);
            vScopeNode.setDescription(patchMgrObj.getDescription());
            this.rootNode.add((MutableTreeNode)vScopeNode);
            this.vDataCache.addElement(patchMgrObj);
            ++n;
        }
        patchMgrObj = new VConsoleEvent((Object)this.theApp, "vconsole.updatescope", (Object)this.getTreeNode());
        this.theApp.fireConsoleAction((VConsoleEvent)patchMgrObj);
    }

    public void removeFromResultsPane(PatchMgrObj patchMgrObj) {
        int n = 0;
        while (n < this.rootNode.getChildCount()) {
            VScopeNode vScopeNode = (VScopeNode)this.rootNode.getChildAt(n);
            PatchMgrObj patchMgrObj2 = (PatchMgrObj)vScopeNode.getPayload();
            if (patchMgrObj2 == patchMgrObj) {
                this.rootNode.remove((MutableTreeNode)vScopeNode);
                VConsoleEvent vConsoleEvent = new VConsoleEvent((Object)this.theApp, "vconsole.updatescope", (Object)this.getTreeNode());
                this.theApp.fireConsoleAction(vConsoleEvent);
                break;
            }
            ++n;
        }
        this.vDataCache.removeElement(patchMgrObj);
    }

    public void refresh() {
        if (!this.isRefreshInProgress()) {
            this.setRefreshInProgress(true);
            this.vDataCache.removeAllElements();
            System.gc();
            this.clear();
            this.theApp.setInfoBar("");
            MyListFetch myListFetch = new MyListFetch(this.getServerChunkSize(), this.getDisplayChunkSize());
            String string = ResourceStrings.getString((ResourceBundle)this.bundle, (String)"FetchPatches");
            final String string2 = ResourceStrings.getString((ResourceBundle)this.bundle, (String)"FetchPatchesDone");
            if (!(this.treeNode.getResultPane() instanceof VBusyPanel)) {
                this.treeNode.setResultPane((Component)new VBusyPanel(string));
                this.theApp.fireConsoleAction(new VConsoleEvent((Object)this.theApp, "vconsole.updatescope", (Object)this.theApp.getScopeNode()));
            }
            this.theApp.setStatusBar(string);
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            myListFetch.addListFetchListener(new ListFetchListener(){

                public synchronized void batchReady(ListFetchEvent listFetchEvent) {
                    Vector vector = listFetchEvent.getBatch();
                    if (vector == null) {
                        AppContent.this.theApp.setStatusBar(string2);
                        AppContent.this.treeNode.setResultPane(null);
                        AppContent.this.theApp.fireConsoleAction(new VConsoleEvent((Object)AppContent.this.theApp, "vconsole.updatescope", (Object)AppContent.this.treeNode));
                        AppContent.this.updateInfoBar();
                        AppContent.this.theApp.waitOff();
                        return;
                    }
                    AppContent.this.appendToResultsPane(vector);
                }

                public synchronized void errorException(Exception exception) {
                    AppContent.this.theApp.reportErrorException(exception);
                }
            });
            this.theApp.waitOn();
            myListFetch.start();
            this.bRefresh = true;
            this.setRefreshInProgress(false);
            String string3 = this.theApp.getServerName();
            String string4 = "/usr/bin/showrev -p";
            Object[] objectArray = new String[]{string3, string3, string4};
            VConsoleEvent vConsoleEvent = new VConsoleEvent((Object)this.theApp, "vconsole.appendcommandlog", (Object)MessageFormat.format(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"CLIListPatches"), objectArray));
            this.theApp.fireConsoleAction(vConsoleEvent);
        }
    }

    private int getServerChunkSize() {
        return 0;
    }

    private int getDisplayChunkSize() {
        return 0;
    }

    public void clear() {
        this.clearSelection();
        this.getDataCache().removeAllElements();
        this.rootNode.removeAllChildren();
        System.gc();
        if (this.treeNode.getInternalRoot() == null) {
            this.treeNode.setInternalRoot(this.rootNode);
        }
        VConsoleEvent vConsoleEvent = new VConsoleEvent((Object)this.theApp, "vconsole.updatescope", (Object)this.treeNode);
        this.theApp.fireConsoleAction(vConsoleEvent);
        this.bRefresh = true;
    }

    public synchronized boolean isRefreshInProgress() {
        return this.bRefreshInProgress;
    }

    private void setRefreshInProgress(boolean bl) {
        this.bRefreshInProgress = bl;
    }

    public void updateInfoBar() {
        String string = ResourceStrings.getString((ResourceBundle)this.bundle, (String)"patchContents");
        Object[] objectArray = new Object[]{new Integer(this.getDataCache().size())};
        String string2 = MessageFormat.format(string, objectArray);
        this.theApp.setInfoBar(string2);
    }

    public void updateSortPreferences() {
        VConsoleProperties vConsoleProperties = this.theApp.getProperties();
        String string = vConsoleProperties.getProperty(this.sortPreferencesKey);
        if (string == null || string.equals("null")) {
            return;
        }
        String string2 = "vconsole.sortup";
        if (string.indexOf(45) >= 0) {
            string2 = "vconsole.sortdown";
        }
        Integer[] integerArray = new Integer[1];
        try {
            int n = Integer.parseInt(string.substring(1));
            integerArray[0] = new Integer(n);
        }
        catch (Exception exception) {
            integerArray[0] = new Integer(0);
        }
        VConsoleEvent vConsoleEvent = new VConsoleEvent((Object)this.theApp, string2, (Object)integerArray);
        this.theApp.fireConsoleAction(vConsoleEvent);
        vConsoleProperties.setProperty("vconsole.sortedcolumn", string);
    }

    public void saveSortPreferences() {
        VConsoleProperties vConsoleProperties = this.theApp.getProperties();
        vConsoleProperties.setProperty(this.sortPreferencesKey, vConsoleProperties.getProperty("vconsole.sortedcolumn"));
    }

    class MyListFetch
    extends ListFetchAdapter {
        public MyListFetch(int n, int n2) {
            super(n, n2);
        }

        public Vector listAll() throws AdminException {
            Vector vector = AppContent.this.theApp.getInstalledPatches();
            if (vector == null || vector.size() == 0) {
                vector = new Vector(0);
            }
            return vector;
        }
    }
}

