/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.patchmgr.client;

import com.sun.admin.cis.common.AdminException;
import com.sun.admin.cis.common.IClientResource;
import com.sun.admin.cis.common.ResourceStrings;
import com.sun.admin.patchmgr.client.ServiceWrapper;
import com.sun.admin.patchmgr.client.WbemServiceWrapper;
import com.sun.admin.patchmgr.common.PatchException;
import com.sun.management.viper.AdminMgmtScope;
import com.sun.management.viper.ToolContext;
import com.sun.management.viper.ToolInfrastructure;
import com.sun.management.viper.client.ExternalClientList;
import java.util.ResourceBundle;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMNameSpace;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMQualifier;
import javax.wbem.client.CIMClient;

public class ApplicationContext {
    private IClientResource theApp;
    private ToolContext toolContext;
    private AdminMgmtScope scope = null;
    private static int MAX_RETRIES = 2;
    private static String SOLARIS_PATCH = "Solaris_Patch";
    private static String VERSION = "Version";
    private static String REQUIRED_VERSION = "1.3.0";

    public ApplicationContext(IClientResource iClientResource, ToolContext toolContext) {
        this.theApp = iClientResource;
        this.toolContext = toolContext;
        this.scope = (AdminMgmtScope)toolContext.getParameter("ToolContext.MGMTSCOPE");
    }

    public ApplicationContext(IClientResource iClientResource, ToolContext toolContext, AdminMgmtScope adminMgmtScope) {
        this.theApp = iClientResource;
        this.toolContext = toolContext;
        this.scope = adminMgmtScope;
    }

    public ToolContext getToolContext() {
        return this.toolContext;
    }

    private String getServiceType() {
        String string = "Wbem";
        try {
            String string2 = System.getProperty("Patchmgr.serviceType");
            if (string2 != null) {
                string = string2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    private void checkClassVersion(CIMClient cIMClient, String string, String string2) throws PatchException {
        String string3 = "";
        try {
            CIMObjectPath cIMObjectPath = new CIMObjectPath(string);
            CIMClass cIMClass = cIMClient.getClass(cIMObjectPath, true);
            CIMQualifier cIMQualifier = cIMClass.getQualifier(VERSION);
            string3 = (String)cIMQualifier.getValue().getValue();
        }
        catch (Exception exception) {
            throw new PatchException("EXM_PROVIDER_VERSION_MISMATCH", (Object)this.getMGMTserverName(), string2);
        }
        if (!string3.equals(string2)) {
            throw new PatchException("EXM_PROVIDER_VERSION_MISMATCH", (Object)this.getMGMTserverName(), (Object)string3, string2);
        }
    }

    public String getMGMTserverName() {
        String string = "";
        string = this.scope.getMgmtServerName();
        return string;
    }

    public ServiceWrapper getServiceWrapper(ToolInfrastructure toolInfrastructure) throws AdminException {
        ResourceBundle resourceBundle = this.theApp.getResourceBundle();
        String string = this.getServiceType();
        String string2 = "com.sun.admin.patchmgr.client." + string + "ServiceWrapper";
        ServiceWrapper serviceWrapper = null;
        try {
            serviceWrapper = (ServiceWrapper)Class.forName(string2).newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new PatchException("EXM_PM_GUI_SERVICE_NOT_REACHABLE", (Object)string, (Object)ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"BEANNAME"), string2);
        }
        catch (Exception exception) {
            PatchException patchException = new PatchException("EXM_PM_GUI_CANT_GET_SERVICE_WRAPPER", (Object)string, (Object)ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"BEANNAME"), string2);
            patchException.addArg(exception.getMessage());
            throw patchException;
        }
        int n = MAX_RETRIES;
        String string3 = "";
        CIMClient cIMClient = null;
        while (n > 0) {
            --n;
            try {
                if (serviceWrapper instanceof WbemServiceWrapper) {
                    string3 = this.scope.getMgmtServerName();
                    CIMNameSpace cIMNameSpace = new CIMNameSpace(string3, "root\\cimv2");
                    Object[] objectArray = new Object[]{cIMNameSpace, new String("cim-rmi")};
                    cIMClient = (CIMClient)toolInfrastructure.getExternalClient(ExternalClientList.JAVAXWBEM, objectArray);
                    serviceWrapper.init(cIMClient, toolInfrastructure, this.scope);
                    break;
                }
                n = 0;
            }
            catch (Exception exception) {
                if (exception.getMessage().equals("TIMED_OUT") && n > 0) continue;
                if (exception.getMessage().equals("NO_CIMOM")) {
                    throw new PatchException("EXM_PM_CANT_CONNECT_NO_CIMOM", ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"BEANNAME"));
                }
                throw new PatchException("EXM_PM_CANT_CONNECT_TO_SERVER", (Object)ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"BEANNAME"), exception.getMessage());
            }
        }
        this.checkClassVersion(cIMClient, SOLARIS_PATCH, REQUIRED_VERSION);
        return serviceWrapper;
    }
}

