/*
 * Decompiled with CFR 0.152.
 */
package tyrex.security.container;

import java.security.AccessController;
import java.util.Vector;
import javax.security.auth.AuthPermission;

public final class RoleCredentials {
    private transient RoleEntry[] _roles = new RoleEntry[29];
    private static final int RoleTableSize = 29;

    public RoleCredentials(String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            this.addRole(stringArray[n]);
            ++n;
        }
    }

    public RoleCredentials(RoleCredentials[] roleCredentialsArray) {
        int n = 0;
        while (n < roleCredentialsArray.length) {
            int n2 = 0;
            while (n2 < roleCredentialsArray[n]._roles.length) {
                RoleEntry roleEntry = roleCredentialsArray[n]._roles[n2];
                while (roleEntry != null) {
                    this.addRole(roleEntry.roleName);
                    roleEntry = roleEntry.next;
                }
                ++n2;
            }
            ++n;
        }
    }

    private void addRole(String string) {
        int n = (string.hashCode() & Integer.MAX_VALUE) % this._roles.length;
        RoleEntry roleEntry = this._roles[n];
        while (roleEntry != null && !roleEntry.roleName.equals(string)) {
            roleEntry = roleEntry.next;
        }
        if (roleEntry == null) {
            this._roles[n] = roleEntry = new RoleEntry(string, this._roles[n]);
        }
    }

    public void destroy() {
        AccessController.checkPermission(new AuthPermission("destroyCredentials"));
        this._roles = null;
    }

    public boolean isDestroyed() {
        return this._roles == null;
    }

    public boolean isInRole(String string) {
        if (this._roles == null) {
            throw new IllegalStateException("These credentials have been destroyed");
        }
        int n = (string.hashCode() & Integer.MAX_VALUE) % this._roles.length;
        RoleEntry roleEntry = this._roles[n];
        while (roleEntry != null && !roleEntry.roleName.equals(string)) {
            roleEntry = roleEntry.next;
        }
        return roleEntry != null;
    }

    public String[] listRoles() {
        if (this._roles == null) {
            throw new IllegalStateException("These credentials have been destroyed");
        }
        Vector<String> vector = new Vector<String>();
        int n = 0;
        while (n < this._roles.length) {
            RoleEntry roleEntry = this._roles[n];
            while (roleEntry != null) {
                vector.add(roleEntry.roleName);
                roleEntry = roleEntry.next;
            }
            ++n;
        }
        return vector.toArray(new String[vector.size()]);
    }

    static class RoleEntry {
        String roleName;
        RoleEntry next;

        RoleEntry(String string, RoleEntry roleEntry) {
            this.roleName = string;
            this.next = roleEntry;
        }
    }
}

