/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.panel;

import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.IDSModel;
import com.netscape.admin.dirserv.panel.BlankPanel;
import com.netscape.admin.dirserv.panel.GroupPanel;
import com.netscape.admin.dirserv.panel.RefreshablePanel;
import com.netscape.management.client.IPage;
import com.netscape.management.client.IResourceObject;
import com.netscape.management.client.util.ResourceSet;
import com.sun.java.swing.JComponent;
import com.sun.java.swing.JPanel;
import com.sun.java.swing.JScrollPane;
import com.sun.java.swing.JTable;
import com.sun.java.swing.border.Border;
import com.sun.java.swing.border.TitledBorder;
import com.sun.java.swing.table.AbstractTableModel;
import com.sun.java.swing.table.DefaultTableCellRenderer;
import com.sun.java.swing.table.TableColumn;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Enumeration;
import java.util.Vector;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;

public class MonitorBasePanel
extends RefreshablePanel {
    protected LDAPEntry _entry;
    protected LDAPConnection _ldc;
    protected String _entryName = "cn=monitor";
    protected Vector _tables = new Vector();
    private boolean _isSelected = false;
    protected static final int PREFERRED_WIDTH = 500;
    static final ResourceSet _resource = DSUtil._resource;

    public MonitorBasePanel(IDSModel model, String title) {
        super(model, title, true);
    }

    public void select(IResourceObject parent, IPage viewInstance) {
        if (!((BlankPanel)this)._isInitialized) {
            this.init();
            ((BlankPanel)this)._isInitialized = true;
        }
        this.refresh();
        this._isSelected = true;
        if (this._refreshCheckbox.isSelected()) {
            this.startUpdater();
        }
    }

    public void unselect(IResourceObject parent, IPage viewInstance) {
        this._isSelected = false;
        this.stopUpdater();
    }

    public boolean refresh() {
        Enumeration en = this._tables.elements();
        while (en.hasMoreElements()) {
            JTable table = (JTable)en.nextElement();
            table.repaint();
        }
        return true;
    }

    protected String getAttrValue(LDAPEntry entry, String attrName) {
        Enumeration e;
        LDAPAttribute attr;
        if (entry != null && (attr = entry.getAttribute(attrName)) != null && (e = attr.getStringValues()).hasMoreElements()) {
            return (String)e.nextElement();
        }
        return "";
    }

    protected String getAttrValue(String attrName) {
        return this.getAttrValue(this._entry, attrName);
    }

    protected void setColumnWidths(JTable table, int[] widths) {
    }

    protected void setColumnHeaders(JTable table, String[] headers) {
        Enumeration en = table.getColumnModel().getColumns();
        int i = 0;
        while (en.hasMoreElements()) {
            TableColumn col = (TableColumn)en.nextElement();
            col.setHeaderValue((Object)headers[i]);
            ++i;
        }
    }

    protected int getTotalColumnWidth(JTable table) {
        Enumeration en = table.getColumnModel().getColumns();
        int width = 0;
        while (en.hasMoreElements()) {
            TableColumn col = (TableColumn)en.nextElement();
            width += col.getWidth();
        }
        return width;
    }

    private Dimension getOptimalDimension(JTable table, JComponent container) {
        int width = this.getTotalColumnWidth(table);
        Dimension d = new Dimension(width, table.getRowHeight() * table.getRowCount() + 8);
        Insets ins = container.getInsets();
        width = container.getWidth() - ins.left - ins.right;
        d.width = Math.max(d.width, width);
        return d;
    }

    private void setupTable(JTable table, JComponent container) {
        Dimension d = this.getOptimalDimension(table, container);
        table.setMinimumSize(d);
        table.setSize(d);
        table.getTableHeader().setReorderingAllowed(false);
        table.setRowSelectionAllowed(false);
        table.setColumnSelectionAllowed(false);
        table.setAutoResizeMode(1);
        table.sizeColumnsToFit(true);
    }

    protected void addTable(JTable table, JComponent myContainer, String key) {
        this.addTableInScrollPane(table, myContainer, key);
    }

    protected void addTableInScrollPane(JTable table, JComponent container, String titleString) {
        JScrollPane scrollpane = new JScrollPane((Component)table);
        TitledBorder title = new TitledBorder(titleString);
        JPanel outer = new JPanel((LayoutManager)new GridBagLayout());
        outer.setBorder((Border)title);
        scrollpane.setHorizontalScrollBarPolicy(31);
        scrollpane.setVerticalScrollBarPolicy(21);
        ((BlankPanel)this)._gbc.gridwidth = 0;
        ((BlankPanel)this)._gbc.fill = 1;
        outer.add((Component)scrollpane, ((BlankPanel)this)._gbc);
        ((BlankPanel)this)._gbc.fill = 2;
        container.add((Component)outer, ((BlankPanel)this)._gbc);
        this.setupTable(table, container);
        Dimension d = this.getOptimalDimension(table, container);
        table.setPreferredScrollableViewportSize(d);
    }

    protected void addTableInGroupPane(JTable table, JComponent container, String titleString) {
        GroupPanel panel = new GroupPanel(titleString);
        panel.add((Component)table, ((BlankPanel)this)._gbc);
        this.setupTable(table, container);
        ((BlankPanel)this)._gbc.insets = new Insets(10, 0, 2, 2);
        ((BlankPanel)this)._gbc.gridwidth = 0;
        ((BlankPanel)this)._gbc.fill = 2;
        container.add((Component)panel, ((BlankPanel)this)._gbc);
    }

    class RightAlignedCellRenderer
    extends DefaultTableCellRenderer {
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setHorizontalAlignment(4);
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }

        RightAlignedCellRenderer() {
            MonitorBasePanel.this = MonitorBasePanel.this;
        }
    }

    class PerfTableModel
    extends AbstractTableModel {
        protected String[] _labels;
        protected String[] _headers;
        protected String[] _dataNames;

        PerfTableModel(String[] labels, String[] headers, String[] dataNames) {
            MonitorBasePanel.this = MonitorBasePanel.this;
            this._labels = labels;
            this._headers = headers;
            this._dataNames = dataNames;
        }

        public void notifyChanges() {
            this.fireTableDataChanged();
        }

        public int getColumnCount() {
            return this._headers.length;
        }

        public int getRowCount() {
            return this._labels.length;
        }

        public Object getValueAt(int row, int col) {
            String val;
            if (col == 0) {
                val = this._labels[row];
            } else {
                val = MonitorBasePanel.this.getAttrValue(this._dataNames[row]);
                if (val == null || val.length() < 1) {
                    return "";
                }
                if (col != 1) {
                    int runningTime = 1;
                    int value = Integer.parseInt(val);
                    val = Integer.toString(value / runningTime);
                }
            }
            return val;
        }

        public String getColumnName(int columnIndex) {
            return this._headers[columnIndex];
        }
    }
}

