/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.im.iiimp;

import com.sun.iiim.IIIMActionEvent;
import com.sun.iiim.IIIMActionListener;
import com.sun.iiim.IIIMAuxEvent;
import com.sun.iiim.IIIMAuxListener;
import com.sun.iiim.IIIMCommittedEvent;
import com.sun.iiim.IIIMEvent;
import com.sun.iiim.IIIMListener;
import com.sun.iiim.IIIMLookupEvent;
import com.sun.iiim.IIIMLookupListener;
import com.sun.iiim.IIIMPreeditEvent;
import com.sun.iiim.IIIMPreeditListener;
import com.sun.iiim.IIIMStatusEvent;
import com.sun.iiim.IIIMStatusListener;
import com.sun.iiim.IMProvider;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashSet;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import sun.awt.im.InputMethodAdapter;
import sun.awt.im.iiimp.IIIMAuxListeners;
import sun.awt.im.iiimp.IIIMCommittedListener;
import sun.awt.im.iiimp.IIIMFAdapter;
import sun.awt.im.iiimp.IIIMKeyEvent;
import sun.awt.im.iiimp.ManageRule;
import sun.awt.im.iiimp.ODClassLoader;
import sun.awt.im.iiimp.ProtocolDriver;

public class Manager {
    private ManageRule rule;
    private IIIMPreeditListener preeditListener;
    private IIIMCommittedListener committedListener;
    private IIIMLookupListener lookupListener;
    private IIIMStatusListener statusListener;
    private IIIMActionListener actionListener;
    private IIIMAuxListener auxListeners;
    private IIIMFAdapter adapter;
    private static ProtocolDriver protocolDriver = null;
    private static final String PCE_CLASSNAME = "sun.awt.im.iiimp.PCE";
    private static final String DEFAULT_RULE = " sun.awt.im.iiimp.ProtocolDriver";
    private static final String TEST_RULE = "sun.awt.im.iiimp.LWE1 sun.awt.im.iiimp.LWE2";
    private static final String PCE_TEST_RULE = "sun.awt.im.iiimp.PCE sun.awt.im.iiimp.PseudoPD";
    private static String defaultRuleString;
    private static String currentRuleString;
    public static boolean DEBUG;
    public static boolean COLOR_SUPPORT;
    public static boolean NO_STATUS;
    private static IIIMKeyEvent toggleKey;
    private static IIIMKeyEvent editHotKey;
    private static HashSet ruleTable;
    private static Manager manager;
    private static ODClassLoader loader;
    private static Properties iiimProps;
    private static String userPropsFile;
    Locale currentLocale = null;

    static void setPD(ProtocolDriver protocolDriver) {
        Manager.protocolDriver = protocolDriver;
        String[] stringArray = protocolDriver.getEngineScript();
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                ruleTable.add(new ManageRule(stringArray[n]));
                ++n;
            }
        }
    }

    private static void collectRules() {
        String string = Manager.getProperty("iiimf.manager.rules", defaultRuleString);
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            ruleTable.add(new ManageRule(string2));
        }
    }

    private Manager() {
        Manager.initProps();
        DEBUG = Manager.getProperty("iiimf.manager.debug", "false").equals("true");
        COLOR_SUPPORT = Manager.getProperty("iiimf.gui.color", "false").equals("true");
        NO_STATUS = Manager.getProperty("iiimf.status.none", "false").equals("true");
        defaultRuleString = Manager.getProperty("iiimf.manager.rule", DEFAULT_RULE);
        currentRuleString = Manager.getProperty("iiimf.manager.rule.userpref", defaultRuleString);
    }

    void setManageRule(ManageRule manageRule) {
        this.rule = manageRule;
    }

    void setCCDEF(String string) {
        this.rule.setCCDEF(string);
    }

    public static Manager getInstance() {
        if (manager == null) {
            manager = new Manager();
            manager.setManageRule(new ManageRule(currentRuleString));
            Manager.collectRules();
        }
        return manager;
    }

    static void setLoader(ODClassLoader oDClassLoader) {
        loader = oDClassLoader;
    }

    public static ODClassLoader getLoader() {
        return loader;
    }

    void setIIIMFAdapter(IIIMFAdapter iIIMFAdapter) {
        this.adapter = iIIMFAdapter;
    }

    void setIIIMActionListener(IIIMActionListener iIIMActionListener) {
        this.actionListener = iIIMActionListener;
    }

    void setIIIMPreeditListener(IIIMPreeditListener iIIMPreeditListener) {
        this.preeditListener = iIIMPreeditListener;
    }

    IIIMPreeditListener getIIIMPreeditListener() {
        return this.preeditListener;
    }

    void setIIIMCommittedListener(IIIMCommittedListener iIIMCommittedListener) {
        this.committedListener = iIIMCommittedListener;
    }

    IIIMCommittedListener getIIIMCommittedListener() {
        return this.committedListener;
    }

    void setIIIMLookupListener(IIIMLookupListener iIIMLookupListener) {
        this.lookupListener = iIIMLookupListener;
    }

    void setIIIMStatusListener(IIIMStatusListener iIIMStatusListener) {
        this.statusListener = iIIMStatusListener;
    }

    void setIIIMAuxListener(IIIMAuxListener iIIMAuxListener) {
        this.auxListeners = IIIMAuxListeners.add(this.auxListeners, iIIMAuxListener);
    }

    void dispatchEvent(IIIMEvent iIIMEvent) {
        int n = 0;
        while (n < this.rule.size()) {
            IIIMListener iIIMListener = this.rule.get(n);
            if (!iIIMEvent.isProcessedBy(iIIMListener) && !iIIMEvent.isConsumed()) {
                iIIMListener.dispatchEvent(iIIMEvent);
                iIIMEvent.processedBy(iIIMListener);
            }
            ++n;
        }
    }

    public void dispatchActionEvent(IIIMActionEvent iIIMActionEvent) {
        switch (iIIMActionEvent.getType()) {
            case 2: {
                Component component = this.getClientComponent();
                char c = ((String)iIIMActionEvent.getArg()).charAt(0);
                KeyEvent keyEvent = new KeyEvent(component, 401, 0L, 0, c, c);
                this.adapter.dispatchEvent(keyEvent);
                break;
            }
            default: {
                int n = 0;
                while (n < this.rule.size()) {
                    IIIMListener iIIMListener = this.rule.get(n);
                    if (iIIMListener instanceof IIIMActionListener && !iIIMActionEvent.isProcessedBy(iIIMListener) && !iIIMActionEvent.isConsumed()) {
                        ((IIIMActionListener)iIIMListener).actionPerformed(iIIMActionEvent);
                        iIIMActionEvent.processedBy(iIIMListener);
                    }
                    ++n;
                }
                break block0;
            }
        }
    }

    public void dispatchAuxEvent(IIIMAuxEvent iIIMAuxEvent) {
        if (iIIMAuxEvent.getType() == 3) {
            if (protocolDriver != null) {
                try {
                    protocolDriver.sendAuxData(iIIMAuxEvent);
                }
                catch (Exception exception) {
                    if (DEBUG) {
                        exception.printStackTrace();
                    }
                }
            }
        } else if (this.auxListeners != null) {
            switch (iIIMAuxEvent.getType()) {
                case 0: {
                    this.auxListeners.auxStart(iIIMAuxEvent);
                    break;
                }
                case 2: {
                    this.auxListeners.auxDone(iIIMAuxEvent);
                    break;
                }
                case 1: {
                    this.auxListeners.auxDraw(iIIMAuxEvent);
                    break;
                }
                default: {
                    System.out.println("Unknown aux event");
                }
            }
        }
    }

    public void dispatchPreeditEvent(IIIMPreeditEvent iIIMPreeditEvent) {
        if (this.preeditListener == null) {
            return;
        }
        switch (iIIMPreeditEvent.getType()) {
            case 0: {
                this.preeditListener.preeditStart(iIIMPreeditEvent);
                break;
            }
            case 2: {
                this.preeditListener.preeditDone(iIIMPreeditEvent);
                break;
            }
            case 1: {
                this.preeditListener.preeditDraw(iIIMPreeditEvent);
                break;
            }
            default: {
                System.out.println(" Unknown preedit event");
            }
        }
    }

    public void dispatchCommittedEvent(IIIMCommittedEvent iIIMCommittedEvent) {
        if (this.committedListener == null) {
            return;
        }
        this.committedListener.committedPerformed(iIIMCommittedEvent);
    }

    public void dispatchStatusEvent(IIIMStatusEvent iIIMStatusEvent) {
        if (NO_STATUS) {
            return;
        }
        if (this.statusListener == null) {
            return;
        }
        switch (iIIMStatusEvent.getType()) {
            case 0: {
                this.statusListener.statusStart(iIIMStatusEvent);
                break;
            }
            case 2: {
                this.statusListener.statusDone(iIIMStatusEvent);
                break;
            }
            case 1: {
                this.statusListener.statusDraw(iIIMStatusEvent);
                break;
            }
            default: {
                System.out.println(" Unknown status event");
            }
        }
    }

    public void dispatchLookupEvent(IIIMLookupEvent iIIMLookupEvent) {
        if (this.lookupListener == null) {
            return;
        }
        switch (iIIMLookupEvent.getType()) {
            case 0: {
                this.lookupListener.lookupStart(iIIMLookupEvent);
                break;
            }
            case 1: {
                this.lookupListener.lookupDone(iIIMLookupEvent);
                break;
            }
            case 2: {
                this.lookupListener.lookupDraw(iIIMLookupEvent);
                break;
            }
            case 3: {
                this.lookupListener.lookupProcess(iIIMLookupEvent);
                break;
            }
            default: {
                System.out.println("Unknown lookup event");
            }
        }
    }

    public void markProcessedUpperListener(IIIMEvent iIIMEvent, IIIMListener iIIMListener) {
        int n = 0;
        while (n < this.rule.size()) {
            IIIMListener iIIMListener2 = this.rule.get(n);
            iIIMEvent.processedBy(iIIMListener2);
            if (iIIMListener2.equals(this.rule.get(n))) break;
            ++n;
        }
    }

    public Component getClientComponent() {
        if (this.adapter == null) {
            return null;
        }
        return this.adapter.getClientComponent();
    }

    static void initProps() {
        iiimProps = new Properties();
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                block4: {
                    String string = System.getProperty("java.home");
                    String string2 = System.getProperty("user.home");
                    try {
                        BufferedInputStream bufferedInputStream;
                        File file = new File(string + File.separator + "lib" + File.separator + "iiimp.properties");
                        if (file != null && file.canRead()) {
                            bufferedInputStream = new BufferedInputStream(new FileInputStream(file.getPath()));
                            iiimProps.load(bufferedInputStream);
                            ((InputStream)bufferedInputStream).close();
                        }
                        userPropsFile = string2 + File.separator + ".iiimp";
                        file = new File(userPropsFile);
                        if (file != null && file.canRead()) {
                            bufferedInputStream = new BufferedInputStream(new FileInputStream(file.getPath()));
                            iiimProps.load(bufferedInputStream);
                            ((InputStream)bufferedInputStream).close();
                        }
                    }
                    catch (Exception exception) {
                        if (!DEBUG) break block4;
                        exception.printStackTrace();
                    }
                }
                return null;
            }
        });
    }

    static String setProperty(String string, String string2) {
        String string3 = (String)iiimProps.setProperty(string, string2);
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                block3: {
                    try {
                        File file = new File(userPropsFile);
                        if (file != null && file.canWrite()) {
                            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file.getPath()));
                            iiimProps.store(bufferedOutputStream, "iiimf property file");
                            ((OutputStream)bufferedOutputStream).close();
                        }
                    }
                    catch (Exception exception) {
                        if (!DEBUG) break block3;
                        exception.printStackTrace();
                    }
                }
                return null;
            }
        });
        return string3;
    }

    static String getProperty(String string) {
        return iiimProps.getProperty(string);
    }

    static String getProperty(String string, String string2) {
        return iiimProps.getProperty(string, string2);
    }

    Locale getCurrentLocale() {
        if (this.currentLocale != null) {
            return this.currentLocale;
        }
        return Locale.getDefault();
    }

    boolean setLocale(Locale locale) {
        this.currentLocale = locale;
        return true;
    }

    void setCharacterSubsets(Character.Subset[] subsetArray) {
        int n = 0;
        while (n < this.rule.size()) {
            IIIMListener iIIMListener = this.rule.get(n);
            if (iIIMListener instanceof InputMethodAdapter) {
                ((InputMethodAdapter)((Object)iIIMListener)).setCharacterSubsets(subsetArray);
            }
            ++n;
        }
    }

    void activate() {
        int n = 0;
        while (n < this.rule.size()) {
            IIIMListener iIIMListener = this.rule.get(n);
            if (iIIMListener instanceof InputMethodAdapter) {
                ((InputMethodAdapter)((Object)iIIMListener)).activate();
            }
            ++n;
        }
        if (this.statusListener instanceof InputMethodAdapter) {
            ((InputMethodAdapter)((Object)this.statusListener)).activate();
        }
        if (this.lookupListener instanceof InputMethodAdapter) {
            ((InputMethodAdapter)((Object)this.lookupListener)).activate();
        }
    }

    void deactivate(boolean bl) {
        int n = 0;
        while (n < this.rule.size()) {
            IIIMListener iIIMListener = this.rule.get(n);
            if (iIIMListener instanceof InputMethodAdapter) {
                ((InputMethodAdapter)((Object)iIIMListener)).deactivate(bl);
            }
            ++n;
        }
        if (this.statusListener instanceof InputMethodAdapter) {
            ((InputMethodAdapter)((Object)this.statusListener)).deactivate(bl);
        }
        if (this.lookupListener instanceof InputMethodAdapter) {
            ((InputMethodAdapter)((Object)this.lookupListener)).deactivate(bl);
        }
    }

    void removeNotify() {
        int n = 0;
        while (n < this.rule.size()) {
            IIIMListener iIIMListener = this.rule.get(n);
            if (iIIMListener instanceof InputMethodAdapter) {
                ((InputMethodAdapter)((Object)iIIMListener)).removeNotify();
            }
            ++n;
        }
    }

    void endComposition() {
        int n = 0;
        while (n < this.rule.size()) {
            IIIMListener iIIMListener = this.rule.get(n);
            if (iIIMListener instanceof InputMethodAdapter) {
                ((InputMethodAdapter)((Object)iIIMListener)).endComposition();
            }
            ++n;
        }
    }

    void dispose() {
        int n = 0;
        while (n < this.rule.size()) {
            IIIMListener iIIMListener = this.rule.get(n);
            if (iIIMListener instanceof InputMethodAdapter) {
                ((InputMethodAdapter)((Object)iIIMListener)).dispose();
            }
            ++n;
        }
        if (this.statusListener instanceof InputMethodAdapter) {
            ((InputMethodAdapter)((Object)this.statusListener)).dispose();
        }
        if (this.lookupListener instanceof InputMethodAdapter) {
            ((InputMethodAdapter)((Object)this.lookupListener)).dispose();
        }
    }

    Object getControlObject() {
        int n = 0;
        while (n < this.rule.size()) {
            Object object;
            IIIMListener iIIMListener = this.rule.get(n);
            if (iIIMListener instanceof InputMethodAdapter && (object = ((InputMethodAdapter)((Object)iIIMListener)).getControlObject()) != null) {
                return object;
            }
            ++n;
        }
        return null;
    }

    public Locale[] getAvailableLocales() {
        Object object;
        Object object2;
        HashSet<Locale> hashSet = new HashSet<Locale>();
        int n = 0;
        while (n < this.rule.size()) {
            Locale[] localeArray;
            object2 = this.rule.get(n);
            if (object2 instanceof IMProvider && (localeArray = (object = (IMProvider)object2).getSupportLocales()) != null) {
                int n2 = 0;
                while (n2 < localeArray.length) {
                    hashSet.add(localeArray[n2]);
                    ++n2;
                }
            }
            ++n;
        }
        object2 = new Locale[hashSet.size()];
        object = hashSet.iterator();
        int n3 = 0;
        while (object.hasNext()) {
            object2[n3++] = (Locale)object.next();
        }
        return object2;
    }

    static {
        DEBUG = false;
        COLOR_SUPPORT = false;
        NO_STATUS = false;
        toggleKey = new IIIMKeyEvent("Alt+Shift");
        editHotKey = new IIIMKeyEvent("F12");
        ruleTable = new HashSet();
        iiimProps = null;
    }
}

