/*
 * Decompiled with CFR 0.152.
 */
package javax.wbem.client.adapter.http;

import com.sun.xml.parser.Parser;
import com.sun.xml.parser.Resolver;
import com.sun.xml.parser.ValidatingParser;
import com.sun.xml.tree.XmlDocument;
import com.sun.xml.tree.XmlDocumentBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.net.Authenticator;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Vector;
import javax.wbem.cim.CIMArgument;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMDataType;
import javax.wbem.cim.CIMDateTime;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMNameSpace;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMQualifierType;
import javax.wbem.cim.CIMValue;
import javax.wbem.cim.UnsignedInt16;
import javax.wbem.cim.UnsignedInt32;
import javax.wbem.cim.UnsignedInt64;
import javax.wbem.cim.UnsignedInt8;
import javax.wbem.cimxml.CIMXml;
import javax.wbem.cimxml.CIMXmlFactory;
import javax.wbem.client.CIMAssociatorNamesOp;
import javax.wbem.client.CIMAssociatorsOp;
import javax.wbem.client.CIMClientAPI;
import javax.wbem.client.CIMCreateClassOp;
import javax.wbem.client.CIMCreateInstanceOp;
import javax.wbem.client.CIMCreateNameSpaceOp;
import javax.wbem.client.CIMCreateQualifierTypeOp;
import javax.wbem.client.CIMDeleteClassOp;
import javax.wbem.client.CIMDeleteInstanceOp;
import javax.wbem.client.CIMDeleteNameSpaceOp;
import javax.wbem.client.CIMDeleteQualifierTypeOp;
import javax.wbem.client.CIMEnumClassNamesOp;
import javax.wbem.client.CIMEnumClassOp;
import javax.wbem.client.CIMEnumInstanceNamesOp;
import javax.wbem.client.CIMEnumInstancesOp;
import javax.wbem.client.CIMEnumNameSpaceOp;
import javax.wbem.client.CIMEnumQualifierTypesOp;
import javax.wbem.client.CIMExecQueryOp;
import javax.wbem.client.CIMGetClassOp;
import javax.wbem.client.CIMGetInstanceOp;
import javax.wbem.client.CIMGetPropertyOp;
import javax.wbem.client.CIMGetQualifierTypeOp;
import javax.wbem.client.CIMInvokeArgsMethodOp;
import javax.wbem.client.CIMInvokeMethodOp;
import javax.wbem.client.CIMListener;
import javax.wbem.client.CIMOperation;
import javax.wbem.client.CIMReferenceNamesOp;
import javax.wbem.client.CIMReferencesOp;
import javax.wbem.client.CIMSetClassOp;
import javax.wbem.client.CIMSetInstanceOp;
import javax.wbem.client.CIMSetPropertyOp;
import javax.wbem.client.CIMSetQualifierTypeOp;
import javax.wbem.client.CIMTransportException;
import javax.wbem.client.adapter.http.Errors;
import javax.wbem.client.adapter.http.HttpEventListener;
import javax.wbem.client.adapter.http.XmlRpcClient;
import javax.wbem.client.adapter.http.transport.HttpClientConnection;
import javax.wbem.client.adapter.http.transport.HttpSocketFactory;
import javax.wbem.client.adapter.http.transport.OutboundRequest;
import javax.wbem.security.BasicClientSecurity;
import javax.wbem.security.ClientSecurityContext;
import javax.wbem.security.SecurityToken;
import org.xml.sax.DocumentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

public class CIMClientXML
extends XmlRpcClient
implements CIMClientAPI {
    private static final String protocol_name = "cim-xml";
    public static final String HTTPPORT = "5988";
    private CIMNameSpace nameSpace;
    private CIMListener clientListener;
    private SecurityToken st = null;
    private String version;
    private HttpClientConnection conn = null;
    private HttpEventListener ls = null;
    private static int debug = 3;
    private boolean retryPost = true;
    private boolean useMPost = true;
    private boolean useChunking = false;
    private static final String LOCALONLY = "LocalOnly";
    private static final String DEEPINHERITANCE = "DeepInheritance";
    private static final String INCLUDEQUALIFIERS = "IncludeQualifiers";
    private static final String INCLUDECLASSORIGIN = "IncludeClassOrigin";
    private static final String PROPERTYLIST = "PropertyList";
    Resolver resolver = new Resolver();
    private static final String SYSTEMID = "http://www.dmtf.org/cim/mapping/xml/v2.0";
    private static final String PUBLICID = "-//DMTF//DTD CIM 2.0//EN";
    private static final String ns = "http://www.dmtf.org/cim/mapping/http/v1.0";
    private String prefix = "";
    private static final String HANDLERCLASS = "CIM_IndicationHandlerCIMXML";
    private boolean sendDoctype = false;
    private CIMXml xmlImpl;
    private HttpEventListener listener = null;
    private ClassCache cache = new ClassCache();

    public CIMClientXML(String string, CIMNameSpace cIMNameSpace, CIMListener cIMListener, Integer n) throws CIMException {
        this.nameSpace = cIMNameSpace;
        this.clientListener = cIMListener;
        try {
            URL uRL = cIMNameSpace.getHostURL();
            if (uRL == null) {
                uRL = new URL("http://" + this.nameSpace.getHost() + ":" + HTTPPORT + "/CIMOM" + string);
            }
            this.setUrl(uRL);
        }
        catch (MalformedURLException malformedURLException) {
            CIMTransportException cIMTransportException = new CIMTransportException("NO_CIMOM", "//" + this.nameSpace.getHost() + "/CIMOM" + string);
            throw cIMTransportException;
        }
        debug = n;
        this.setCheckTypes(System.getProperty("checktypes") != null ? "true".equalsIgnoreCase(System.getProperty("checktypes")) : false);
        this.sendDoctype = System.getProperty("setdoctype") != null ? "true".equalsIgnoreCase(System.getProperty("setdoctype")) : this.sendDoctype;
        this.resolver.registerCatalogEntry(PUBLICID, "javax/wbem/client/cim20.dtd", this.getClass().getClassLoader());
        this.customizeResolver((EntityResolver)this.resolver);
        this.xmlImpl = CIMXmlFactory.getCIMXmlImpl();
    }

    public String getProtocol() {
        return protocol_name;
    }

    public synchronized void initSecurityContext(String string, ClientSecurityContext clientSecurityContext) throws CIMException {
        BasicClientSecurity basicClientSecurity = null;
        try {
            basicClientSecurity = (BasicClientSecurity)clientSecurityContext;
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", "Bad credential");
        }
        String string2 = new String(basicClientSecurity.getUserName());
        String string3 = basicClientSecurity.getUserPassword();
        Authenticator.setDefault(new HttpAuthenticator(string2, string3));
    }

    boolean getUseMPost() {
        return this.useMPost;
    }

    void setUseMPost(boolean bl) {
        this.useMPost = bl;
        this.retryPost = false;
    }

    /*
     * Unable to fully structure code
     */
    XmlDocument call(XmlDocument var1_1) throws CIMException, IOException {
        block23: {
            var2_2 = this.getUrl();
            if (var2_2 == null) {
                throw new IllegalStateException("URL is not set");
            }
            var3_3 = null;
            var4_4 = var2_2.getHost();
            var5_5 = var2_2.getPort();
            var6_6 = new HttpSocketFactory(var2_2.getProtocol());
            var7_7 = null;
            var8_8 = 0;
            while (var8_8 < 2) {
                try {
                    if (this.conn == null) {
                        this.conn = new HttpClientConnection(var4_4, var5_5, var6_6, this.useMPost, this.useChunking);
                    }
                    var7_7 = this.conn.newRequest(var2_2.getPath());
                    var3_3 = new OutputStreamWriter(var7_7.getRequestOutputStream(), "UTF8");
                    this.setRequestHeaders(var7_7, this.xmlImpl.getXmlRequestHeaders(var1_1));
                    var7_7.endWriteHeader();
                    var1_1.write((Writer)var3_3);
                    var3_3.flush();
                    var3_3.close();
                    break;
                }
                catch (IOException var9_9) {
                    this.conn.shutdown(true);
                    this.conn = null;
                    if (var8_8 == 1) {
                        throw var9_9;
                    }
                    ++var8_8;
                }
            }
            if (this.getCheckTypes()) {
                var9_10 = new ValidatingParser();
                var9_10.setErrorHandler((ErrorHandler)Errors.instance);
            } else {
                var9_10 = new Parser();
                var9_10.setFastStandalone(true);
            }
            var10_11 = new XmlDocumentBuilder();
            var9_10.setDocumentHandler((DocumentHandler)var10_11);
            if (this.resolver == null) {
                this.resolver = new Resolver();
            }
            var9_10.setEntityResolver((EntityResolver)this.resolver);
            try {
                block24: {
                    var12_12 = var7_7.getResponseInputStream();
                    var11_14 = Resolver.createInputSource(null, (InputStream)var12_12, (boolean)this.getCheckTypes(), (String)var2_2.getProtocol());
                    if (CIMClientXML.debug == 1 || CIMClientXML.debug == 3) {
                        this.dumpRequest(var1_1, var7_7);
                    }
                    if (var7_7.getResponseCode() >= 400) {
                        throw new IOException();
                    }
                    try {
                        var9_10.parse(var11_14);
                        var12_12.close();
                        break block23;
                    }
                    catch (SAXException var13_15) {
                        if (CIMClientXML.debug <= 0) break block24;
                        var14_16 = new StringBuffer();
                        var15_17 = var11_14.getCharacterStream();
                        var16_18 = 0;
                        ** while (var16_18 >= 0)
                    }
lbl-1000:
                    // 1 sources

                    {
                        var14_16.append((char)var16_18);
                        var16_18 = var15_17.read();
                        continue;
                    }
lbl63:
                    // 1 sources

                    if (CIMClientXML.debug >= 2) {
                        this.dumpResponse(null, var7_7);
                    }
                    break block23;
                }
                throw new CIMException("XMLERROR", (Object)var13_15);
            }
            catch (IOException var12_13) {
                if (var12_13.getMessage() != null && var12_13.getMessage().startsWith("stream invalid")) {
                    this.conn.shutdown(true);
                    this.conn = null;
                    return this.call(var1_1);
                }
                if (var7_7.getResponseCode() == 401) {
                    throw new CIMException("CIM_ERR_ACCESS_DENIED");
                }
                if (CIMClientXML.debug >= 2) {
                    this.dumpResponse(null, var7_7);
                }
                if (var7_7.getResponseCode() == 411 && this.conn.supportsChunking()) {
                    this.conn.shutdown(true);
                    this.conn = null;
                    this.useChunking = false;
                    return this.call(var1_1);
                }
                if (this.retryPost && this.useMPost) {
                    this.conn.shutdown(true);
                    this.conn = null;
                    this.useMPost = false;
                    return this.call(var1_1);
                }
                throw new CIMException("XMLERROR", (Object)var12_13);
            }
        }
        if (CIMClientXML.debug >= 2) {
            this.dumpResponse(var10_11.getDocument(), var7_7);
        }
        return var10_11.getDocument();
    }

    private void setRequestHeaders(OutboundRequest outboundRequest, Map map) throws CIMException {
        if (this.useMPost) {
            this.setPrefix();
            outboundRequest.addHeaderField("Man", "http://www.dmtf.org/cim/mapping/http/v1.0;ns=" + this.prefix);
            this.prefix = this.prefix + "-";
        } else {
            this.prefix = "";
        }
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            outboundRequest.addHeaderField(this.prefix + (String)entry.getKey(), (String)entry.getValue());
        }
    }

    private void setPrefix() {
        Random random = new Random();
        int n = Math.abs(random.nextInt() % 100);
        this.prefix = Integer.toString(n);
        this.prefix = this.prefix.length() == 1 ? "0" + this.prefix : this.prefix;
    }

    private void dumpRequest(XmlDocument xmlDocument, OutboundRequest outboundRequest) throws IOException {
        System.out.println("****************************************");
        outboundRequest.dumpOutHeader();
        if (xmlDocument != null) {
            xmlDocument.write((OutputStream)System.out);
        }
        System.out.println("=-=-=-=-=-=-=-=-=-=-=-= END OF REQUEST  =-=-=-=-=-=-=-=-=-=-=-=");
    }

    private void dumpResponse(XmlDocument xmlDocument, OutboundRequest outboundRequest) throws IOException {
        System.out.println("++++++++++++++++++++++++++++++++++++++++");
        outboundRequest.dumpInHeader();
        System.out.println("\n");
        if (xmlDocument != null) {
            xmlDocument.write((OutputStream)System.out);
        }
        System.out.println("=-=-=-=-=-=-=-=-=-=-=-= END OF RESPONSE =-=-=-=-=-=-=-=-=-=-=-=");
    }

    private Vector getResponse(XmlDocument xmlDocument) throws MalformedURLException, CIMException, IOException {
        if (xmlDocument == null) {
            throw new CIMException("XMLERROR", "getResponse");
        }
        if (this.sendDoctype) {
            xmlDocument.setDoctype(PUBLICID, SYSTEMID, null);
        }
        XmlDocument xmlDocument2 = this.call(xmlDocument);
        return this.xmlImpl.getCIMResponse(xmlDocument2);
    }

    private Vector getFirstResponse(String string, XmlDocument xmlDocument) throws MalformedURLException, CIMException, IOException {
        Vector vector = this.getResponse(xmlDocument);
        Hashtable hashtable = (Hashtable)vector.firstElement();
        Vector vector2 = (Vector)hashtable.get(string);
        if (vector2.size() > 0 && vector2.elementAt(0) instanceof CIMException) {
            throw (CIMException)vector2.elementAt(0);
        }
        Object var6_6 = null;
        Object var7_7 = null;
        Iterator iterator = vector2.iterator();
        while (iterator.hasNext()) {
            this.fixKeytype(iterator.next());
        }
        return vector2;
    }

    private Vector getMultiResponse(XmlDocument xmlDocument) throws MalformedURLException, CIMException, IOException {
        Vector vector = new Vector();
        Vector vector2 = this.getResponse(xmlDocument);
        Vector vector3 = null;
        int n = 0;
        while (n < vector2.size()) {
            Hashtable hashtable = (Hashtable)vector2.elementAt(n);
            String string = (String)hashtable.keySet().iterator().next();
            vector3 = (Vector)hashtable.get(string);
            if (string.startsWith("Enum") || string.startsWith("Asso") || string.startsWith("Refe") || string.startsWith("ExecQ")) {
                if (vector3.size() > 0 && vector3.firstElement() instanceof CIMException) {
                    vector.addElement(vector3.firstElement());
                } else {
                    vector.addElement(vector3);
                }
            } else {
                try {
                    vector.addElement(vector3.firstElement());
                }
                catch (Exception exception) {
                    vector.addElement(null);
                }
            }
            ++n;
        }
        return vector;
    }

    public synchronized void createNameSpace(String string, CIMNameSpace cIMNameSpace, CIMNameSpace cIMNameSpace2) throws CIMException {
        try {
            CIMCreateNameSpaceOp cIMCreateNameSpaceOp = new CIMCreateNameSpaceOp(cIMNameSpace2);
            cIMCreateNameSpaceOp.setNameSpace(cIMNameSpace);
            Vector vector = this.getFirstResponse("CreateInstance", this.xmlImpl.getXmlRequest(cIMCreateNameSpaceOp));
        }
        catch (CIMException cIMException) {
            throw cIMException;
        }
        catch (Exception exception) {
            throw new CIMException("XMLERROR", "createNameSpace", exception);
        }
    }

    public synchronized void close(String string) throws CIMException {
        if (this.conn != null) {
            this.conn.shutdown(true);
        }
        if (this.listener != null) {
            this.listener.stop();
        }
    }

    public synchronized void deleteNameSpace(String string, CIMNameSpace cIMNameSpace, CIMNameSpace cIMNameSpace2) throws CIMException {
        try {
            CIMDeleteNameSpaceOp cIMDeleteNameSpaceOp = new CIMDeleteNameSpaceOp(cIMNameSpace2);
            cIMDeleteNameSpaceOp.setNameSpace(cIMNameSpace);
            this.getFirstResponse("DeleteInstance", this.xmlImpl.getXmlRequest(cIMDeleteNameSpaceOp));
        }
        catch (CIMException cIMException) {
            throw cIMException;
        }
        catch (Exception exception) {
            throw new CIMException("XMLERROR", "deleteNameSpace", exception);
        }
    }

    public synchronized void deleteClass(String string, CIMNameSpace cIMNameSpace, CIMObjectPath cIMObjectPath) throws CIMException {
        try {
            CIMDeleteClassOp cIMDeleteClassOp = new CIMDeleteClassOp(cIMObjectPath);
            cIMDeleteClassOp.setNameSpace(cIMNameSpace);
            this.getFirstResponse("DeleteClass", this.xmlImpl.getXmlRequest(cIMDeleteClassOp));
        }
        catch (CIMException cIMException) {
            throw cIMException;
        }
        catch (Exception exception) {
            throw new CIMException("XMLERROR", "deleteClass", exception);
        }
    }

    public synchronized void deleteInstance(String string, CIMNameSpace cIMNameSpace, CIMObjectPath cIMObjectPath) throws CIMException {
        try {
            CIMDeleteInstanceOp cIMDeleteInstanceOp = new CIMDeleteInstanceOp(cIMObjectPath);
            cIMDeleteInstanceOp.setNameSpace(cIMNameSpace);
            this.getFirstResponse("DeleteInstance", this.xmlImpl.getXmlRequest(cIMDeleteInstanceOp));
        }
        catch (CIMException cIMException) {
            throw cIMException;
        }
        catch (Exception exception) {
            throw new CIMException("XMLERROR", "deleteInstance", exception);
        }
    }

    public synchronized void deleteQualifierType(String string, CIMNameSpace cIMNameSpace, CIMObjectPath cIMObjectPath) throws CIMException {
        try {
            CIMDeleteQualifierTypeOp cIMDeleteQualifierTypeOp = new CIMDeleteQualifierTypeOp(cIMObjectPath);
            cIMDeleteQualifierTypeOp.setNameSpace(cIMNameSpace);
            this.getFirstResponse("DeleteQualifier", this.xmlImpl.getXmlRequest(cIMDeleteQualifierTypeOp));
        }
        catch (CIMException cIMException) {
            throw cIMException;
        }
        catch (Exception exception) {
            throw new CIMException("XMLERROR", "deleteQualifierType", exception);
        }
    }

    public synchronized Vector enumerateClasses(String string, CIMNameSpace cIMNameSpace, CIMObjectPath cIMObjectPath, boolean bl, boolean bl2, boolean bl3, boolean bl4) throws CIMException {
        try {
            CIMEnumClassOp cIMEnumClassOp = new CIMEnumClassOp(cIMObjectPath, bl, bl2, bl3, bl4);
            cIMEnumClassOp.setNameSpace(cIMNameSpace);
            return this.getFirstResponse("EnumerateClasses", this.xmlImpl.getXmlRequest(cIMEnumClassOp));
        }
        catch (CIMException cIMException) {
            throw cIMException;
        }
        catch (Exception exception) {
            throw new CIMException("XMLERROR", "enumerateClasses", exception);
        }
    }

    public synchronized Vector enumerateClassNames(String string, CIMNameSpace cIMNameSpace, CIMObjectPath cIMObjectPath, boolean bl) throws CIMException {
        try {
            CIMEnumClassNamesOp cIMEnumClassNamesOp = new CIMEnumClassNamesOp(cIMObjectPath, bl);
            cIMEnumClassNamesOp.setNameSpace(cIMNameSpace);
            return this.getFirstResponse("EnumerateClassNames", this.xmlImpl.getXmlRequest(cIMEnumClassNamesOp));
        }
        catch (CIMException cIMException) {
            throw cIMException;
        }
        catch (Exception exception) {
            throw new CIMException("XMLERROR", "enumerateClassNames", exception);
        }
    }

    public synchronized Vector enumNameSpace(String string, CIMNameSpace cIMNameSpace, CIMObjectPath cIMObjectPath, boolean bl) throws CIMException {
        try {
            cIMObjectPath.setObjectName("__Namespace");
            CIMEnumNameSpaceOp cIMEnumNameSpaceOp = new CIMEnumNameSpaceOp(cIMObjectPath, bl);
            cIMEnumNameSpaceOp.setNameSpace(cIMNameSpace);
            return this.getFirstResponse("EnumerateInstanceNames", this.xmlImpl.getXmlRequest(cIMEnumNameSpaceOp));
        }
        catch (CIMException cIMException) {
            throw cIMException;
        }
        catch (Exception exception) {
            throw new CIMException("XMLERROR", "enumNameSpace", exception);
        }
    }

    public Vector enumerateInstances(String string, CIMNameSpace cIMNameSpace, CIMObjectPath cIMObjectPath, boolean bl, boolean bl2, boolean bl3, boolean bl4, String[] stringArray) throws CIMException {
        try {
            CIMEnumInstancesOp cIMEnumInstancesOp = new CIMEnumInstancesOp(cIMObjectPath, bl, bl2, bl3, bl4, stringArray);
            cIMEnumInstancesOp.setNameSpace(cIMNameSpace);
            return this.getFirstResponse("EnumerateInstances", this.xmlImpl.getXmlRequest(cIMEnumInstancesOp));
        }
        catch (CIMException cIMException) {
            throw cIMException;
        }
        catch (Exception exception) {
            throw new CIMException("XMLERROR", "enumerateInstances", exception);
        }
    }

    public Vector enumerateInstanceNames(String string, CIMNameSpace cIMNameSpace, CIMObjectPath cIMObjectPath) throws CIMException {
        try {
            CIMEnumInstanceNamesOp cIMEnumInstanceNamesOp = new CIMEnumInstanceNamesOp(cIMObjectPath);
            cIMEnumInstanceNamesOp.setNameSpace(cIMNameSpace);
            return this.getFirstResponse("EnumerateInstanceNames", this.xmlImpl.getXmlRequest(cIMEnumInstanceNamesOp));
        }
        catch (CIMException cIMException) {
            throw cIMException;
        }
        catch (Exception exception) {
            throw new CIMException("XMLERROR", "enumerateInstanceNames", exception);
        }
    }

    public synchronized Vector enumQualifierTypes(String string, CIMNameSpace cIMNameSpace, CIMObjectPath cIMObjectPath) throws CIMException {
        Vector<CIMQualifierType> vector = new Vector<CIMQualifierType>();
        try {
            CIMEnumQualifierTypesOp cIMEnumQualifierTypesOp = new CIMEnumQualifierTypesOp(cIMObjectPath);
            cIMEnumQualifierTypesOp.setNameSpace(cIMNameSpace);
            Enumeration enumeration = this.getFirstResponse("EnumerateQualifiers", this.xmlImpl.getXmlRequest(cIMEnumQualifierTypesOp)).elements();
            while (enumeration.hasMoreElements()) {
                vector.addElement((CIMQualifierType)enumeration.nextElement());
            }
        }
        catch (CIMException cIMException) {
            throw cIMException;
        }
        catch (Exception exception) {
            throw new CIMException("XMLERROR", "enumQualifierTypes", exception);
        }
        return vector;
    }

    public synchronized CIMClass getClass(String string, CIMNameSpace cIMNameSpace, CIMObjectPath cIMObjectPath, boolean bl, boolean bl2, boolean bl3, String[] stringArray) throws CIMException {
        try {
            CIMGetClassOp cIMGetClassOp = new CIMGetClassOp(cIMObjectPath, bl, bl2, bl3, stringArray);
            cIMGetClassOp.setNameSpace(cIMNameSpace);
            Vector vector = this.getFirstResponse("GetClass", this.xmlImpl.getXmlRequest(cIMGetClassOp));
            return (CIMClass)vector.firstElement();
        }
        catch (CIMException cIMException) {
            throw cIMException;
        }
        catch (Exception exception) {
            throw new CIMException("XMLERROR", "getClass", exception);
        }
    }

    public synchronized CIMInstance getInstance(String string, CIMNameSpace cIMNameSpace, CIMObjectPath cIMObjectPath, boolean bl, boolean bl2, boolean bl3, String[] stringArray) throws CIMException {
        try {
            CIMGetInstanceOp cIMGetInstanceOp = new CIMGetInstanceOp(cIMObjectPath, bl, bl2, bl3, stringArray);
            cIMGetInstanceOp.setNameSpace(cIMNameSpace);
            Vector vector = this.getFirstResponse("GetInstance", this.xmlImpl.getXmlRequest(cIMGetInstanceOp));
            return (CIMInstance)vector.firstElement();
        }
        catch (CIMException cIMException) {
            throw cIMException;
        }
        catch (Exception exception) {
            throw new CIMException("XMLERROR", "getInstance", exception);
        }
    }

    public synchronized CIMValue invokeMethod(String string, CIMNameSpace cIMNameSpace, CIMObjectPath cIMObjectPath, String string2, Vector vector, Vector vector2) throws CIMException {
        try {
            CIMInvokeMethodOp cIMInvokeMethodOp = new CIMInvokeMethodOp(cIMObjectPath, string2, vector, null);
            cIMInvokeMethodOp.setNameSpace(cIMNameSpace);
            Vector vector3 = (Vector)this.getFirstResponse(string2, this.xmlImpl.getXmlRequest(cIMInvokeMethodOp)).firstElement();
            int n = 1;
            while (n < vector3.size()) {
                vector2.addElement(vector3.elementAt(n));
                ++n;
            }
            return (CIMValue)vector3.firstElement();
        }
        catch (CIMException cIMException) {
            throw cIMException;
        }
        catch (Exception exception) {
            throw new CIMException("XMLERROR", "invokeMethod", exception);
        }
    }

    public synchronized CIMValue invokeMethod(String string, CIMNameSpace cIMNameSpace, CIMObjectPath cIMObjectPath, String string2, CIMArgument[] cIMArgumentArray, CIMArgument[] cIMArgumentArray2) throws CIMException {
        try {
            CIMInvokeArgsMethodOp cIMInvokeArgsMethodOp = new CIMInvokeArgsMethodOp(cIMObjectPath, string2, cIMArgumentArray, null);
            cIMInvokeArgsMethodOp.setNameSpace(cIMNameSpace);
            Vector vector = (Vector)this.getFirstResponse(string2, this.xmlImpl.getXmlRequest(cIMInvokeArgsMethodOp)).firstElement();
            int n = 1;
            while (n < vector.size()) {
                cIMArgumentArray2[n - 1] = (CIMArgument)vector.elementAt(n);
                ++n;
            }
            return (CIMValue)vector.firstElement();
        }
        catch (CIMException cIMException) {
            throw cIMException;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new CIMException("XMLERROR", "invokeMethod", exception);
        }
    }

    public synchronized CIMQualifierType getQualifierType(String string, CIMNameSpace cIMNameSpace, CIMObjectPath cIMObjectPath) throws CIMException {
        try {
            CIMGetQualifierTypeOp cIMGetQualifierTypeOp = new CIMGetQualifierTypeOp(cIMObjectPath);
            cIMGetQualifierTypeOp.setNameSpace(cIMNameSpace);
            Vector vector = this.getFirstResponse("GetQualifier", this.xmlImpl.getXmlRequest(cIMGetQualifierTypeOp));
            return (CIMQualifierType)vector.firstElement();
        }
        catch (CIMException cIMException) {
            throw cIMException;
        }
        catch (Exception exception) {
            throw new CIMException("XMLERROR", "getQualifierType", exception);
        }
    }

    public synchronized void createQualifierType(String string, CIMNameSpace cIMNameSpace, CIMObjectPath cIMObjectPath, CIMQualifierType cIMQualifierType) throws CIMException {
        try {
            CIMCreateQualifierTypeOp cIMCreateQualifierTypeOp = new CIMCreateQualifierTypeOp(cIMObjectPath, cIMQualifierType);
            cIMCreateQualifierTypeOp.setNameSpace(cIMNameSpace);
            this.getFirstResponse("CreateQualifier", this.xmlImpl.getXmlRequest(cIMCreateQualifierTypeOp));
        }
        catch (CIMException cIMException) {
            throw cIMException;
        }
        catch (Exception exception) {
            throw new CIMException("XMLERROR", "createQualifierType", exception);
        }
    }

    public synchronized void createClass(String string, CIMNameSpace cIMNameSpace, CIMObjectPath cIMObjectPath, CIMClass cIMClass) throws CIMException {
        try {
            CIMCreateClassOp cIMCreateClassOp = new CIMCreateClassOp(cIMObjectPath, cIMClass);
            cIMCreateClassOp.setNameSpace(cIMNameSpace);
            this.getFirstResponse("CreateClass", this.xmlImpl.getXmlRequest(cIMCreateClassOp));
        }
        catch (CIMException cIMException) {
            throw cIMException;
        }
        catch (Exception exception) {
            throw new CIMException("XMLERROR", "createClass", exception);
        }
    }

    public synchronized CIMObjectPath createInstance(String string, CIMNameSpace cIMNameSpace, CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) throws CIMException {
        try {
            CIMCreateInstanceOp cIMCreateInstanceOp = new CIMCreateInstanceOp(cIMObjectPath, cIMInstance);
            cIMCreateInstanceOp.setNameSpace(cIMNameSpace);
            Vector vector = this.getFirstResponse("CreateInstance", this.xmlImpl.getXmlRequest(cIMCreateInstanceOp));
            return (CIMObjectPath)vector.firstElement();
        }
        catch (CIMException cIMException) {
            throw cIMException;
        }
        catch (Exception exception) {
            throw new CIMException("XMLERROR", "createInstance", exception);
        }
    }

    public synchronized void setQualifierType(String string, CIMNameSpace cIMNameSpace, CIMObjectPath cIMObjectPath, CIMQualifierType cIMQualifierType) throws CIMException {
        try {
            CIMSetQualifierTypeOp cIMSetQualifierTypeOp = new CIMSetQualifierTypeOp(cIMObjectPath, cIMQualifierType);
            cIMSetQualifierTypeOp.setNameSpace(cIMNameSpace);
            this.getFirstResponse("SetQualifier", this.xmlImpl.getXmlRequest(cIMSetQualifierTypeOp));
        }
        catch (CIMException cIMException) {
            throw cIMException;
        }
        catch (Exception exception) {
            throw new CIMException("XMLERROR", "setQualifierType", exception);
        }
    }

    public synchronized void setClass(String string, CIMNameSpace cIMNameSpace, CIMObjectPath cIMObjectPath, CIMClass cIMClass) throws CIMException {
        try {
            CIMSetClassOp cIMSetClassOp = new CIMSetClassOp(cIMObjectPath, cIMClass);
            cIMSetClassOp.setNameSpace(cIMNameSpace);
            this.getFirstResponse("ModifyClass", this.xmlImpl.getXmlRequest(cIMSetClassOp));
        }
        catch (CIMException cIMException) {
            throw cIMException;
        }
        catch (Exception exception) {
            throw new CIMException("XMLERROR", "setClass", exception);
        }
    }

    public synchronized void setInstance(String string, CIMNameSpace cIMNameSpace, CIMObjectPath cIMObjectPath, CIMInstance cIMInstance, boolean bl, String[] stringArray) throws CIMException {
        try {
            CIMSetInstanceOp cIMSetInstanceOp = new CIMSetInstanceOp(cIMObjectPath, cIMInstance, bl, stringArray);
            cIMSetInstanceOp.setNameSpace(cIMNameSpace);
            this.getFirstResponse("ModifyInstance", this.xmlImpl.getXmlRequest(cIMSetInstanceOp));
        }
        catch (CIMException cIMException) {
            throw cIMException;
        }
        catch (Exception exception) {
            throw new CIMException("XMLERROR", "setInstance", exception);
        }
    }

    public synchronized CIMValue getProperty(String string, CIMNameSpace cIMNameSpace, CIMObjectPath cIMObjectPath, String string2) throws CIMException {
        try {
            CIMGetPropertyOp cIMGetPropertyOp = new CIMGetPropertyOp(cIMObjectPath, string2);
            cIMGetPropertyOp.setNameSpace(cIMNameSpace);
            Vector vector = this.getFirstResponse("GetProperty", this.xmlImpl.getXmlRequest(cIMGetPropertyOp));
            return (CIMValue)vector.firstElement();
        }
        catch (CIMException cIMException) {
            throw cIMException;
        }
        catch (Exception exception) {
            throw new CIMException("XMLERROR", "getProperty", exception);
        }
    }

    public synchronized void setProperty(String string, CIMNameSpace cIMNameSpace, CIMObjectPath cIMObjectPath, String string2, CIMValue cIMValue) throws CIMException {
        try {
            CIMSetPropertyOp cIMSetPropertyOp = new CIMSetPropertyOp(cIMObjectPath, string2, cIMValue);
            cIMSetPropertyOp.setNameSpace(cIMNameSpace);
            this.getFirstResponse("SetProperty", this.xmlImpl.getXmlRequest(cIMSetPropertyOp));
        }
        catch (CIMException cIMException) {
            throw cIMException;
        }
        catch (Exception exception) {
            throw new CIMException("XMLERROR", "setProperty", exception);
        }
    }

    public synchronized Vector execQuery(String string, CIMNameSpace cIMNameSpace, CIMObjectPath cIMObjectPath, String string2, String string3) throws CIMException {
        try {
            CIMExecQueryOp cIMExecQueryOp = new CIMExecQueryOp(cIMObjectPath, string2, string3);
            cIMExecQueryOp.setNameSpace(cIMNameSpace);
            return this.getFirstResponse("ExecQuery", this.xmlImpl.getXmlRequest(cIMExecQueryOp));
        }
        catch (CIMException cIMException) {
            throw cIMException;
        }
        catch (Exception exception) {
            throw new CIMException("XMLERROR", "execQuery", exception);
        }
    }

    public Vector associators(String string, CIMNameSpace cIMNameSpace, CIMObjectPath cIMObjectPath, String string2, String string3, String string4, String string5, boolean bl, boolean bl2, String[] stringArray) throws CIMException {
        try {
            CIMAssociatorsOp cIMAssociatorsOp = new CIMAssociatorsOp(cIMObjectPath, string2, string3, string4, string5, bl, bl2, stringArray);
            cIMAssociatorsOp.setNameSpace(cIMNameSpace);
            return this.getFirstResponse("Associators", this.xmlImpl.getXmlRequest(cIMAssociatorsOp));
        }
        catch (CIMException cIMException) {
            throw cIMException;
        }
        catch (Exception exception) {
            throw new CIMException("XMLERROR", "associators", exception);
        }
    }

    public Vector associatorNames(String string, CIMNameSpace cIMNameSpace, CIMObjectPath cIMObjectPath, String string2, String string3, String string4, String string5) throws CIMException {
        try {
            CIMAssociatorNamesOp cIMAssociatorNamesOp = new CIMAssociatorNamesOp(cIMObjectPath, string2, string3, string4, string5);
            cIMAssociatorNamesOp.setNameSpace(cIMNameSpace);
            return this.getFirstResponse("AssociatorNames", this.xmlImpl.getXmlRequest(cIMAssociatorNamesOp));
        }
        catch (CIMException cIMException) {
            throw cIMException;
        }
        catch (Exception exception) {
            throw new CIMException("XMLERROR", "associatorNames", exception);
        }
    }

    public Vector references(String string, CIMNameSpace cIMNameSpace, CIMObjectPath cIMObjectPath, String string2, String string3, boolean bl, boolean bl2, String[] stringArray) throws CIMException {
        try {
            CIMReferencesOp cIMReferencesOp = new CIMReferencesOp(cIMObjectPath, string2, string3, bl, bl2, stringArray);
            cIMReferencesOp.setNameSpace(cIMNameSpace);
            return this.getFirstResponse("References", this.xmlImpl.getXmlRequest(cIMReferencesOp));
        }
        catch (CIMException cIMException) {
            throw cIMException;
        }
        catch (Exception exception) {
            throw new CIMException("XMLERROR", "references", exception);
        }
    }

    public Vector referenceNames(String string, CIMNameSpace cIMNameSpace, CIMObjectPath cIMObjectPath, String string2, String string3) throws CIMException {
        try {
            CIMReferenceNamesOp cIMReferenceNamesOp = new CIMReferenceNamesOp(cIMObjectPath, string2, string3);
            cIMReferenceNamesOp.setNameSpace(cIMNameSpace);
            return this.getFirstResponse("ReferenceNames", this.xmlImpl.getXmlRequest(cIMReferenceNamesOp));
        }
        catch (CIMException cIMException) {
            throw cIMException;
        }
        catch (Exception exception) {
            throw new CIMException("XMLERROR", "referenceNames", exception);
        }
    }

    public Vector performOperations(String string, CIMOperation[] cIMOperationArray) throws CIMException {
        try {
            return this.getMultiResponse(this.xmlImpl.getXmlRequest(cIMOperationArray));
        }
        catch (CIMException cIMException) {
            throw cIMException;
        }
        catch (Exception exception) {
            throw new CIMException("XMLERROR", "performOperations", exception);
        }
    }

    public void setListener(String string) throws CIMException {
        try {
            this.listener = new HttpEventListener(this.clientListener);
        }
        catch (Exception exception) {
            throw new CIMException("XMLERROR", "setListener", exception);
        }
    }

    public CIMInstance getIndicationHandler(CIMListener cIMListener) throws CIMException {
        int n;
        String string;
        if (cIMListener != null) {
            throw new CIMException("CIM_ERR_NOT_SUPPORTED");
        }
        try {
            string = this.listener.getHost();
            n = this.listener.getPort();
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception);
        }
        CIMClass cIMClass = this.getClass(this.version, this.nameSpace, new CIMObjectPath(HANDLERCLASS), false, true, false, null);
        CIMInstance cIMInstance = cIMClass.newInstance();
        cIMInstance.setProperty("Name", new CIMValue(new Date().toString()));
        cIMInstance.setProperty("SystemName", new CIMValue(""));
        cIMInstance.setProperty("SystemCreationClassName", new CIMValue("solaris_computersystem"));
        cIMInstance.setProperty("CreationClassName", new CIMValue(""));
        cIMInstance.setProperty("Destination", new CIMValue("http://" + string + ":" + n));
        cIMInstance.setProperty("Owner", new CIMValue(""));
        return cIMInstance;
    }

    private void fixKeytype(Object object) throws CIMException {
        if (object == null) {
            return;
        }
        if (object instanceof CIMObjectPath) {
            this.fixCIMOjbectPath((CIMObjectPath)object);
        } else if (object instanceof CIMInstance) {
            this.fixCIMInstance((CIMInstance)object);
        }
    }

    private void fixCIMInstance(CIMInstance cIMInstance) throws CIMException {
        Vector vector = cIMInstance.getProperties();
        this.fixCIMProperties(vector);
    }

    private void fixCIMClass(CIMClass cIMClass) throws CIMException {
        Vector vector = cIMClass.getAllProperties();
        String string = cIMClass.getName();
        this.cache.get(string);
        this.fixCIMProperties(vector);
    }

    private void fixCIMProperties(Vector vector) throws CIMException {
        if (vector == null || vector.size() == 0) {
            return;
        }
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            CIMValue cIMValue;
            CIMDataType cIMDataType;
            CIMProperty cIMProperty = (CIMProperty)iterator.next();
            if (cIMProperty == null || (cIMDataType = cIMProperty.getType()) == null || (cIMValue = cIMProperty.getValue()) == null || !cIMDataType.isReferenceType()) continue;
            Object object = cIMValue.getValue();
            this.fixKeytype(object);
        }
    }

    private static boolean isFixNeeded(CIMObjectPath cIMObjectPath) {
        Vector vector = cIMObjectPath.getKeys();
        if (vector == null || vector.size() == 0) {
            return false;
        }
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            CIMProperty cIMProperty = (CIMProperty)iterator.next();
            if (cIMProperty.getValue() == null) continue;
            return true;
        }
        return false;
    }

    private void fixCIMOjbectPath(CIMObjectPath cIMObjectPath) throws CIMException {
        if (CIMClientXML.isFixNeeded(cIMObjectPath)) {
            String string = cIMObjectPath.getObjectName();
            CIMProperty[] cIMPropertyArray = this.cache.get(string);
            CIMClientXML.fixInstanceName(cIMObjectPath, cIMPropertyArray);
        }
    }

    public static void fixInstanceName(CIMObjectPath cIMObjectPath, CIMProperty[] cIMPropertyArray) {
        Vector vector = cIMObjectPath.getKeys();
        if (vector == null || vector.size() == 0) {
            return;
        }
        CIMProperty[] cIMPropertyArray2 = new CIMProperty[vector.size()];
        vector.toArray(cIMPropertyArray2);
        int n = 0;
        while (n < cIMPropertyArray2.length) {
            CIMClientXML.fixInstancekeyProperty(cIMPropertyArray2[n], cIMPropertyArray);
            ++n;
        }
    }

    private static void fixInstancekeyProperty(CIMProperty cIMProperty, CIMProperty[] cIMPropertyArray) {
        String string = cIMProperty.getName();
        int n = 0;
        while (n < cIMPropertyArray.length) {
            if (cIMProperty.getName().equals(cIMPropertyArray[n].getName())) {
                CIMClientXML.convertType(cIMProperty, cIMPropertyArray[n].getType());
            }
            ++n;
        }
    }

    private static void convertType(CIMProperty cIMProperty, CIMDataType cIMDataType) {
        Object object;
        if (cIMProperty == null) {
            return;
        }
        String string = cIMDataType.toString();
        if (cIMProperty != null && cIMProperty.getValue() != null && (object = cIMProperty.getValue().getValue()) instanceof String) {
            String string2 = (String)object;
            Object object2 = CIMClientXML.valueObject(string2, string);
            cIMProperty.setValue(new CIMValue(object2));
            cIMProperty.setType(cIMDataType);
        }
    }

    private static Object valueObject(String string, String string2) {
        Object object = null;
        string2 = string2.length() > 0 ? string2 : "string";
        int n = 10;
        if (string2.startsWith("sint") && (string.startsWith("0x") || string.startsWith("+0x") || string.startsWith("-0x") || string.startsWith("0X") || string.startsWith("+0X") || string.startsWith("-0X")) || string2.startsWith("uint") && (string.startsWith("0x") || string.startsWith("0X"))) {
            n = 16;
            int n2 = (string.indexOf("x") > 0 ? string.indexOf("x") : string.indexOf("X")) + 1;
            String string3 = string = string.startsWith("-") ? "-" + string.substring(n2) : string.substring(n2);
        }
        if (string2.equals("boolean")) {
            object = Boolean.valueOf(string);
        } else if (string2.equals("char16")) {
            object = new Character(string.charAt(0));
        } else if (string2.equals("datetime")) {
            object = new CIMDateTime(string);
        } else if (string2.equals("real32")) {
            object = new Float(string);
        } else if (string2.equals("real64")) {
            object = new Double(string);
        } else if (string2.equals("sint16")) {
            object = Short.valueOf(string, n);
        } else if (string2.equals("sint32")) {
            object = Integer.valueOf(string, n);
        } else if (string2.equals("sint64")) {
            object = Long.valueOf(string, n);
        } else if (string2.equals("sint8")) {
            object = Byte.valueOf(string, n);
        } else if (string2.equals("string")) {
            object = string == null ? "" : new String(string);
        } else if (string2.equals("uint16")) {
            object = new UnsignedInt16(Integer.valueOf(string, n));
        } else if (string2.equals("uint32")) {
            object = new UnsignedInt32(Long.valueOf(string, n));
        } else if (string2.equals("uint64")) {
            object = new UnsignedInt64(new BigInteger(string, n));
        } else if (string2.equals("uint8")) {
            object = new UnsignedInt8(Short.valueOf(string, n));
        } else if (string.indexOf("e") > 0 || string.indexOf("E") > 0) {
            object = new Double(string);
        } else if (string.startsWith("+") || string.startsWith("-")) {
            object = new Long(string);
        }
        return object;
    }

    private class ClassCache {
        private HashMap classCache = new HashMap();
        private ArrayList classCacheNames = new ArrayList();
        private static final int CACHE_SIZE = 200;

        private ClassCache() {
        }

        public CIMProperty[] get(String string) throws CIMException {
            CIMProperty[] cIMPropertyArray = (CIMProperty[])this.classCache.get(string);
            if (cIMPropertyArray == null) {
                cIMPropertyArray = this.add(string);
            }
            return cIMPropertyArray;
        }

        private CIMProperty[] add(String string) throws CIMException {
            CIMClass cIMClass = CIMClientXML.this.getClass("", CIMClientXML.this.nameSpace, new CIMObjectPath(string), false, true, false, null);
            Vector vector = cIMClass.getKeys();
            if (vector == null) {
                vector = new Vector(0);
            }
            CIMProperty[] cIMPropertyArray = new CIMProperty[vector.size()];
            vector.toArray(cIMPropertyArray);
            if (this.classCacheNames.size() == 200) {
                String string2 = (String)this.classCacheNames.remove(0);
                this.classCache.remove(string2);
            }
            this.classCache.put(string, cIMPropertyArray);
            this.classCacheNames.add(string);
            return cIMPropertyArray;
        }
    }

    private static class HttpAuthenticator
    extends Authenticator {
        private String username;
        private char[] password;

        HttpAuthenticator(String string, String string2) {
            this.username = string;
            this.password = string2.toCharArray();
        }

        protected PasswordAuthentication getPasswordAuthentication() {
            return new PasswordAuthentication(this.username, this.password);
        }
    }
}

