/*
 * Decompiled with CFR 0.152.
 */
package javax.wbem.client.adapter.http.transport;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.security.AccessController;
import java.util.HashSet;
import java.util.Set;
import javax.wbem.client.adapter.http.transport.ConnectionTimer;
import javax.wbem.client.adapter.http.transport.HttpServerConnection;
import javax.wbem.client.adapter.http.transport.HttpSettings;
import javax.wbem.client.adapter.http.transport.RequestHandler;
import javax.wbem.client.adapter.http.transport.ServerEndpointListener;
import sun.rmi.runtime.Executor;
import sun.rmi.runtime.GetThreadPoolAction;

public final class HttpServerEndpoint {
    private static final Executor systemThreadPool = (Executor)AccessController.doPrivileged(new GetThreadPoolAction(false));
    private static final ConnectionTimer connTimer;
    private final String h;
    private int p;

    public HttpServerEndpoint(String string, int n) {
        if (string == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n > 65535) {
            throw new IllegalArgumentException("port number out of range: " + n);
        }
        this.h = string;
        this.p = n;
    }

    public String getHost() {
        return this.h;
    }

    public int getPort() {
        return this.p;
    }

    public ServerEndpointListener listen(RequestHandler requestHandler) throws IOException {
        if (requestHandler == null) {
            throw new NullPointerException();
        }
        ServerSocket serverSocket = new ServerSocket(this.p);
        Listener listener = new Listener(requestHandler, serverSocket);
        systemThreadPool.execute((Runnable)listener, "HttpServerEndpoint Accept (port " + this.p + ")");
        return listener;
    }

    public boolean equals(Object object) {
        if (object instanceof HttpServerEndpoint) {
            HttpServerEndpoint httpServerEndpoint = (HttpServerEndpoint)object;
            return this.h.equals(httpServerEndpoint.h) && this.p == httpServerEndpoint.p;
        }
        return false;
    }

    public String toString() {
        return "HttpServerEndpoint[" + this.h + ":" + this.p + "]";
    }

    static {
        HttpSettings httpSettings = HttpSettings.getHttpSettings();
        connTimer = new ConnectionTimer(httpSettings.getConnectionTimeout(15000L));
    }

    private final class Connection
    extends HttpServerConnection {
        private Socket sock;
        Listener listener;

        Connection(Socket socket, RequestHandler requestHandler, Listener listener) throws IOException {
            super(socket, requestHandler);
            this.sock = socket;
            this.listener = listener;
            this.start();
        }

        protected void checkPermissions() {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                String string = this.sock.getInetAddress().getHostAddress();
                securityManager.checkAccept(string, this.sock.getPort());
            }
        }

        protected String getClientHost() {
            InetAddress inetAddress = this.sock.getInetAddress();
            return inetAddress != null ? inetAddress.getHostAddress() : "0.0.0.0";
        }

        protected void idle() {
            connTimer.scheduleTimeout(this, false);
        }

        protected void busy() {
            connTimer.cancelTimeout(this);
        }

        public boolean shutdown(boolean bl) {
            if (super.shutdown(bl)) {
                connTimer.cancelTimeout(this);
                this.listener.connectionClosed(this);
            }
            return false;
        }
    }

    private final class Listener
    implements Runnable,
    ServerEndpointListener {
        private final RequestHandler handler;
        private final ServerSocket ssock;
        private long acceptFailureTime = 0L;
        private int acceptFailureCount;
        private boolean closed = false;
        private final Set connections = new HashSet(5);

        private Listener(RequestHandler requestHandler, ServerSocket serverSocket) {
            this.handler = requestHandler;
            this.ssock = serverSocket;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            Object[] objectArray;
            Set set = this.connections;
            synchronized (set) {
                if (this.closed) {
                    return;
                }
                this.closed = true;
                objectArray = this.connections.toArray();
            }
            try {
                this.ssock.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            int n = 0;
            while (n < objectArray.length) {
                ((Connection)objectArray[n]).shutdown(true);
                ++n;
            }
        }

        public void run() {
            this.executeAcceptLoop();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void executeAcceptLoop() {
            try {
                while (true) {
                    Socket socket = this.ssock.accept();
                    try {
                        socket.setTcpNoDelay(true);
                    }
                    catch (SocketException socketException) {
                        // empty catch block
                    }
                    try {
                        socket.setKeepAlive(true);
                    }
                    catch (SocketException socketException) {
                        // empty catch block
                    }
                    Set set = this.connections;
                    synchronized (set) {
                        if (this.closed) {
                            try {
                                socket.close();
                            }
                            catch (IOException iOException) {}
                        } else {
                            this.connections.add(new Connection(socket, this.handler, this));
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void connectionClosed(Connection connection) {
            Set set = this.connections;
            synchronized (set) {
                this.connections.remove(connection);
            }
        }

        public int getLocalPort() {
            return this.ssock.getLocalPort();
        }
    }
}

