/*
 * Decompiled with CFR 0.152.
 */
package javax.wbem.security;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMNameSpace;
import javax.wbem.client.CIMSecurityException;
import javax.wbem.client.Debug;
import javax.wbem.security.ClientSecurityContext;

public class ClientSecurityFactory {
    private static final String PROP_DEFAULT_FILE = "javax.wbem.client.WbemDefaults";
    private static final String PROP_EXTEND_FILE = "WbemClient";
    private static final String PROP_SECURITY = "security";
    private static final String PROP_TRANSPORT = "transport";
    private static final String PROP_PROTOCOL = "protocol";
    private static final String PROP_MECHANISM = "mechanism";
    private static final String PROP_NAME = "name";
    private static final String PROP_DEFAULT = "default";
    private static final String PROP_CLASS = "client.class";
    private static final String DFLT_XML_SECURITY = "basic";
    private static final String DFLT_RMI_SECURITY = "sundigest";
    private static final String DFLT_BASIC_CLASS = "javax.wbem.security.BasicClientSecurity";
    private static final String DFLT_SUNDIGEST_CLASS = "javax.wbem.security.SunDigestClientSecurity";
    private static Properties props = null;
    static /* synthetic */ Class class$javax$wbem$cim$CIMNameSpace;
    static /* synthetic */ Class class$java$security$Principal;
    static /* synthetic */ Class class$java$lang$Object;

    public static ClientSecurityContext createClientSecurity(CIMNameSpace cIMNameSpace, Principal principal, Object object, String string, String string2) throws CIMException {
        String string3 = null;
        String string4 = null;
        String string5 = string2;
        if ((string2 == null || string2.trim().length() == 0) && (string5 = ClientSecurityFactory.getProperty(string3 = "transport.protocol.default")) == null) {
            string5 = "cim-rmi";
        }
        string5 = string5.toLowerCase();
        if ((string4 == null || string4.trim().length() == 0) && (string4 = ClientSecurityFactory.getProperty(string3 = "transport." + string5 + "." + PROP_SECURITY + "." + PROP_DEFAULT)) == null) {
            if (string5.equals("cim-xml")) {
                string4 = DFLT_XML_SECURITY;
            } else if (string5.equals("cim-rmi")) {
                string4 = DFLT_RMI_SECURITY;
            } else {
                Debug.trace1("Security mechanism not valid");
                throw new CIMSecurityException("CIM_ERR_NOT_FOUND", PROP_DEFAULT);
            }
        }
        string4 = string4.toLowerCase();
        string3 = "security.mechanism.name." + string4;
        String string6 = ClientSecurityFactory.getProperty(string3);
        if (string6 == null || !string4.equalsIgnoreCase(string6)) {
            Debug.trace1("Security mechanism not in configuration properties");
            throw new CIMException("CIM_ERR_NOT_FOUND", "mechanism-0");
        }
        Debug.trace1("Security mechanism name is " + string4);
        string3 = "security." + string4 + "." + PROP_TRANSPORT;
        String string7 = ClientSecurityFactory.getProperty(string3);
        if (string7 == null) {
            if (string4.equals(DFLT_XML_SECURITY)) {
                string7 = "cim-xml";
            } else if (string4.equals(DFLT_RMI_SECURITY)) {
                string7 = "cim-rmi";
            }
        }
        if (string7 == null) {
            Debug.trace1("Security mechanism not supported on protocol");
            throw new CIMSecurityException("CIM_ERR_NOT_FOUND", "mechanism-1");
        }
        List list = ClientSecurityFactory.parseList(string7);
        if (!list.contains(string5)) {
            Debug.trace1("Security mechanism not supported on protocol");
            throw new CIMSecurityException("CIM_ERR_NOT_FOUND", "mechanism-2");
        }
        string3 = "security." + string4 + "." + PROP_CLASS;
        String string8 = ClientSecurityFactory.getProperty(string3);
        if (string8 == null) {
            if (string4.equals(DFLT_XML_SECURITY)) {
                string8 = DFLT_BASIC_CLASS;
            } else if (string4.equals(DFLT_RMI_SECURITY)) {
                string8 = DFLT_SUNDIGEST_CLASS;
            }
        }
        if (string8 == null) {
            Debug.trace1("No security module class for mechanism");
            throw new CIMSecurityException("CIM_ERR_NOT_FOUND", "mechanism-3");
        }
        if (!ClientSecurityFactory.checkSecurityClass(string8)) {
            Debug.trace1("Security module class not allowed");
            throw new CIMSecurityException("CIM_ERR_NOT_FOUND", "mechanism-4");
        }
        Class<?> clazz = null;
        try {
            clazz = Class.forName(string8);
        }
        catch (Exception exception) {
            Debug.trace1("Mechanism " + string4 + ": class not found: " + string8, exception);
            throw new CIMSecurityException("CIM_ERR_NOT_FOUND", "mechanism-5");
        }
        ClientSecurityContext clientSecurityContext = null;
        try {
            Class[] classArray = new Class[]{class$javax$wbem$cim$CIMNameSpace == null ? (class$javax$wbem$cim$CIMNameSpace = ClientSecurityFactory.class$("javax.wbem.cim.CIMNameSpace")) : class$javax$wbem$cim$CIMNameSpace, class$java$security$Principal == null ? (class$java$security$Principal = ClientSecurityFactory.class$("java.security.Principal")) : class$java$security$Principal, class$java$lang$Object == null ? (class$java$lang$Object = ClientSecurityFactory.class$("java.lang.Object")) : class$java$lang$Object};
            Object[] objectArray = new Object[]{cIMNameSpace, principal, object};
            Constructor<?> constructor = clazz.getConstructor(classArray);
            clientSecurityContext = (ClientSecurityContext)constructor.newInstance(objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            Debug.trace1("Error in security module class constructor", throwable);
            if (throwable instanceof CIMException) {
                CIMException cIMException = (CIMException)throwable;
                throw cIMException;
            }
            throw new CIMSecurityException("CIM_ERR_FAILED", (Object)throwable);
        }
        catch (Exception exception) {
            Debug.trace1("Error creating security module instance", exception);
            throw new CIMSecurityException("CIM_ERR_FAILED", (Object)exception);
        }
        return clientSecurityContext;
    }

    public static String[] getSecurityMechanisms() throws CIMException {
        String[] stringArray = null;
        String string = "security.mechanism";
        List list = ClientSecurityFactory.getPropertyList(string);
        if (list != null && list.size() > 0) {
            stringArray = new String[list.size()];
            list.toArray(stringArray);
        }
        return stringArray;
    }

    static String getProperty(String string) throws CIMException {
        if (props == null) {
            ClientSecurityFactory.initProperties();
        }
        return props.getProperty(string);
    }

    static List getPropertyList(String string) throws CIMException {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (props == null) {
            ClientSecurityFactory.initProperties();
        }
        boolean bl = false;
        boolean bl2 = true;
        String string2 = string.concat(".");
        Enumeration<?> enumeration = props.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string3;
            String string4 = (String)enumeration.nextElement();
            if (!string4.startsWith(string2) || (string3 = props.getProperty(string4)) == null) continue;
            arrayList.add(string3);
        }
        return arrayList;
    }

    private static boolean checkSecurityClass(String string) {
        return string.equals(DFLT_BASIC_CLASS) || string.equals(DFLT_SUNDIGEST_CLASS) || string.equals("com.sun.wbem.client.SolarisDigestClientSecurity");
    }

    private static List parseList(String string) {
        ArrayList<String> arrayList = new ArrayList<String>(10);
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreElements()) {
            String string2 = (String)stringTokenizer.nextElement();
            arrayList.add(string2);
        }
        return arrayList;
    }

    private static void initProperties() throws CIMException {
        if (props == null) {
            props = new Properties();
            try {
                ClientSecurityFactory.loadProperties(PROP_DEFAULT_FILE);
            }
            catch (Exception exception) {
                Debug.trace1("Error loading WbemDefaults properties");
                throw new CIMException("CIM_ERR_FAILED", PROP_DEFAULT_FILE);
            }
            try {
                ClientSecurityFactory.loadProperties(PROP_EXTEND_FILE);
            }
            catch (MissingResourceException missingResourceException) {
                Debug.trace1("Error loading properties: WbemClient");
            }
        }
    }

    private static void loadProperties(String string) throws CIMException {
        PropertyResourceBundle propertyResourceBundle = (PropertyResourceBundle)ResourceBundle.getBundle(string, new Locale("", ""));
        if (propertyResourceBundle != null) {
            String string2 = null;
            Enumeration<String> enumeration = propertyResourceBundle.getKeys();
            while (enumeration.hasMoreElements()) {
                String string3 = enumeration.nextElement();
                try {
                    string2 = propertyResourceBundle.getString(string3);
                }
                catch (Exception exception) {
                    string3 = null;
                }
                if (string3 == null) continue;
                props.setProperty(string3, string2);
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

