/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.asn1;

import java.io.ByteArrayOutputStream;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mozilla.jss.asn1.ASN1Header;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Util;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.CharConverter;
import org.mozilla.jss.asn1.Form;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.OCTET_STRING;
import org.mozilla.jss.asn1.Tag;

public abstract class CharacterString
implements ASN1Value {
    static final Form FORM = Form.PRIMITIVE;
    private char[] chars;
    private byte[] cachedContents;

    protected CharacterString(String string) throws CharConversionException {
        this.chars = string.toCharArray();
        this.cachedContents = this.computeContents();
    }

    protected CharacterString(char[] cArray) throws CharConversionException {
        this.chars = cArray;
        this.cachedContents = this.computeContents();
    }

    private byte[] computeContents() throws CharConversionException {
        CharConverter charConverter = this.getCharConverter();
        byte[] byArray = charConverter.charToByte(this.chars, 0, this.chars.length);
        return byArray;
    }

    public void encode(OutputStream outputStream) throws IOException {
        this.encode(this.getTag(), outputStream);
    }

    public void encode(Tag tag, OutputStream outputStream) throws IOException {
        byte[] byArray = this.getEncodedContents();
        ASN1Header aSN1Header = new ASN1Header(tag, FORM, byArray.length);
        aSN1Header.encode(outputStream);
        outputStream.write(byArray);
    }

    abstract CharConverter getCharConverter();

    private byte[] getEncodedContents() {
        return this.cachedContents;
    }

    public abstract Tag getTag();

    public char[] toCharArray() {
        return this.chars;
    }

    public String toString() {
        return new String(this.chars);
    }

    public static abstract class Template
    implements ASN1Template {
        public ASN1Value decode(InputStream inputStream) throws IOException, InvalidBERException {
            return this.decode(this.getTag(), inputStream);
        }

        public ASN1Value decode(Tag tag, InputStream inputStream) throws IOException, InvalidBERException {
            try {
                byte[] byArray;
                Object object;
                ASN1Header aSN1Header = new ASN1Header(inputStream);
                aSN1Header.validate(tag);
                if (aSN1Header.getContentLength() == -1L) {
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    do {
                        if (((ASN1Header)(object = ASN1Header.lookAhead(inputStream))).isEOC()) continue;
                        OCTET_STRING.Template template = new OCTET_STRING.Template();
                        OCTET_STRING oCTET_STRING = (OCTET_STRING)template.decode(inputStream);
                        byteArrayOutputStream.write(oCTET_STRING.toByteArray());
                    } while (!((ASN1Header)object).isEOC());
                    object = new ASN1Header(inputStream);
                    byArray = byteArrayOutputStream.toByteArray();
                } else {
                    byArray = new byte[(int)aSN1Header.getContentLength()];
                    ASN1Util.readFully(byArray, inputStream);
                }
                object = this.getCharConverter().byteToChar(byArray, 0, byArray.length);
                return this.generateInstance((char[])object);
            }
            catch (CharConversionException charConversionException) {
                throw new InvalidBERException(charConversionException.getMessage());
            }
            catch (InvalidBERException invalidBERException) {
                throw new InvalidBERException(invalidBERException, this.typeName());
            }
        }

        protected abstract CharacterString generateInstance(char[] var1) throws CharConversionException;

        protected abstract CharConverter getCharConverter();

        protected abstract Tag getTag();

        public abstract boolean tagMatch(Tag var1);

        protected abstract String typeName();
    }
}

