/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.crypto;

import java.security.NoSuchAlgorithmException;
import org.mozilla.jss.asn1.OBJECT_IDENTIFIER;

public class Algorithm {
    protected int oidIndex;
    String name;
    protected OBJECT_IDENTIFIER oid;
    private Class parameterClass = null;
    static final OBJECT_IDENTIFIER ANSI_X9_ALGORITHM = new OBJECT_IDENTIFIER(new long[]{1L, 2L, 840L, 10040L, 4L});
    protected static final short SEC_OID_PKCS1_MD2_WITH_RSA_ENCRYPTION = 0;
    protected static final short SEC_OID_PKCS1_MD5_WITH_RSA_ENCRYPTION = 1;
    protected static final short SEC_OID_PKCS1_SHA1_WITH_RSA_ENCRYPTION = 2;
    protected static final short SEC_OID_ANSIX9_DSA_SIGNATURE_WITH_SHA1_DIGEST = 3;
    protected static final short SEC_OID_PKCS1_RSA_ENCRYPTION = 4;
    protected static final short CKM_RSA_PKCS_KEY_PAIR_GEN = 5;
    protected static final short CKM_DSA_KEY_PAIR_GEN = 6;
    protected static final short SEC_OID_ANSIX9_DSA_SIGNATURE = 7;
    protected static final short SEC_OID_RC4 = 8;
    protected static final short SEC_OID_DES_ECB = 9;
    protected static final short SEC_OID_DES_CBC = 10;
    protected static final short CKM_DES_CBC_PAD = 11;
    protected static final short CKM_DES3_ECB = 12;
    protected static final short SEC_OID_DES_EDE3_CBC = 13;
    protected static final short CKM_DES3_CBC_PAD = 14;
    protected static final short CKM_DES_KEY_GEN = 15;
    protected static final short CKM_DES3_KEY_GEN = 16;
    protected static final short CKM_RC4_KEY_GEN = 17;
    protected static final short SEC_OID_PKCS5_PBE_WITH_MD2_AND_DES_CBC = 18;
    protected static final short SEC_OID_PKCS5_PBE_WITH_MD5_AND_DES_CBC = 19;
    protected static final short SEC_OID_PKCS5_PBE_WITH_SHA1_AND_DES_CBC = 20;
    protected static final short SEC_OID_PKCS12_V2_PBE_WITH_SHA1_AND_128_BIT_RC4 = 21;
    protected static final short SEC_OID_PKCS12_V2_PBE_WITH_SHA1_AND_40_BIT_RC4 = 22;
    protected static final short SEC_OID_PKCS12_V2_PBE_WITH_SHA1_AND_3KEY_TRIPLE_DES_CBC = 23;
    protected static final short SEC_OID_MD2 = 24;
    protected static final short SEC_OID_MD5 = 25;
    protected static final short SEC_OID_SHA1 = 26;
    protected static final short CKM_SHA_1_HMAC = 27;
    protected static final short SEC_OID_PKCS12_V2_PBE_WITH_SHA1_AND_128_BIT_RC2_CBC = 28;
    protected static final short SEC_OID_PKCS12_V2_PBE_WITH_SHA1_AND_40_BIT_RC2_CBC = 29;
    protected static final short SEC_OID_RC2_CBC = 30;
    protected static final short CKM_PBA_SHA1_WITH_SHA1_HMAC = 31;

    private Algorithm() {
    }

    protected Algorithm(int n, String string) {
        this.oidIndex = n;
        this.name = string;
    }

    protected Algorithm(int n, String string, OBJECT_IDENTIFIER oBJECT_IDENTIFIER) {
        this(n, string);
        this.oid = oBJECT_IDENTIFIER;
    }

    protected Algorithm(int n, String string, OBJECT_IDENTIFIER oBJECT_IDENTIFIER, Class clazz) {
        this(n, string, oBJECT_IDENTIFIER);
        this.parameterClass = clazz;
    }

    public Class getParameterClass() {
        return this.parameterClass;
    }

    public OBJECT_IDENTIFIER toOID() throws NoSuchAlgorithmException {
        if (this.oid == null) {
            throw new NoSuchAlgorithmException();
        }
        return this.oid;
    }

    public String toString() {
        return this.name;
    }
}

