/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkcs11;

import java.math.BigInteger;
import java.security.Principal;
import java.security.PublicKey;
import java.security.cert.CertificateEncodingException;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.crypto.X509Certificate;
import org.mozilla.jss.pkcs11.CertProxy;
import org.mozilla.jss.util.Assert;

public class PK11Cert
implements X509Certificate {
    protected CertProxy certProxy;

    PK11Cert(byte[] byArray) {
        Assert.assert(byArray != null);
        this.certProxy = new CertProxy(byArray);
    }

    public native byte[] getEncoded() throws CertificateEncodingException;

    public Principal getIssuerDN() {
        return new StringPrincipal(this.getIssuerDNString());
    }

    protected native String getIssuerDNString();

    public native String getNickname();

    protected native CryptoToken getOwningToken();

    public native PublicKey getPublicKey();

    public BigInteger getSerialNumber() {
        return new BigInteger(this.getSerialNumberByteArray());
    }

    protected native byte[] getSerialNumberByteArray();

    public Principal getSubjectDN() {
        return new StringPrincipal(this.getSubjectDNString());
    }

    protected native String getSubjectDNString();

    protected native int getTrust(int var1);

    protected native byte[] getUniqueID();

    public native int getVersion();

    protected native void setTrust(int var1, int var2);

    protected static class StringPrincipal
    implements Principal {
        protected String str;

        public StringPrincipal(String string) {
            this.str = string;
        }

        public boolean equals(Object object) {
            if (!(object instanceof StringPrincipal)) {
                return false;
            }
            return this.getName().equals(((StringPrincipal)object).getName());
        }

        public String getName() {
            return this.str;
        }

        public int hashCode() {
            return this.str.hashCode();
        }

        public String toString() {
            return this.str;
        }
    }
}

