/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.logsvc;

import com.sun.wbem.solarisprovider.common.ProviderUtility;
import com.sun.wbem.solarisprovider.logsvc.AdminLogException;
import com.sun.wbem.solarisprovider.logsvc.Filterable;
import com.sun.wbem.solarisprovider.logsvc.LogFilter;
import com.sun.wbem.solarisprovider.logsvc.LogRecord;
import com.sun.wbem.solarisprovider.logsvc.LogService;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.Vector;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMDataType;
import javax.wbem.cim.CIMDateTime;
import javax.wbem.cim.CIMElement;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMMethodException;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;
import javax.wbem.client.CIMOMHandle;
import javax.wbem.client.CIMProviderException;
import javax.wbem.client.ProviderCIMOMHandle;
import javax.wbem.provider.Authorizable;
import javax.wbem.provider.InstanceProvider;
import javax.wbem.provider.MethodProvider;
import javax.wbem.query.AndQueryExp;
import javax.wbem.query.AttributeExp;
import javax.wbem.query.BinaryRelQueryExp;
import javax.wbem.query.DateTimeExp;
import javax.wbem.query.NonJoinExp;
import javax.wbem.query.NotQueryExp;
import javax.wbem.query.OrQueryExp;
import javax.wbem.query.QueryExp;
import javax.wbem.query.SelectList;
import javax.wbem.query.StringValueExp;
import javax.wbem.query.ValueExp;
import javax.wbem.query.WQLParser;

public class Solaris_LogRecord
implements InstanceProvider,
MethodProvider,
Authorizable {
    private ProviderUtility provUtil = null;
    private LogService logsvc = null;
    private ProviderCIMOMHandle cimomhandle = null;

    public void cleanup() throws CIMException {
    }

    public void initialize(CIMOMHandle cIMOMHandle) throws CIMException {
        this.cimomhandle = (ProviderCIMOMHandle)cIMOMHandle;
        this.provUtil = new ProviderUtility(cIMOMHandle, "Logging Service");
    }

    public CIMInstance getInstance(CIMObjectPath cIMObjectPath, boolean bl, boolean bl2, boolean bl3, String[] stringArray, CIMClass cIMClass) throws CIMException {
        Number number;
        Object object;
        this.provUtil.checkAuthenticated();
        long l = 0L;
        int n = 0;
        String string = "";
        if (this.logsvc == null) {
            try {
                this.logsvc = LogService.getInstance();
            }
            catch (AdminLogException adminLogException) {
                throw new CIMProviderException("GENERAL_EXCEPTION", (Object)adminLogException.getLocalizedMessage());
            }
        }
        Enumeration enumeration = cIMObjectPath.getKeys().elements();
        while (enumeration.hasMoreElements()) {
            object = (CIMProperty)enumeration.nextElement();
            if (object.getName().equalsIgnoreCase("RecordID")) {
                number = (Long)object.getValue().getValue();
                l = (Long)number;
            }
            if (object.getName().equalsIgnoreCase("RecordHashCode")) {
                number = (Integer)object.getValue().getValue();
                n = (Integer)number;
            }
            if (!object.getName().equalsIgnoreCase("FileName")) continue;
            string = (String)object.getValue().getValue();
        }
        object = null;
        try {
            object = this.logsvc.readRecord(l, n, string);
        }
        catch (AdminLogException adminLogException) {
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)adminLogException.getLocalizedMessage());
        }
        number = this.logToCim(cIMClass, (LogRecord)object, string);
        if (bl) {
            number = number.localElements();
        }
        return number.filterProperties(stringArray, bl2, bl3);
    }

    public CIMObjectPath[] enumerateInstanceNames(CIMObjectPath cIMObjectPath, CIMClass cIMClass) throws CIMException {
        String string;
        this.provUtil.checkAuthenticated();
        Vector<String> vector = new Vector<String>();
        if (this.logsvc == null) {
            try {
                this.logsvc = LogService.getInstance();
            }
            catch (AdminLogException adminLogException) {
                throw new CIMProviderException("GENERAL_EXCEPTION", (Object)adminLogException.getLocalizedMessage());
            }
        }
        Vector<Vector> vector2 = new Vector<Vector>();
        try {
            LogFilter logFilter = new LogFilter();
            int n = 0;
            long l = 0L;
            string = "";
            String[] stringArray = this.logsvc.listLogFiles();
            int n2 = 0;
            while (n2 < stringArray.length) {
                n = (int)((long)n + this.logsvc.getNumRecords(stringArray[n2]));
                ++n2;
            }
            int n3 = 0;
            while (n3 < stringArray.length) {
                Vector vector3 = this.logsvc.getList(n, logFilter, l, stringArray[n3]);
                if (vector3 != null) {
                    vector3.addElement(stringArray[n3]);
                    vector2.addElement(vector3);
                }
                ++n3;
            }
        }
        catch (AdminLogException adminLogException) {
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)adminLogException.getLocalizedMessage());
        }
        int n = 0;
        while (n < vector2.size()) {
            Vector vector4 = (Vector)vector2.elementAt(n);
            int n4 = 0;
            while (n4 < vector4.size() - 1) {
                LogRecord logRecord = (LogRecord)vector4.elementAt(n4);
                string = new CIMObjectPath(cIMObjectPath.getObjectName(), cIMObjectPath.getNameSpace());
                string.addKey("RecordID", new CIMValue((Object)new Long(logRecord.getRecordId())));
                string.addKey("RecordHashCode", new CIMValue((Object)new Integer((int)logRecord.getHashCode())));
                string.addKey("Filename", new CIMValue(vector4.elementAt(vector4.size() - 1)));
                vector.addElement(string);
                ++n4;
            }
            ++n;
        }
        CIMObjectPath[] cIMObjectPathArray = new CIMObjectPath[vector.size()];
        vector.toArray(cIMObjectPathArray);
        return cIMObjectPathArray;
    }

    public synchronized CIMObjectPath createInstance(CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) throws CIMException {
        this.provUtil.checkAuthenticated();
        LogRecord logRecord = new LogRecord();
        if (this.logsvc == null) {
            try {
                this.logsvc = LogService.getInstance();
            }
            catch (AdminLogException adminLogException) {
                throw new CIMProviderException("GENERAL_EXCEPTION", (Object)adminLogException.getLocalizedMessage());
            }
        }
        logRecord = this.cimToLog(cIMInstance);
        boolean bl = (Boolean)cIMInstance.getProperty("syslogflag").getValue().getValue();
        try {
            this.logsvc.writeRecord(logRecord, bl, null);
        }
        catch (AdminLogException adminLogException) {
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)adminLogException.getLocalizedMessage());
        }
        CIMObjectPath cIMObjectPath2 = new CIMObjectPath("Solaris_LogRecord");
        cIMObjectPath2.setNameSpace("root/cimv2");
        cIMObjectPath2.addKey("RecordID", new CIMValue((Object)new Long(logRecord.getRecordId())));
        cIMObjectPath2.addKey("RecordHashCode", new CIMValue((Object)new Integer((int)logRecord.getHashCode())));
        cIMObjectPath2.addKey("Filename", new CIMValue((Object)logRecord.getFileName()));
        return cIMObjectPath2;
    }

    public synchronized void setInstance(CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public synchronized void deleteInstance(CIMObjectPath cIMObjectPath) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public CIMInstance[] enumerateInstances(CIMObjectPath cIMObjectPath, boolean bl, boolean bl2, boolean bl3, String[] stringArray, CIMClass cIMClass) throws CIMException {
        this.provUtil.checkAuthenticated();
        Vector vector = new Vector();
        Vector<CIMInstance> vector2 = new Vector<CIMInstance>();
        CIMInstance cIMInstance = null;
        if (this.logsvc == null) {
            try {
                this.logsvc = LogService.getInstance();
            }
            catch (AdminLogException adminLogException) {
                throw new CIMProviderException("GENERAL_EXCEPTION", (Object)adminLogException.getLocalizedMessage());
            }
        }
        Vector<Vector> vector3 = new Vector<Vector>();
        try {
            LogFilter logFilter = new LogFilter();
            int n = 0;
            long l = 0L;
            String string = "";
            String[] stringArray2 = this.logsvc.listLogFiles();
            int n2 = 0;
            while (n2 < stringArray2.length) {
                n = (int)((long)n + this.logsvc.getNumRecords(stringArray2[n2]));
                ++n2;
            }
            int n3 = 0;
            while (n3 < stringArray2.length) {
                Vector vector4 = this.logsvc.getList(n, logFilter, l, stringArray2[n3]);
                if (vector4 != null) {
                    vector4.addElement(stringArray2[n3]);
                    vector3.addElement(vector4);
                }
                ++n3;
            }
        }
        catch (AdminLogException adminLogException) {
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)adminLogException.getLocalizedMessage());
        }
        int n = 0;
        while (n < vector3.size()) {
            Vector vector5 = (Vector)vector3.elementAt(n);
            int n4 = 0;
            while (n4 < vector5.size() - 1) {
                LogRecord logRecord = (LogRecord)vector5.elementAt(n4);
                cIMInstance = this.logToCim(cIMClass, logRecord, (String)vector5.elementAt(vector5.size() - 1));
                if (bl) {
                    cIMInstance = cIMInstance.localElements();
                }
                vector2.addElement(cIMInstance.filterProperties(stringArray, bl2, bl3));
                ++n4;
            }
            ++n;
        }
        CIMInstance[] cIMInstanceArray = new CIMInstance[vector2.size()];
        vector2.toArray(cIMInstanceArray);
        return cIMInstanceArray;
    }

    public CIMInstance[] execQuery(CIMObjectPath cIMObjectPath, String string, String string2, CIMClass cIMClass) throws CIMException {
        CIMInstance[] cIMInstanceArray;
        this.provUtil.checkAuthenticated();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
        WQLParser wQLParser = new WQLParser((InputStream)byteArrayInputStream);
        Vector<CIMElement> vector = new Vector<CIMElement>();
        try {
            cIMInstanceArray = (CIMInstance[])wQLParser.querySpecification();
            SelectList selectList = cIMInstanceArray.getSelectList();
            NonJoinExp nonJoinExp = (NonJoinExp)cIMInstanceArray.getFromClause();
            QueryExp queryExp = cIMInstanceArray.getWhereClause();
            String string3 = null;
            try {
                string3 = (String)this.getAttributeValueInQuery(queryExp, "FileName");
            }
            catch (Exception exception) {
                string3 = null;
            }
            CIMInstance[] cIMInstanceArray2 = null;
            cIMInstanceArray2 = string3 != null ? this.myEnum(cIMObjectPath, cIMClass, string3) : this.enumerateInstances(cIMObjectPath, false, false, false, null, cIMClass);
            int n = 0;
            while (cIMInstanceArray2 != null && n < cIMInstanceArray2.length) {
                if (queryExp == null || queryExp.apply((CIMElement)cIMInstanceArray2[n])) {
                    vector.addElement(selectList.apply((CIMElement)cIMInstanceArray2[n]));
                }
                ++n;
            }
        }
        catch (Exception exception) {
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)exception.getMessage());
        }
        cIMInstanceArray = new CIMInstance[vector.size()];
        vector.toArray(cIMInstanceArray);
        return cIMInstanceArray;
    }

    private Object getAttributeValueInQuery(QueryExp queryExp, String string) throws Exception {
        if (queryExp instanceof AndQueryExp) {
            QueryExp queryExp2 = ((AndQueryExp)queryExp).getLeftExp();
            QueryExp queryExp3 = ((AndQueryExp)queryExp).getRightExp();
            Object object = this.getAttributeValueInQuery(queryExp2, string);
            if (object != null) {
                return object;
            }
            object = this.getAttributeValueInQuery(queryExp3, string);
            return object;
        }
        if (queryExp instanceof OrQueryExp) {
            QueryExp queryExp4 = ((OrQueryExp)queryExp).getLeftExp();
            QueryExp queryExp5 = ((OrQueryExp)queryExp).getRightExp();
            Object object = this.getAttributeValueInQuery(queryExp4, string);
            if (object != null) {
                return object;
            }
            object = this.getAttributeValueInQuery(queryExp5, string);
            return object;
        }
        if (queryExp instanceof NotQueryExp) {
            throw new Exception();
        }
        if (queryExp instanceof BinaryRelQueryExp) {
            ValueExp valueExp = ((BinaryRelQueryExp)queryExp).getLeftValue();
            ValueExp valueExp2 = ((BinaryRelQueryExp)queryExp).getRightValue();
            if (valueExp instanceof AttributeExp) {
                String string2 = ((AttributeExp)valueExp).getAttributeName();
                if (string2.equalsIgnoreCase(string)) {
                    if (valueExp2 instanceof StringValueExp) {
                        return ((StringValueExp)valueExp2).getValue();
                    }
                    if (valueExp2 instanceof DateTimeExp) {
                        return ((DateTimeExp)valueExp2).getValue();
                    }
                    return null;
                }
                return null;
            }
            if (valueExp2 instanceof AttributeExp) {
                String string3 = ((AttributeExp)valueExp2).getAttributeName();
                if (string3.equalsIgnoreCase(string)) {
                    if (valueExp instanceof StringValueExp) {
                        return ((StringValueExp)valueExp).getValue();
                    }
                    if (valueExp instanceof DateTimeExp) {
                        return ((DateTimeExp)valueExp).getValue();
                    }
                    return null;
                }
                return null;
            }
            return null;
        }
        return null;
    }

    private CIMInstance[] myEnum(CIMObjectPath cIMObjectPath, CIMClass cIMClass, String string) throws CIMException {
        Vector<CIMInstance> vector = new Vector<CIMInstance>();
        CIMInstance cIMInstance = null;
        if (this.logsvc == null) {
            try {
                this.logsvc = LogService.getInstance();
            }
            catch (AdminLogException adminLogException) {
                throw new CIMProviderException("GENERAL_EXCEPTION", (Object)adminLogException.getLocalizedMessage());
            }
        }
        Vector vector2 = new Vector();
        try {
            LogFilter logFilter = new LogFilter();
            int n = 0;
            long l = 0L;
            n = (int)((long)n + this.logsvc.getNumRecords(string));
            vector2 = this.logsvc.getList(n, logFilter, l, string);
        }
        catch (AdminLogException adminLogException) {
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)adminLogException.getLocalizedMessage());
        }
        int n = 0;
        while (vector2 != null && n < vector2.size()) {
            LogRecord logRecord = (LogRecord)vector2.elementAt(n);
            cIMInstance = this.logToCim(cIMClass, logRecord, string);
            vector.addElement(cIMInstance);
            ++n;
        }
        CIMInstance[] cIMInstanceArray = new CIMInstance[vector.size()];
        vector.toArray(cIMInstanceArray);
        return cIMInstanceArray;
    }

    public synchronized CIMValue invokeMethod(CIMObjectPath cIMObjectPath, String string, Vector vector, Vector vector2) throws CIMException {
        this.provUtil.checkAuthenticated();
        CIMValue cIMValue = null;
        if (!string.equalsIgnoreCase("bulkData")) {
            throw new CIMMethodException("NO_SUCH_METHOD", (Object)string, (Object)cIMObjectPath.getObjectName());
        }
        cIMValue = this.bulkData(vector, vector2);
        return cIMValue;
    }

    private synchronized CIMValue bulkData(Vector vector, Vector vector2) throws CIMException {
        int n;
        Object object;
        String string = null;
        String[] stringArray = null;
        CIMValue cIMValue = null;
        if (vector != null && vector.size() > 0) {
            try {
                cIMValue = (CIMValue)vector.elementAt(0);
                string = (String)cIMValue.getValue();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.logsvc == null) {
            try {
                this.logsvc = LogService.getInstance();
            }
            catch (AdminLogException adminLogException) {
                throw new CIMProviderException("GENERAL_EXCEPTION", (Object)adminLogException.getLocalizedMessage());
            }
        }
        Vector vector3 = null;
        try {
            String string2;
            long l;
            if (string != null) {
                object = new LogFilter(string);
                n = 0;
                l = 0L;
                string2 = ((LogFilter)object).getFileName();
                ((LogFilter)object).setFileName(null);
                if (string2 == null) {
                    string2 = this.logsvc.getCurrentLogFileName();
                }
                n = (int)((long)n + this.logsvc.getNumRecords(string2));
                vector3 = this.logsvc.getList(n, (Filterable)object, l, string2);
            } else {
                object = new LogFilter();
                n = 0;
                l = 0L;
                string2 = this.logsvc.getCurrentLogFileName();
                n = (int)((long)n + this.logsvc.getNumRecords(string2));
                vector3 = this.logsvc.getList(n, (Filterable)object, l, string2);
            }
        }
        catch (AdminLogException adminLogException) {
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)adminLogException.getLocalizedMessage());
        }
        if (vector3 != null && vector3.size() > 0) {
            stringArray = new String[vector3.size()];
            object = vector3.elements();
            n = 0;
            while (object.hasMoreElements()) {
                LogRecord logRecord = (LogRecord)object.nextElement();
                stringArray[n] = logRecord.formatRecord();
                ++n;
            }
            vector2.addElement(new CIMValue((Object)stringArray, new CIMDataType(22)));
        }
        object = new CIMValue((Object)new Integer(0));
        return object;
    }

    private CIMInstance logToCim(CIMClass cIMClass, LogRecord logRecord, String string) throws CIMException {
        CIMInstance cIMInstance = cIMClass.newInstance();
        cIMInstance.setProperty("RecordID", new CIMValue((Object)new Long(logRecord.getRecordId())));
        cIMInstance.setProperty("RecordHashCode", new CIMValue((Object)new Integer((int)logRecord.getHashCode())));
        cIMInstance.setProperty("Filename", new CIMValue((Object)string));
        cIMInstance.setProperty("RecordDate", new CIMValue((Object)new CIMDateTime(logRecord.getDate())));
        cIMInstance.setProperty("category", new CIMValue((Object)new Integer(logRecord.getCategory())));
        cIMInstance.setProperty("severity", new CIMValue((Object)new Integer(logRecord.getSeverity())));
        cIMInstance.setProperty("AppName", new CIMValue((Object)logRecord.getAppName()));
        cIMInstance.setProperty("UserName", new CIMValue((Object)logRecord.getUserName()));
        cIMInstance.setProperty("ClientMachineName", new CIMValue((Object)logRecord.getClientHostName()));
        cIMInstance.setProperty("ServerMachineName", new CIMValue((Object)logRecord.getAgentHostName()));
        cIMInstance.setProperty("SummaryMessage", new CIMValue((Object)logRecord.getSummaryMesg(true)));
        cIMInstance.setProperty("DetailedMessage", new CIMValue((Object)logRecord.getDetailedMesg(true)));
        cIMInstance.setProperty("data", new CIMValue((Object)logRecord.getData()));
        cIMInstance.setProperty("SyslogFlag", new CIMValue((Object)new Boolean(logRecord.getSyslog())));
        return cIMInstance;
    }

    private LogRecord cimToLog(CIMInstance cIMInstance) throws CIMException {
        LogRecord logRecord = new LogRecord();
        logRecord.setCategory((Integer)cIMInstance.getProperty("category").getValue().getValue());
        logRecord.setSeverity((Integer)cIMInstance.getProperty("severity").getValue().getValue());
        logRecord.setAppName((String)cIMInstance.getProperty("AppName").getValue().getValue());
        logRecord.setUserName(this.provUtil.getClientUserName());
        String string = this.cimomhandle.getCurrentClientHost();
        String string2 = null;
        try {
            InetAddress inetAddress = InetAddress.getByName(string);
            string2 = inetAddress.getHostName();
        }
        catch (Exception exception) {
            string2 = string;
        }
        if (string2 == null) {
            string2 = string;
        }
        logRecord.setClientHostName(string2);
        try {
            logRecord.setAgentHostName(InetAddress.getLocalHost().getHostName());
        }
        catch (Exception exception) {
            logRecord.setAgentHostName((String)cIMInstance.getProperty("ServerMachineName").getValue().getValue());
        }
        logRecord.setSummaryMesgId((String)cIMInstance.getProperty("SummaryMessage").getValue().getValue());
        logRecord.setDetailedMesgId((String)cIMInstance.getProperty("DetailedMessage").getValue().getValue());
        logRecord.addData((String)cIMInstance.getProperty("data").getValue().getValue());
        boolean bl = (Boolean)cIMInstance.getProperty("syslogflag").getValue().getValue();
        logRecord.setSyslog(bl);
        return logRecord;
    }
}

